/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.builtin;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.authorization.SecurityRole;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Set;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SecurityRoleImpl
implements SecurityRole {
    private static final TraceComponent tc = Tr.register(SecurityRoleImpl.class);
    static final String CFG_KEY_USER = "user";
    static final String CFG_KEY_GROUP = "group";
    static final String CFG_KEY_ACCESSID = "access-id";
    static final String CFG_KEY_SPECIAL_SUBJECT = "special-subject";
    private final Set<String> users = new HashSet<String>();
    private final Set<String> groups = new HashSet<String>();
    private final Set<String> specialSubjects = new HashSet<String>();
    private final Set<String> accessIds = new HashSet<String>();
    private String name = null;
    static final long serialVersionUID = 2441729510601226330L;

    public SecurityRoleImpl(ConfigurationAdmin configAdmin, String roleName, Dictionary<String, Object> roleProps, Set<String> pids) {
        this.name = roleName;
        this.processUsers(configAdmin, roleName, roleProps, pids);
        this.processGroups(configAdmin, roleName, roleProps, pids);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Role " + roleName + " has accessIds:"), (Object[])new Object[]{this.accessIds});
        }
        this.processSpecialSubjects(configAdmin, roleName, roleProps, pids);
    }

    public String getRoleName() {
        return this.name;
    }

    public synchronized Set<String> getUsers() {
        return this.users;
    }

    public synchronized Set<String> getGroups() {
        return this.groups;
    }

    public Set<String> getSpecialSubjects() {
        return this.specialSubjects;
    }

    public Set<String> getAccessIds() {
        return this.accessIds;
    }

    private void processUsers(ConfigurationAdmin configAdmin, String roleName, Dictionary<String, Object> roleProps, Set<String> pids) {
        String[] userPids = (String[])roleProps.get(CFG_KEY_USER);
        if (userPids == null || userPids.length == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No users in role " + roleName), (Object[])new Object[0]);
            }
        } else {
            HashSet<String> badUsers = new HashSet<String>();
            HashSet<String> badAccessIds = new HashSet<String>();
            for (int i = 0; i < userPids.length; ++i) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("user pid " + i + ": " + userPids[i]), (Object[])new Object[0]);
                }
                pids.add(userPids[i]);
                Configuration userConfig = null;
                try {
                    userConfig = configAdmin.getConfiguration(userPids[i]);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.authorization.builtin.SecurityRoleImpl", (String)"122", (Object)this, (Object[])new Object[]{configAdmin, roleName, roleProps, pids});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Invalid user entry " + userPids[i]), (Object[])new Object[0]);
                    continue;
                }
                if (userConfig == null || userConfig.getProperties() == null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Null user element", (Object[])new Object[]{userPids[i]});
                    continue;
                }
                Dictionary userProps = userConfig.getProperties();
                String name = (String)userProps.get("name");
                String accessId = (String)userProps.get(CFG_KEY_ACCESSID);
                if (name == null || name.trim().isEmpty()) continue;
                if (accessId != null && AccessIdUtil.isUserAccessId((String)accessId)) {
                    if (badAccessIds.contains(accessId) || this.accessIds.add(accessId)) continue;
                    Tr.error((TraceComponent)tc, (String)"AUTHZ_TABLE_DUPLICATE_ROLE_MEMBER", (Object[])new Object[]{this.getRoleName(), CFG_KEY_ACCESSID, accessId});
                    badAccessIds.add(accessId);
                    this.accessIds.remove(accessId);
                    continue;
                }
                if (badUsers.contains(name) || name.trim().isEmpty() || this.users.add(name)) continue;
                Tr.error((TraceComponent)tc, (String)"AUTHZ_TABLE_DUPLICATE_ROLE_MEMBER", (Object[])new Object[]{this.getRoleName(), CFG_KEY_USER, name});
                badUsers.add(name);
                this.users.remove(name);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Role " + roleName + " has users:"), (Object[])new Object[]{this.users});
            }
        }
    }

    private void processGroups(ConfigurationAdmin configAdmin, String roleName, Dictionary<String, Object> roleProps, Set<String> pids) {
        String[] groupPids = (String[])roleProps.get(CFG_KEY_GROUP);
        if (groupPids == null || groupPids.length == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No groups in role " + roleName), (Object[])new Object[0]);
            }
        } else {
            HashSet<String> badGroups = new HashSet<String>();
            HashSet<String> badAccessIds = new HashSet<String>();
            for (int i = 0; i < groupPids.length; ++i) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("group pid " + i + ": " + groupPids[i]), (Object[])new Object[0]);
                }
                pids.add(groupPids[i]);
                Configuration groupConfig = null;
                try {
                    groupConfig = configAdmin.getConfiguration(groupPids[i]);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.authorization.builtin.SecurityRoleImpl", (String)"204", (Object)this, (Object[])new Object[]{configAdmin, roleName, roleProps, pids});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Invalid group entry " + groupPids[i]), (Object[])new Object[0]);
                    continue;
                }
                if (groupConfig == null || groupConfig.getProperties() == null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Null group element", (Object[])new Object[]{groupPids[i]});
                    continue;
                }
                Dictionary groupProps = groupConfig.getProperties();
                String name = (String)groupProps.get("name");
                String accessId = (String)groupProps.get(CFG_KEY_ACCESSID);
                if (name == null || name.trim().isEmpty()) continue;
                if (accessId != null && AccessIdUtil.isGroupAccessId((String)accessId)) {
                    if (badAccessIds.contains(accessId) || this.accessIds.add(accessId)) continue;
                    Tr.error((TraceComponent)tc, (String)"AUTHZ_TABLE_DUPLICATE_ROLE_MEMBER", (Object[])new Object[]{this.getRoleName(), CFG_KEY_ACCESSID, accessId});
                    badAccessIds.add(accessId);
                    this.accessIds.remove(accessId);
                    continue;
                }
                if (badGroups.contains(name) || name.trim().isEmpty() || this.groups.add(name)) continue;
                Tr.error((TraceComponent)tc, (String)"AUTHZ_TABLE_DUPLICATE_ROLE_MEMBER", (Object[])new Object[]{this.getRoleName(), CFG_KEY_GROUP, name});
                badGroups.add(name);
                this.groups.remove(name);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Role " + roleName + " has groups:"), (Object[])new Object[]{this.groups});
            }
        }
    }

    private void processSpecialSubjects(ConfigurationAdmin configAdmin, String roleName, Dictionary<String, Object> roleProps, Set<String> pids) {
        String[] specialSubjectPids = (String[])roleProps.get(CFG_KEY_SPECIAL_SUBJECT);
        if (specialSubjectPids == null || specialSubjectPids.length == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No special subjects in role " + roleName), (Object[])new Object[0]);
            }
        } else {
            HashSet<String> badSpecialSubjects = new HashSet<String>();
            for (int i = 0; i < specialSubjectPids.length; ++i) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("special subject pid " + i + ": " + specialSubjectPids[i]), (Object[])new Object[0]);
                }
                pids.add(specialSubjectPids[i]);
                Configuration specialSubjectConfig = null;
                try {
                    specialSubjectConfig = configAdmin.getConfiguration(specialSubjectPids[i]);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.authorization.builtin.SecurityRoleImpl", (String)"286", (Object)this, (Object[])new Object[]{configAdmin, roleName, roleProps, pids});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("Invalid special subject entry " + specialSubjectPids[i]), (Object[])new Object[0]);
                    continue;
                }
                if (specialSubjectConfig == null || specialSubjectConfig.getProperties() == null) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)"Null special subject element", (Object[])new Object[]{specialSubjectPids[i]});
                    continue;
                }
                Dictionary specialSubjectProps = specialSubjectConfig.getProperties();
                String type = (String)specialSubjectProps.get("type");
                if (type == null || type.trim().isEmpty() || badSpecialSubjects.contains(type) || type.trim().isEmpty() || this.specialSubjects.add(type)) continue;
                Tr.error((TraceComponent)tc, (String)"AUTHZ_TABLE_DUPLICATE_ROLE_MEMBER", (Object[])new Object[]{this.getRoleName(), CFG_KEY_SPECIAL_SUBJECT, type});
                badSpecialSubjects.add(type);
                this.specialSubjects.remove(type);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Role " + roleName + " has special subjects:"), (Object[])new Object[]{this.specialSubjects});
            }
        }
    }
}

