/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.builtin.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authorization.AccessDecisionService;
import java.util.Collection;
import javax.security.auth.Subject;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class BuiltinAccessDecisionService
implements AccessDecisionService {
    private static final TraceComponent tc = Tr.register(BuiltinAccessDecisionService.class);
    private ServiceReference<JavaEEVersion> eeVersionRef;
    private volatile Version eeVersion = JavaEEVersion.DEFAULT_VERSION;
    private static final String ALL_AUTHENTICATED_ROLE = "**";
    private static final String STARSTAR_ROLE = "_starstar_";
    static final long serialVersionUID = -1612858456700178360L;

    public synchronized void setVersion(ServiceReference<JavaEEVersion> reference) {
        this.eeVersionRef = reference;
        this.eeVersion = Version.parseVersion((String)((String)reference.getProperty("version")));
    }

    public synchronized void unsetVersion(ServiceReference<JavaEEVersion> reference) {
        if (reference == this.eeVersionRef) {
            this.eeVersionRef = null;
            this.eeVersion = JavaEEVersion.DEFAULT_VERSION;
        }
    }

    private boolean isEEVersion7() {
        return this.eeVersion.compareTo(JavaEEVersion.VERSION_7_0) >= 0;
    }

    public boolean isGranted(String resourceName, Collection<String> requiredRoles, Collection<String> assignedRoles, Subject subject) {
        if (subject != null && requiredRoles.contains(ALL_AUTHENTICATED_ROLE) && this.isEEVersion7()) {
            return true;
        }
        if (assignedRoles != null) {
            for (String r : requiredRoles) {
                if (r.equals(STARSTAR_ROLE)) {
                    r = ALL_AUTHENTICATED_ROLE;
                }
                if (!assignedRoles.contains(r)) continue;
                return true;
            }
        }
        return false;
    }
}

