/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.h2internal.Constants;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.H2HttpInboundLinkWrap;
import com.ibm.ws.http.channel.h2internal.H2MuxTCPReadCallback;
import com.ibm.ws.http.channel.h2internal.H2MuxTCPWriteCallback;
import com.ibm.ws.http.channel.h2internal.H2StreamProcessor;
import com.ibm.ws.http.channel.h2internal.H2TCPConnectionContext;
import com.ibm.ws.http.channel.h2internal.H2VirtualConnectionImpl;
import com.ibm.ws.http.channel.h2internal.H2WorkQInterface;
import com.ibm.ws.http.channel.h2internal.H2WriteQEntry;
import com.ibm.ws.http.channel.h2internal.H2WriteTree;
import com.ibm.ws.http.channel.h2internal.ItemForCompletion;
import com.ibm.ws.http.channel.h2internal.exceptions.FlowControlException;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderTable;
import com.ibm.ws.http.channel.h2internal.priority.Node;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundChannel;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundLink;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class H2InboundLink
extends HttpInboundLink {
    private static final TraceComponent tc = Tr.register(H2InboundLink.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    LINK_STATUS linkStatus = LINK_STATUS.INIT;
    READ_LINK_STATUS readLinkStatus = READ_LINK_STATUS.NOT_READING;
    WRITE_LINK_STATUS writeLinkStatus = WRITE_LINK_STATUS.NOT_WRITING;
    Object linkStatusSync = new Object(){
        static final long serialVersionUID = 5654600835162015576L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    private boolean processGoAway = false;
    private int lastStreamToProcess = 0;
    private int highestClientStreamId = 0;
    private int highestLocalStreamId = 0;
    boolean connection_preface_sent = false;
    boolean connection_preface_string_rcvd = false;
    boolean connection_preface_settings_rcvd = false;
    public volatile boolean connection_preface_settings_ack_rcvd = false;
    public volatile boolean connection_init_failed = false;
    volatile long initialWindowSize = Constants.SPEC_INITIAL_WINDOW_SIZE;
    volatile long connectionReadWindowSize = Constants.SPEC_INITIAL_WINDOW_SIZE;
    volatile long maxReadWindowSize = Constants.SPEC_INITIAL_WINDOW_SIZE;
    FrameReadProcessor frameReadProcessor = null;
    H2MuxTCPReadCallback h2MuxReadCallback = null;
    TCPReadRequestContext h2MuxTCPReadContext = null;
    H2MuxTCPWriteCallback h2MuxWriteCallback = null;
    TCPWriteRequestContext h2MuxTCPWriteContext = null;
    WsByteBuffer slicedBuffer = null;
    ItemForCompletion readWaitingForCompletion = new ItemForCompletion();
    ItemForCompletion writeWaitingForCompletion = new ItemForCompletion();
    ConcurrentHashMap<Integer, H2StreamProcessor> streamTable = new ConcurrentHashMap();
    ConcurrentHashMap<Integer, H2StreamProcessor> closeTable = new ConcurrentHashMap();
    private static long CLOSE_TABLE_PURGE_TIME = 30000000000L;
    HttpInboundLink initialHttpInboundLink = null;
    VirtualConnection initialVC = null;
    HttpInboundChannel httpInboundChannel = null;
    TCPConnectionContext h2MuxTCPConnectionContext = null;
    HttpInboundServiceContextImpl h2MuxServiceContextImpl = null;
    H2ConnectionSettings connectionSettings;
    H2WorkQInterface writeQ = null;
    int h2NextPromisedStreamId = 0;
    private H2HeaderTable readContextTable = null;
    private H2HeaderTable writeContextTable = null;
    HttpChannelConfig config = null;
    private ScheduledFuture<?> closeFuture;
    private H2ConnectionTimeout connTimeout;
    private int readStackDepthCount = 0;
    private static final int READ_STACK_DEPTH_LIMIT = 64;
    private boolean continuationFrameExpected = false;
    static final long serialVersionUID = -1284044727282572790L;

    public boolean isContinuationExpected() {
        return this.continuationFrameExpected;
    }

    public void setContinuationExpected(boolean expected) {
        this.continuationFrameExpected = expected;
    }

    public H2InboundLink(HttpInboundChannel channel, VirtualConnection vc, TCPConnectionContext tcc) {
        super(channel, vc);
        this.initialVC = vc;
        this.httpInboundChannel = channel;
        this.frameReadProcessor = new FrameReadProcessor(this);
        this.h2MuxReadCallback = new H2MuxTCPReadCallback();
        this.h2MuxWriteCallback = new H2MuxTCPWriteCallback();
        this.h2MuxReadCallback.setConnLinkCallback(this);
        this.h2MuxTCPConnectionContext = tcc;
        this.h2MuxTCPReadContext = tcc.getReadInterface();
        this.h2MuxTCPWriteContext = tcc.getWriteInterface();
        this.connectionSettings = new H2ConnectionSettings();
        this.config = channel.getHttpConfig();
        this.connectionReadWindowSize = this.maxReadWindowSize = (long)this.config.getH2ConnReadWindowSize();
        this.writeQ = new H2WriteTree();
        this.writeQ.init(this.h2MuxTCPWriteContext, this.h2MuxWriteCallback);
        this.readContextTable = new H2HeaderTable();
        this.writeContextTable = new H2HeaderTable();
    }

    public synchronized long getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public H2StreamProcessor createNewInboundLink(Integer streamID) {
        if ((streamID & 1) == 0) {
            if (streamID > this.highestLocalStreamId) {
                this.highestLocalStreamId = streamID;
            }
        } else if (streamID > this.highestClientStreamId) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("highestClientStreamId set to stream-id: " + streamID), (Object[])new Object[0]);
            }
            this.highestClientStreamId = streamID;
        }
        H2VirtualConnectionImpl h2VC = new H2VirtualConnectionImpl(this.initialVC);
        H2HttpInboundLinkWrap link = new H2HttpInboundLinkWrap(this.httpInboundChannel, h2VC, streamID, this);
        H2StreamProcessor stream = new H2StreamProcessor(streamID, link, this);
        this.writeQ.addNewNodeToQ(streamID, Node.ROOT_STREAM_ID, Node.DEFAULT_NODE_PRIORITY, false);
        this.streamTable.put(streamID, stream);
        return stream;
    }

    public void processConnectionPrefaceMagic() {
        this.connection_preface_string_rcvd = true;
        H2StreamProcessor controlStream = this.createNewInboundLink(0);
        controlStream.completeConnectionPreface();
        this.connection_preface_sent = true;
    }

    @Override
    public void ready(VirtualConnection inVC) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"ready called illegally!", (Object[])new Object[0]);
        }
    }

    @Override
    protected void processRequest() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"processRequest called illegally!", (Object[])new Object[0]);
        }
    }

    public boolean handleHTTP2UpgradeRequest(Map<String, String> headers, HttpInboundLink link) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest entry", (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest, sending 101 response", (Object[])new Object[0]);
        }
        link.getHTTPContext().send101SwitchingProtocol("h2c");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest, sent 101 response", (Object[])new Object[0]);
        }
        Integer streamID = new Integer(1);
        H2VirtualConnectionImpl h2VC = new H2VirtualConnectionImpl(this.initialVC);
        H2HttpInboundLinkWrap wrap = new H2HttpInboundLinkWrap(this.httpInboundChannel, h2VC, streamID, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest, creating stream processor", (Object[])new Object[0]);
        }
        H2StreamProcessor streamProcessor = new H2StreamProcessor(streamID, wrap, this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handleHTTP2UpgradeRequest, created stream processor : " + streamProcessor), (Object[])new Object[0]);
        }
        this.writeQ.addNewNodeToQ(streamID, Node.ROOT_STREAM_ID, Node.DEFAULT_NODE_PRIORITY, false);
        this.streamTable.put(streamID, streamProcessor);
        String settings = headers.get("HTTP2-Settings");
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("handleHTTP2UpgradeRequest, processing upgrade header settings : " + settings), (Object[])new Object[0]);
            }
            this.getConnectionSettings().processUpgradeHeaderSettings(settings);
        }
        catch (ProtocolException protocolException) {
            FFDCFilter.processException((Throwable)protocolException, (String)"com.ibm.ws.http.channel.h2internal.H2InboundLink", (String)"272", (Object)((Object)this), (Object[])new Object[]{headers, link});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest an error occurred processing the settings during connection initialization", (Object[])new Object[0]);
            }
            return false;
        }
        this.initialHttpInboundLink = link;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("handleHTTP2UpgradeRequest, reinit the link : " + (Object)((Object)link)), (Object[])new Object[0]);
        }
        link.reinit(wrap.getConnectionContext(), wrap.getVirtualConnection(), wrap);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"handleHTTP2UpgradeRequest, exit", (Object[])new Object[0]);
        }
        return true;
    }

    public void startAsyncRead(boolean newFrame) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("startAsyncRead entry; newframe = " + newFrame), (Object[])new Object[0]);
        }
        if (newFrame) {
            this.frameReadProcessor.reset(true);
        }
        if (this.slicedBuffer != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("startAsyncRead reading slicedBuffer length: " + this.slicedBuffer.limit()), (Object[])new Object[0]);
            }
            this.slicedBuffer.position(this.slicedBuffer.limit());
            this.h2MuxTCPReadContext.setBuffer(this.slicedBuffer);
            this.slicedBuffer = null;
            if (this.readStackDepthCount < 64) {
                ++this.readStackDepthCount;
                this.h2MuxReadCallback.complete(this.initialVC, this.h2MuxTCPReadContext);
            } else {
                ExecutorService executorService = CHFWBundle.getExecutorService();
                AsyncCallback ac = new AsyncCallback();
                this.readStackDepthCount = 0;
                executorService.execute(ac);
            }
            return;
        }
        WsByteBufferPoolManager mgr = HttpDispatcher.getBufferManager();
        WsByteBuffer buf = mgr.allocate(8192);
        this.h2MuxTCPReadContext.setBuffer(buf);
        boolean forceQueue = true;
        int numBytes = 1;
        this.readStackDepthCount = 0;
        this.h2MuxTCPReadContext.read((long)numBytes, (TCPReadCompletedCallback)this.h2MuxReadCallback, forceQueue, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void processRead(VirtualConnection vc, TCPReadRequestContext rrc) throws ProtocolException {
        boolean readForNewFrame = true;
        Object object = this.linkStatusSync;
        synchronized (object) {
            if (this.writeLinkStatus == WRITE_LINK_STATUS.WRITE_IN_PROGRESS || this.linkStatus == LINK_STATUS.CLOSED || this.linkStatus == LINK_STATUS.CLOSING) {
                this.readWaitingForCompletion.setReadComplete(vc, rrc);
                return;
            }
            this.readLinkStatus = READ_LINK_STATUS.PROCESSING_READ;
        }
        if (this.closeFuture != null) {
            boolean result = this.closeFuture.cancel(false);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("closeFuture detected while processing a read, attempting to cancel the outstanding close result: " + result), (Object[])new Object[0]);
            }
        }
        int frameReadStatus = 0;
        WsByteBuffer nextBuffer = rrc.getBuffer();
        nextBuffer.flip();
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processRead next buffer length: " + nextBuffer.limit()), (Object[])new Object[0]);
            }
            if ((frameReadStatus = this.frameReadProcessor.processNextBuffer(nextBuffer)) == -2) {
                readForNewFrame = false;
            } else {
                if (frameReadStatus > 0) {
                    int oldPosition = nextBuffer.position();
                    this.slicedBuffer = nextBuffer.position(frameReadStatus).slice();
                    nextBuffer.position(oldPosition);
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processRead process complete frame", (Object[])new Object[0]);
                }
                this.frameReadProcessor.processCompleteFrame();
            }
        }
        catch (Http2Exception oldPosition) {
            void e;
            FFDCFilter.processException((Throwable)oldPosition, (String)"com.ibm.ws.http.channel.h2internal.H2InboundLink", (String)"430", (Object)((Object)this), (Object[])new Object[]{vc, rrc});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processRead an error occurred processing a frame: " + e.getErrorString()), (Object[])new Object[0]);
            }
            try {
                this.getStreamProcessor(0).sendGOAWAYFrame((Http2Exception)e);
            }
            catch (ProtocolException protocolException) {
                FFDCFilter.processException((Throwable)protocolException, (String)"com.ibm.ws.http.channel.h2internal.H2InboundLink", (String)"438", (Object)((Object)this), (Object[])new Object[]{vc, rrc});
            }
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processRead get ready to read for more data", (Object[])new Object[0]);
            }
            Object object2 = this.linkStatusSync;
            synchronized (object2) {
                this.readWaitingForCompletion.reset();
                if (this.linkStatus != LINK_STATUS.CLOSED && this.linkStatus != LINK_STATUS.CLOSING) {
                    this.readLinkStatus = READ_LINK_STATUS.READ_OUTSTANDING;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"processRead read for more data", (Object[])new Object[0]);
                    }
                    this.startAsyncRead(readForNewFrame);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void AfterWriteLinkProcessing() {
        boolean localDoReadComplete = false;
        boolean localDoReadError = false;
        Object object = this.linkStatusSync;
        synchronized (object) {
            this.writeLinkStatus = WRITE_LINK_STATUS.NOT_WRITING;
            if (this.linkStatus == LINK_STATUS.CLOSED && this.linkStatus == LINK_STATUS.CLOSING) {
                return;
            }
            if (this.readWaitingForCompletion.getItemState() == ItemForCompletion.ItemState.READ_COMPLETE_READY) {
                this.readLinkStatus = READ_LINK_STATUS.PROCESSING_READ;
                localDoReadComplete = true;
            }
            if (this.readWaitingForCompletion.getItemState() == ItemForCompletion.ItemState.READ_ERROR_READY) {
                this.readLinkStatus = READ_LINK_STATUS.PROCESSING_READ;
                localDoReadError = true;
            }
        }
        if (localDoReadComplete) {
            this.h2MuxReadCallback.complete(this.readWaitingForCompletion.getVC(), this.readWaitingForCompletion.getTCPReadContext());
            return;
        }
        if (localDoReadError) {
            this.h2MuxReadCallback.error(this.readWaitingForCompletion.getVC(), this.readWaitingForCompletion.getTCPReadContext(), this.readWaitingForCompletion.getIOException());
            return;
        }
    }

    public H2StreamProcessor getStreamProcessor(Integer sID) {
        H2StreamProcessor p = null;
        p = this.streamTable.get(sID);
        return p;
    }

    public void destroy() {
        this.httpInboundChannel.stop(50L);
        this.initialVC = null;
        this.frameReadProcessor = null;
        this.h2MuxReadCallback = null;
        this.h2MuxTCPConnectionContext = null;
        this.h2MuxTCPReadContext = null;
        this.h2MuxTCPWriteContext = null;
        this.connectionSettings = null;
        this.readContextTable = null;
        this.writeContextTable = null;
        super.destroy();
    }

    public void writeSync(WsByteBuffer buf, WsByteBuffer[] bufs, long numBytes, int timeout, FrameTypes fType, int payloadLength, int streamID) throws IOException, FlowControlException {
        H2WorkQInterface.WRITE_ACTION action = H2WorkQInterface.WRITE_ACTION.NOT_SET;
        if (buf != null && bufs != null) {
            IOException up = new IOException("Internal error - incorrect buffers specified");
            throw up;
        }
        H2WriteQEntry e = new H2WriteQEntry(buf, bufs, numBytes, timeout, H2WriteQEntry.WRITE_TYPE.SYNC, fType, payloadLength, streamID);
        e.armWriteCompleteLatch();
        action = this.writeQ.writeOrAddToQ(e);
        if (action == H2WorkQInterface.WRITE_ACTION.QUEUED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"writeSync - call entry.waitWriteCompleteLatch", (Object[])new Object[0]);
            }
            e.waitWriteCompleteLatch();
        }
    }

    public H2TCPConnectionContext writeASync(WsByteBuffer buf, WsByteBuffer[] bufs, long numBytes, TCPWriteCompletedCallback callback, boolean forceQueue, int timeout, H2TCPConnectionContext connCtx, FrameTypes fType, int payloadLength, int streamID) throws IOException, FlowControlException {
        H2WorkQInterface.WRITE_ACTION action = H2WorkQInterface.WRITE_ACTION.NOT_SET;
        if (buf != null && bufs != null) {
            IOException up = new IOException("too many buffer parameters set");
            throw up;
        }
        H2WriteQEntry e = new H2WriteQEntry(buf, bufs, numBytes, callback, forceQueue, timeout, connCtx, H2WriteQEntry.WRITE_TYPE.ASYNC, fType, payloadLength, streamID);
        action = this.writeQ.writeOrAddToQ(e);
        if (action == H2WorkQInterface.WRITE_ACTION.COMPLETED) {
            return connCtx;
        }
        return null;
    }

    public synchronized int getNextPromisedStreamId() {
        this.h2NextPromisedStreamId += 2;
        return this.h2NextPromisedStreamId;
    }

    public H2HeaderTable getReadTable() {
        return this.readContextTable;
    }

    public H2HeaderTable getWriteTable() {
        return this.writeContextTable;
    }

    public H2WorkQInterface getWorkQ() {
        return this.writeQ;
    }

    public void incrementConnectionWindowUpdateLimit(int x) throws FlowControlException {
        this.writeQ.incrementConnectionWindowUpdateLimit(x);
    }

    public synchronized void changeInitialWindowSizeAllStreams(int newSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("changeInitialWindowSizeAllStreams entry: newSize: " + newSize), (Object[])new Object[0]);
        }
        this.initialWindowSize = newSize;
        for (Integer i : this.streamTable.keySet()) {
            H2StreamProcessor stream = this.streamTable.get(i);
            stream.updateInitialWindowsUpdateSize(newSize);
        }
    }

    public H2ConnectionSettings getConnectionSettings() {
        return this.connectionSettings;
    }

    public void cleanupStream(int streamID) {
        this.streamTable.remove(streamID);
        this.writeQ.removeNodeFromQ(streamID);
    }

    @Override
    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"destroy entry", (Object[])new Object[0]);
        }
        for (Integer i : this.streamTable.keySet()) {
            H2StreamProcessor stream = this.streamTable.get(i);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("destroying " + stream + ", " + stream.myID), (Object[])new Object[0]);
            }
            if (stream.myID == 0) continue;
            stream.h2HttpInboundLinkWrap.destroy(e);
        }
        this.initialVC = null;
        this.frameReadProcessor = null;
        this.h2MuxReadCallback = null;
        this.h2MuxTCPConnectionContext = null;
        this.h2MuxTCPReadContext = null;
        this.h2MuxTCPWriteContext = null;
        this.connectionSettings = null;
        this.readContextTable = null;
        this.writeContextTable = null;
        super.destroy(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goAway(int lastStreamId) {
        Object object = this.linkStatusSync;
        synchronized (object) {
            this.linkStatus = LINK_STATUS.GOAWAY_IN_PROGRESS;
        }
        this.lastStreamToProcess = lastStreamId;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("goAway received : H2InboundLink hc: " + ((Object)((Object)this)).hashCode() + " last stream to process : " + this.lastStreamToProcess), (Object[])new Object[0]);
        }
        if (this.closeFuture != null) {
            boolean isDone = this.closeFuture.isDone();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("H2InboundLink goAway closeFuture hc: " + this.closeFuture.hashCode() + " cancel done : " + isDone), (Object[])new Object[0]);
            }
            if (isDone) {
                this.triggerLinkClose(this.connTimeout.vc, this.connTimeout.e);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"H2InboundLink goAway closeFuture is null", (Object[])new Object[0]);
        }
    }

    public boolean isGoAwayInProgress() {
        return this.linkStatus == LINK_STATUS.GOAWAY_IN_PROGRESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(VirtualConnection inVC, Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"close entry", (Object[])new Object[0]);
        }
        boolean shouldClose = false;
        for (Integer i : this.streamTable.keySet()) {
            H2StreamProcessor stream = this.streamTable.get(i);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("close, " + stream + ", " + stream.myID + ", " + this.lastStreamToProcess + ", " + (Object)((Object)stream.state) + ", " + stream.isStreamClosed() + ", " + stream.isHalfClosed()), (Object[])new Object[0]);
            }
            if (stream.myID == 0 || stream.isHalfClosed() || stream.isStreamClosed() || this.lastStreamToProcess > -1 && stream.myID > this.lastStreamToProcess) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"close: Nothing to close at the moment", (Object[])new Object[0]);
            }
            return;
        }
        Object object = this.linkStatusSync;
        synchronized (object) {
            if (this.linkStatus == LINK_STATUS.GOAWAY_IN_PROGRESS) {
                shouldClose = true;
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"close : triggering the wait to close", (Object[])new Object[0]);
                }
                ScheduledExecutorService scheduler = CHFWBundle.getScheduledExecutorService();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("close : scheduler : " + scheduler + " config : " + this.config), (Object[])new Object[0]);
                }
                this.connTimeout = new H2ConnectionTimeout(inVC, e);
                this.closeFuture = scheduler.schedule(this.connTimeout, this.config.getH2ConnCloseTimeout(), TimeUnit.SECONDS);
            }
        }
        if (shouldClose) {
            ConnectionLink deviceLink;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"close : calling device link close", (Object[])new Object[0]);
            }
            if ((deviceLink = this.getDeviceLink()) != null) {
                this.getDeviceLink().close(this.initialVC, e);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"close : device link was null, cannot close", (Object[])new Object[0]);
            }
        }
    }

    public void triggerLinkClose(VirtualConnection inVC, Exception inE) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("triggerLinkClose : " + (Object)((Object)this.initialHttpInboundLink) + ", " + this.initialHttpInboundLink.getDeviceLink()), (Object[])new Object[0]);
        }
        this.linkStatus = LINK_STATUS.CLOSING;
        this.initialHttpInboundLink.getDeviceLink().close(inVC, inE);
    }

    public void triggerStreamClose(H2StreamProcessor streamProcessor) {
        if (this.closeTable.size() >= 512) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"triggerStreamClose : close table size greater than or equal to 512, purge the table of old entries", (Object[])new Object[0]);
            }
            this.purgeCloseTable();
        }
        streamProcessor.setCloseTime(System.nanoTime());
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("triggerStreamClose : move stream into close table.  stream-id: " + streamProcessor.myID), (Object[])new Object[0]);
        }
        this.closeTable.put(streamProcessor.myID, streamProcessor);
        this.streamTable.remove(streamProcessor.myID);
    }

    public H2StreamProcessor getStream(int streamID) {
        H2StreamProcessor streamProcessor = null;
        streamProcessor = this.streamTable.get(streamID);
        if (streamProcessor == null) {
            streamProcessor = this.closeTable.get(streamID);
        }
        return streamProcessor;
    }

    public boolean significantlyPastCloseTime(int streamID) {
        if (this.streamTable.contains(streamID)) {
            return false;
        }
        if (this.closeTable.containsKey(streamID)) {
            H2StreamProcessor streamProcessor = this.closeTable.get(streamID);
            if (streamProcessor.getCloseTime() != 0L) {
                long diff = System.nanoTime() - streamProcessor.getCloseTime();
                if (diff > CLOSE_TABLE_PURGE_TIME) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("stream-id: " + streamID + " closed and significantly past the close time, close time: " + streamProcessor.getCloseTime() + " now: " + System.nanoTime() + " diff: " + diff), (Object[])new Object[0]);
                    }
                    this.closeTable.remove(streamID);
                    return true;
                }
                return false;
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Stream ID: " + streamID + " not in stream or close table"), (Object[])new Object[0]);
        }
        return true;
    }

    public void purgeCloseTable() {
        long now = System.nanoTime();
        for (Map.Entry<Integer, H2StreamProcessor> entry : this.closeTable.entrySet()) {
            if (entry.getValue().getCloseTime() + CLOSE_TABLE_PURGE_TIME >= now) continue;
            this.closeTable.remove(entry.getKey());
        }
    }

    public int getLastStreamToProcess() {
        return this.lastStreamToProcess;
    }

    public void setLastStreamToProcess(int x) {
        this.lastStreamToProcess = x;
    }

    public int getHighestClientStreamId() {
        return this.highestClientStreamId;
    }

    public void setLastStreamToHighestClientStream() {
        this.lastStreamToProcess = this.highestClientStreamId;
    }

    public void startProcessingGoAway() {
        this.processGoAway = true;
    }

    public boolean isProcessingGoAway() {
        return this.processGoAway;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class H2ConnectionTimeout
    implements Runnable {
        private final VirtualConnection vc;
        private final Exception e;
        static final long serialVersionUID = 1163414810296154378L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public H2ConnectionTimeout(VirtualConnection inVC, Exception inE) {
            this.vc = inVC;
            this.e = inE;
        }

        @Override
        public void run() {
            block5: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"H2InboundLink timeout has elapsed, now closing the connection", (Object[])new Object[0]);
                }
                Integer lastID = 0;
                for (Integer i : H2InboundLink.this.streamTable.keySet()) {
                    H2StreamProcessor stream = H2InboundLink.this.streamTable.get(i);
                    if (stream.myID <= lastID) continue;
                    lastID = stream.myID;
                }
                H2InboundLink.this.lastStreamToProcess = lastID;
                try {
                    H2InboundLink.this.streamTable.get(0).sendGOAWAYFrame(new Http2Exception("the http2 connection has timed out"));
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.http.channel.h2internal.H2InboundLink$H2ConnectionTimeout", (String)"810", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block5;
                    Tr.debug((TraceComponent)tc, (String)"H2InboundLink Exception received while sending GOAWAY, closing link anyway", (Object[])new Object[0]);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"H2InboundLink timeout has ended, now calling closing", (Object[])new Object[0]);
            }
            H2InboundLink.this.triggerLinkClose(this.vc, this.e);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(H2ConnectionTimeout.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class AsyncCallback
    implements Runnable {
        static final long serialVersionUID = 4538248969825901376L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected AsyncCallback() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            block3: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"doing async callback internally on a new thread", (Object[])new Object[0]);
                }
                try {
                    H2InboundLink.this.h2MuxReadCallback.complete(H2InboundLink.this.initialVC, H2InboundLink.this.h2MuxTCPReadContext);
                }
                catch (Throwable throwable) {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.http.channel.h2internal.H2InboundLink$AsyncCallback", (String)"361", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("caught a Throwable. log and leave: " + t), (Object[])new Object[0]);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AsyncCallback.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class WRITE_LINK_STATUS
    extends Enum<WRITE_LINK_STATUS> {
        public static final /* enum */ WRITE_LINK_STATUS NOT_WRITING;
        public static final /* enum */ WRITE_LINK_STATUS WRITE_IN_PROGRESS;
        private static final /* synthetic */ WRITE_LINK_STATUS[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static WRITE_LINK_STATUS[] values() {
            return (WRITE_LINK_STATUS[])$VALUES.clone();
        }

        public static WRITE_LINK_STATUS valueOf(String name) {
            return Enum.valueOf(WRITE_LINK_STATUS.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WRITE_LINK_STATUS.class);
            NOT_WRITING = new WRITE_LINK_STATUS();
            WRITE_IN_PROGRESS = new WRITE_LINK_STATUS();
            $VALUES = new WRITE_LINK_STATUS[]{NOT_WRITING, WRITE_IN_PROGRESS};
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class READ_LINK_STATUS
    extends Enum<READ_LINK_STATUS> {
        public static final /* enum */ READ_LINK_STATUS NOT_READING;
        public static final /* enum */ READ_LINK_STATUS READ_OUTSTANDING;
        public static final /* enum */ READ_LINK_STATUS PROCESSING_READ;
        private static final /* synthetic */ READ_LINK_STATUS[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static READ_LINK_STATUS[] values() {
            return (READ_LINK_STATUS[])$VALUES.clone();
        }

        public static READ_LINK_STATUS valueOf(String name) {
            return Enum.valueOf(READ_LINK_STATUS.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(READ_LINK_STATUS.class);
            NOT_READING = new READ_LINK_STATUS();
            READ_OUTSTANDING = new READ_LINK_STATUS();
            PROCESSING_READ = new READ_LINK_STATUS();
            $VALUES = new READ_LINK_STATUS[]{NOT_READING, READ_OUTSTANDING, PROCESSING_READ};
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class LINK_STATUS
    extends Enum<LINK_STATUS> {
        public static final /* enum */ LINK_STATUS INIT;
        public static final /* enum */ LINK_STATUS OPEN;
        public static final /* enum */ LINK_STATUS GOAWAY_IN_PROGRESS;
        public static final /* enum */ LINK_STATUS CLOSING;
        public static final /* enum */ LINK_STATUS CLOSED;
        private static final /* synthetic */ LINK_STATUS[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static LINK_STATUS[] values() {
            return (LINK_STATUS[])$VALUES.clone();
        }

        public static LINK_STATUS valueOf(String name) {
            return Enum.valueOf(LINK_STATUS.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(LINK_STATUS.class);
            INIT = new LINK_STATUS();
            OPEN = new LINK_STATUS();
            GOAWAY_IN_PROGRESS = new LINK_STATUS();
            CLOSING = new LINK_STATUS();
            CLOSED = new LINK_STATUS();
            $VALUES = new LINK_STATUS[]{INIT, OPEN, GOAWAY_IN_PROGRESS, CLOSING, CLOSED};
        }
    }
}

