/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2WorkQInterface;
import com.ibm.ws.http.channel.h2internal.H2WriteQEntry;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.io.IOException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class H2MuxTCPWriteCallback
implements TCPWriteCompletedCallback {
    private static final TraceComponent tc = Tr.register(H2MuxTCPWriteCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    H2WriteQEntry qEntry = null;
    H2WorkQInterface h2WorkQ = null;
    static final long serialVersionUID = -2459292427011428973L;

    public void setCurrentQEntry(H2WriteQEntry x) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("muxCallback entry set to stream-id: " + x.getStreamID()), (Object[])new Object[0]);
        }
        this.qEntry = x;
    }

    public void setH2WorkQ(H2WorkQInterface x) {
        this.h2WorkQ = x;
    }

    public void complete(VirtualConnection vc, TCPWriteRequestContext twc) {
        this.commonProcessing(vc, twc, null, true);
    }

    public void error(VirtualConnection vc, TCPWriteRequestContext twc, IOException ioe) {
        this.commonProcessing(vc, twc, ioe, false);
    }

    /*
     * WARNING - void declaration
     */
    public void commonProcessing(VirtualConnection vc, TCPWriteRequestContext twc, IOException ioe, boolean complete) {
        block12: {
            if (this.qEntry == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"no queue entries for this callback", (Object[])new Object[0]);
                }
                return;
            }
            if (this.qEntry.getWriteType() == H2WriteQEntry.WRITE_TYPE.ASYNC) {
                VirtualConnection eVC = this.qEntry.getConnectionContext().getVC();
                TCPWriteRequestContext eTWC = this.qEntry.getConnectionContext().getWriteInterface();
                try {
                    if (complete) {
                        if (this.h2WorkQ != null && this.qEntry.getFrameType() == FrameTypes.DATA) {
                            this.h2WorkQ.decreaseConnectionWindowUpdateWriteLimit(this.qEntry.getPayloadLength());
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("invoke complete callback vc: " + eVC + " TWC: " + eTWC), (Object[])new Object[0]);
                        }
                        this.qEntry.getCallback().complete(eVC, eTWC);
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("invoke error callback vc: " + eVC + " TWC: " + eTWC), (Object[])new Object[0]);
                        }
                        this.qEntry.getCallback().error(eVC, eTWC, ioe);
                    }
                }
                catch (Throwable throwable) {
                    void t;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.http.channel.h2internal.H2MuxTCPWriteCallback", (String)"91", (Object)this, (Object[])new Object[]{vc, twc, ioe, complete});
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block12;
                    Tr.debug((TraceComponent)tc, (String)("caught a Throwable. log and leave: " + t), (Object[])new Object[0]);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("hit write complete latch for qentry: " + this.qEntry.hashCode()), (Object[])new Object[0]);
        }
        this.qEntry.hitWriteCompleteLatch();
        if (this.h2WorkQ != null) {
            this.h2WorkQ.notifyStandBy();
        }
    }
}

