/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.h2internal.Constants;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2HttpInboundLinkWrap;
import com.ibm.ws.http.channel.h2internal.H2InboundLink;
import com.ibm.ws.http.channel.h2internal.StreamState;
import com.ibm.ws.http.channel.h2internal.exceptions.CompressionException;
import com.ibm.ws.http.channel.h2internal.exceptions.FlowControlException;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.exceptions.StreamClosedException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.FrameContinuation;
import com.ibm.ws.http.channel.h2internal.frames.FrameData;
import com.ibm.ws.http.channel.h2internal.frames.FrameGoAway;
import com.ibm.ws.http.channel.h2internal.frames.FrameHeaders;
import com.ibm.ws.http.channel.h2internal.frames.FramePing;
import com.ibm.ws.http.channel.h2internal.frames.FramePriority;
import com.ibm.ws.http.channel.h2internal.frames.FrameRstStream;
import com.ibm.ws.http.channel.h2internal.frames.FrameSettings;
import com.ibm.ws.http.channel.h2internal.frames.FrameWindowUpdate;
import com.ibm.ws.http.channel.h2internal.frames.utils;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderField;
import com.ibm.ws.http.channel.h2internal.hpack.H2Headers;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferPoolManager;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class H2StreamProcessor {
    private static final TraceComponent tc = Tr.register(H2StreamProcessor.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    StreamState state = StreamState.IDLE;
    Frame currentFrame;
    FrameTypes frameType;
    byte[] headerBlock;
    byte[] dataPayload;
    int weight = 0;
    boolean exclusive = false;
    int streamDependency = 0;
    long readReceivedCount = 0L;
    long readRequestSize = 0L;
    private boolean headersCompleted = false;
    private boolean continuationExpected = false;
    public boolean endStream = false;
    int myID = -1;
    H2HttpInboundLinkWrap h2HttpInboundLinkWrap = null;
    H2InboundLink muxLink = null;
    private long streamWindowUpdateWriteInitialSize;
    private long streamWindowUpdateWriteLimit;
    private long streamReadWindowSize = Constants.SPEC_INITIAL_WINDOW_SIZE;
    private boolean waitingForWindowUpdate = false;
    Queue<FrameData> dataWaitingForWindowUpdate;
    private long closeTime = 0L;
    WsByteBuffer[] streamReadReady = new WsByteBuffer[32];
    int streamReadSize = 0;
    int streamReadBufferIndex = 0;
    long actualReadCount = 0L;
    static final long serialVersionUID = 37412728033146119L;

    public H2StreamProcessor(Integer id, H2HttpInboundLinkWrap link, H2InboundLink m) {
        this(id, link, m, StreamState.IDLE);
    }

    public H2StreamProcessor(Integer id, H2HttpInboundLinkWrap link, H2InboundLink m, StreamState state) {
        this.myID = id;
        this.h2HttpInboundLinkWrap = link;
        this.muxLink = m;
        this.streamReadWindowSize = this.muxLink.maxReadWindowSize;
        this.updateStreamState(state);
        this.streamWindowUpdateWriteInitialSize = this.muxLink.getInitialWindowSize();
        this.streamWindowUpdateWriteLimit = this.muxLink.getInitialWindowSize();
    }

    protected void completeConnectionPreface() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"completeConnectionPreface entry: about to send SETTINGS frame to ACK receipt of MAGIC", (Object[])new Object[0]);
        }
        this.currentFrame = (long)Constants.SPEC_INITIAL_WINDOW_SIZE != this.streamReadWindowSize ? new FrameSettings(0, -1, -1, -1, (int)this.streamReadWindowSize, -1, -1, false) : new FrameSettings();
        this.frameType = FrameTypes.SETTINGS;
        try {
            this.writeFrameSync();
        }
        catch (FlowControlException flowControlException) {
            FFDCFilter.processException((Throwable)flowControlException, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"150", (Object)this, (Object[])new Object[0]);
        }
        if ((long)Constants.SPEC_INITIAL_WINDOW_SIZE != this.muxLink.maxReadWindowSize) {
            this.currentFrame = new FrameWindowUpdate(0, (int)this.muxLink.maxReadWindowSize, false);
            try {
                this.writeFrameSync();
            }
            catch (FlowControlException flowControlException) {
                FFDCFilter.processException((Throwable)flowControlException, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"158", (Object)this, (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void processNextFrame(Frame frame, Constants.Direction direction) throws ProtocolException {
        boolean doDebugWhile = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processNextFrame-entry:  stream: " + this.myID + " frame type: " + frame.getFrameType().toString() + " direction: " + direction.toString()), (Object[])new Object[0]);
        }
        if (this.isStreamClosed()) {
            if (direction.equals((Object)Constants.Direction.WRITING_OUT)) {
                if (this.muxLink.significantlyPastCloseTime(this.myID)) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"processNextFrame: Stream significantly past close time - throwing ProtocolException", (Object[])new Object[0]);
                    }
                    throw new ProtocolException("Stream significantly past close time");
                }
                if (frame.getFrameType() == FrameTypes.PRIORITY || frame.getFrameType() == FrameTypes.WINDOW_UPDATE || frame.getFrameType() == FrameTypes.RST_STREAM) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"processNextFrame: close, not past time, ignoring frame", (Object[])new Object[0]);
                    }
                    return;
                }
                if (frame.getFrameType() == FrameTypes.HEADERS || frame.getFrameType() == FrameTypes.DATA || frame.getFrameType() == FrameTypes.PUSH_PROMISE) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"processNextFrame: Stream is closed - throwing ProtocolException", (Object[])new Object[0]);
                    }
                    throw new ProtocolException("Stream is closed, can't write out HEADER, DATA, or PUSH_PROMISE frames");
                }
            } else if (direction.equals((Object)Constants.Direction.READ_IN)) {
                if (frame.getFrameType() == FrameTypes.PRIORITY) {
                    return;
                }
                if (this.muxLink.significantlyPastCloseTime(this.myID)) {
                    throw new ProtocolException("Stream is already closed");
                }
                if (frame.getFrameType() == FrameTypes.DATA || frame.getFrameType() == FrameTypes.HEADERS) {
                    if (this.state.equals((Object)StreamState.HALF_CLOSED_REMOTE)) {
                        throw new ProtocolException("Stream half closed remote and received a DATA or HEADERS frame");
                    }
                    return;
                }
                if (frame.getFrameType() == FrameTypes.RST_STREAM) {
                    return;
                }
            }
        }
        ADDITIONAL_FRAME addFrame = ADDITIONAL_FRAME.FIRST_TIME;
        Http2Exception addFrameException = null;
        this.currentFrame = frame;
        while (addFrame != ADDITIONAL_FRAME.NO) {
            block69: {
                if (doDebugWhile) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processNextFrame- in while: stream-id: " + this.myID + " frame type: " + frame.getFrameType().toString() + " direction: " + direction.toString()), (Object[])new Object[0]);
                    }
                } else {
                    doDebugWhile = true;
                }
                if (addFrame == ADDITIONAL_FRAME.RESET) {
                    this.currentFrame = new FrameRstStream(this.myID, addFrameException.getErrorCode(), false);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processNextFrame: exception encountered.  Sending RST_STREAM on stream " + this.myID + " with the error code " + addFrameException.getErrorString()), (Object[])new Object[0]);
                    }
                    direction = Constants.Direction.WRITING_OUT;
                }
                if (addFrame == ADDITIONAL_FRAME.GOAWAY) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processNextFrame: addFrame GOAWAY: highestStreamIDToProcess: " + this.muxLink.getLastStreamToProcess()), (Object[])new Object[0]);
                    }
                    this.currentFrame = new FrameGoAway(0, addFrameException.getMessage().getBytes(), addFrameException.getErrorCode(), this.muxLink.getLastStreamToProcess(), false);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("processNextFrame: exception encountered.  Sending a GOAWAY frame with the error code " + addFrameException.getErrorString()), (Object[])new Object[0]);
                    }
                    direction = Constants.Direction.WRITING_OUT;
                }
                this.frameType = this.currentFrame.getFrameType();
                if (this.frameType == FrameTypes.RST_STREAM && addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                    addFrame = ADDITIONAL_FRAME.RESET;
                } else if (this.frameType == FrameTypes.GOAWAY && addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                    addFrame = ADDITIONAL_FRAME.GOAWAY;
                }
                try {
                    this.currentFrame.validate(this.muxLink.getConnectionSettings());
                }
                catch (Http2Exception http2Exception) {
                    void e;
                    FFDCFilter.processException((Throwable)http2Exception, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"283", (Object)this, (Object[])new Object[]{frame, direction});
                    if (addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                        addFrame = e.isConnectionError() ? ADDITIONAL_FRAME.GOAWAY : ADDITIONAL_FRAME.RESET;
                        addFrameException = e;
                        continue;
                    }
                    if (direction == Constants.Direction.READ_IN) {
                        addFrame = ADDITIONAL_FRAME.RESET;
                        addFrameException = e;
                    }
                    addFrame = ADDITIONAL_FRAME.NO;
                    continue;
                }
                if (direction == Constants.Direction.READ_IN) {
                    block68: {
                        if (this.muxLink.isProcessingGoAway() && frame.getStreamId() > this.muxLink.getLastStreamToProcess()) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("processNextFrame: " + (Object)((Object)this.currentFrame.getFrameType()) + " received on stream " + this.myID + " after a GOAWAY was sent.  This frame will be ignored."), (Object[])new Object[0]);
                            }
                            return;
                        }
                        if (this.isContinuationFrameExpected() && (this.frameType != FrameTypes.CONTINUATION || !this.continuationExpected)) {
                            addFrame = ADDITIONAL_FRAME.GOAWAY;
                            addFrameException = new ProtocolException("Did not receive the expected continuation frame");
                            System.out.println("wtlucy: writing exception for mismatched continuation");
                            continue;
                        }
                        if (this.frameType == FrameTypes.RST_STREAM || this.frameType == FrameTypes.SETTINGS || this.frameType == FrameTypes.GOAWAY || this.frameType == FrameTypes.PING) {
                            switch (this.frameType) {
                                case RST_STREAM: {
                                    this.processRstFrame();
                                    break;
                                }
                                case SETTINGS: {
                                    this.processSETTINGSFrame();
                                    break;
                                }
                                case GOAWAY: {
                                    this.processGOAWAYFrame();
                                    this.updateStreamState(StreamState.CLOSED);
                                    break;
                                }
                                case PING: {
                                    this.processPINGFrame();
                                    break;
                                }
                            }
                            return;
                        }
                        try {
                            this.verifyReadFrameSequence();
                        }
                        catch (Http2Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"353", (Object)this, (Object[])new Object[]{frame, direction});
                            if (addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                                addFrame = e.isConnectionError() ? ADDITIONAL_FRAME.GOAWAY : ADDITIONAL_FRAME.RESET;
                                addFrameException = e;
                                continue;
                            }
                            addFrame = ADDITIONAL_FRAME.NO;
                            continue;
                        }
                        if (this.frameType == FrameTypes.PRIORITY) {
                            this.processPriorityFrame();
                            return;
                        }
                        try {
                            if (this.frameType != FrameTypes.WINDOW_UPDATE) break block68;
                            this.processWindowUpdateFrame();
                            if (this.dataWaitingForWindowUpdate != null) {
                                if (!this.isWindowLimitExceeded(this.dataWaitingForWindowUpdate.peek())) {
                                    this.waitingForWindowUpdate = false;
                                }
                                break block68;
                            }
                            return;
                        }
                        catch (Http2Exception e) {
                            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"390", (Object)this, (Object[])new Object[]{frame, direction});
                            if (addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                                if (e.isConnectionError()) {
                                    addFrame = ADDITIONAL_FRAME.GOAWAY;
                                    continue;
                                }
                                addFrame = ADDITIONAL_FRAME.RESET;
                                continue;
                            }
                            addFrame = ADDITIONAL_FRAME.NO;
                            continue;
                        }
                    }
                    try {
                        this.updateStreamReadWindow();
                    }
                    catch (Http2Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"407", (Object)this, (Object[])new Object[]{frame, direction});
                        if (addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                            addFrame = e.isConnectionError() ? ADDITIONAL_FRAME.GOAWAY : ADDITIONAL_FRAME.RESET;
                            addFrameException = e;
                            continue;
                        }
                        addFrame = ADDITIONAL_FRAME.NO;
                        continue;
                    }
                    try {
                        this.readWriteTransitionState(direction);
                        break block69;
                    }
                    catch (CompressionException e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"423", (Object)this, (Object[])new Object[]{frame, direction});
                        if (addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                            Tr.info((TraceComponent)tc, (String)"A Header compression error occurred!  This connection is no longer valid.", (Object[])new Object[0]);
                            addFrame = ADDITIONAL_FRAME.GOAWAY;
                            addFrameException = e;
                            continue;
                        }
                        addFrame = ADDITIONAL_FRAME.NO;
                        continue;
                    }
                    catch (Http2Exception e) {
                        FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"433", (Object)this, (Object[])new Object[]{frame, direction});
                        if (addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                            addFrame = e.isConnectionError() ? ADDITIONAL_FRAME.GOAWAY : ADDITIONAL_FRAME.RESET;
                            addFrameException = e;
                            continue;
                        }
                        addFrame = ADDITIONAL_FRAME.NO;
                        continue;
                    }
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processNextFrame Writing out data", (Object[])new Object[0]);
                }
                try {
                    this.verifyWriteFrameSequence();
                    this.readWriteTransitionState(direction);
                }
                catch (CompressionException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"453", (Object)this, (Object[])new Object[]{frame, direction});
                    if (addFrame == ADDITIONAL_FRAME.FIRST_TIME || addFrame == ADDITIONAL_FRAME.RESET) {
                        Tr.info((TraceComponent)tc, (String)"A Header compression error occurred!  This connection is no longer valid.", (Object[])new Object[0]);
                        addFrame = ADDITIONAL_FRAME.GOAWAY;
                        addFrameException = e;
                        continue;
                    }
                    addFrame = ADDITIONAL_FRAME.NO;
                    continue;
                }
                catch (Http2Exception e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"463", (Object)this, (Object[])new Object[]{frame, direction});
                    if (addFrame == ADDITIONAL_FRAME.FIRST_TIME) {
                        addFrame = e.isConnectionError() ? ADDITIONAL_FRAME.GOAWAY : ADDITIONAL_FRAME.RESET;
                        addFrameException = e;
                        continue;
                    }
                    addFrame = ADDITIONAL_FRAME.NO;
                    continue;
                }
            }
            if (!this.waitingForWindowUpdate && this.dataWaitingForWindowUpdate != null && !this.isWindowLimitExceeded(this.dataWaitingForWindowUpdate.peek())) {
                addFrame = ADDITIONAL_FRAME.DATA;
                this.currentFrame = this.dataWaitingForWindowUpdate.remove();
                direction = Constants.Direction.WRITING_OUT;
                if (!this.dataWaitingForWindowUpdate.isEmpty()) continue;
                this.dataWaitingForWindowUpdate = null;
                continue;
            }
            addFrame = ADDITIONAL_FRAME.NO;
        }
    }

    private void readWriteTransitionState(Constants.Direction direction) throws Http2Exception {
        if (this.currentFrame.getFrameType() == FrameTypes.GOAWAY || this.currentFrame.getFrameType() == FrameTypes.RST_STREAM) {
            this.writeFrameSync();
            this.updateStreamState(StreamState.CLOSED);
            if (this.currentFrame.getFrameType() == FrameTypes.GOAWAY) {
                this.muxLink.goAway(this.muxLink.getLastStreamToProcess());
            }
            return;
        }
        switch (this.state) {
            case IDLE: {
                this.processIdle(direction);
                break;
            }
            case RESERVED_LOCAL: {
                this.processReservedLocal(direction);
                break;
            }
            case RESERVED_REMOTE: {
                this.processReservedRemote(direction);
                break;
            }
            case OPEN: {
                this.processOpen(direction);
                break;
            }
            case HALF_CLOSED_REMOTE: {
                this.processHalfClosedRemote(direction);
                break;
            }
            case HALF_CLOSED_LOCAL: {
                this.processHalfClosedLocal(direction);
                break;
            }
            case CLOSED: {
                this.processClosed(direction);
                break;
            }
        }
    }

    private void updateStreamState(StreamState state) {
        this.state = state;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("current stream state for stream " + this.myID + " : " + (Object)((Object)this.state)), (Object[])new Object[0]);
        }
        if (state == StreamState.CLOSED || state == StreamState.HALF_CLOSED_LOCAL) {
            this.muxLink.setLastStreamToProcess(this.myID);
        }
    }

    public void initializePromisedStream() {
        this.updateStreamState(StreamState.RESERVED_LOCAL);
    }

    private void processClosed(Constants.Direction direction) {
    }

    private void processHalfClosedLocal(Constants.Direction direction) throws FlowControlException {
        if (direction == Constants.Direction.WRITING_OUT) {
            this.writeFrameSync();
            if (this.currentFrame.getFrameType() == FrameTypes.RST_STREAM) {
                this.endStream = true;
                this.updateStreamState(StreamState.CLOSED);
            }
        } else if (this.currentFrame.getFrameType() == FrameTypes.RST_STREAM || this.currentFrame.flagEndStreamSet()) {
            this.endStream = true;
            this.updateStreamState(StreamState.CLOSED);
        }
    }

    private void processHalfClosedRemote(Constants.Direction direction) throws FlowControlException {
        if (direction == Constants.Direction.WRITING_OUT) {
            boolean writeCompleted = this.writeFrameSync();
            if ((this.currentFrame.getFrameType() == FrameTypes.RST_STREAM || this.currentFrame.flagEndStreamSet()) && writeCompleted) {
                this.endStream = true;
                this.muxLink.triggerStreamClose(this);
                this.updateStreamState(StreamState.CLOSED);
            }
        } else if (this.currentFrame.getFrameType() == FrameTypes.RST_STREAM) {
            this.endStream = true;
            this.updateStreamState(StreamState.CLOSED);
        }
    }

    private void processReservedRemote(Constants.Direction direction) {
    }

    private void processReservedLocal(Constants.Direction direction) throws FlowControlException {
        if (direction == Constants.Direction.WRITING_OUT) {
            if ((this.currentFrame.getFrameType() == FrameTypes.HEADERS || this.currentFrame.getFrameType() == FrameTypes.CONTINUATION) && this.currentFrame.flagEndHeadersSet()) {
                this.updateStreamState(StreamState.HALF_CLOSED_REMOTE);
            }
            this.writeFrameSync();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processSETTINGSFrame() {
        block10: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processSETTINGSFrame entry", (Object[])new Object[0]);
            }
            if (!this.muxLink.connection_preface_settings_rcvd) {
                this.muxLink.connection_preface_settings_rcvd = true;
            }
            if (((FrameSettings)this.currentFrame).flagAckSet()) {
                if (!this.muxLink.connection_preface_settings_ack_rcvd) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"connection preface completed; notify any waiting streams to continue", (Object[])new Object[0]);
                    }
                    this.muxLink.connection_preface_settings_ack_rcvd = true;
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"received a new settings frame: updating connection settings and sending out SETTINGS ACK", (Object[])new Object[0]);
                }
                if (((FrameSettings)this.currentFrame).getInitialWindowSize() != -1) {
                    int newSize = ((FrameSettings)this.currentFrame).getInitialWindowSize();
                    this.muxLink.changeInitialWindowSizeAllStreams(newSize);
                }
                this.muxLink.getConnectionSettings().updateSettings((FrameSettings)this.currentFrame);
                this.currentFrame = new FrameSettings();
                this.currentFrame.setAckFlag();
                try {
                    this.writeFrameSync();
                }
                catch (FlowControlException newSize) {
                    void e;
                    FFDCFilter.processException((Throwable)newSize, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"670", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    Tr.debug((TraceComponent)tc, (String)("writeSync caught (logically unexpected) FlowControlException: " + e), (Object[])new Object[0]);
                }
            }
        }
    }

    private void processPriorityFrame() {
        FramePriority castFrame = (FramePriority)this.currentFrame;
        this.exclusive = castFrame.isExclusive();
        this.streamDependency = castFrame.getStreamDependency();
        this.weight = castFrame.getWeight();
        this.muxLink.getWorkQ().updateNodeFrameParameters(this.myID, this.weight, this.streamDependency, this.exclusive);
    }

    private void processWindowUpdateFrame() throws FlowControlException {
        FrameWindowUpdate castFrame = (FrameWindowUpdate)this.currentFrame;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processWindowUpdateFrame: streamID: " + castFrame.getStreamId() + " desired increment: " + castFrame.getWindowSizeIncrement()), (Object[])new Object[0]);
        }
        if (castFrame.getStreamId() == 0) {
            this.muxLink.incrementConnectionWindowUpdateLimit(castFrame.getWindowSizeIncrement());
        } else {
            long temp = this.streamWindowUpdateWriteLimit + (long)castFrame.getWindowSizeIncrement();
            if ((temp &= Integer.MIN_VALUE) != 0L) {
                String s = "processWindowUpdateFrame: out of bounds increment, current stream write limit: " + this.streamWindowUpdateWriteLimit + " total would have been: " + temp;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)s, (Object[])new Object[0]);
                }
                FlowControlException e = new FlowControlException(s);
                e.setConnectionError(false);
                throw e;
            }
            this.streamWindowUpdateWriteLimit += (long)castFrame.getWindowSizeIncrement();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("processWindowUpdateFrame: new write limit is: " + this.streamWindowUpdateWriteLimit), (Object[])new Object[0]);
            }
        }
    }

    private void updateStreamReadWindow() throws FlowControlException {
        if (this.currentFrame instanceof FrameData) {
            long frameSize = this.currentFrame.getPayloadLength();
            this.streamReadWindowSize -= frameSize;
            this.muxLink.connectionReadWindowSize -= frameSize;
            if (this.streamReadWindowSize < this.muxLink.maxReadWindowSize / 2L || this.muxLink.connectionReadWindowSize < this.muxLink.maxReadWindowSize / 2L) {
                int windowChange = (int)(this.muxLink.maxReadWindowSize - this.streamReadWindowSize);
                Frame savedFrame = this.currentFrame;
                this.currentFrame = new FrameWindowUpdate(this.myID, windowChange, false);
                this.writeFrameSync();
                long windowSizeIncrement = this.muxLink.maxReadWindowSize - this.muxLink.connectionReadWindowSize;
                this.currentFrame = new FrameWindowUpdate(0, (int)windowSizeIncrement, false);
                this.writeFrameSync();
                this.currentFrame = savedFrame;
            }
        }
    }

    protected void updateInitialWindowsUpdateSize(int newSize) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateInitialWindowsUpdateSize entry: newSize: " + newSize), (Object[])new Object[0]);
        }
        long diff = (long)newSize - this.streamWindowUpdateWriteInitialSize;
        this.streamWindowUpdateWriteInitialSize = newSize;
        this.streamWindowUpdateWriteLimit += diff;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("streamWindowUpdateWriteInitialSize updated to: " + this.streamWindowUpdateWriteInitialSize), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("streamWindowUpdateWriteLimit updated to: " + this.streamWindowUpdateWriteLimit), (Object[])new Object[0]);
        }
    }

    public void sendGOAWAYFrame(Http2Exception e) throws ProtocolException {
        this.muxLink.startProcessingGoAway();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sendGOAWAYFrame sending a GOAWAY with Last-Stream-ID " + this.muxLink.getLastStreamToProcess() + " and exception " + e.toString()), (Object[])new Object[0]);
        }
        FrameGoAway frame = new FrameGoAway(0, e.getMessage().getBytes(), e.getErrorCode(), this.muxLink.getLastStreamToProcess(), false);
        this.processNextFrame(frame, Constants.Direction.WRITING_OUT);
    }

    /*
     * WARNING - void declaration
     */
    private void processGOAWAYFrame() {
        int lastStreamId;
        block3: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processGOAWAYFrame entry: begin connection shutdown and send reciprocal GOAWAY to client", (Object[])new Object[0]);
            }
            this.muxLink.startProcessingGoAway();
            lastStreamId = ((FrameGoAway)this.currentFrame).getLastStreamId();
            this.muxLink.triggerStreamClose(this);
            this.muxLink.setLastStreamToProcess(lastStreamId);
            this.currentFrame = new FrameGoAway(0, new byte[0], 0, this.muxLink.getLastStreamToProcess(), false);
            try {
                this.writeFrameSync();
            }
            catch (FlowControlException flowControlException) {
                void e;
                FFDCFilter.processException((Throwable)flowControlException, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"807", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("writeSync caught (logically unexpected) FlowControlException: " + e), (Object[])new Object[0]);
            }
        }
        this.muxLink.goAway(lastStreamId);
    }

    /*
     * WARNING - void declaration
     */
    private void processPINGFrame() {
        block3: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"processPINGFrame entry: send reciprocal PING frame to client", (Object[])new Object[0]);
            }
            byte[] data = ((FramePing)this.currentFrame).getPayload();
            this.currentFrame = new FramePing(0, data, false);
            this.currentFrame.setAckFlag();
            try {
                this.writeFrameSync();
            }
            catch (FlowControlException flowControlException) {
                void e;
                FFDCFilter.processException((Throwable)flowControlException, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"828", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("writeSync caught (logically unexpected) FlowControlException: " + e), (Object[])new Object[0]);
            }
        }
    }

    private void processRstFrame() {
        int error = ((FrameRstStream)this.currentFrame).getErrorCode();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processRstFrame: error received from peer: " + utils.getErrorFromCode(error)), (Object[])new Object[0]);
        }
        this.muxLink.triggerStreamClose(this);
        this.updateStreamState(StreamState.CLOSED);
    }

    private void processIdle(Constants.Direction direction) throws CompressionException, FlowControlException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processIdle entry: stream " + this.myID), (Object[])new Object[0]);
        }
        if (direction == Constants.Direction.READ_IN) {
            if (this.frameType == FrameTypes.HEADERS) {
                this.processHeadersPriority();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("header frame read in on stream " + this.myID), (Object[])new Object[0]);
                }
                this.getHeadersFromFrame();
                if (this.currentFrame.flagEndHeadersSet()) {
                    this.setHeadersComplete();
                    this.processCompleteHeaders();
                    if (this.currentFrame.flagEndStreamSet()) {
                        this.updateStreamState(StreamState.HALF_CLOSED_REMOTE);
                        this.endStream = true;
                        this.setReadyForRead();
                    } else {
                        this.updateStreamState(StreamState.OPEN);
                    }
                } else {
                    this.setContinuationFrameExpected(true);
                    if (this.currentFrame.flagEndStreamSet()) {
                        this.endStream = true;
                    }
                }
            }
            if (this.frameType == FrameTypes.CONTINUATION) {
                this.getHeadersFromFrame();
                if (this.currentFrame.flagEndHeadersSet()) {
                    this.setHeadersComplete();
                    this.processCompleteHeaders();
                    this.updateStreamState(StreamState.OPEN);
                }
                if (this.endStream) {
                    this.updateStreamState(StreamState.HALF_CLOSED_REMOTE);
                } else {
                    this.updateStreamState(StreamState.OPEN);
                }
            }
        } else {
            if (this.frameType == FrameTypes.HEADERS) {
                this.updateStreamState(StreamState.OPEN);
                if (!this.currentFrame.flagEndHeadersSet()) {
                    this.setContinuationFrameExpected(true);
                }
            }
            this.writeFrameSync();
        }
    }

    private void processOpen(Constants.Direction direction) throws ProtocolException, FlowControlException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processOpen entry: stream " + this.myID), (Object[])new Object[0]);
        }
        if (direction == Constants.Direction.READ_IN) {
            if (this.frameType == FrameTypes.DATA) {
                this.getBodyFromFrame();
                if (this.currentFrame.flagEndStreamSet()) {
                    this.endStream = true;
                    this.updateStreamState(StreamState.HALF_CLOSED_REMOTE);
                    this.setReadyForRead();
                }
            }
        } else {
            if (this.frameType != FrameTypes.PUSH_PROMISE && (this.frameType == FrameTypes.HEADERS || this.frameType == FrameTypes.CONTINUATION)) {
                if (this.currentFrame.flagEndHeadersSet()) {
                    this.setContinuationFrameExpected(false);
                    if (this.currentFrame.flagEndStreamSet()) {
                        this.endStream = true;
                        this.updateStreamState(StreamState.HALF_CLOSED_LOCAL);
                    }
                } else {
                    this.setContinuationFrameExpected(true);
                    if (this.currentFrame.flagEndStreamSet()) {
                        this.endStream = true;
                    }
                }
            }
            boolean writeCompleted = this.writeFrameSync();
            if (this.frameType == FrameTypes.DATA && writeCompleted && this.currentFrame.flagEndStreamSet()) {
                this.endStream = true;
                this.updateStreamState(StreamState.HALF_CLOSED_LOCAL);
            }
        }
    }

    private boolean isWindowLimitExceeded(Frame frame) {
        if (this.streamWindowUpdateWriteLimit - (long)frame.getPayloadLength() < 0L || this.muxLink.getWorkQ().getConnectionWriteLimit() - frame.getPayloadLength() < 0) {
            String s = "Cannot write Data Frame because it would exceed the stream window update limit.streamWindowUpdateWriteLimit: " + this.streamWindowUpdateWriteLimit + " streamWindowUpdateWriteInitialSize: " + this.streamWindowUpdateWriteInitialSize + " frame size: " + frame.getPayloadLength();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)s, (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    @ManualTrace
    public void sendRequestToWc(FrameHeaders frame) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"sendRequestToWc", (Object[])new Object[0]);
        }
        if (null == frame) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sendRequestToWc: frame is null", (Object[])new Object[0]);
            }
        } else {
            WsByteBufferPoolManager bufManager = HttpDispatcher.getBufferManager();
            WsByteBuffer buf = bufManager.allocate(frame.buildFrameForWrite().length);
            byte[] ba = frame.buildFrameForWrite();
            buf.put(ba);
            buf.flip();
            TCPReadRequestContext readi = this.h2HttpInboundLinkWrap.getConnectionContext().getReadInterface();
            readi.setBuffer(buf);
            this.currentFrame = frame;
            this.getHeadersFromFrame();
            this.setHeadersComplete();
            try {
                this.processCompleteHeaders();
            }
            catch (CompressionException compressionException) {
                FFDCFilter.processException((Throwable)compressionException, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"1028", (Object)this, (Object[])new Object[]{frame});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("sendRequestToWc: compression exception when creating the pushed reqeust on stream-id " + this.myID), (Object[])new Object[0]);
                }
                buf.release();
                this.currentFrame = null;
                this.h2HttpInboundLinkWrap.muxLink.streamTable.remove(this);
                return;
            }
            this.setReadyForRead();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"sendRequestToWc");
        }
    }

    private void verifyReadFrameSequence() throws ProtocolException, StreamClosedException {
        if (!this.currentFrame.isReadFrame()) {
            throw new ProtocolException("Write frame was given for Read frame processing");
        }
        switch (this.frameType) {
            case DATA: {
                if (this.state == StreamState.OPEN || this.state == StreamState.HALF_CLOSED_LOCAL) break;
                throw new StreamClosedException("DATA Frame Received in the wrong state of: " + (Object)((Object)this.state));
            }
            case HEADERS: {
                if (this.state != StreamState.IDLE) {
                    throw new ProtocolException("HEADERS Frame Received in the wrong state of: " + (Object)((Object)this.state));
                }
                if (this.state != StreamState.HALF_CLOSED_REMOTE) break;
                throw new StreamClosedException("HEADERS Frame Received in the wrong state of: " + (Object)((Object)this.state));
            }
            case PRIORITY: {
                break;
            }
            case RST_STREAM: {
                if (this.state != StreamState.IDLE) break;
                throw new ProtocolException("RST_STREAM Frame Received in the wrong state of: " + (Object)((Object)this.state));
            }
            case PUSH_PROMISE: {
                throw new ProtocolException("PUSH_PROMISE Frame Received on server side");
            }
            case WINDOW_UPDATE: {
                break;
            }
            case CONTINUATION: {
                if (!this.isContinuationFrameExpected()) {
                    throw new ProtocolException("CONTINUATION Frame Received when not in a Continuation State");
                }
                if (this.state != StreamState.HALF_CLOSED_REMOTE) break;
                throw new StreamClosedException("CONTINUATION Frame Received in the wrong state of: " + (Object)((Object)this.state));
            }
        }
    }

    private void verifyWriteFrameSequence() throws ProtocolException {
        if (!this.currentFrame.isWriteFrame()) {
            throw new ProtocolException("Read frame was given for Write frame processing");
        }
        switch (this.frameType) {
            case DATA: {
                if (this.state == StreamState.OPEN || this.state == StreamState.HALF_CLOSED_REMOTE) break;
                throw new ProtocolException("DATA Frame cannot be sent in this state: " + (Object)((Object)this.state));
            }
            case HEADERS: {
                if (this.state == StreamState.IDLE || this.state == StreamState.OPEN || this.state == StreamState.HALF_CLOSED_REMOTE || this.state == StreamState.RESERVED_LOCAL) break;
                throw new ProtocolException("HEADERS Frame cannot be sent in this state: " + (Object)((Object)this.state));
            }
            case PRIORITY: {
                if (!this.isContinuationFrameExpected()) break;
                throw new ProtocolException("PRIORITY Frame sent when in a Continuation State of: " + (Object)((Object)this.state));
            }
            case RST_STREAM: {
                if (this.state != StreamState.IDLE) break;
                throw new ProtocolException("RST_STREAM Frame cannot be sent in this state: " + (Object)((Object)this.state));
            }
            case SETTINGS: {
                break;
            }
            case PUSH_PROMISE: {
                if (this.state == StreamState.OPEN || this.state == StreamState.HALF_CLOSED_REMOTE) break;
                throw new ProtocolException("PUSH_PROMISE Frame cannot be sent in this state: " + (Object)((Object)this.state));
            }
            case WINDOW_UPDATE: {
                break;
            }
            case CONTINUATION: {
                if (this.isContinuationFrameExpected()) break;
                throw new ProtocolException("CONTINUATION Frame sent when not in a Continuation State");
            }
        }
    }

    private void setHeadersComplete() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("completed headers have been received stream " + this.myID), (Object[])new Object[0]);
        }
        this.headersCompleted = true;
        this.setContinuationFrameExpected(false);
    }

    public boolean isContinuationFrameExpected() {
        return this.muxLink.isContinuationExpected();
    }

    public void setContinuationFrameExpected(boolean expected) {
        this.muxLink.setContinuationExpected(expected);
        this.continuationExpected = expected;
    }

    private void processHeadersPriority() {
        FrameHeaders castFrame = (FrameHeaders)this.currentFrame;
        if (castFrame.flagPrioritySet()) {
            int weight = castFrame.getWeight();
            int streamDependency = castFrame.getStreamDependency();
            boolean exclusive = castFrame.isExclusive();
            this.muxLink.getWorkQ().updateNodeFrameParameters(this.myID, weight, streamDependency, exclusive);
        }
    }

    private void getHeadersFromFrame() {
        byte[] hbf = null;
        if (this.currentFrame.getFrameType() == FrameTypes.HEADERS) {
            hbf = ((FrameHeaders)this.currentFrame).getHeaderBlockFragment();
        } else if (this.currentFrame.getFrameType() == FrameTypes.CONTINUATION) {
            hbf = ((FrameContinuation)this.currentFrame).getHeaderBlockFragment();
        }
        if (hbf != null) {
            this.headerBlock = this.headerBlock == null ? hbf : this.concatenateArrays(this.headerBlock, hbf);
        }
    }

    private void processCompleteHeaders() throws CompressionException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("processCompleteHeaders entry: stream " + this.myID), (Object[])new Object[0]);
        }
        if (this.headerBlock != null) {
            WsByteBufferPoolManager bufManager = HttpDispatcher.getBufferManager();
            WsByteBuffer buf = bufManager.allocate(this.headerBlock.length);
            buf.put(this.headerBlock);
            buf.flip();
            this.moveDataIntoReadBufferArray(buf);
            this.headerBlock = null;
            boolean isFirstLineComplete = false;
            HashMap<String, String> pseudoHeaders = new HashMap<String, String>();
            ArrayList<H2HeaderField> headers = new ArrayList<H2HeaderField>();
            H2HeaderField current = null;
            while (buf.hasRemaining()) {
                current = H2Headers.decodeHeader(buf, this.muxLink.getReadTable());
                if (!isFirstLineComplete) {
                    if (current.getName().startsWith(":")) {
                        if (pseudoHeaders.get(current.getName()) != null) {
                            this.muxLink.getReadTable().setDynamicTableValidity(false);
                            throw new CompressionException("Invalid pseudo-header for decompression context: " + current.toString());
                        }
                        pseudoHeaders.put(current.getName(), current.getValue());
                        continue;
                    }
                    isFirstLineComplete = true;
                    headers.add(current);
                    continue;
                }
                if (current.getName().startsWith(":")) {
                    this.muxLink.getReadTable().setDynamicTableValidity(false);
                    throw new CompressionException("Invalid pseudo-header decoded: all pseudo-headers must appear in the header block before regular header fields.");
                }
                headers.add(current);
            }
            this.h2HttpInboundLinkWrap.setReadPseudoHeaders(pseudoHeaders);
            this.h2HttpInboundLinkWrap.setReadHeaders(headers);
            buf.flip();
        }
    }

    private void getBodyFromFrame() {
        if (this.currentFrame.getFrameType() == FrameTypes.DATA) {
            this.dataPayload = ((FrameData)this.currentFrame).getData();
            WsByteBufferPoolManager bufManager = HttpDispatcher.getBufferManager();
            WsByteBuffer buf = bufManager.allocate(this.dataPayload.length);
            buf.put(this.dataPayload);
            this.moveDataIntoReadBufferArray(buf);
        }
    }

    private void setReadyForRead() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setReadyForRead entry: stream id:" + this.myID), (Object[])new Object[0]);
        }
        if (this.headersCompleted) {
            ExecutorService executorService = CHFWBundle.getExecutorService();
            Http2Ready readyThread = new Http2Ready(this.h2HttpInboundLinkWrap);
            executorService.execute(readyThread);
        }
    }

    private void moveDataIntoReadBufferArray(WsByteBuffer newBuf) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("moveDataIntoReadBufferArray entry: stream " + this.myID + " buffer: " + newBuf), (Object[])new Object[0]);
        }
        if (newBuf != null) {
            int size = newBuf.remaining();
            this.streamReadReady[this.streamReadBufferIndex] = newBuf;
            ++this.streamReadBufferIndex;
            this.streamReadSize += size;
        }
    }

    public VirtualConnection read(long numBytes, WsByteBuffer[] req) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("read entry: stream " + this.myID + " request: " + req + " num bytes requested: " + numBytes), (Object[])new Object[0]);
        }
        long streamCount = 0L;
        long requestCount = 0L;
        if (numBytes > (long)this.streamReadSize) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("read exit: stream " + this.myID + " more bytes requested than available for read: " + numBytes + " > " + this.streamReadSize), (Object[])new Object[0]);
            }
            return null;
        }
        streamCount = this.streamReadSize;
        requestCount = this.bytesRemaining(req);
        this.actualReadCount = streamCount < requestCount ? streamCount : requestCount;
        int streamArrayIndex = 0;
        int reqArrayIndex = 0;
        int i = 0;
        while ((long)i < this.actualReadCount) {
            if (!req[reqArrayIndex].hasRemaining()) {
                ++reqArrayIndex;
                while (!req[reqArrayIndex].hasRemaining()) {
                    ++reqArrayIndex;
                }
            }
            if (!this.streamReadReady[streamArrayIndex].hasRemaining()) {
                this.streamReadReady[streamArrayIndex].release();
                ++streamArrayIndex;
                while (!this.streamReadReady[streamArrayIndex].hasRemaining()) {
                    ++streamArrayIndex;
                }
            }
            req[reqArrayIndex].put(this.streamReadReady[streamArrayIndex].get());
            ++i;
        }
        int streamOldBufferIndex = this.streamReadBufferIndex;
        this.streamReadBufferIndex = 0;
        this.streamReadSize = 0;
        if (this.streamReadReady[streamArrayIndex].hasRemaining()) {
            this.moveDataIntoReadBufferArray(this.streamReadReady[streamArrayIndex].slice());
        }
        ++streamArrayIndex;
        while (streamArrayIndex <= streamOldBufferIndex) {
            this.moveDataIntoReadBufferArray(this.streamReadReady[streamArrayIndex]);
            ++streamArrayIndex;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("read exit: stream " + this.myID), (Object[])new Object[0]);
        }
        return this.h2HttpInboundLinkWrap.getVirtualConnection();
    }

    public long readCount(long numBytes, WsByteBuffer[] req) {
        if (this.read(numBytes, req) != null) {
            return this.actualReadCount;
        }
        return 0L;
    }

    private long bytesRemaining(@Sensitive WsByteBuffer[] bufs) {
        long count = 0L;
        int length = bufs.length;
        for (int i = 0; i < length; ++i) {
            if (bufs[i] == null) {
                return count;
            }
            count += (long)bufs[i].remaining();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("bytesRemaining: stream " + this.myID + " has " + count + " bytes remaining"), (Object[])new Object[0]);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean writeFrameSync() throws FlowControlException {
        if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("writeFrameSync entry: stream: " + this.myID + " write out the following frame: " + this.currentFrame), (Object[])new Object[0]);
        }
        if (this.isStreamClosed()) {
            if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("writeFrameSync exit - stream " + this.myID + " is closed"), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.currentFrame.isWriteFrame() && this.currentFrame.getInitialized()) {
            writeFrameBytes = this.currentFrame.buildFrameForWrite();
            mgr = HttpDispatcher.getBufferManager();
            writeFrame = mgr.allocate(writeFrameBytes.length);
            try {
                writeFrame.put(writeFrameBytes);
                writeFrame.flip();
                if (this.currentFrame.getFrameType() == FrameTypes.DATA) {
                    if (!this.isWindowLimitExceeded(this.currentFrame) && !this.waitingForWindowUpdate) {
                        this.streamWindowUpdateWriteLimit -= (long)this.currentFrame.getPayloadLength();
                        if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("stream: " + this.myID + " Data payload written - new streamWindowUpdateWriteLimit: " + this.streamWindowUpdateWriteLimit), (Object[])new Object[0]);
                        }
                    } else {
                        this.waitingForWindowUpdate = true;
                        if (this.dataWaitingForWindowUpdate == null) {
                            this.dataWaitingForWindowUpdate = new LinkedList<FrameData>();
                        }
                        this.dataWaitingForWindowUpdate.add((FrameData)this.currentFrame);
                        if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("writeFrameSync the write window is too small, so the current DATA frame will be queued on stream " + this.myID), (Object[])new Object[0]);
                        }
                        var4_4 = false;
                        return var4_4;
                    }
                }
                this.muxLink.writeSync(writeFrame, null, writeFrame.limit(), -1, this.currentFrame.getFrameType(), this.currentFrame.getPayloadLength(), this.myID);
            }
            catch (IOException var4_5) {
                FFDCFilter.processException((Throwable)var4_5, (String)"com.ibm.ws.http.channel.h2internal.H2StreamProcessor", (String)"1542", (Object)this, (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !H2StreamProcessor.tc.isDebugEnabled()) ** GOTO lbl43
                Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("writeFrameSync caught an IOException: " + e), (Object[])new Object[0]);
            }
            finally {
                writeFrame.release();
            }
        } else if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)"writeFrameSync internal flow issue - exiting method ", (Object[])new Object[0]);
        }
lbl43:
        // 6 sources

        if (TraceComponent.isAnyTracingEnabled() && H2StreamProcessor.tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)H2StreamProcessor.tc, (String)("writeFrameSync exit: stream-id: " + this.myID), (Object[])new Object[0]);
        }
        return true;
    }

    public boolean isStreamClosed() {
        if (this.myID == 0 && !this.endStream) {
            return false;
        }
        boolean goAwayInProgress = this.muxLink.isGoAwayInProgress();
        if (goAwayInProgress && this.myID > this.muxLink.getLastStreamToProcess()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isStreamClosed stream closed; stream: " + this.myID), (Object[])new Object[0]);
            }
            return true;
        }
        if (this.state == StreamState.CLOSED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("isStreamClosed stream closed; stream: " + this.myID), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    public boolean isHalfClosed() {
        return this.state == StreamState.HALF_CLOSED_LOCAL || this.state == StreamState.HALF_CLOSED_REMOTE;
    }

    protected byte[] concatenateArrays(byte[] a, byte[] b) {
        int aLen = a.length;
        int bLen = b.length;
        byte[] concatenated = new byte[aLen + bLen];
        System.arraycopy(a, 0, concatenated, 0, aLen);
        System.arraycopy(b, 0, concatenated, aLen, bLen);
        return concatenated;
    }

    private boolean isControlFrame(Frame frame) {
        FrameTypes type = frame.getFrameType();
        return type == FrameTypes.GOAWAY || type == FrameTypes.RST_STREAM || type == FrameTypes.SETTINGS || type == FrameTypes.WINDOW_UPDATE || type == FrameTypes.PING || type == FrameTypes.PRIORITY;
    }

    protected void setCloseTime(long x) {
        this.closeTime = x;
    }

    protected long getCloseTime() {
        return this.closeTime;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class Http2Ready
    implements Runnable {
        private H2HttpInboundLinkWrap h2HttpInboundLinkWrap = null;
        static final long serialVersionUID = -8471928916340232065L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Http2Ready(H2HttpInboundLinkWrap x) {
            this.h2HttpInboundLinkWrap = x;
        }

        @Override
        public void run() {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("new thread calling h2HttpInboundLinkWrap.ready(...): stream id:" + H2StreamProcessor.this.myID), (Object[])new Object[0]);
            }
            this.h2HttpInboundLinkWrap.ready(this.h2HttpInboundLinkWrap.vc);
            H2StreamProcessor.this.headersCompleted = false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(Http2Ready.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class ADDITIONAL_FRAME
    extends Enum<ADDITIONAL_FRAME> {
        public static final /* enum */ ADDITIONAL_FRAME FIRST_TIME;
        public static final /* enum */ ADDITIONAL_FRAME NO;
        public static final /* enum */ ADDITIONAL_FRAME RESET;
        public static final /* enum */ ADDITIONAL_FRAME GOAWAY;
        public static final /* enum */ ADDITIONAL_FRAME DATA;
        private static final /* synthetic */ ADDITIONAL_FRAME[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static ADDITIONAL_FRAME[] values() {
            return (ADDITIONAL_FRAME[])$VALUES.clone();
        }

        public static ADDITIONAL_FRAME valueOf(String name) {
            return Enum.valueOf(ADDITIONAL_FRAME.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ADDITIONAL_FRAME.class);
            FIRST_TIME = new ADDITIONAL_FRAME();
            NO = new ADDITIONAL_FRAME();
            RESET = new ADDITIONAL_FRAME();
            GOAWAY = new ADDITIONAL_FRAME();
            DATA = new ADDITIONAL_FRAME();
            $VALUES = new ADDITIONAL_FRAME[]{FIRST_TIME, NO, RESET, GOAWAY, DATA};
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class PROCESS_TYPE
    extends Enum<PROCESS_TYPE> {
        public static final /* enum */ PROCESS_TYPE DEFAULT;
        public static final /* enum */ PROCESS_TYPE PAYLOAD_FIRST;
        private static final /* synthetic */ PROCESS_TYPE[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static PROCESS_TYPE[] values() {
            return (PROCESS_TYPE[])$VALUES.clone();
        }

        public static PROCESS_TYPE valueOf(String name) {
            return Enum.valueOf(PROCESS_TYPE.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PROCESS_TYPE.class);
            DEFAULT = new PROCESS_TYPE();
            PAYLOAD_FIRST = new PROCESS_TYPE();
            $VALUES = new PROCESS_TYPE[]{DEFAULT, PAYLOAD_FIRST};
        }
    }
}

