/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.h2internal.H2InboundLink;
import com.ibm.ws.http.channel.h2internal.H2StreamProcessor;
import com.ibm.ws.http.channel.h2internal.H2TCPConnectionContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ChannelFrameworkFactory;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;
import java.nio.ByteBuffer;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class H2TCPReadRequestContext
implements TCPReadRequestContext {
    H2TCPConnectionContext h2TcpConnectionContext = null;
    Integer streamID = null;
    H2InboundLink muxLink = null;
    private WsByteBuffer[] buffers;
    private ByteBuffer[] byteBufferArray = null;
    private ByteBuffer[] byteBufferArrayDirect = null;
    private ByteBuffer[] byteBufferArrayOf1 = null;
    private ByteBuffer[] byteBufferArrayOf2 = null;
    private ByteBuffer[] byteBufferArrayOf3 = null;
    private ByteBuffer[] byteBufferArrayOf4 = null;
    private final WsByteBuffer[] defaultBuffers = new WsByteBuffer[1];
    private final boolean jitAllocateAction = false;
    private int jitAllocateSize = 0;
    private static final TraceComponent tc = Tr.register(H2TCPReadRequestContext.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    static final long serialVersionUID = 8622268576426258080L;

    public H2TCPReadRequestContext(Integer id, H2InboundLink link, H2TCPConnectionContext x) {
        this.streamID = id;
        this.muxLink = link;
        this.h2TcpConnectionContext = x;
    }

    public VirtualConnection read(long numBytes, TCPReadCompletedCallback callback, boolean forceQueue, int timeout) {
        VirtualConnection vc = null;
        final H2StreamProcessor p = this.muxLink.getStreamProcessor(this.streamID);
        final long nB = numBytes;
        final TCPReadCompletedCallback cb = callback;
        if (this.jitAllocateSize > 0 && this.getBuffers() == null) {
            WsByteBuffer buf = ChannelFrameworkFactory.getBufferManager().allocate(this.jitAllocateSize);
            this.setBuffer(buf);
        }
        if (!forceQueue) {
            vc = p.read(numBytes, this.getBuffers());
        }
        if (vc == null) {
            Runnable r = new Runnable(){
                static final long serialVersionUID = 8427123545371668672L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                @Override
                public void run() {
                    H2TCPReadRequestContext.this.doWork(nB, cb, p);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            };
            new Thread(r).start();
        }
        return vc;
    }

    void doWork(long numBytes, TCPReadCompletedCallback callback, H2StreamProcessor p) {
        VirtualConnection vc = null;
        if (this.jitAllocateSize > 0 && this.getBuffers() == null) {
            WsByteBuffer buf = ChannelFrameworkFactory.getBufferManager().allocate(this.jitAllocateSize);
            this.setBuffer(buf);
        }
        while (true) {
            try {
                do {
                    Thread.sleep(250L);
                } while ((vc = p.read(numBytes, this.getBuffers())) == null);
                callback.complete(vc, (TCPReadRequestContext)this);
                return;
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.http.channel.h2internal.H2TCPReadRequestContext", (String)"99", (Object)this, (Object[])new Object[]{numBytes, callback, p});
                continue;
            }
            break;
        }
    }

    public long read(long numBytes, int timeout) throws IOException {
        long readCount = 0L;
        H2StreamProcessor p = this.muxLink.getStreamProcessor(this.streamID);
        while (true) {
            try {
                while (true) {
                    if ((readCount = p.readCount(numBytes, this.getBuffers())) != 0L || numBytes == 0L) {
                        return readCount;
                    }
                    Thread.sleep(250L);
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.http.channel.h2internal.H2TCPReadRequestContext", (String)"119", (Object)this, (Object[])new Object[]{numBytes, timeout});
                continue;
            }
            break;
        }
    }

    public TCPConnectionContext getInterface() {
        return this.h2TcpConnectionContext;
    }

    public void clearBuffers() {
        if (null != this.buffers) {
            for (int i = 0; i < this.buffers.length; ++i) {
                this.buffers[i].clear();
            }
        }
    }

    public WsByteBuffer[] getBuffers() {
        return this.buffers;
    }

    public void setBuffers(WsByteBuffer[] bufs) {
        int i;
        this.buffers = bufs;
        if (this.byteBufferArray != null) {
            for (i = 0; i < this.byteBufferArray.length; ++i) {
                this.byteBufferArray[i] = null;
            }
        }
        if (this.byteBufferArrayDirect != null) {
            for (i = 0; i < this.byteBufferArrayDirect.length; ++i) {
                this.byteBufferArrayDirect[i] = null;
            }
            this.byteBufferArrayDirect = null;
        }
        if (bufs != null) {
            int numBufs;
            for (numBufs = 0; numBufs < bufs.length && bufs[numBufs] != null; ++numBufs) {
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("setBuffers number of buffers is " + numBufs), (Object[])new Object[0]);
            }
            if (numBufs == 1) {
                if (this.byteBufferArrayOf1 == null) {
                    this.byteBufferArrayOf1 = new ByteBuffer[1];
                }
                this.byteBufferArray = this.byteBufferArrayOf1;
            } else if (numBufs == 2) {
                if (this.byteBufferArrayOf2 == null) {
                    this.byteBufferArrayOf2 = new ByteBuffer[2];
                }
                this.byteBufferArray = this.byteBufferArrayOf2;
            } else if (numBufs == 3) {
                if (this.byteBufferArrayOf3 == null) {
                    this.byteBufferArrayOf3 = new ByteBuffer[3];
                }
                this.byteBufferArray = this.byteBufferArrayOf3;
            } else if (numBufs == 4) {
                if (this.byteBufferArrayOf4 == null) {
                    this.byteBufferArrayOf4 = new ByteBuffer[4];
                }
                this.byteBufferArray = this.byteBufferArrayOf4;
            } else {
                this.byteBufferArray = new ByteBuffer[numBufs];
            }
            if (numBufs > 1) {
                for (int i2 = 0; i2 < numBufs; ++i2) {
                    this.byteBufferArray[i2] = bufs[i2].getWrappedByteBufferNonSafe();
                }
            } else if (numBufs == 1) {
                this.byteBufferArray[0] = bufs[0].getWrappedByteBufferNonSafe();
            }
        } else {
            this.byteBufferArray = null;
        }
    }

    public WsByteBuffer getBuffer() {
        if (this.buffers == null) {
            return null;
        }
        return this.buffers[0];
    }

    public void setBuffer(WsByteBuffer buf) {
        int i;
        if (this.byteBufferArray != null) {
            for (i = 0; i < this.byteBufferArray.length; ++i) {
                this.byteBufferArray[i] = null;
            }
        }
        if (this.byteBufferArrayDirect != null) {
            for (i = 0; i < this.byteBufferArrayDirect.length; ++i) {
                this.byteBufferArrayDirect[i] = null;
            }
            this.byteBufferArrayDirect = null;
        }
        this.defaultBuffers[0] = null;
        if (buf != null) {
            this.buffers = this.defaultBuffers;
            this.buffers[0] = buf;
            if (this.byteBufferArrayOf1 == null) {
                this.byteBufferArrayOf1 = new ByteBuffer[1];
            }
            this.byteBufferArray = this.byteBufferArrayOf1;
            this.byteBufferArray[0] = buf.getWrappedByteBufferNonSafe();
        } else {
            this.buffers = null;
            this.byteBufferArray = null;
        }
    }

    public void setJITAllocateSize(int numBytes) {
        this.jitAllocateSize = numBytes;
    }

    public boolean getJITAllocateAction() {
        return this.jitAllocateAction;
    }
}

