/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.h2internal.H2MuxTCPWriteCallback;
import com.ibm.ws.http.channel.h2internal.H2WorkQInterface;
import com.ibm.ws.http.channel.h2internal.H2WriteQEntry;
import com.ibm.ws.http.channel.h2internal.exceptions.FlowControlException;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class H2WriteQ
implements H2WorkQInterface {
    private static final TraceComponent tc = Tr.register(H2WriteQ.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    LinkedList<H2WriteQEntry> writeQ = new LinkedList();
    TCPWriteRequestContext writeReqContext = null;
    H2MuxTCPWriteCallback muxCallback = null;
    Object qSync = new Object(){
        static final long serialVersionUID = -242983090838847955L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    H2WorkQInterface.Q_STATUS qStatus = H2WorkQInterface.Q_STATUS.NOT_IN_USE;
    boolean drainQ = false;
    static final long serialVersionUID = -1311562537801572961L;

    @Override
    public void init(TCPWriteRequestContext x, H2MuxTCPWriteCallback c) {
        this.writeReqContext = x;
        this.muxCallback = c;
        this.muxCallback.setH2WorkQ(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public H2WorkQInterface.WRITE_ACTION writeOrAddToQ(H2WriteQEntry n) throws FlowControlException {
        Object object = this.qSync;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("process write entry with qStatus: " + (Object)((Object)this.qStatus) + " entry: " + n.hashCode()), (Object[])new Object[0]);
            }
            if (this.qStatus == H2WorkQInterface.Q_STATUS.NOT_IN_USE) {
                this.qStatus = H2WorkQInterface.Q_STATUS.BYPASSED;
                n.setServicedOnQ(false);
            } else {
                if (this.qStatus == H2WorkQInterface.Q_STATUS.ACTIVE || this.qStatus == H2WorkQInterface.Q_STATUS.STAND_BY) {
                    n.setServicedOnQ(true);
                    this.writeQ.add(n);
                    return H2WorkQInterface.WRITE_ACTION.QUEUED;
                }
                if (this.qStatus == H2WorkQInterface.Q_STATUS.BYPASSED) {
                    n.setServicedOnQ(true);
                    this.qStatus = H2WorkQInterface.Q_STATUS.STAND_BY;
                    this.writeQ.add(n);
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"waiting to start write Q thread", (Object[])new Object[0]);
                        }
                        this.qSync.wait();
                        this.qStatus = H2WorkQInterface.Q_STATUS.ACTIVE;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"start write Q thread", (Object[])new Object[0]);
                        }
                        this.startQThread();
                        return H2WorkQInterface.WRITE_ACTION.QUEUED;
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.http.channel.h2internal.H2WriteQ", (String)"116", (Object)this, (Object[])new Object[]{n});
                    }
                } else if (this.qStatus == H2WorkQInterface.Q_STATUS.QUIT || this.qStatus == H2WorkQInterface.Q_STATUS.FINISHED) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"do not process write - Q told to quit", (Object[])new Object[0]);
                    }
                    return H2WorkQInterface.WRITE_ACTION.CONNECTION_QUIT;
                }
            }
        }
        if (!n.getServicedOnQ()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"process write on caller's thread", (Object[])new Object[0]);
            }
            return this.writeEntry(n);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"uh-oh we're confused: WRITE_ACTION.CONFUSED", (Object[])new Object[0]);
        }
        return H2WorkQInterface.WRITE_ACTION.CONFUSED;
    }

    private H2WorkQInterface.WRITE_ACTION writeEntry(H2WriteQEntry e) {
        VirtualConnection vc = null;
        this.muxCallback.setCurrentQEntry(e);
        if (e.getBuffer() != null) {
            this.writeReqContext.setBuffer(e.getBuffer());
        } else {
            this.writeReqContext.setBuffers(e.getBuffers());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"tell device channel to write the data", (Object[])new Object[0]);
        }
        if ((vc = this.writeReqContext.write(e.getMinToWrite(), (TCPWriteCompletedCallback)this.muxCallback, e.getForceQueue(), e.getTimeout())) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"write worked right away", (Object[])new Object[0]);
            }
            if (!e.getServicedOnQ() && !e.getForceQueue()) {
                this.notifyStandBy();
                return H2WorkQInterface.WRITE_ACTION.COMPLETED;
            }
            if (e.getWriteType() == H2WriteQEntry.WRITE_TYPE.SYNC) {
                e.hitWriteCompleteLatch();
                return H2WorkQInterface.WRITE_ACTION.COMPLETED;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"start a new thread to service the async callback", (Object[])new Object[0]);
            }
            ExecutorService executorService = CHFWBundle.getExecutorService();
            AsyncCallback ac = new AsyncCallback(e);
            executorService.execute(ac);
            if (!e.getServicedOnQ()) {
                this.notifyStandBy();
            }
            return H2WorkQInterface.WRITE_ACTION.PENDING_CALLBACK;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"write did not work right away", (Object[])new Object[0]);
        }
        if (e.getWriteType() == H2WriteQEntry.WRITE_TYPE.SYNC) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"writeEntry - WRITE_TYPE.SYNC - call entry.waitWriteCompleteLatch", (Object[])new Object[0]);
            }
            e.waitWriteCompleteLatch();
            return H2WorkQInterface.WRITE_ACTION.COMPLETED;
        }
        if (!e.getServicedOnQ()) {
            return H2WorkQInterface.WRITE_ACTION.PENDING_CALLBACK;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"writeEntry - WRITE_TYPE.ASYNC - call entry.waitWriteCompleteLatch", (Object[])new Object[0]);
        }
        e.waitWriteCompleteLatch();
        return H2WorkQInterface.WRITE_ACTION.COMPLETED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyStandBy() {
        Object object = this.qSync;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("notifyStandBy called with qStatus: " + (Object)((Object)this.qStatus)), (Object[])new Object[0]);
            }
            if (this.qStatus == H2WorkQInterface.Q_STATUS.BYPASSED) {
                this.qStatus = H2WorkQInterface.Q_STATUS.NOT_IN_USE;
            } else if (this.qStatus == H2WorkQInterface.Q_STATUS.STAND_BY) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"notifyStandBy doing notify", (Object[])new Object[0]);
                }
                this.qSync.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setToQuit(boolean inDrainQ) {
        Object object = this.qSync;
        synchronized (object) {
            this.qStatus = H2WorkQInterface.Q_STATUS.QUIT;
            this.drainQ = inDrainQ;
        }
    }

    @Override
    public void asyncCallbackComplete(H2WriteQEntry e) {
    }

    @Override
    public void addNewNodeToQ(int streamID, int parentStreamID, int priority, boolean exclusive) {
    }

    @Override
    public boolean removeNodeFromQ(int streamID) {
        return true;
    }

    @Override
    public boolean updateNodeFrameParameters(int streamID, int newPriority, int newParentStreamID, boolean exclusive) {
        return true;
    }

    @Override
    public void incrementConnectionWindowUpdateLimit(int increment) {
    }

    @Override
    public void decreaseConnectionWindowUpdateWriteLimit(int decrease) {
    }

    protected void startQThread() {
        ExecutorService executorService = CHFWBundle.getExecutorService();
        QOwner qOwner = new QOwner();
        executorService.execute(qOwner);
    }

    private H2WriteQEntry findNext() {
        H2WriteQEntry e = null;
        if (!this.writeQ.isEmpty()) {
            e = this.writeQ.getLast();
        }
        return e;
    }

    @Override
    public int getConnectionWriteLimit() {
        return 0;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class AsyncCallback
    implements Runnable {
        H2WriteQEntry e;
        static final long serialVersionUID = 7994022658367017863L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected AsyncCallback(H2WriteQEntry x) {
            this.e = x;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            block3: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New thread to service callback for entry: " + this.e.hashCode()), (Object[])new Object[0]);
                }
                try {
                    VirtualConnection eVC = this.e.getConnectionContext().getVC();
                    TCPWriteRequestContext eTWC = this.e.getConnectionContext().getWriteInterface();
                    this.e.getCallback().complete(eVC, eTWC);
                }
                catch (Throwable eVC) {
                    void t;
                    FFDCFilter.processException((Throwable)eVC, (String)"com.ibm.ws.http.channel.h2internal.H2WriteQ$AsyncCallback", (String)"414", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("caught a Throwable. log and leave: " + t), (Object[])new Object[0]);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AsyncCallback.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class QOwner
    implements Runnable {
        static final long serialVersionUID = 5856428386798017013L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected QOwner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            try {
                while (true) {
                    H2WriteQEntry e = null;
                    Object object = H2WriteQ.this.qSync;
                    synchronized (object) {
                        if (H2WriteQ.this.qStatus == H2WorkQInterface.Q_STATUS.QUIT && !H2WriteQ.this.drainQ) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Write Q thread told to quite without drain - finished", (Object[])new Object[0]);
                            }
                            H2WriteQ.this.qStatus = H2WorkQInterface.Q_STATUS.FINISHED;
                            return;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Write Q getting next entry", (Object[])new Object[0]);
                        }
                        if ((e = H2WriteQ.this.findNext()) == null) {
                            if (H2WriteQ.this.qStatus == H2WorkQInterface.Q_STATUS.QUIT) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Write Q thread told to quite and queue is empty - finished", (Object[])new Object[0]);
                                }
                                H2WriteQ.this.qStatus = H2WorkQInterface.Q_STATUS.FINISHED;
                                return;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Write Q empty so thread is leaving", (Object[])new Object[0]);
                            }
                            H2WriteQ.this.qStatus = H2WorkQInterface.Q_STATUS.NOT_IN_USE;
                            return;
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Write Q processing next entry: " + e.hashCode()), (Object[])new Object[0]);
                    }
                    H2WriteQ.this.writeEntry(e);
                }
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.channel.h2internal.H2WriteQ$QOwner", (String)"369", (Object)this, (Object[])new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void t;
                    Tr.debug((TraceComponent)tc, (String)("Write Q caught a Throwable.  Set Q status to Q_STATUS.FINISHED and leave: " + t), (Object[])new Object[0]);
                }
                H2WriteQ.this.qStatus = H2WorkQInterface.Q_STATUS.FINISHED;
                return;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(QOwner.class);
        }
    }
}

