/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2TCPConnectionContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import java.util.concurrent.CountDownLatch;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class H2WriteQEntry {
    private static final TraceComponent tc = Tr.register(H2WriteQEntry.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    WsByteBuffer buf = null;
    WsByteBuffer[] bufs = null;
    long minToWrite;
    int timeout;
    WRITE_TYPE wType = WRITE_TYPE.NOT_SET;
    int priority = 0;
    FrameTypes frameType = FrameTypes.UNKNOWN;
    int payloadLength = 0;
    CountDownLatch writeCompleteLatch = null;
    boolean servicedOnQ = true;
    H2TCPConnectionContext connectionContext = null;
    TCPWriteCompletedCallback callback = null;
    int streamID = 0;
    boolean forceQueue = false;
    static final long serialVersionUID = -5686644964823864186L;

    public H2WriteQEntry(WsByteBuffer inBuf, WsByteBuffer[] inBufs, long inMin, int inTimeout, WRITE_TYPE inType, FrameTypes fType, int inPayloadLength, int inStreamID) {
        this(inBuf, inBufs, inMin, null, false, inTimeout, null, inType, fType, inPayloadLength, inStreamID);
    }

    public H2WriteQEntry(WsByteBuffer inBuf, WsByteBuffer[] inBufs, long inMin, TCPWriteCompletedCallback inCallback, boolean inForceQueue, int inTimeout, H2TCPConnectionContext inConnectionContext, WRITE_TYPE inType, FrameTypes fType, int inPayloadLength, int inStreamID) {
        this.buf = inBuf;
        this.bufs = inBufs;
        this.minToWrite = inMin;
        this.timeout = inTimeout;
        this.wType = inType;
        this.callback = inCallback;
        this.forceQueue = inForceQueue;
        this.connectionContext = inConnectionContext;
        this.frameType = fType;
        this.payloadLength = inPayloadLength;
        this.streamID = inStreamID;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("H2WriteQEntry constructor for entry: " + this.hashCode()), (Object[])new Object[0]);
        }
    }

    public void armWriteCompleteLatch() {
        this.writeCompleteLatch = new CountDownLatch(1);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeCompleteLatch armed: " + this.writeCompleteLatch.hashCode() + " on entry: " + this.hashCode()), (Object[])new Object[0]);
        }
    }

    public void waitWriteCompleteLatch() {
        try {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("writeCompleteLatch await: " + this.writeCompleteLatch.hashCode() + " on entry: " + this.hashCode()), (Object[])new Object[0]);
            }
            this.writeCompleteLatch.await();
        }
        catch (InterruptedException interruptedException) {
            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.http.channel.h2internal.H2WriteQEntry", (String)"97", (Object)this, (Object[])new Object[0]);
        }
    }

    public void hitWriteCompleteLatch() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeCompleteLatch hit countDown: " + this.writeCompleteLatch.hashCode() + " on entry: " + this.hashCode()), (Object[])new Object[0]);
        }
        this.writeCompleteLatch.countDown();
    }

    public boolean getServicedOnQ() {
        return this.servicedOnQ;
    }

    public void setServicedOnQ(boolean x) {
        this.servicedOnQ = x;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int x) {
        this.priority = x;
    }

    public WsByteBuffer getBuffer() {
        return this.buf;
    }

    public WsByteBuffer[] getBuffers() {
        return this.bufs;
    }

    public long getMinToWrite() {
        return this.minToWrite;
    }

    public WRITE_TYPE getWriteType() {
        return this.wType;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean getForceQueue() {
        return this.forceQueue;
    }

    public TCPWriteCompletedCallback getCallback() {
        return this.callback;
    }

    public H2TCPConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    public int getStreamID() {
        return this.streamID;
    }

    public FrameTypes getFrameType() {
        return this.frameType;
    }

    public int getPayloadLength() {
        return this.payloadLength;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class WRITE_TYPE
    extends Enum<WRITE_TYPE> {
        public static final /* enum */ WRITE_TYPE NOT_SET;
        public static final /* enum */ WRITE_TYPE SYNC;
        public static final /* enum */ WRITE_TYPE ASYNC;
        private static final /* synthetic */ WRITE_TYPE[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static WRITE_TYPE[] values() {
            return (WRITE_TYPE[])$VALUES.clone();
        }

        public static WRITE_TYPE valueOf(String name) {
            return Enum.valueOf(WRITE_TYPE.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WRITE_TYPE.class);
            NOT_SET = new WRITE_TYPE();
            SYNC = new WRITE_TYPE();
            ASYNC = new WRITE_TYPE();
            $VALUES = new WRITE_TYPE[]{NOT_SET, SYNC, ASYNC};
        }
    }
}

