/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2MuxTCPWriteCallback;
import com.ibm.ws.http.channel.h2internal.H2WorkQInterface;
import com.ibm.ws.http.channel.h2internal.H2WriteQEntry;
import com.ibm.ws.http.channel.h2internal.exceptions.FlowControlException;
import com.ibm.ws.http.channel.h2internal.priority.Node;
import com.ibm.ws.http.channel.h2internal.priority.Tree;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPWriteCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import java.util.concurrent.ExecutorService;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class H2WriteTree
implements H2WorkQInterface {
    private static final TraceComponent tc = Tr.register(H2WriteTree.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    TCPWriteRequestContext writeReqContext = null;
    H2MuxTCPWriteCallback muxCallback = null;
    Tree tree = null;
    Object qSync = new Object(){
        static final long serialVersionUID = 6563184331186564468L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    H2WorkQInterface.Q_STATUS qStatus = H2WorkQInterface.Q_STATUS.NOT_IN_USE;
    boolean drainQ = false;
    private final int connectionWindowUpdateWriteInitialSize = 65535;
    private int connectionWindowUpdateWriteLimit = 65535;
    static final long serialVersionUID = -2335664883206680154L;

    @Override
    public void init(TCPWriteRequestContext x, H2MuxTCPWriteCallback c) {
        this.writeReqContext = x;
        this.muxCallback = c;
        this.muxCallback.setH2WorkQ(this);
        this.tree = new Tree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyStandBy() {
        Object object = this.qSync;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("notifyStandBy called with qStatus: " + (Object)((Object)this.qStatus)), (Object[])new Object[0]);
            }
            if (this.qStatus == H2WorkQInterface.Q_STATUS.BYPASSED) {
                this.qStatus = H2WorkQInterface.Q_STATUS.NOT_IN_USE;
            } else if (this.qStatus == H2WorkQInterface.Q_STATUS.STAND_BY) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"notifyStandBy doing notify", (Object[])new Object[0]);
                }
                this.qSync.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setToQuit(boolean inDrainQ) {
        Object object = this.qSync;
        synchronized (object) {
            this.qStatus = H2WorkQInterface.Q_STATUS.QUIT;
            this.drainQ = inDrainQ;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public H2WorkQInterface.WRITE_ACTION writeOrAddToQ(H2WriteQEntry entry) throws FlowControlException {
        Object object = this.qSync;
        synchronized (object) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("process write entry with qStatus: " + (Object)((Object)this.qStatus) + " entry: " + entry.hashCode()), (Object[])new Object[0]);
            }
            if (this.qStatus == H2WorkQInterface.Q_STATUS.NOT_IN_USE) {
                this.qStatus = H2WorkQInterface.Q_STATUS.BYPASSED;
                entry.setServicedOnQ(false);
            } else {
                if (this.qStatus == H2WorkQInterface.Q_STATUS.ACTIVE || this.qStatus == H2WorkQInterface.Q_STATUS.STAND_BY) {
                    entry.setServicedOnQ(true);
                    this.addEntryToQ(entry);
                    return H2WorkQInterface.WRITE_ACTION.QUEUED;
                }
                if (this.qStatus == H2WorkQInterface.Q_STATUS.BYPASSED) {
                    entry.setServicedOnQ(true);
                    this.qStatus = H2WorkQInterface.Q_STATUS.STAND_BY;
                    this.addEntryToQ(entry);
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"waiting to start write Q thread", (Object[])new Object[0]);
                        }
                        this.qSync.wait();
                        this.qStatus = H2WorkQInterface.Q_STATUS.ACTIVE;
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"start write Q thread", (Object[])new Object[0]);
                        }
                        this.startQThread();
                        return H2WorkQInterface.WRITE_ACTION.QUEUED;
                    }
                    catch (InterruptedException interruptedException) {
                        FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.http.channel.h2internal.H2WriteTree", (String)"148", (Object)this, (Object[])new Object[]{entry});
                    }
                } else if (this.qStatus == H2WorkQInterface.Q_STATUS.QUIT || this.qStatus == H2WorkQInterface.Q_STATUS.FINISHED) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"do not process write - Q told to quit", (Object[])new Object[0]);
                    }
                    return H2WorkQInterface.WRITE_ACTION.CONNECTION_QUIT;
                }
            }
        }
        if (!entry.getServicedOnQ()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"perform write on caller's thread", (Object[])new Object[0]);
            }
            return this.writeEntry(entry);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"uh-oh we're confused: WRITE_ACTION.CONFUSED", (Object[])new Object[0]);
        }
        return H2WorkQInterface.WRITE_ACTION.CONFUSED;
    }

    @Override
    public void addNewNodeToQ(int streamID, int parentStreamID, int priority, boolean exclusive) {
        boolean bNode = this.tree.findNode(streamID);
        if (bNode) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"could not add a new node, was already in the tree", (Object[])new Object[0]);
            }
            return;
        }
        Node node = new Node(streamID, priority);
        this.tree.addNode(node, parentStreamID, exclusive);
    }

    @Override
    public boolean removeNodeFromQ(int streamID) {
        return this.tree.removeNode(streamID);
    }

    private void addEntryToQ(H2WriteQEntry entry) {
        int streamID;
        boolean bNode;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addEntryToQ entry: " + entry.hashCode()), (Object[])new Object[0]);
        }
        if (!(bNode = this.tree.findNode(streamID = entry.getStreamID()))) {
            Node node = new Node(streamID, Node.DEFAULT_NODE_PRIORITY);
            this.tree.addNode(node, Node.ROOT_STREAM_ID, false);
        }
        this.tree.updateNode(streamID, Node.NODE_STATUS.REQUESTING_WRITE, Node.WRITE_COUNT_ACTION.NO_ACTION, entry);
    }

    private H2WorkQInterface.WRITE_ACTION writeEntry(H2WriteQEntry e) throws FlowControlException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("H2WriteTree entered with stream-id: " + e.getStreamID() + " entry hc:" + e.hashCode()), (Object[])new Object[0]);
        }
        if (e.getFrameType() == FrameTypes.DATA && this.connectionWindowUpdateWriteLimit - e.getPayloadLength() < 0) {
            String s = " connectionWindowUpdateWriteLimit " + this.connectionWindowUpdateWriteLimit + " connectionWindowUpdateWriteInitialSize " + 65535;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Can not write Data would exceed connection window update limit: " + s), (Object[])new Object[0]);
            }
            FlowControlException ex = new FlowControlException("Can not write Data would exceed connection window update limit: " + s);
            throw ex;
        }
        VirtualConnection vc = null;
        this.muxCallback.setCurrentQEntry(e);
        if (e.getBuffer() != null) {
            this.writeReqContext.setBuffer(e.getBuffer());
        } else {
            this.writeReqContext.setBuffers(e.getBuffers());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("update node for stream-id: " + e.getStreamID()), (Object[])new Object[0]);
        }
        this.tree.updateNode(e.getStreamID(), Node.NODE_STATUS.ACTION_NO_CHANGE, Node.WRITE_COUNT_ACTION.INCREMENT, null);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("tell device channel to write the data on stream-id: " + e.getStreamID()), (Object[])new Object[0]);
        }
        if ((vc = this.writeReqContext.write(e.getMinToWrite(), (TCPWriteCompletedCallback)this.muxCallback, e.getForceQueue(), e.getTimeout())) != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"write worked right away", (Object[])new Object[0]);
            }
            if (e.getFrameType() == FrameTypes.DATA) {
                this.connectionWindowUpdateWriteLimit -= e.getPayloadLength();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Data payload written - new connectionWindowUpdateWriteLimit: " + this.connectionWindowUpdateWriteLimit), (Object[])new Object[0]);
                }
            }
            if (!e.getServicedOnQ() && !e.getForceQueue()) {
                this.tree.updateNode(e.getStreamID(), Node.NODE_STATUS.NOT_REQUESTING, Node.WRITE_COUNT_ACTION.NO_ACTION, null);
                this.notifyStandBy();
                return H2WorkQInterface.WRITE_ACTION.COMPLETED;
            }
            if (e.getWriteType() == H2WriteQEntry.WRITE_TYPE.SYNC) {
                this.tree.updateNode(e.getStreamID(), Node.NODE_STATUS.NOT_REQUESTING, Node.WRITE_COUNT_ACTION.NO_ACTION, null);
                e.hitWriteCompleteLatch();
                return H2WorkQInterface.WRITE_ACTION.COMPLETED;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"start a new thread to service the async callback", (Object[])new Object[0]);
            }
            ExecutorService executorService = CHFWBundle.getExecutorService();
            AsyncCallback ac = new AsyncCallback(e);
            executorService.execute(ac);
            if (!e.getServicedOnQ()) {
                this.notifyStandBy();
            }
            return H2WorkQInterface.WRITE_ACTION.COMPLETED;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"write did not work right away", (Object[])new Object[0]);
        }
        if (e.getWriteType() == H2WriteQEntry.WRITE_TYPE.SYNC) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"writeEntry - WRITE_TYPE.SYNC - call entry.waitWriteCompleteLatch", (Object[])new Object[0]);
            }
            e.waitWriteCompleteLatch();
            this.tree.updateNode(e.getStreamID(), Node.NODE_STATUS.NOT_REQUESTING, Node.WRITE_COUNT_ACTION.NO_ACTION, null);
            return H2WorkQInterface.WRITE_ACTION.COMPLETED;
        }
        if (!e.getServicedOnQ()) {
            return H2WorkQInterface.WRITE_ACTION.PENDING_CALLBACK;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"writeEntry - WRITE_TYPE.ASYNC - call entry.waitWriteCompleteLatch", (Object[])new Object[0]);
        }
        e.waitWriteCompleteLatch();
        return H2WorkQInterface.WRITE_ACTION.COMPLETED;
    }

    @Override
    public boolean updateNodeFrameParameters(int streamID, int newPriority, int newParentStreamID, boolean exclusive) {
        return this.tree.updateNodeFrameParameters(streamID, newPriority, newParentStreamID, exclusive);
    }

    @Override
    public void asyncCallbackComplete(H2WriteQEntry e) {
        this.tree.updateNode(e.getStreamID(), Node.NODE_STATUS.NOT_REQUESTING, Node.WRITE_COUNT_ACTION.NO_ACTION, null);
    }

    @Override
    public void incrementConnectionWindowUpdateLimit(int x) throws FlowControlException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("incrementConnectionWindowUpdateLimit entry: inc value: " + x + "current connectionWindowUpdateWriteLimit: " + this.connectionWindowUpdateWriteLimit), (Object[])new Object[0]);
        }
        int temp = this.connectionWindowUpdateWriteLimit + x;
        if ((temp &= 0x10000000) != 0) {
            String s = "processWindowUpdateFrame: out of bounds increment, current connection write limit: " + this.connectionWindowUpdateWriteLimit + " total would have been: " + temp;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)s, (Object[])new Object[0]);
            }
            FlowControlException e = new FlowControlException(s);
            throw e;
        }
        this.connectionWindowUpdateWriteLimit += x;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("connectionWindowUpdateWriteLimit updated to: " + this.connectionWindowUpdateWriteLimit), (Object[])new Object[0]);
        }
    }

    @Override
    public void decreaseConnectionWindowUpdateWriteLimit(int x) {
        this.connectionWindowUpdateWriteLimit -= x;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("decreaseConnectionWindowUpdateWriteLimit: dec value: " + x + "connectionWindowUpdateWriteLimit decreased to: " + this.connectionWindowUpdateWriteLimit), (Object[])new Object[0]);
        }
    }

    protected void startQThread() {
        ExecutorService executorService = CHFWBundle.getExecutorService();
        QOwner qOwner = new QOwner();
        executorService.execute(qOwner);
    }

    private H2WriteQEntry findNext() {
        H2WriteQEntry e = this.tree.findNextWriteEntry();
        return e;
    }

    @Override
    public int getConnectionWriteLimit() {
        return this.connectionWindowUpdateWriteLimit;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class AsyncCallback
    implements Runnable {
        H2WriteQEntry e;
        static final long serialVersionUID = 5197723212247471260L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected AsyncCallback(H2WriteQEntry x) {
            this.e = x;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            block3: {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("New thread to service callback for entry: " + this.e.hashCode()), (Object[])new Object[0]);
                }
                try {
                    VirtualConnection eVC = this.e.getConnectionContext().getVC();
                    TCPWriteRequestContext eTWC = this.e.getConnectionContext().getWriteInterface();
                    this.e.getCallback().complete(eVC, eTWC);
                }
                catch (Throwable eVC) {
                    void t;
                    FFDCFilter.processException((Throwable)eVC, (String)"com.ibm.ws.http.channel.h2internal.H2WriteTree$AsyncCallback", (String)"525", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)("caught a Throwable. log and leave: " + t), (Object[])new Object[0]);
                }
            }
            H2WriteTree.this.asyncCallbackComplete(this.e);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AsyncCallback.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    protected class QOwner
    implements Runnable {
        static final long serialVersionUID = 4289580449098013325L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        protected QOwner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            try {
                while (true) {
                    H2WriteQEntry e = null;
                    Object object = H2WriteTree.this.qSync;
                    synchronized (object) {
                        if (H2WriteTree.this.qStatus == H2WorkQInterface.Q_STATUS.QUIT && !H2WriteTree.this.drainQ) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Write Q thread told to quite without drain - finished", (Object[])new Object[0]);
                            }
                            H2WriteTree.this.qStatus = H2WorkQInterface.Q_STATUS.FINISHED;
                            return;
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Write Q getting next entry", (Object[])new Object[0]);
                        }
                        if ((e = H2WriteTree.this.findNext()) == null) {
                            if (H2WriteTree.this.qStatus == H2WorkQInterface.Q_STATUS.QUIT) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"Write Q thread told to quite and queue is empty - finished", (Object[])new Object[0]);
                                }
                                H2WriteTree.this.qStatus = H2WorkQInterface.Q_STATUS.FINISHED;
                                return;
                            }
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"Write Q empty so thread is leaving", (Object[])new Object[0]);
                            }
                            H2WriteTree.this.qStatus = H2WorkQInterface.Q_STATUS.NOT_IN_USE;
                            return;
                        }
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Write Q perform write Q thread", (Object[])new Object[0]);
                    }
                    H2WriteTree.this.writeEntry(e);
                }
            }
            catch (Throwable e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.http.channel.h2internal.H2WriteTree$QOwner", (String)"481", (Object)this, (Object[])new Object[0]);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void t;
                    Tr.debug((TraceComponent)tc, (String)("Write Q caught a Throwable.  Set Q status to Q_STATUS.FINISHED and leave: " + t), (Object[])new Object[0]);
                }
                H2WriteTree.this.qStatus = H2WorkQInterface.Q_STATUS.FINISHED;
                return;
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(QOwner.class);
        }
    }
}

