/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.utils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FrameContinuation
extends Frame {
    public byte[] headerBlockFragment = null;
    static final long serialVersionUID = -305827949752192123L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public FrameContinuation(int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        super(streamId, payloadLength, flags, reserveBit, direction);
        this.frameType = FrameTypes.CONTINUATION;
    }

    public FrameContinuation(int streamId, byte[] headerBlockFragment, boolean endHeaders, boolean endStream, boolean reserveBit) {
        super(streamId, 0, (byte)0, reserveBit, Frame.FrameDirection.WRITE);
        if (headerBlockFragment != null) {
            this.payloadLength += headerBlockFragment.length;
        }
        this.headerBlockFragment = headerBlockFragment;
        this.END_HEADERS_FLAG = endHeaders;
        this.END_STREAM_FLAG = endStream;
        this.frameType = FrameTypes.CONTINUATION;
        this.setInitialized();
    }

    @Override
    public void processPayload(FrameReadProcessor frp) throws FrameSizeException {
        this.headerBlockFragment = new byte[this.payloadLength];
        int payloadIndex = 0;
        int i = 0;
        while (payloadIndex++ < this.payloadLength) {
            this.headerBlockFragment[i] = frp.grabNextByte();
            ++i;
        }
    }

    @Override
    public byte[] buildFrameForWrite() {
        byte[] frame = super.buildFrameForWrite();
        this.setFrameHeaders(frame, (byte)9);
        int frameIndex = 9;
        for (int i = 0; i < this.headerBlockFragment.length; ++i) {
            frame[frameIndex] = this.headerBlockFragment[i];
            ++frameIndex;
        }
        return frame;
    }

    public byte[] getHeaderBlockFragment() {
        return this.headerBlockFragment;
    }

    @Override
    public void validate(H2ConnectionSettings settings) throws ProtocolException, FrameSizeException {
        if (this.streamId == 0) {
            throw new ProtocolException("CONTINUATION frame streamID cannot be 0x0");
        }
        if (this.getPayloadLength() > settings.maxFrameSize) {
            throw new FrameSizeException("CONTINUATION payload greater than max allowed");
        }
    }

    @Override
    protected void setFlags() {
        this.END_HEADERS_FLAG = utils.getFlag(this.flags, 2);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FrameContinuation.class);
    }
}

