/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.LongEncoder;
import com.ibm.ws.http.channel.h2internal.frames.utils;
import com.ibm.ws.http.channel.h2internal.huffman.HuffmanEncoder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FrameHeaders
extends Frame {
    private int paddingLength = 0;
    boolean exclusive = false;
    int streamDependency = 0;
    int weight = 0;
    public byte[] headerBlockFragment = null;
    public StringBuilder headers;
    static final long serialVersionUID = -5165984996108955445L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public FrameHeaders(int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        super(streamId, payloadLength, flags, reserveBit, direction);
        this.frameType = FrameTypes.HEADERS;
    }

    public FrameHeaders(int streamId, byte[] headerBlockFragment) {
        super(streamId, 0, (byte)0, false, Frame.FrameDirection.READ);
        this.frameType = FrameTypes.HEADERS;
        if (headerBlockFragment != null) {
            this.payloadLength += headerBlockFragment.length;
        }
        this.headerBlockFragment = headerBlockFragment;
        this.END_STREAM_FLAG = false;
        this.END_HEADERS_FLAG = true;
        this.frameType = FrameTypes.HEADERS;
        this.setInitialized();
    }

    public FrameHeaders(int streamId, byte[] headerBlockFragment, int streamDependency, int paddingLength, int weight, boolean endStream, boolean endHeaders, boolean padded, boolean priority, boolean exclusive, boolean reserveBit) {
        super(streamId, 0, (byte)0, reserveBit, Frame.FrameDirection.WRITE);
        if (headerBlockFragment != null) {
            this.payloadLength += headerBlockFragment.length;
        }
        this.headerBlockFragment = headerBlockFragment;
        this.END_STREAM_FLAG = endStream;
        this.END_HEADERS_FLAG = endHeaders;
        if (padded) {
            this.PADDED_FLAG = padded;
            this.payloadLength += paddingLength + 1;
            this.paddingLength = paddingLength;
        }
        if (priority) {
            this.PRIORITY_FLAG = priority;
            this.payloadLength += 6;
        }
        this.exclusive = exclusive;
        this.streamDependency = streamDependency;
        this.weight = weight;
        this.frameType = FrameTypes.HEADERS;
        this.setInitialized();
    }

    public FrameHeaders(int streamId, byte[] headerBlockFragment, boolean endStream, boolean endHeaders) {
        super(streamId, 0, (byte)0, false, Frame.FrameDirection.WRITE);
        if (headerBlockFragment != null) {
            this.payloadLength += headerBlockFragment.length;
        }
        this.headerBlockFragment = headerBlockFragment;
        this.END_STREAM_FLAG = endStream;
        this.END_HEADERS_FLAG = endHeaders;
        this.exclusive = false;
        this.weight = 0;
        this.frameType = FrameTypes.HEADERS;
        this.setInitialized();
    }

    @Override
    public void processPayload(FrameReadProcessor frp) throws FrameSizeException {
        int i;
        this.setFlags();
        int payloadIndex = 0;
        if (this.PADDED_FLAG) {
            this.paddingLength = frp.grabNextByte();
            this.payloadLength -= this.paddingLength;
            ++payloadIndex;
        }
        if (this.PRIORITY_FLAG) {
            byte firstPayloadByte = frp.grabNextByte();
            this.exclusive = utils.getReservedBit(firstPayloadByte);
            firstPayloadByte = (byte)(firstPayloadByte & 0x7F);
            this.streamDependency = frp.grabNext24BitInt(firstPayloadByte);
            this.weight = frp.grabNextByte();
            payloadIndex += 4;
        }
        this.payloadLength -= payloadIndex;
        this.headerBlockFragment = new byte[this.payloadLength];
        for (i = payloadIndex; i < payloadIndex + this.payloadLength; ++i) {
            this.headerBlockFragment[i] = frp.grabNextByte();
        }
        for (i = payloadIndex; i < payloadIndex + this.paddingLength; ++i) {
            frp.grabNextByte();
        }
        this.setInitialized();
    }

    @Override
    public byte[] buildFrameForWrite() {
        int i;
        byte[] frame = super.buildFrameForWrite();
        this.setFrameHeaders(frame, (byte)1);
        int frameIndex = 9;
        if (this.PADDED_FLAG) {
            utils.Move8BitstoByteArray(this.paddingLength, frame, frameIndex);
            ++frameIndex;
        }
        if (this.PRIORITY_FLAG) {
            utils.Move31BitstoByteArray(this.streamDependency, frame, frameIndex);
            if (this.exclusive) {
                frame[frameIndex] = (byte)(frame[frameIndex] | 0x80);
            }
            utils.Move8BitstoByteArray(this.weight, frame, frameIndex += 4);
            ++frameIndex;
        }
        for (i = 0; i < this.headerBlockFragment.length; ++i) {
            frame[frameIndex] = this.headerBlockFragment[i];
            ++frameIndex;
        }
        for (i = 0; i < this.paddingLength; ++i) {
            frame[frameIndex] = 0;
            ++frameIndex;
        }
        return frame;
    }

    public byte[] getHeaderBlockFragment() {
        return this.initialized ? this.headerBlockFragment : null;
    }

    public int getPaddingLength() {
        return this.paddingLength;
    }

    @Override
    public void validate(H2ConnectionSettings settings) throws ProtocolException, FrameSizeException {
        if (this.streamId == 0) {
            throw new ProtocolException("HEADERS frame streamID cannot be 0x0");
        }
        if (this.getPayloadLength() > settings.maxFrameSize) {
            throw new FrameSizeException("HEADERS payload greater than allowed by the max frame size");
        }
        if (this.paddingLength >= this.payloadLength) {
            throw new ProtocolException("HEADERS padding length must be less than the length of the payload");
        }
    }

    @Override
    protected void setFlags() {
        this.END_STREAM_FLAG = utils.getFlag(this.flags, 0);
        this.END_HEADERS_FLAG = utils.getFlag(this.flags, 2);
        this.PADDED_FLAG = utils.getFlag(this.flags, 3);
        this.PRIORITY_FLAG = utils.getFlag(this.flags, 5);
    }

    public byte[] buildHeader(HeaderFieldType xIndexingType, String xHeaderName, String xHeaderValue, long xHeaderIndex) {
        int headerStaticIndex = -1;
        byte[] retArray = null;
        LongEncoder enc = new LongEncoder();
        if (xHeaderName != null) {
            headerStaticIndex = utils.getIndexNumber(xHeaderName);
        }
        if (xIndexingType == HeaderFieldType.INDEXED) {
            if (headerStaticIndex != -1) {
                retArray = new byte[]{(byte)(0x80 | headerStaticIndex)};
            } else {
                retArray = enc.encode(xHeaderIndex, 7);
                retArray[0] = (byte)(0x80 | retArray[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Indexed header built array: " + utils.printArray(retArray)), (Object[])new Object[0]);
            }
            return retArray;
        }
        if (xIndexingType == HeaderFieldType.LITERAL_INCREMENTAL_INDEXING || xIndexingType == HeaderFieldType.LITERAL_NEVER_INDEXED_INDEXED_NAME || xIndexingType == HeaderFieldType.LITERAL_WITHOUT_INDEXING_AND_INDEXED_NAME) {
            byte[] idxArray = null;
            if (xHeaderName != null) {
                headerStaticIndex = utils.getIndexNumber(xHeaderName);
            }
            if (xIndexingType == HeaderFieldType.LITERAL_INCREMENTAL_INDEXING) {
                idxArray = enc.encode(headerStaticIndex, 6);
                idxArray[0] = (byte)(0x40 | idxArray[0]);
                idxArray[0] = (byte)(0x7F & idxArray[0]);
            } else if (xIndexingType == HeaderFieldType.LITERAL_NEVER_INDEXED_INDEXED_NAME) {
                idxArray = enc.encode(headerStaticIndex, 4);
                idxArray[0] = (byte)(0x10 | idxArray[0]);
                idxArray[0] = (byte)(0x1F & idxArray[0]);
            } else if (xIndexingType == HeaderFieldType.LITERAL_WITHOUT_INDEXING_AND_INDEXED_NAME) {
                idxArray = enc.encode(headerStaticIndex, 4);
                idxArray[0] = (byte)(0xF & idxArray[0]);
            }
            byte[] ba = xHeaderValue.getBytes();
            byte[] hArrayValue = HuffmanEncoder.convertAsciiToHuffman(ba);
            byte[] hArrayLength = enc.encode(hArrayValue.length, 7);
            hArrayLength[0] = (byte)(0x80 | hArrayLength[0]);
            int totalLength = idxArray.length + hArrayLength.length + hArrayValue.length;
            retArray = new byte[totalLength];
            System.arraycopy(idxArray, 0, retArray, 0, idxArray.length);
            System.arraycopy(hArrayLength, 0, retArray, idxArray.length, hArrayLength.length);
            System.arraycopy(hArrayValue, 0, retArray, idxArray.length + hArrayLength.length, hArrayValue.length);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Literal Header Field with Incremental Indexing built array: " + utils.printArray(retArray)), (Object[])new Object[0]);
            }
            return retArray;
        }
        if (xIndexingType == HeaderFieldType.LITERAL_WITHOUT_INDEXING_AND_NEW_NAME || xIndexingType == HeaderFieldType.LITERAL_NEVER_INDEXED_NEW_NAME || xIndexingType == HeaderFieldType.LITERAL_INCREMENTAL_INDEXING_NEW_NAME) {
            byte[] ba = xHeaderName.getBytes();
            byte[] hName = HuffmanEncoder.convertAsciiToHuffman(ba);
            byte[] hNameLength = enc.encode(hName.length, 7);
            hNameLength[0] = (byte)(0x80 | hNameLength[0]);
            ba = xHeaderValue.getBytes();
            byte[] hValue = HuffmanEncoder.convertAsciiToHuffman(ba);
            byte[] hValueLength = enc.encode(hValue.length, 7);
            hValueLength[0] = (byte)(0x80 | hValueLength[0]);
            int totalLength = 1 + hNameLength.length + hName.length + hValueLength.length + hValue.length;
            retArray = new byte[totalLength];
            if (xIndexingType == HeaderFieldType.LITERAL_WITHOUT_INDEXING_AND_NEW_NAME) {
                retArray[0] = 0;
            } else if (xIndexingType == HeaderFieldType.LITERAL_NEVER_INDEXED_NEW_NAME) {
                retArray[0] = 16;
            } else if (xIndexingType == HeaderFieldType.LITERAL_INCREMENTAL_INDEXING_NEW_NAME) {
                retArray[0] = 64;
            }
            System.arraycopy(hNameLength, 0, retArray, 1, hNameLength.length);
            System.arraycopy(hName, 0, retArray, 1 + hNameLength.length, hName.length);
            System.arraycopy(hValueLength, 0, retArray, 1 + hNameLength.length + hName.length, hValueLength.length);
            System.arraycopy(hValue, 0, retArray, 1 + hNameLength.length + hName.length + hValueLength.length, hValue.length);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Literal Header Field without Indexing - new Name built array: " + utils.printArray(retArray)), (Object[])new Object[0]);
            }
            return retArray;
        }
        return null;
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int getStreamDependency() {
        return this.streamDependency;
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    public String toString() {
        StringBuilder frameToString = new StringBuilder();
        frameToString.append(super.toString()).append("\n");
        frameToString.append("PaddingLength: " + this.getPaddingLength() + "\n");
        frameToString.append("isExclusive: " + this.isExclusive() + "\n");
        frameToString.append("StreamIdDependency: " + this.getStreamDependency() + "\n");
        frameToString.append("Weight: " + this.getWeight() + "\n");
        return frameToString.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FrameHeaders.class);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class HeaderFieldType
    extends Enum<HeaderFieldType> {
        public static final /* enum */ HeaderFieldType INDEXED;
        public static final /* enum */ HeaderFieldType LITERAL_INCREMENTAL_INDEXING;
        public static final /* enum */ HeaderFieldType LITERAL_INCREMENTAL_INDEXING_NEW_NAME;
        public static final /* enum */ HeaderFieldType LITERAL_WITHOUT_INDEXING_AND_INDEXED_NAME;
        public static final /* enum */ HeaderFieldType LITERAL_WITHOUT_INDEXING_AND_NEW_NAME;
        public static final /* enum */ HeaderFieldType LITERAL_NEVER_INDEXED_INDEXED_NAME;
        public static final /* enum */ HeaderFieldType LITERAL_NEVER_INDEXED_NEW_NAME;
        private static final /* synthetic */ HeaderFieldType[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static HeaderFieldType[] values() {
            return (HeaderFieldType[])$VALUES.clone();
        }

        public static HeaderFieldType valueOf(String name) {
            return Enum.valueOf(HeaderFieldType.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(HeaderFieldType.class);
            INDEXED = new HeaderFieldType();
            LITERAL_INCREMENTAL_INDEXING = new HeaderFieldType();
            LITERAL_INCREMENTAL_INDEXING_NEW_NAME = new HeaderFieldType();
            LITERAL_WITHOUT_INDEXING_AND_INDEXED_NAME = new HeaderFieldType();
            LITERAL_WITHOUT_INDEXING_AND_NEW_NAME = new HeaderFieldType();
            LITERAL_NEVER_INDEXED_INDEXED_NAME = new HeaderFieldType();
            LITERAL_NEVER_INDEXED_NEW_NAME = new HeaderFieldType();
            $VALUES = new HeaderFieldType[]{INDEXED, LITERAL_INCREMENTAL_INDEXING, LITERAL_INCREMENTAL_INDEXING_NEW_NAME, LITERAL_WITHOUT_INDEXING_AND_INDEXED_NAME, LITERAL_WITHOUT_INDEXING_AND_NEW_NAME, LITERAL_NEVER_INDEXED_INDEXED_NAME, LITERAL_NEVER_INDEXED_NEW_NAME};
        }
    }
}

