/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.utils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FramePriority
extends Frame {
    private boolean exclusive = false;
    private int streamDependency = 0;
    private int weight = 0;
    static final long serialVersionUID = 6836038936402556535L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public FramePriority(int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        super(streamId, payloadLength, flags, reserveBit, direction);
        this.frameType = FrameTypes.PRIORITY;
    }

    public FramePriority(int streamId, int streamDependency, int weight, boolean exclusive, boolean reserveBit) {
        super(streamId, 5, (byte)0, reserveBit, Frame.FrameDirection.WRITE);
        this.exclusive = exclusive;
        this.streamDependency = streamDependency;
        this.weight = weight;
        this.frameType = FrameTypes.PRIORITY;
        this.setInitialized();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processPayload(FrameReadProcessor frp) throws FrameSizeException {
        try {
            byte firstPayloadByte = frp.grabNextByte();
            this.exclusive = utils.getReservedBit(firstPayloadByte);
            firstPayloadByte = (byte)(firstPayloadByte & 0x7F);
            this.streamDependency = frp.grabNext24BitInt(firstPayloadByte);
            this.weight = 0xFF & frp.grabNextByte();
            ++this.weight;
        }
        catch (FrameSizeException firstPayloadByte) {
            void e;
            FFDCFilter.processException((Throwable)firstPayloadByte, (String)"com.ibm.ws.http.channel.h2internal.frames.FramePriority", (String)"85", (Object)this, (Object[])new Object[]{frp});
            e.setConnectionError(false);
            throw e;
        }
    }

    @Override
    public byte[] buildFrameForWrite() {
        byte[] frame = super.buildFrameForWrite();
        this.setFrameHeaders(frame, (byte)2);
        int frameIndex = 9;
        utils.Move31BitstoByteArray(this.streamDependency, frame, frameIndex);
        if (this.exclusive) {
            frame[frameIndex] = (byte)(frame[frameIndex] | 0x80);
        }
        utils.Move8BitstoByteArray(this.weight, frame, frameIndex += 4);
        return frame;
    }

    @Override
    public void validate(H2ConnectionSettings settings) throws ProtocolException {
        if (this.streamId == 0) {
            throw new ProtocolException("PRIORITY frame stream ID cannot be 0x0");
        }
    }

    public boolean isExclusive() {
        return this.exclusive;
    }

    public int getStreamDependency() {
        return this.streamDependency;
    }

    public int getWeight() {
        return this.weight;
    }

    @Override
    protected void setFlags() {
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FramePriority)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"equals: object is not a FramePriority", (Object[])new Object[0]);
            }
            return false;
        }
        FramePriority framePriorityToCompare = (FramePriority)object;
        if (!super.equals(framePriorityToCompare)) {
            return false;
        }
        if (this.isExclusive() != framePriorityToCompare.isExclusive()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.isExclusive() = " + this.isExclusive() + " framePriorityToCompare.isExclusive() = " + framePriorityToCompare.isExclusive()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.getStreamDependency() != framePriorityToCompare.getStreamDependency()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.getStreamDependency() = " + this.getStreamDependency() + " framePriorityToCompare.getStreamDependency() = " + framePriorityToCompare.getStreamDependency()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.getWeight() != framePriorityToCompare.getWeight()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.getWeight() = " + this.getWeight() + " framePriorityToCompare.getWeight() = " + framePriorityToCompare.getWeight()), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder frameToString = new StringBuilder();
        frameToString.append(super.toString());
        frameToString.append("Exclusive: " + this.isExclusive() + "\n");
        frameToString.append("StreamDependency: " + this.getStreamDependency() + "\n");
        frameToString.append("Weight: " + this.getWeight() + "\n");
        return frameToString.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FramePriority.class);
    }
}

