/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.utils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FramePushPromise
extends Frame {
    int promisedStreamID = 0;
    public byte[] headerBlockFragment = null;
    int paddingLength = 0;
    static final long serialVersionUID = 6308375066771745827L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public FramePushPromise(int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        super(streamId, payloadLength, flags, reserveBit, direction);
        this.frameType = FrameTypes.PUSH_PROMISE;
    }

    public FramePushPromise(int streamId, byte[] headerBlockFragment, int promisedStream, int paddingLength, boolean endHeaders, boolean padded, boolean reserveBit) {
        super(streamId, headerBlockFragment.length + 4, (byte)0, reserveBit, Frame.FrameDirection.WRITE);
        this.headerBlockFragment = headerBlockFragment;
        this.paddingLength = paddingLength;
        this.PADDED_FLAG = padded;
        this.END_HEADERS_FLAG = endHeaders;
        this.reservedBit = reserveBit;
        this.promisedStreamID = promisedStream;
        if (padded) {
            this.payloadLength += paddingLength + 1;
        }
        this.frameType = FrameTypes.PUSH_PROMISE;
        this.setInitialized();
    }

    @Override
    public void processPayload(FrameReadProcessor frp) throws FrameSizeException {
        this.setFlags();
        int payloadIndex = 4;
        int paddedLength = 0;
        if (this.PADDED_FLAG) {
            paddedLength = this.payloadLength - frp.grabNextByte();
        }
        byte nextPayloadByte = frp.grabNextByte();
        this.reservedBit = utils.getReservedBit(nextPayloadByte);
        nextPayloadByte = (byte)(nextPayloadByte & 0x7F);
        this.promisedStreamID = frp.grabNext24BitInt(nextPayloadByte);
        this.headerBlockFragment = new byte[paddedLength];
        int i = 0;
        while (true) {
            int n = ++payloadIndex;
            ++payloadIndex;
            if (n >= paddedLength) break;
            this.headerBlockFragment[i] = frp.grabNextByte();
            ++i;
        }
    }

    @Override
    public byte[] buildFrameForWrite() {
        int i;
        byte[] frame = super.buildFrameForWrite();
        this.setFrameHeaders(frame, (byte)5);
        int frameIndex = 9;
        if (this.PADDED_FLAG) {
            utils.Move8BitstoByteArray(this.paddingLength, frame, frameIndex);
            ++frameIndex;
        }
        utils.Move31BitstoByteArray(this.promisedStreamID, frame, frameIndex);
        frameIndex += 4;
        for (i = 0; i < this.headerBlockFragment.length; ++i) {
            frame[frameIndex] = this.headerBlockFragment[i];
            ++frameIndex;
        }
        for (i = 0; i < this.paddingLength; ++i) {
            frame[frameIndex] = 0;
            ++frameIndex;
        }
        return frame;
    }

    @Override
    public void validate(H2ConnectionSettings settings) throws ProtocolException, FrameSizeException {
        if (this.streamId == 0) {
            throw new ProtocolException("PUSH_PROMISE Frame stream ID cannot be 0x0");
        }
        if (this.getPayloadLength() > settings.maxFrameSize) {
            throw new FrameSizeException("PUSH_PROMISE payload greater than max allowed");
        }
        if (this.paddingLength >= this.payloadLength) {
            throw new ProtocolException("PUSH_PROMISE padding length must be less than the length of the payload");
        }
    }

    @Override
    protected void setFlags() {
        this.END_HEADERS_FLAG = utils.getFlag(this.flags, 2);
        this.PADDED_FLAG = utils.getFlag(this.flags, 3);
    }

    public int getPromisedStreamId() {
        return this.promisedStreamID;
    }

    public int getPaddingLength() {
        return this.paddingLength;
    }

    public byte[] getHeaderBlockFragment() {
        return this.headerBlockFragment;
    }

    @Override
    public String toString() {
        StringBuilder frameToString = new StringBuilder();
        frameToString.append(super.toString());
        frameToString.append("FrameReserveBit: ").append(this.getFrameReserveBit()).append("\n");
        frameToString.append("PaddingLength: ").append(this.getPaddingLength()).append("\n");
        frameToString.append("PromisedStreamID: ").append(this.getPromisedStreamId()).append("\n");
        return frameToString.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FramePushPromise.class);
    }
}

