/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.utils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class FrameSettings
extends Frame {
    private int headerTableSize = -1;
    private int enablePush = -1;
    private int maxConcurrentStreams = -1;
    private int maxFrameSize = -1;
    private int maxHeaderListSize = -1;
    private int initialWindowSize = -1;
    private final int HEADER_TABLE_SIZE_ID = 1;
    private final int ENABLE_PUSH_ID = 2;
    private final int MAX_CONCURRENT_STREAMS_ID = 3;
    private final int INITIAL_WINDOW_SIZE_ID = 4;
    private final int MAX_FRAME_SIZE_ID = 5;
    private final int MAX_HEADER_LIST_SIZE_ID = 6;
    static final long serialVersionUID = 5243695148498845199L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public FrameSettings(int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        super(streamId, payloadLength, flags, reserveBit, direction);
        this.frameType = FrameTypes.SETTINGS;
    }

    public FrameSettings(int streamId, int headerTableSize, int enablePush, int maxConcurrentStreams, int initialWindowSize, int maxFrameSize, int maxHeaderListSize, boolean reserveBit) {
        super(streamId, 0, (byte)0, reserveBit, Frame.FrameDirection.WRITE);
        if (headerTableSize != -1) {
            this.headerTableSize = headerTableSize;
            this.payloadLength += 6;
        }
        if (enablePush != -1) {
            this.enablePush = enablePush;
            this.payloadLength += 6;
        }
        if (maxConcurrentStreams != -1) {
            this.maxConcurrentStreams = maxConcurrentStreams;
            this.payloadLength += 6;
        }
        if (initialWindowSize != -1) {
            this.initialWindowSize = initialWindowSize;
            this.payloadLength += 6;
        }
        if (maxFrameSize != -1) {
            this.maxFrameSize = maxFrameSize;
            this.payloadLength += 6;
        }
        if (maxHeaderListSize != -1) {
            this.maxHeaderListSize = maxHeaderListSize;
            this.payloadLength += 6;
        }
        this.frameType = FrameTypes.SETTINGS;
        this.setInitialized();
    }

    public FrameSettings() {
        this(0, -1, -1, -1, -1, -1, -1, false);
        this.setInitialized();
    }

    @Override
    public void processPayload(FrameReadProcessor frp) throws FrameSizeException {
        int numberOfSettings = this.payloadLength / 6;
        while (numberOfSettings-- > 0) {
            int settingId = frp.grabNext16BitInt();
            int settingValue = frp.grabNext32BitInt();
            this.putSettingValue(settingId, settingValue);
        }
    }

    public void processPayload(byte[] payload) throws ProtocolException {
        int numberOfSettings = this.payloadLength / 6;
        int i = 0;
        while (numberOfSettings-- > 0) {
            int settingId = payload[i++] & payload[i++];
            int settingValue = payload[i++] & payload[i++] & payload[i++] & payload[i++];
            this.putSettingValue(settingId, settingValue);
        }
    }

    @Override
    public byte[] buildFrameForWrite() {
        byte[] frame = super.buildFrameForWrite();
        this.setFrameHeaders(frame, (byte)4);
        int frameIndex = 9;
        if (this.headerTableSize != -1) {
            utils.Move16BitstoByteArray(1, frame, frameIndex);
            utils.Move32BitstoByteArray(this.headerTableSize, frame, frameIndex += 2);
            frameIndex += 4;
        }
        if (this.enablePush != -1) {
            utils.Move16BitstoByteArray(2, frame, frameIndex);
            utils.Move32BitstoByteArray(this.enablePush, frame, frameIndex += 2);
            frameIndex += 4;
        }
        if (this.maxConcurrentStreams != -1) {
            utils.Move16BitstoByteArray(3, frame, frameIndex);
            utils.Move32BitstoByteArray(this.maxConcurrentStreams, frame, frameIndex += 2);
            frameIndex += 4;
        }
        if (this.initialWindowSize != -1) {
            utils.Move16BitstoByteArray(4, frame, frameIndex);
            utils.Move32BitstoByteArray(this.initialWindowSize, frame, frameIndex += 2);
            frameIndex += 4;
        }
        if (this.maxFrameSize != -1) {
            utils.Move16BitstoByteArray(5, frame, frameIndex);
            utils.Move32BitstoByteArray(this.maxFrameSize, frame, frameIndex += 2);
            frameIndex += 4;
        }
        if (this.maxHeaderListSize != -1) {
            utils.Move16BitstoByteArray(6, frame, frameIndex);
            utils.Move32BitstoByteArray(this.maxHeaderListSize, frame, frameIndex += 2);
            frameIndex += 4;
        }
        return frame;
    }

    @Override
    public void validate(H2ConnectionSettings settings) throws Http2Exception {
        if (this.streamId != 0) {
            throw new ProtocolException("SETTINGS frame stream ID must be 0x0; received " + this.streamId);
        }
        if (this.ACK_FLAG && this.getPayloadLength() != 0) {
            throw new FrameSizeException("SETTINGS frame with ACK set cannot have an additional payload");
        }
    }

    @Override
    protected void setFlags() {
        this.ACK_FLAG = utils.getFlag(this.flags, 0);
    }

    public int getHeaderTableSize() {
        return this.headerTableSize;
    }

    public int getEnablePush() {
        return this.enablePush;
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public int getInitialWindowSize() {
        return this.initialWindowSize;
    }

    public int getMaxFrameSize() {
        return this.maxFrameSize;
    }

    public int getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    private void putSettingValue(int id, int value) {
        switch (id) {
            case 1: {
                this.headerTableSize = value;
                break;
            }
            case 2: {
                this.enablePush = value;
                break;
            }
            case 3: {
                this.maxConcurrentStreams = value;
                break;
            }
            case 4: {
                this.initialWindowSize = value;
                break;
            }
            case 5: {
                this.maxFrameSize = value;
                break;
            }
            case 6: {
                this.maxHeaderListSize = value;
                break;
            }
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FrameSettings)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Object is not FrameSettings", (Object[])new Object[0]);
            }
            return false;
        }
        FrameSettings frameSettingsToCompare = (FrameSettings)object;
        if (!super.equals(frameSettingsToCompare)) {
            return false;
        }
        if (this.getEnablePush() != frameSettingsToCompare.getEnablePush()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.getEnablePush() = " + this.getEnablePush() + " frameSettingsToCompare.getEnablePush() = " + frameSettingsToCompare.getEnablePush()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.getHeaderTableSize() != frameSettingsToCompare.getHeaderTableSize()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.getHeaderTableSize() = " + this.getHeaderTableSize() + " frameSettingsToCompare.getHeaderTableSize() = " + frameSettingsToCompare.getHeaderTableSize()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.getInitialWindowSize() != frameSettingsToCompare.getInitialWindowSize()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.getInitialWindowSize() = " + this.getInitialWindowSize() + " frameSettingsToCompare.getInitialWindowSize() = " + frameSettingsToCompare.getInitialWindowSize()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.getMaxConcurrentStreams() != frameSettingsToCompare.getMaxConcurrentStreams()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.getMaxConcurrentStreams() = " + this.getMaxConcurrentStreams() + " frameSettingsToCompare.getMaxConcurrentStreams() = " + frameSettingsToCompare.getMaxConcurrentStreams()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.getMaxFrameSize() != frameSettingsToCompare.getMaxFrameSize()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.getMaxFrameSize() = " + this.getMaxFrameSize() + " frameSettingsToCompare.getMaxFrameSize() = " + frameSettingsToCompare.getMaxFrameSize()), (Object[])new Object[0]);
            }
            return false;
        }
        if (this.getMaxHeaderListSize() != frameSettingsToCompare.getMaxHeaderListSize()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("this.getMaxHeaderListSize() = " + this.getMaxHeaderListSize() + " frameSettingsToCompare.getMaxHeaderListSize() = " + frameSettingsToCompare.getMaxHeaderListSize()), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder frameToString = new StringBuilder();
        frameToString.append(super.toString());
        frameToString.append("EnablePush: " + this.getEnablePush() + "\n");
        frameToString.append("HeaderTableSize: " + this.getHeaderTableSize() + "\n");
        frameToString.append("InitialWindowSize: " + this.getInitialWindowSize() + "\n");
        frameToString.append("MaxHeaderListSize: " + this.getMaxHeaderListSize() + "\n");
        frameToString.append("MaxFrameSize: " + this.getMaxFrameSize() + "\n");
        frameToString.append("MaxHeaderListSize: " + this.getMaxHeaderListSize() + "\n");
        return frameToString.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(FrameSettings.class);
    }
}

