/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.hpack;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderField;
import com.ibm.ws.http.channel.h2internal.hpack.HpackConstants;
import com.ibm.ws.http.channel.h2internal.hpack.StaticTable;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Iterator;
import java.util.LinkedList;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DynamicTable {
    private final LinkedList<H2HeaderField> entries = new LinkedList();
    private int tableAddressSpace;
    private int freeAddressSpace = this.tableAddressSpace = HpackConstants.INITIAL_SETTINGS_HEADER_TABLE_SIZE;
    private boolean isValid = true;
    static final long serialVersionUID = -3430300706713781721L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public DynamicTable() {
    }

    public DynamicTable(int size) {
        this.freeAddressSpace = this.tableAddressSpace = size;
    }

    public void addDynamicEntry(H2HeaderField entry) {
        int entrySize = entry.getSize();
        if (entrySize <= this.freeAddressSpace) {
            this.entries.addFirst(entry);
            this.freeAddressSpace -= entrySize;
        } else if (entrySize > this.tableAddressSpace) {
            this.clearDynamicTable();
        } else {
            while (entrySize > this.freeAddressSpace) {
                this.evictDynamicEntry();
            }
            this.entries.addFirst(entry);
            this.freeAddressSpace -= entrySize;
        }
    }

    private void evictDynamicEntry() {
        this.freeAddressSpace += this.entries.getLast().getSize();
        this.entries.removeLast();
    }

    public void updateDynamicTableSize(int size) {
        if (size == 0) {
            this.tableAddressSpace = size;
            this.clearDynamicTable();
            return;
        }
        if (this.tableAddressSpace > size) {
            while (this.tableAddressSpace - this.freeAddressSpace >= size) {
                this.evictDynamicEntry();
            }
        }
        this.freeAddressSpace -= this.tableAddressSpace - size;
        this.tableAddressSpace = size;
    }

    public H2HeaderField get(int index) {
        try {
            return this.entries.get(index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            FFDCFilter.processException((Throwable)indexOutOfBoundsException, (String)"com.ibm.ws.http.channel.h2internal.hpack.DynamicTable", (String)"135", (Object)this, (Object[])new Object[]{index});
            return null;
        }
    }

    public H2HeaderField findInList(int name, int value) {
        H2HeaderField result = null;
        H2HeaderField current = null;
        Iterator i = this.entries.iterator();
        int indexAddressSpace = StaticTable.STATIC_TABLE.size() + 1;
        while (i.hasNext()) {
            current = (H2HeaderField)i.next();
            if (current.getNameHash() == name) {
                if (result == null) {
                    result = current;
                    result.setCurrentIndex(indexAddressSpace);
                }
                if (current.getValueHash() == value) {
                    return result;
                }
            }
            ++indexAddressSpace;
        }
        return result;
    }

    private void clearDynamicTable() {
        this.entries.clear();
        this.freeAddressSpace = this.tableAddressSpace;
    }

    public int tableAddressSpace() {
        return this.tableAddressSpace;
    }

    public int amountOfEntries() {
        return this.entries.size();
    }

    public int usedAddressSpace() {
        return this.tableAddressSpace - this.freeAddressSpace;
    }

    public int freeSpace() {
        return this.freeAddressSpace;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void setValidity(boolean isValid) {
        this.isValid = isValid;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (H2HeaderField current : this.entries) {
            result.append("[  " + ++i + "] (s = " + current.getSize() + ") " + current.getName() + ": " + current.getValue() + "\n");
        }
        result.append("Table size: " + this.usedAddressSpace());
        return result.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DynamicTable.class);
    }
}

