/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.hpack;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http.channel.h2internal.exceptions.CompressionException;
import com.ibm.ws.http.channel.h2internal.hpack.HpackConstants;
import com.ibm.ws.http.channel.h2internal.hpack.HpackUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class IntegerRepresentation {
    static final long serialVersionUID = -5489907304139612319L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected static byte[] encode(int I, HpackConstants.LiteralIndexType type) throws CompressionException, UnsupportedEncodingException {
        HpackConstants.ByteFormatType formatType;
        switch (type) {
            case INDEX: {
                formatType = HpackConstants.ByteFormatType.INCREMENTAL;
                break;
            }
            case NOINDEXING: {
                formatType = HpackConstants.ByteFormatType.NOINDEXING;
                break;
            }
            case NEVERINDEX: {
                formatType = HpackConstants.ByteFormatType.NEVERINDEX;
                break;
            }
            default: {
                throw new CompressionException("Unrecognized byte format used during integer encoding.");
            }
        }
        return IntegerRepresentation.encode(I, formatType);
    }

    protected static byte[] encode(int I, HpackConstants.ByteFormatType type) throws CompressionException, UnsupportedEncodingException {
        byte format;
        int N;
        switch (type) {
            case INDEXED: 
            case HUFFMAN: {
                N = 7;
                format = HpackConstants.MASK_80;
                break;
            }
            case INCREMENTAL: {
                N = 6;
                format = HpackConstants.MASK_40;
                break;
            }
            case NOINDEXING: {
                N = 4;
                format = HpackConstants.MASK_00;
                break;
            }
            case NEVERINDEX: {
                N = 4;
                format = HpackConstants.MASK_10;
                break;
            }
            case NOHUFFMAN: {
                N = 7;
                format = HpackConstants.MASK_00;
                break;
            }
            default: {
                throw new CompressionException("Unrecognized byte format used during integer encoding.");
            }
        }
        return IntegerRepresentation.encode(I, format, N);
    }

    public static byte[] encode(int I, byte format, int N) throws UnsupportedEncodingException {
        ByteArrayOutputStream ba = new ByteArrayOutputStream();
        if (I < HpackUtils.ipow(2, N) - 1) {
            ba.write(HpackUtils.format((byte)I, format));
        } else {
            ba.write(HpackUtils.format((byte)(HpackUtils.ipow(2, N) - 1), format));
            I -= HpackUtils.ipow(2, N) - 1;
            while (I >= 128) {
                ba.write((byte)(I % 128 + 128));
                I /= 128;
            }
            ba.write((byte)I);
        }
        return ba.toByteArray();
    }

    protected static int decode(WsByteBuffer buffer, HpackConstants.ByteFormatType type) throws CompressionException {
        int N = -1;
        switch (type) {
            case INDEXED: 
            case HUFFMAN: 
            case NOHUFFMAN: {
                N = 7;
                break;
            }
            case INCREMENTAL: {
                N = 6;
                break;
            }
            case TABLE_UPDATE: {
                N = 5;
                break;
            }
            case NOINDEXING: 
            case NEVERINDEX: {
                N = 4;
                break;
            }
            default: {
                throw new CompressionException("Encoding Exception: Unknown Indexing Type");
            }
        }
        return IntegerRepresentation.decode(buffer, N);
    }

    public static int decode(WsByteBuffer headerBlock, int N) {
        int I = HpackUtils.getLSB(headerBlock.get(), N);
        if (I < HpackUtils.ipow(2, N) - 1) {
            return I;
        }
        int M = 0;
        boolean done = false;
        while (!done) {
            byte b = headerBlock.get();
            I += (b & 0x7F) * HpackUtils.ipow(2, M);
            M += 7;
            if ((b & 0x80) == 128) continue;
            done = true;
        }
        return I;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(IntegerRepresentation.class);
    }
}

