/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.priority;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.http.channel.h2internal.H2WriteQEntry;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.ArrayList;
import java.util.Iterator;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Node {
    private static final TraceComponent tc = Tr.register(Node.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    public static int DEFAULT_NODE_PRIORITY = 16;
    public static int ROOT_STREAM_ID = 0;
    public static int ROOT_PRIORITY = -1;
    Node parent = null;
    ArrayList<Node> dependents = new ArrayList();
    int streamID;
    int priority = 16;
    NODE_STATUS status = NODE_STATUS.NOT_REQUESTING;
    boolean priorityRatioPositive = false;
    int writeCount = 0;
    int dependentWriteCount = 0;
    H2WriteQEntry entry = null;
    static final long serialVersionUID = 2574713341012038257L;

    public Node(int nodeStreamID, int nodePriority) {
        this.streamID = nodeStreamID;
        this.priority = nodePriority;
    }

    protected Node findNode(int nodeStreamID) {
        if (nodeStreamID == this.streamID) {
            Tr.debug((TraceComponent)tc, (String)("findNode exit: bottom of recursion, found node: " + this), (Object[])new Object[0]);
            return this;
        }
        Iterator<Node> iter = this.dependents.iterator();
        Node found = null;
        while (iter.hasNext()) {
            found = iter.next().findNode(nodeStreamID);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    protected void addDependent(Node nodeToAdd) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addDependent entry: node to add: " + nodeToAdd), (Object[])new Object[0]);
        }
        this.dependents.add(nodeToAdd);
    }

    protected void removeDependent(Node nodeToRemove) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeDependent entry: node to remove: " + nodeToRemove), (Object[])new Object[0]);
        }
        this.dependents.remove(nodeToRemove);
    }

    protected void clearDependentsWriteCount() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("clearDependentsWriteCount entry: for this node: " + this), (Object[])new Object[0]);
        }
        this.dependentWriteCount = 0;
        if (this.dependents == null || this.dependents.size() == 0) {
            return;
        }
        for (int i = 0; i < this.dependents.size(); ++i) {
            this.dependents.get(i).setWriteCount(0);
        }
    }

    protected void sortDependents() {
        int i;
        int bigIndex = 0;
        int smallIndex = 0;
        int prioritySum = 0;
        boolean noChange = true;
        boolean firstLoop = true;
        Node nI = null;
        Node nIMinus1 = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sortDependents entry: sort dependents of this node " + this), (Object[])new Object[0]);
        }
        if (this.dependents == null || this.dependents.size() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sortDependents exit", (Object[])new Object[0]);
            }
            return;
        }
        if (this.dependents.size() == 1) {
            this.dependents.get(0).setPriorityRatioPositive(true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sortDependents exit", (Object[])new Object[0]);
            }
            return;
        }
        for (i = bigIndex = this.dependents.size() - 1; i >= 0; --i) {
            prioritySum += this.dependents.get(i).getPriority();
        }
        do {
            noChange = true;
            if (firstLoop) {
                nI = this.dependents.get(bigIndex);
                if (this.dependentWriteCount == 0 || nI.getPriority() * this.dependentWriteCount > nI.getWriteCount() * prioritySum) {
                    nI.setPriorityRatioPositive(true);
                } else {
                    nI.setPriorityRatioPositive(false);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("looping through with indexes of: " + bigIndex + " and: " + smallIndex), (Object[])new Object[0]);
            }
            for (i = bigIndex; i >= smallIndex + 1; --i) {
                nI = this.dependents.get(i);
                nIMinus1 = this.dependents.get(i - 1);
                if (firstLoop) {
                    if (this.dependentWriteCount == 0 || nIMinus1.getPriority() * this.dependentWriteCount > nIMinus1.getWriteCount() * prioritySum) {
                        nIMinus1.setPriorityRatioPositive(true);
                    } else {
                        nIMinus1.setPriorityRatioPositive(false);
                    }
                }
                if (!nIMinus1.getPriorityRatioPositive()) {
                    if (!nI.getPriorityRatioPositive() && nI.getPriority() <= nIMinus1.getPriority()) continue;
                    noChange = false;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("swapping node (n-1): " + nIMinus1 + " with node (n): " + nI), (Object[])new Object[0]);
                    }
                    this.dependents.set(i, nIMinus1);
                    this.dependents.set(i - 1, nI);
                    continue;
                }
                if (!nI.getPriorityRatioPositive() || nI.getPriority() <= nIMinus1.getPriority()) continue;
                noChange = false;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("swapping node (n-1): " + nIMinus1 + " with node (n): " + nI), (Object[])new Object[0]);
                }
                this.dependents.set(i, nIMinus1);
                this.dependents.set(i - 1, nI);
            }
            firstLoop = false;
        } while (!noChange && bigIndex != ++smallIndex);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sortDependents exit", (Object[])new Object[0]);
        }
    }

    protected Node findNextWrite() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findNextWrite entry: on node " + this + "With status: " + (Object)((Object)this.status) + "and positive ratio of: " + this.getPriorityRatioPositive()), (Object[])new Object[0]);
        }
        if (this.status == NODE_STATUS.REQUESTING_WRITE) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("findNextWrite exit: node to write next is: " + this.toStringDetails()), (Object[])new Object[0]);
            }
            return this;
        }
        for (int i = 0; i < this.dependents.size(); ++i) {
            Node n = this.dependents.get(i);
            Node nextWrite = n.findNextWrite();
            if (nextWrite == null) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("findNextWrite exit: next write node found. stream-id: " + nextWrite.getStreamID() + " node hc: " + nextWrite.hashCode()), (Object[])new Object[0]);
            }
            return nextWrite;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"findNextWrite exit: null", (Object[])new Object[0]);
        }
        return null;
    }

    protected int incrementDependentWriteCount() {
        ++this.dependentWriteCount;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("incrementDependentWriteCount entry: new dependentWriteCount of: " + this.dependentWriteCount + " for node: " + this), (Object[])new Object[0]);
        }
        return this.dependentWriteCount;
    }

    protected void setParent(Node newParent) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setParent entry: new parent will be: " + newParent + " for node: " + this), (Object[])new Object[0]);
        }
        Node oldParent = this.parent;
        this.parent = newParent;
        if (newParent != null) {
            this.parent.addDependent(this);
        }
        if (oldParent != null) {
            oldParent.removeDependent(this);
        }
    }

    protected void incrementWriteCount() {
        ++this.writeCount;
    }

    public Node getParent() {
        return this.parent;
    }

    public ArrayList<Node> getDependents() {
        return this.dependents;
    }

    public int getStreamID() {
        return this.streamID;
    }

    public int getWriteCount() {
        return this.writeCount;
    }

    protected void setWriteCount(int x) {
        this.writeCount = x;
    }

    public int getPriority() {
        return this.priority;
    }

    protected void setPriority(int x) {
        this.priority = x;
    }

    public boolean getPriorityRatioPositive() {
        return this.priorityRatioPositive;
    }

    protected void setPriorityRatioPositive(boolean x) {
        this.priorityRatioPositive = x;
    }

    public NODE_STATUS getStatus() {
        return this.status;
    }

    protected void setStatus(NODE_STATUS x) {
        this.status = x;
    }

    protected void setEntry(H2WriteQEntry x) {
        this.entry = x;
    }

    public H2WriteQEntry getEntry() {
        return this.entry;
    }

    public String toString() {
        String s = "hashcode: " + this.hashCode() + " stream id: " + this.streamID + " ";
        return s;
    }

    public String toStringDetails() {
        String s = "hashcode: " + this.hashCode() + " stream id: " + this.streamID + " prioirity: " + this.priority + " status: " + (Object)((Object)this.status) + " ratio: " + this.priorityRatioPositive + " write count: " + this.writeCount + " dep write count: " + this.dependentWriteCount + " ";
        return s;
    }

    public StringBuffer dumpDependents(StringBuffer s) {
        Node n;
        int i;
        if (s == null) {
            s = new StringBuffer("\nDump of Tree: ");
        }
        if (this.dependents.size() > 0) {
            s.append("\n" + this.dependents.size() + " Dependents of: " + this);
        }
        s.append("\nDependents of: " + this);
        for (i = 0; i < this.dependents.size(); ++i) {
            n = this.dependents.get(i);
            s.append("\n  " + n.toStringDetails());
        }
        for (i = 0; i < this.dependents.size(); ++i) {
            n = this.dependents.get(i);
            n.dumpDependents(s);
        }
        return s;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class WRITE_COUNT_ACTION
    extends Enum<WRITE_COUNT_ACTION> {
        public static final /* enum */ WRITE_COUNT_ACTION CLEAR;
        public static final /* enum */ WRITE_COUNT_ACTION INCREMENT;
        public static final /* enum */ WRITE_COUNT_ACTION NO_ACTION;
        private static final /* synthetic */ WRITE_COUNT_ACTION[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static WRITE_COUNT_ACTION[] values() {
            return (WRITE_COUNT_ACTION[])$VALUES.clone();
        }

        public static WRITE_COUNT_ACTION valueOf(String name) {
            return Enum.valueOf(WRITE_COUNT_ACTION.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(WRITE_COUNT_ACTION.class);
            CLEAR = new WRITE_COUNT_ACTION();
            INCREMENT = new WRITE_COUNT_ACTION();
            NO_ACTION = new WRITE_COUNT_ACTION();
            $VALUES = new WRITE_COUNT_ACTION[]{CLEAR, INCREMENT, NO_ACTION};
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    public static final class NODE_STATUS
    extends Enum<NODE_STATUS> {
        public static final /* enum */ NODE_STATUS REQUESTING_WRITE;
        public static final /* enum */ NODE_STATUS NOT_REQUESTING;
        public static final /* enum */ NODE_STATUS CLOSED;
        public static final /* enum */ NODE_STATUS ACTION_NO_CHANGE;
        private static final /* synthetic */ NODE_STATUS[] $VALUES;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public static NODE_STATUS[] values() {
            return (NODE_STATUS[])$VALUES.clone();
        }

        public static NODE_STATUS valueOf(String name) {
            return Enum.valueOf(NODE_STATUS.class, name);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(NODE_STATUS.class);
            REQUESTING_WRITE = new NODE_STATUS();
            NOT_REQUESTING = new NODE_STATUS();
            CLOSED = new NODE_STATUS();
            ACTION_NO_CHANGE = new NODE_STATUS();
            $VALUES = new NODE_STATUS[]{REQUESTING_WRITE, NOT_REQUESTING, CLOSED, ACTION_NO_CHANGE};
        }
    }
}

