/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jmx.PlatformMBeanService;
import com.ibm.ws.jmx.internal.DelayedMBeanActivator;
import com.ibm.ws.kernel.boot.jmx.service.MBeanServerForwarderDelegate;
import com.ibm.ws.kernel.boot.jmx.service.MBeanServerPipeline;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, service={PlatformMBeanService.class}, property={"service.vendor=IBM"})
public final class DelayedMBeanActivatorHelper
implements PlatformMBeanService,
ServiceTrackerCustomizer<Object, ServiceReference<?>> {
    private volatile DelayedMBeanActivator mDelayedMBeanActivator;
    private final ConcurrentHashMap<ServiceReference<?>, ObjectName> mBeanMap = new ConcurrentHashMap();
    private ServiceTracker<Object, ServiceReference<?>> mbeanTracker;
    private MBeanServerPipeline pipeline;
    static final long serialVersionUID = -341321982513526209L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected void activate(ComponentContext compContext) {
        BundleContext ctx = compContext.getBundleContext();
        this.mDelayedMBeanActivator = new DelayedMBeanActivator(ctx);
        this.pipeline.insert((MBeanServerForwarderDelegate)this.mDelayedMBeanActivator);
        try {
            this.mbeanTracker = new ServiceTracker(ctx, ctx.createFilter("(jmx.objectname=*)"), (ServiceTrackerCustomizer)this);
            this.mbeanTracker.open(true);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivatorHelper", (String)"63", (Object)this, (Object[])new Object[]{compContext});
        }
    }

    protected void deactivate(ComponentContext compContext) {
        if (this.mbeanTracker != null) {
            this.mbeanTracker.close();
        }
        this.pipeline.remove((MBeanServerForwarderDelegate)this.mDelayedMBeanActivator);
    }

    @Override
    public MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    protected void setMBean(ServiceReference<?> ref) {
        Object jmxObjectName = ref.getProperty("jmx.objectname");
        if (jmxObjectName instanceof String) {
            try {
                ObjectName name = new ObjectName((String)jmxObjectName);
                this.setServiceReferenceInternal(ref, name);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                FFDCFilter.processException((Throwable)malformedObjectNameException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivatorHelper", (String)"96", (Object)this, (Object[])new Object[]{ref});
            }
        }
    }

    protected void unsetMBean(ServiceReference<?> ref) {
        this.unsetServiceReferenceInternal(ref);
    }

    @Reference
    protected void setMBeanServerPipeline(MBeanServerPipeline pipeline) {
        this.pipeline = pipeline;
    }

    protected void unsetMBeanServerPipeline(MBeanServerPipeline pipeline) {
        this.pipeline = null;
    }

    private void setServiceReferenceInternal(ServiceReference<?> ref, ObjectName name) {
        if (this.mBeanMap.put(ref, name) != null) {
            // empty if block
        }
        if (!this.mDelayedMBeanActivator.registerDelayedMBean(ref, name)) {
            // empty if block
        }
    }

    private void unsetServiceReferenceInternal(ServiceReference<?> ref) {
        ObjectName name = this.mBeanMap.remove(ref);
        if (name != null) {
            try {
                this.mDelayedMBeanActivator.unregisterMBean(name);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                FFDCFilter.processException((Throwable)instanceNotFoundException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivatorHelper", (String)"149", (Object)this, (Object[])new Object[]{ref});
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                FFDCFilter.processException((Throwable)mBeanRegistrationException, (String)"com.ibm.ws.jmx.internal.DelayedMBeanActivatorHelper", (String)"152", (Object)this, (Object[])new Object[]{ref});
            }
        }
    }

    public ServiceReference<?> addingService(ServiceReference<Object> reference) {
        this.setMBean(reference);
        return reference;
    }

    public void modifiedService(ServiceReference<Object> reference, ServiceReference<?> service) {
    }

    public void removedService(ServiceReference<Object> reference, ServiceReference<?> service) {
        this.unsetMBean(reference);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(DelayedMBeanActivatorHelper.class);
    }
}

