/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.connectionpool.monitor;

import com.ibm.websphere.connectionpool.monitor.ConnectionPoolStatsMXBean;
import com.ibm.websphere.monitor.meters.Counter;
import com.ibm.websphere.monitor.meters.Gauge;
import com.ibm.websphere.monitor.meters.Meter;
import com.ibm.websphere.monitor.meters.StatisticsMeter;

public class ConnectionPoolStats
extends Meter
implements ConnectionPoolStatsMXBean {
    private final Counter createCount = new Counter();
    private final Counter destroyCount = new Counter();
    private final Gauge poolSize = new Gauge();
    private final Gauge freeConnectionCount;
    private final Gauge managedConnectionCount = new Gauge();
    private final Gauge connectionHandleCount = new Gauge();
    private final StatisticsMeter waitTime = new StatisticsMeter();
    private final StatisticsMeter inUseTime;

    public ConnectionPoolStats() {
        this.freeConnectionCount = new Gauge();
        this.inUseTime = new StatisticsMeter();
    }

    public void incCreateCount() {
        this.createCount.incrementBy(1L);
    }

    public void incPoolSize() {
        this.poolSize.incrementCurrentValue(1L);
    }

    public void incDestroyCount() {
        this.destroyCount.incrementBy(1L);
    }

    public void incManagedConnectionCount() {
        this.managedConnectionCount.incrementCurrentValue(1L);
    }

    public void decManagedConnectionCount() {
        this.managedConnectionCount.decrementCurrentValue(1L);
    }

    public void incConnectionHandleCount() {
        this.connectionHandleCount.incrementCurrentValue(1L);
    }

    public void decConnectionHandleCount() {
        this.connectionHandleCount.decrementCurrentValue(1L);
    }

    public void updateWaitTime(long elapsed) {
        this.waitTime.addDataPoint(elapsed);
    }

    public void updateInUseTime(long elapsed) {
        this.inUseTime.addDataPoint(elapsed);
    }

    public void incFreeConnectionCount() {
        this.freeConnectionCount.incrementCurrentValue(1L);
    }

    public void decFreeConnectionCount() {
        this.freeConnectionCount.decrementCurrentValue(1L);
    }

    @Override
    public long getCreateCount() {
        return this.createCount.getCurrentValue();
    }

    @Override
    public long getDestroyCount() {
        return this.destroyCount.getCurrentValue();
    }

    @Override
    public long getManagedConnectionCount() {
        return this.managedConnectionCount.getCurrentValue();
    }

    @Override
    public long getConnectionHandleCount() {
        return this.connectionHandleCount.getCurrentValue();
    }

    @Override
    public double getWaitTime() {
        return this.waitTime.getMean();
    }

    @Override
    public double getInUseTime() {
        return this.inUseTime.getMean();
    }

    @Override
    public long getFreeConnectionCount() {
        return this.freeConnectionCount.getCurrentValue();
    }

    public String toString() {
        return "ConnectionPoolStats [createCount=" + this.createCount + ", destroyCount=" + this.destroyCount + ", poolSize=" + this.poolSize + ", freeConnectionCount=" + this.freeConnectionCount + ", managedConnectionCount=" + this.managedConnectionCount + ", connectionHandleCount=" + this.connectionHandleCount + ", waitTime=" + this.waitTime + "]";
    }
}

