/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Map;
import org.apache.yoko.rmi.impl.ArrayDescriptor;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

class CharArrayDescriptor
extends ArrayDescriptor {
    CharArrayDescriptor(Class type, Class elemType, TypeRepository rep) {
        super(type, elemType, rep);
    }

    @Override
    public Serializable readValue(InputStream in, Map<Integer, Serializable> offsetMap, Integer key) {
        int len = in.read_long();
        char[] arr = new char[len];
        offsetMap.put(key, (Serializable)arr);
        in.read_wchar_array(arr, 0, len);
        return arr;
    }

    @Override
    public void writeValue(OutputStream out, Serializable value) {
        char[] arr = (char[])value;
        out.write_long(arr.length);
        out.write_wchar_array(arr, 0, arr.length);
    }

    @Override
    Object copyObject(Object value, CopyState state) {
        if (((char[])value).length == 0) {
            return value;
        }
        Object copy = ((char[])value).clone();
        state.put(value, copy);
        return copy;
    }

    @Override
    void printFields(PrintWriter pw, Map recurse, Object val) {
        char[] arr = (char[])val;
        pw.print("length=" + arr.length + "; ");
        for (int i = 0; i < arr.length; ++i) {
            if (i != 0) {
                pw.print(", ");
            }
            pw.print(arr[i]);
        }
    }
}

