/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.appbnd.internal.authorization;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.metadata.ApplicationMetaDataListener;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.security.SecurityRoles;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.appbnd.Group;
import com.ibm.ws.javaee.dd.appbnd.SecurityRole;
import com.ibm.ws.javaee.dd.appbnd.SpecialSubject;
import com.ibm.ws.javaee.dd.appbnd.Subject;
import com.ibm.ws.javaee.dd.appbnd.User;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ApplicationMetaData;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.appbnd.internal.delegation.DefaultDelegationProvider;
import com.ibm.ws.security.authorization.AuthorizationTableService;
import com.ibm.ws.security.authorization.RoleSet;
import com.ibm.ws.security.authorization.builtin.BaseAuthorizationTableService;
import com.ibm.ws.security.delegation.DelegationProvider;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryChangeListener;
import com.ibm.ws.security.registry.UserRegistryService;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={ApplicationMetaDataListener.class, AuthorizationTableService.class, UserRegistryChangeListener.class}, name="com.ibm.ws.security.appbnd.AppBndAuthorizationTableService", immediate=true, configurationPolicy=ConfigurationPolicy.IGNORE, property={"service.vendor=IBM", "com.ibm.ws.security.authorization.table.name=WebApp"})
public class AppBndAuthorizationTableService
extends BaseAuthorizationTableService
implements ApplicationMetaDataListener,
AuthorizationTableService,
UserRegistryChangeListener {
    private static final TraceComponent tc = Tr.register(AppBndAuthorizationTableService.class);
    private volatile DefaultDelegationProvider defaultDelegationProvider = null;
    private ServiceRegistration<DelegationProvider> defaultDelegationProviderReg;
    private static final String INVALID_ACCESS_ID = "";
    private final ConcurrentMap<String, AuthzInfo> resourceToAuthzInfoMap = new ConcurrentHashMap<String, AuthzInfo>(16, 0.7f, 1);
    static final long serialVersionUID = -8114775263411507830L;

    private void registerDefaultDelegationProvider(ComponentContext cc) {
        this.defaultDelegationProvider = new DefaultDelegationProvider();
        this.defaultDelegationProvider.setSecurityService((SecurityService)this.securityServiceRef.getService());
        BundleContext bc = cc.getBundleContext();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("type", "defaultProvider");
        this.defaultDelegationProviderReg = bc.registerService(DelegationProvider.class, (Object)this.defaultDelegationProvider, props);
    }

    protected void activate(ComponentContext cc) {
        super.activate(cc);
        this.registerDefaultDelegationProvider(cc);
    }

    protected void deactivate(ComponentContext cc) {
        super.deactivate(cc);
        if (this.defaultDelegationProviderReg != null) {
            this.defaultDelegationProviderReg.unregister();
        }
    }

    private boolean establishInitialTable(String appName, Collection<SecurityRole> secRoles) {
        if (this.resourceToAuthzInfoMap.putIfAbsent(appName, new AuthzInfo(appName, secRoles)) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Created initial authorization tables for " + appName), (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void applicationMetaDataCreated(MetaDataEvent<ApplicationMetaData> event) throws MetaDataException {
        String appName = ((ApplicationMetaData)event.getMetaData()).getJ2EEName().getApplication();
        try {
            List securityRoles = ((SecurityRoles)event.getContainer().adapt(SecurityRoles.class)).getSecurityRoles();
            if (!this.establishInitialTable(appName, securityRoles)) {
                Tr.error((TraceComponent)tc, (String)"AUTHZ_TABLE_DUPLICATE_APP_NAME", (Object[])new Object[]{appName});
                throw new MetaDataException(TraceNLS.getFormattedMessage(((Object)((Object)this)).getClass(), (String)"com.ibm.ws.security.token.internal.resources.TokenMessages", (String)"AUTHZ_TABLE_DUPLICATE_APP_NAME", (Object[])new Object[]{appName}, (String)"CWWKS9110E: Multiple applications have the name {0}. Security authorization policies requires that names be unique."));
            }
            this.defaultDelegationProvider.createAppToSecurityRolesMapping(appName, securityRoles);
        }
        catch (UnableToAdaptException securityRoles) {
            FFDCFilter.processException((Throwable)securityRoles, (String)"com.ibm.ws.security.appbnd.internal.authorization.AppBndAuthorizationTableService", (String)"215", (Object)((Object)this), (Object[])new Object[]{event});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("There was a problem setting the security meta data for application " + appName + "."), (Object[])new Object[]{e});
            }
            Tr.error((TraceComponent)tc, (String)"AUTHZ_TABLE_NOT_CREATED", (Object[])new Object[]{appName});
        }
    }

    public void applicationMetaDataDestroyed(MetaDataEvent<ApplicationMetaData> event) {
        String appName = ((ApplicationMetaData)event.getMetaData()).getJ2EEName().getApplication();
        this.removeTable(appName);
        this.defaultDelegationProvider.removeRoleToRunAsMapping(appName);
    }

    private void removeTable(String appName) {
        this.resourceToAuthzInfoMap.remove(appName);
    }

    private Map<String, RoleSet> updateMapForSpecialSubject(String appName, Map<String, RoleSet> specialSubjectToRolesMap, String specialSubjectName) {
        RoleSet computedRoles = RoleSet.EMPTY_ROLESET;
        HashSet<String> rolesForSubject = new HashSet<String>();
        for (SecurityRole role : ((AuthzInfo)this.resourceToAuthzInfoMap.get((Object)appName)).securityRoles) {
            String roleName = role.getName();
            for (SpecialSubject specialSubject : role.getSpecialSubjects()) {
                String specialSubjectNameFromRole = specialSubject.getType().toString();
                if (!specialSubjectName.equals(specialSubjectNameFromRole)) continue;
                rolesForSubject.add(roleName);
            }
        }
        if (!rolesForSubject.isEmpty()) {
            computedRoles = new RoleSet(rolesForSubject);
        }
        specialSubjectToRolesMap.put(specialSubjectName, computedRoles);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Added the following subject to role mapping for application: " + appName + "."), (Object[])new Object[]{specialSubjectName, computedRoles});
        }
        return specialSubjectToRolesMap;
    }

    public RoleSet getRolesForSpecialSubject(String appName, String specialSubject) {
        AuthzInfo authzInfo = (AuthzInfo)this.resourceToAuthzInfoMap.get(appName);
        if (authzInfo != null) {
            Map<String, RoleSet> subjectToRolesMap = authzInfo.authzTableContainer.specialSubjectMap;
            if (subjectToRolesMap.get(specialSubject) == null) {
                subjectToRolesMap = this.updateMapForSpecialSubject(appName, subjectToRolesMap, specialSubject);
            }
            return (RoleSet)subjectToRolesMap.get(specialSubject);
        }
        return null;
    }

    @FFDCIgnore(value={EntryNotFoundException.class})
    private String getMissingAccessId(Subject subjectFromArchive) {
        block9: {
            String subjectType = null;
            try {
                SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
                UserRegistryService userRegistryService = securityService.getUserRegistryService();
                if (!userRegistryService.isUserRegistryConfigured()) {
                    return null;
                }
                UserRegistry userRegistry = userRegistryService.getUserRegistry();
                String realm = userRegistry.getRealm();
                if (subjectFromArchive instanceof Group) {
                    subjectType = "group";
                    String groupUniqueId = userRegistry.getUniqueGroupId(subjectFromArchive.getName());
                    return AccessIdUtil.createAccessId((String)"group", (String)realm, (String)groupUniqueId);
                }
                if (subjectFromArchive instanceof User) {
                    subjectType = "user";
                    String uniqueId = userRegistry.getUniqueUserId(subjectFromArchive.getName());
                    return AccessIdUtil.createAccessId((String)"user", (String)realm, (String)uniqueId);
                }
            }
            catch (EntryNotFoundException e) {
                if (TraceComponent.isAnyTracingEnabled()) {
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)("No entry found for " + subjectType + " " + subjectFromArchive.getName() + " found in user registry. Unable to create access ID."), (Object[])new Object[0]);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"EntryNotFoundException details:", (Object[])new Object[]{e});
                    }
                }
            }
            catch (RegistryException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.appbnd.internal.authorization.AppBndAuthorizationTableService", (String)"343", (Object)((Object)this), (Object[])new Object[]{subjectFromArchive});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)("Unexpected exception getting the accessId for " + subjectFromArchive.getName() + ": " + (Object)((Object)e)), (Object[])new Object[0]);
            }
        }
        return null;
    }

    private String updateMissingUserAccessId(AuthzTableContainer maps, User user, String userNameFromRole) {
        String accessIdFromRole = this.getMissingAccessId((Subject)user);
        if (accessIdFromRole != null) {
            maps.userToAccessIdMap.put(userNameFromRole, accessIdFromRole);
        } else {
            maps.userToAccessIdMap.put(userNameFromRole, INVALID_ACCESS_ID);
        }
        return accessIdFromRole;
    }

    private String updateMissingGroupAccessId(AuthzTableContainer maps, Group group, String groupNameFromRole) {
        String accessIdFromRole = this.getMissingAccessId((Subject)group);
        if (accessIdFromRole != null) {
            maps.groupToAccessIdMap.put(groupNameFromRole, accessIdFromRole);
        } else {
            maps.groupToAccessIdMap.put(groupNameFromRole, INVALID_ACCESS_ID);
        }
        return accessIdFromRole;
    }

    private Map<String, RoleSet> updateMapsForAccessId(String appName, String accessId) {
        RoleSet computedRoles = RoleSet.EMPTY_ROLESET;
        HashSet<String> rolesForSubject = new HashSet<String>();
        AuthzInfo authzInfo = (AuthzInfo)this.resourceToAuthzInfoMap.get(appName);
        AuthzTableContainer maps = authzInfo.authzTableContainer;
        for (SecurityRole role : authzInfo.securityRoles) {
            String accessIdFromRole;
            String roleName = role.getName();
            if (accessId.startsWith("user")) {
                for (User user : role.getUsers()) {
                    String userNameFromRole = user.getName();
                    accessIdFromRole = user.getAccessId();
                    if ((accessIdFromRole == null || accessIdFromRole.isEmpty() || !accessIdFromRole.startsWith("user")) && (accessIdFromRole = (String)maps.userToAccessIdMap.get(userNameFromRole)) == null) {
                        accessIdFromRole = this.updateMissingUserAccessId(maps, user, userNameFromRole);
                    }
                    if (!this.isMatch(accessId, accessIdFromRole)) continue;
                    rolesForSubject.add(roleName);
                }
                continue;
            }
            if (!accessId.startsWith("group")) continue;
            for (Group group : role.getGroups()) {
                String groupNameFromRole = group.getName();
                accessIdFromRole = group.getAccessId();
                if ((accessIdFromRole == null || accessIdFromRole.isEmpty() || !accessIdFromRole.startsWith("group")) && (accessIdFromRole = (String)maps.groupToAccessIdMap.get(groupNameFromRole)) == null) {
                    accessIdFromRole = this.updateMissingGroupAccessId(maps, group, groupNameFromRole);
                }
                if (!this.isMatch(accessId, accessIdFromRole)) continue;
                rolesForSubject.add(roleName);
            }
        }
        if (!rolesForSubject.isEmpty()) {
            computedRoles = new RoleSet(rolesForSubject);
        }
        maps.accessIdToRolesMap.put(accessId, computedRoles);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Added the following subject to role mapping for application: " + appName + "."), (Object[])new Object[]{accessId, computedRoles});
        }
        return maps.accessIdToRolesMap;
    }

    public RoleSet getRolesForAccessId(String appName, String accessId) {
        AuthzInfo authzInfo = (AuthzInfo)this.resourceToAuthzInfoMap.get(appName);
        if (authzInfo != null) {
            Map<String, RoleSet> accessIdToRolesMap = authzInfo.authzTableContainer.accessIdToRolesMap;
            if (accessIdToRolesMap.get(accessId) == null) {
                accessIdToRolesMap = this.updateMapsForAccessId(appName, accessId);
            }
            return (RoleSet)accessIdToRolesMap.get(accessId);
        }
        return null;
    }

    public boolean isAuthzInfoAvailableForApp(String appName) {
        AuthzInfo authzInfo = (AuthzInfo)this.resourceToAuthzInfoMap.get(appName);
        return authzInfo != null && authzInfo.hasRoles();
    }

    public void notifyOfUserRegistryChange() {
        super.notifyOfUserRegistryChange();
        for (AuthzInfo authzInfo : this.resourceToAuthzInfoMap.values()) {
            authzInfo.authzTableContainer = new AuthzTableContainer(authzInfo.authzTableContainer.resourceName);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class AuthzTableContainer {
        final String resourceName;
        final ConcurrentMap<String, RoleSet> specialSubjectMap = new ConcurrentHashMap<String, RoleSet>(16, 0.7f, 1);
        final ConcurrentMap<String, RoleSet> accessIdToRolesMap = new ConcurrentHashMap<String, RoleSet>(16, 0.7f, 1);
        final ConcurrentMap<String, String> userToAccessIdMap = new ConcurrentHashMap<String, String>(16, 0.7f, 1);
        final ConcurrentMap<String, String> groupToAccessIdMap = new ConcurrentHashMap<String, String>(16, 0.7f, 1);
        static final long serialVersionUID = 2510182940130094083L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        AuthzTableContainer(String resourceName) {
            this.resourceName = resourceName;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AuthzTableContainer.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static final class AuthzInfo {
        final Collection<SecurityRole> securityRoles;
        volatile AuthzTableContainer authzTableContainer;
        boolean hasSecurityRole = false;
        static final long serialVersionUID = -548054554422089430L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AuthzInfo(String resourceName, Collection<SecurityRole> securityRoles) {
            this.securityRoles = securityRoles;
            this.authzTableContainer = new AuthzTableContainer(resourceName);
            if (securityRoles != null && !securityRoles.isEmpty()) {
                this.hasSecurityRole = true;
            }
        }

        public boolean hasRoles() {
            return this.hasSecurityRole;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AuthzInfo.class);
        }
    }
}

