/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.threading.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.threading.PolicyExecutor;
import com.ibm.ws.threading.internal.ExecutorServiceImpl;
import com.ibm.ws.threading.internal.QueueItem;
import com.ibm.ws.threading.internal.ReduceableSemaphore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PolicyExecutorImpl
implements PolicyExecutor {
    private static final TraceComponent tc = Tr.register(PolicyExecutorImpl.class);
    private final Integer configLock = new Integer(0);
    private int coreConcurrency;
    private final AtomicInteger coreConcurrencyAvailable = new AtomicInteger();
    private ExecutorServiceImpl globalExecutor;
    private String identifier;
    private int maxConcurrency;
    private final ReduceableSemaphore maxConcurrencyConstraint = new ReduceableSemaphore(0, false);
    private int maxQueueSize;
    private final ReduceableSemaphore maxQueueSizeConstraint = new ReduceableSemaphore(0, false);
    private final AtomicLong maxWaitForEnqueueNS = new AtomicLong();
    private final ConcurrentHashMap<String, PolicyExecutorImpl> providerCreated;
    private final ConcurrentLinkedQueue<PolicyTaskFuture<?>> queue = new ConcurrentLinkedQueue();
    private final AtomicReference<PolicyExecutor.QueueFullAction> queueFullAction = new AtomicReference();
    private final Set<PolicyTaskFuture<?>> running = Collections.newSetFromMap(new ConcurrentHashMap());
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private final CountDownLatch shutdownNowLatch = new CountDownLatch(1);
    private final AtomicReference<State> state = new AtomicReference<State>(State.ACTIVE);
    private final AtomicInteger withheldConcurrency = new AtomicInteger();
    static final long serialVersionUID = -3085456843190278836L;

    public PolicyExecutorImpl() {
        this.providerCreated = null;
    }

    public PolicyExecutorImpl(ExecutorServiceImpl globalExecutor, String identifier, ConcurrentHashMap<String, PolicyExecutorImpl> providerCreatedInstances) {
        this.globalExecutor = globalExecutor;
        this.identifier = "PolicyExecutorProvider-" + identifier;
        this.providerCreated = providerCreatedInstances;
        this.maxConcurrency = Integer.MAX_VALUE;
        this.maxConcurrencyConstraint.release(Integer.MAX_VALUE);
        this.maxQueueSize = Integer.MAX_VALUE;
        this.maxQueueSizeConstraint.release(Integer.MAX_VALUE);
        if (this.providerCreated.putIfAbsent(this.identifier, this) != null) {
            throw new IllegalStateException(this.identifier);
        }
    }

    private int acquireCoreConcurrency() {
        int cca;
        while ((cca = this.coreConcurrencyAvailable.get()) > 0 && !this.coreConcurrencyAvailable.compareAndSet(cca, cca - 1)) {
        }
        return cca;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long remaining;
        if (this.providerCreated == null) {
            throw new UnsupportedOperationException();
        }
        long start = System.nanoTime();
        switch (this.state.get()) {
            case TASKS_CANCELING: {
                if (this.shutdownNowLatch.await(timeout, unit)) break;
                return false;
            }
            case ACTIVE: 
            case ENQUEUE_STOPPING: {
                if (this.shutdownLatch.await(timeout, unit)) break;
                return false;
            }
        }
        long pollInterval = TimeUnit.MILLISECONDS.toNanos(500L);
        timeout = timeout < 0L ? 0L : unit.toNanos(timeout);
        boolean firstTime = true;
        long waitTime = System.nanoTime() - start;
        while ((remaining = timeout - waitTime) > 0L || firstTime) {
            if (firstTime) {
                firstTime = false;
            }
            State currentState = this.state.get();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"awaitTermination", (Object[])new Object[]{remaining, currentState});
            }
            switch (currentState) {
                case TERMINATED: {
                    return true;
                }
                case TASKS_CANCELING: 
                case ENQUEUE_STOPPED: 
                case TASKS_CANCELED: {
                    if (this.queue.isEmpty()) {
                        if (!(remaining > 0L ? this.maxConcurrencyConstraint.tryAcquire(this.maxConcurrency, remaining < pollInterval ? remaining : pollInterval, TimeUnit.NANOSECONDS) : this.maxConcurrencyConstraint.tryAcquire(this.maxConcurrency))) break;
                        State previous = this.state.getAndSet(State.TERMINATED);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                            Tr.event((Object)this, (TraceComponent)tc, (String)("state: " + (Object)((Object)previous) + " --> TERMINATED"), (Object[])new Object[0]);
                        }
                        return true;
                    }
                    if (remaining <= 0L) break;
                    TimeUnit.NANOSECONDS.sleep(remaining < pollInterval ? remaining : pollInterval);
                    break;
                }
            }
            waitTime = System.nanoTime() - start;
        }
        return this.state.get() == State.TERMINATED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PolicyExecutor coreConcurrency(int core) {
        int cca;
        if (this.providerCreated == null) {
            throw new UnsupportedOperationException();
        }
        if (core == -1) {
            core = Integer.MAX_VALUE;
        } else if (core < 0) {
            throw new IllegalArgumentException(Integer.toString(core));
        }
        Integer n = this.configLock;
        synchronized (n) {
            if (core > this.maxConcurrency) {
                throw new IllegalArgumentException(Integer.toString(core));
            }
            if (this.state.get() != State.ACTIVE) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1203.config.update.after.shutdown", (Object[])new Object[]{"coreConcurrency", this.identifier}));
            }
            cca = this.coreConcurrencyAvailable.addAndGet(core - this.coreConcurrency);
            this.coreConcurrency = core;
        }
        if (cca > 0) {
            while (cca-- > 0 && this.withheldConcurrency.get() > 0 && this.maxConcurrencyConstraint.tryAcquire()) {
                if (this.acquireCoreConcurrency() > 0) {
                    this.decrementWithheldConcurrency();
                    this.expediteGlobal(new PollingTask());
                    continue;
                }
                this.maxConcurrencyConstraint.release();
                break;
            }
        }
        return this;
    }

    @Trivial
    private void decrementWithheldConcurrency() {
        int w;
        while ((w = this.withheldConcurrency.get()) > 0 && !this.withheldConcurrency.compareAndSet(w, w - 1)) {
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("withheld concurrency " + w + " --> " + (w == 0 ? 0 : w - 1)), (Object[])new Object[0]);
        }
    }

    @FFDCIgnore(value={InterruptedException.class, RejectedExecutionException.class})
    private void enqueue(PolicyTaskFuture<?> policyTaskFuture, long wait, Boolean callerRunsOverride) {
        block20: {
            try {
                if (wait <= 0L ? this.maxQueueSizeConstraint.tryAcquire() : this.maxQueueSizeConstraint.tryAcquire(wait, TimeUnit.NANOSECONDS)) {
                    this.queue.offer(policyTaskFuture);
                    int w = this.withheldConcurrency.incrementAndGet();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)("withheld concurrency --> " + w), (Object[])new Object[0]);
                    }
                    if (this.maxConcurrencyConstraint.tryAcquire()) {
                        this.decrementWithheldConcurrency();
                        if (this.acquireCoreConcurrency() > 0) {
                            this.expediteGlobal(new PollingTask());
                        } else {
                            this.enqueueGlobal(new PollingTask());
                        }
                    }
                    if (this.state.get() != State.ACTIVE && this.queue.remove(policyTaskFuture)) {
                        throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1202.submit.after.shutdown", (Object[])new Object[]{this.identifier}));
                    }
                    break block20;
                }
                if (this.state.get() == State.ACTIVE) {
                    PolicyExecutor.QueueFullAction action;
                    PolicyExecutor.QueueFullAction queueFullAction = action = Boolean.TRUE.equals(callerRunsOverride) ? PolicyExecutor.QueueFullAction.CallerRuns : this.queueFullAction.get();
                    if (Boolean.FALSE.equals(callerRunsOverride) && (action == PolicyExecutor.QueueFullAction.CallerRuns || action == PolicyExecutor.QueueFullAction.CallerRunsIfSameExecutor)) {
                        action = PolicyExecutor.QueueFullAction.Abort;
                    }
                    if (action == PolicyExecutor.QueueFullAction.Abort) {
                        throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1201.queue.full.abort", (Object[])new Object[]{this.identifier, this.maxQueueSize, wait}));
                    }
                    if (action == PolicyExecutor.QueueFullAction.CallerRuns) {
                        Throwable x = this.runTask(policyTaskFuture);
                        if (x instanceof InterruptedException) {
                            throw (InterruptedException)x;
                        }
                        break block20;
                    }
                    throw new UnsupportedOperationException("queueFullAction=" + (Object)((Object)action));
                }
                throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1202.submit.after.shutdown", (Object[])new Object[]{this.identifier}));
            }
            catch (InterruptedException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"enqueue", (Object[])new Object[]{x});
                }
                throw new RejectedExecutionException(x);
            }
            catch (RejectedExecutionException x) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"enqueue", (Object[])new Object[]{x});
                }
                throw x;
            }
            catch (RuntimeException x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.threading.internal.PolicyExecutorImpl", (String)"470", (Object)this, (Object[])new Object[]{policyTaskFuture, wait, callerRunsOverride});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"enqueue", (Object[])new Object[]{x});
                }
                throw x;
            }
            catch (Error x) {
                FFDCFilter.processException((Throwable)x, (String)"com.ibm.ws.threading.internal.PolicyExecutorImpl", (String)"474", (Object)this, (Object[])new Object[]{policyTaskFuture, wait, callerRunsOverride});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"enqueue", (Object[])new Object[]{x});
                }
                throw x;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void enqueueGlobal(PollingTask pollingTask) {
        pollingTask.expedite = false;
        boolean submitted = false;
        try {
            this.globalExecutor.executeWithoutInterceptors(pollingTask);
            return;
        }
        catch (Throwable throwable) {
            if (submitted) throw throwable;
            this.maxConcurrencyConstraint.release();
            if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) throw throwable;
            Tr.debug((Object)this, (TraceComponent)tc, (String)"core/maxConcurrency available", (Object[])new Object[]{this.coreConcurrencyAvailable, this.maxConcurrencyConstraint.availablePermits()});
            throw throwable;
        }
    }

    @Override
    public void execute(Runnable command) {
        this.enqueue(new PolicyTaskFuture(command, null), this.maxWaitForEnqueueNS.get(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expediteGlobal(PollingTask pollingTask) {
        block5: {
            int cca;
            pollingTask.expedite = true;
            boolean submitted = false;
            try {
                this.globalExecutor.executeWithoutInterceptors(pollingTask);
                submitted = true;
                if (submitted) break block5;
                cca = this.coreConcurrencyAvailable.incrementAndGet();
            }
            catch (Throwable throwable) {
                if (!submitted) {
                    int cca2 = this.coreConcurrencyAvailable.incrementAndGet();
                    this.maxConcurrencyConstraint.release();
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"core/maxConcurrency available", (Object[])new Object[]{cca2, this.maxConcurrencyConstraint.availablePermits()});
                    }
                }
                throw throwable;
            }
            this.maxConcurrencyConstraint.release();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"core/maxConcurrency available", (Object[])new Object[]{cca, this.maxConcurrencyConstraint.availablePermits()});
            }
        }
    }

    @Override
    @FFDCIgnore(value={CancellationException.class, ExecutionException.class, RejectedExecutionException.class})
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        ArrayList<Future<T>> futures;
        int taskCount;
        block35: {
            boolean useCurrentThread;
            boolean trace = TraceComponent.isAnyTracingEnabled();
            for (Callable<T> task : tasks) {
                if (task != null) continue;
                throw new NullPointerException();
            }
            taskCount = tasks.size();
            boolean bl = useCurrentThread = this.queueFullAction.get() == PolicyExecutor.QueueFullAction.CallerRuns;
            boolean havePermit = !useCurrentThread && (useCurrentThread = taskCount > 0 && this.maxConcurrencyConstraint.tryAcquire());
            futures = new ArrayList<Future<T>>(taskCount);
            try {
                int t = 0;
                int n = useCurrentThread ? taskCount - 1 : taskCount;
                for (Callable<T> callable : tasks) {
                    PolicyTaskFuture taskFuture = new PolicyTaskFuture(callable);
                    if (t++ < n) {
                        if (useCurrentThread) {
                            this.enqueue(taskFuture, 0L, true);
                        } else {
                            this.enqueue(taskFuture, this.maxWaitForEnqueueNS.get(), null);
                        }
                    }
                    futures.add(taskFuture);
                }
                if (useCurrentThread) {
                    for (t = n; t >= 0; --t) {
                        Throwable x;
                        PolicyTaskFuture taskFuture = (PolicyTaskFuture)futures.get(t);
                        State state = this.state.get();
                        if (t == n) {
                            if (state != State.ACTIVE) {
                                throw new RejectedExecutionException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1202.submit.after.shutdown", (Object[])new Object[]{this.identifier}));
                            }
                        } else if (!taskFuture.isDone() && (state == State.ACTIVE || state == State.ENQUEUE_STOPPING || state == State.ENQUEUE_STOPPED) && this.queue.remove(taskFuture)) {
                            this.maxQueueSizeConstraint.release();
                        } else {
                            if (!trace || !tc.isDebugEnabled()) continue;
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"no longer in queue", (Object[])new Object[]{taskFuture});
                            continue;
                        }
                        if (!((x = this.runTask(taskFuture)) instanceof InterruptedException)) continue;
                        throw (InterruptedException)x;
                    }
                }
                for (Future future : futures) {
                    try {
                        future.get();
                        --taskCount;
                    }
                    catch (CancellationException x) {
                        if (!trace || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"task is canceled", (Object[])new Object[]{x});
                    }
                    catch (ExecutionException x) {
                        if (!trace || !tc.isDebugEnabled()) continue;
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"task completed exceptionally", (Object[])new Object[]{x});
                    }
                }
                if (!havePermit) break block35;
            }
            catch (RejectedExecutionException x) {
                try {
                    if (trace && tc.isDebugEnabled()) {
                        Tr.debug((Object)this, (TraceComponent)tc, (String)"rejected", (Object[])new Object[]{x});
                    }
                    if (x.getCause() instanceof InterruptedException) {
                        throw (InterruptedException)x.getCause();
                    }
                    throw x;
                }
                catch (Throwable throwable) {
                    if (havePermit) {
                        this.maxConcurrencyConstraint.release();
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"core/maxConcurrency available", (Object[])new Object[]{this.coreConcurrencyAvailable, this.maxConcurrencyConstraint.availablePermits()});
                        }
                        if (!this.queue.isEmpty() && this.withheldConcurrency.get() > 0 && this.maxConcurrencyConstraint.tryAcquire()) {
                            this.decrementWithheldConcurrency();
                            if (this.acquireCoreConcurrency() > 0) {
                                this.expediteGlobal(new PollingTask());
                            } else {
                                this.enqueueGlobal(new PollingTask());
                            }
                        }
                    }
                    if (taskCount != 0) {
                        for (Future future : futures) {
                            future.cancel(true);
                        }
                    }
                    throw throwable;
                }
            }
            this.maxConcurrencyConstraint.release();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"core/maxConcurrency available", (Object[])new Object[]{this.coreConcurrencyAvailable, this.maxConcurrencyConstraint.availablePermits()});
            }
            if (!this.queue.isEmpty() && this.withheldConcurrency.get() > 0 && this.maxConcurrencyConstraint.tryAcquire()) {
                this.decrementWithheldConcurrency();
                if (this.acquireCoreConcurrency() > 0) {
                    this.expediteGlobal(new PollingTask());
                } else {
                    this.enqueueGlobal(new PollingTask());
                }
            }
        }
        if (taskCount != 0) {
            for (Future future : futures) {
                future.cancel(true);
            }
        }
        return futures;
    }

    @Override
    @FFDCIgnore(value={CancellationException.class, ExecutionException.class, RejectedExecutionException.class, TimeoutException.class})
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        int taskCount = tasks.size();
        long stop = System.nanoTime() + unit.toNanos(timeout);
        for (Callable<T> callable : tasks) {
            if (callable != null) continue;
            throw new NullPointerException();
        }
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(taskCount);
        try {
            for (Callable<T> callable : tasks) {
                PolicyTaskFuture taskFuture = new PolicyTaskFuture(callable);
                long remaining = stop - System.nanoTime();
                if (remaining <= 0L) {
                    throw new RejectedExecutionException("timed out before all tasks could be submitted");
                }
                long qWait = this.maxWaitForEnqueueNS.get();
                this.enqueue(taskFuture, qWait < remaining ? qWait : remaining, false);
                futures.add(taskFuture);
            }
            for (Future future : futures) {
                try {
                    future.get(stop - System.nanoTime(), TimeUnit.NANOSECONDS);
                    --taskCount;
                }
                catch (CancellationException x) {
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"task is canceled", (Object[])new Object[]{x});
                }
                catch (ExecutionException x) {
                    if (!trace || !tc.isDebugEnabled()) continue;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"task completed exceptionally", (Object[])new Object[]{x});
                }
                catch (TimeoutException x) {
                    break;
                }
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            if (trace && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"rejected", (Object[])new Object[]{rejectedExecutionException});
            }
            if (rejectedExecutionException.getCause() instanceof InterruptedException) {
                throw (InterruptedException)rejectedExecutionException.getCause();
            }
            throw rejectedExecutionException;
        }
        finally {
            if (taskCount != 0) {
                for (Future future : futures) {
                    future.cancel(true);
                }
            }
        }
        return futures;
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        if (this.providerCreated == null) {
            throw new UnsupportedOperationException();
        }
        return this.state.get() != State.ACTIVE;
    }

    @Override
    public boolean isTerminated() {
        if (this.providerCreated == null) {
            throw new UnsupportedOperationException();
        }
        State currentState = this.state.get();
        switch (currentState) {
            case TERMINATED: {
                return true;
            }
            case TASKS_CANCELING: 
            case ENQUEUE_STOPPED: 
            case TASKS_CANCELED: {
                if (this.queue.isEmpty() && this.maxConcurrencyConstraint.tryAcquire(this.maxConcurrency)) {
                    State previous = this.state.getAndSet(State.TERMINATED);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)("state: " + (Object)((Object)previous) + " --> TERMINATED"), (Object[])new Object[0]);
                    }
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PolicyExecutor maxConcurrency(int max) {
        if (this.providerCreated == null) {
            throw new UnsupportedOperationException();
        }
        if (max == -1) {
            max = Integer.MAX_VALUE;
        } else if (max < 1) {
            throw new IllegalArgumentException(Integer.toString(max));
        }
        Integer n = this.configLock;
        synchronized (n) {
            if (max < this.coreConcurrency) {
                throw new IllegalArgumentException(Integer.toString(max));
            }
            if (this.state.get() != State.ACTIVE) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1203.config.update.after.shutdown", (Object[])new Object[]{"maxConcurrency", this.identifier}));
            }
            int increase = max - this.maxConcurrency;
            if (increase > 0) {
                this.maxConcurrencyConstraint.release(increase);
            } else if (increase < 0) {
                this.maxConcurrencyConstraint.reducePermits(-increase);
            }
            this.maxConcurrency = max;
        }
        while (this.withheldConcurrency.get() > 0 && this.maxConcurrencyConstraint.tryAcquire()) {
            this.decrementWithheldConcurrency();
            this.enqueueGlobal(new PollingTask());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PolicyExecutor maxQueueSize(int max) {
        if (this.providerCreated == null) {
            throw new UnsupportedOperationException();
        }
        if (max == -1) {
            max = Integer.MAX_VALUE;
        } else if (max < 1) {
            throw new IllegalArgumentException(Integer.toString(max));
        }
        Integer n = this.configLock;
        synchronized (n) {
            if (this.state.get() != State.ACTIVE) {
                throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1203.config.update.after.shutdown", (Object[])new Object[]{"maxQueueSize", this.identifier}));
            }
            int increase = max - this.maxQueueSize;
            if (increase > 0) {
                this.maxQueueSizeConstraint.release(increase);
            } else if (increase < 0) {
                this.maxQueueSizeConstraint.reducePermits(-increase);
            }
            this.maxQueueSize = max;
        }
        return this;
    }

    @Override
    public PolicyExecutor maxWaitForEnqueue(long ms) {
        if (this.providerCreated == null) {
            throw new UnsupportedOperationException();
        }
        if (ms < 0L) {
            throw new IllegalArgumentException(Long.toString(ms));
        }
        long current = this.maxWaitForEnqueueNS.get();
        while (current != -1L) {
            if (this.maxWaitForEnqueueNS.compareAndSet(current, TimeUnit.MILLISECONDS.toNanos(ms))) {
                return this;
            }
            current = this.maxWaitForEnqueueNS.get();
        }
        throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1203.config.update.after.shutdown", (Object[])new Object[]{"maxWaitForEnqueue", this.identifier}));
    }

    @Override
    public PolicyExecutor queueFullAction(PolicyExecutor.QueueFullAction action) {
        if (this.providerCreated == null) {
            throw new UnsupportedOperationException();
        }
        if (this.state.get() != State.ACTIVE) {
            throw new IllegalStateException(Tr.formatMessage((TraceComponent)tc, (String)"CWWKE1203.config.update.after.shutdown", (Object[])new Object[]{"queueFullAction", this.identifier}));
        }
        this.queueFullAction.set(action);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Trivial
    @ManualTrace
    Throwable runTask(PolicyTaskFuture<?> future) {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"runTask", (Object[])new Object[]{future});
        }
        Throwable failure = null;
        try {
            State currentState;
            if (this.providerCreated != null) {
                this.running.add(future);
            }
            if ((currentState = this.state.get()) == State.ACTIVE || currentState == State.ENQUEUE_STOPPING || currentState == State.ENQUEUE_STOPPED) {
                ((PolicyTaskFuture)future).futureTask.run();
            } else {
                if (trace && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)("Cancel task due to policy executor state " + (Object)((Object)currentState)), (Object[])new Object[0]);
                }
                future.cancel(false);
            }
        }
        catch (Throwable currentState) {
            void x;
            FFDCFilter.processException((Throwable)currentState, (String)"com.ibm.ws.threading.internal.PolicyExecutorImpl", (String)"849", (Object)this, (Object[])new Object[]{future});
            failure = x;
        }
        finally {
            if (this.providerCreated != null) {
                this.running.remove(future);
            }
        }
        if (trace && tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"runTask", failure);
        }
        return failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void shutdown() {
        if (this.providerCreated == null) {
            throw new UnsupportedOperationException();
        }
        if (this.state.compareAndSet(State.ACTIVE, State.ENQUEUE_STOPPING)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"state: ACTIVE --> ENQUEUE_STOPPING", (Object[])new Object[0]);
            }
            this.maxWaitForEnqueueNS.set(-1L);
            Integer n = this.configLock;
            synchronized (n) {
                this.maxQueueSize = 0;
                this.maxQueueSizeConstraint.drainPermits();
                this.maxQueueSizeConstraint.reducePermits(Integer.MAX_VALUE);
            }
            if (this.state.compareAndSet(State.ENQUEUE_STOPPING, State.ENQUEUE_STOPPED) && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"state: ENQUEUE_STOPPING --> ENQUEUE_STOPPED", (Object[])new Object[0]);
            }
            this.shutdownLatch.countDown();
            this.providerCreated.remove(this.identifier);
        } else {
            while (this.state.get() == State.ENQUEUE_STOPPING) {
                try {
                    this.shutdownLatch.await();
                }
                catch (InterruptedException interruptedException) {
                    void x;
                    FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.threading.internal.PolicyExecutorImpl", (String)"890", (Object)this, (Object[])new Object[0]);
                    throw new RuntimeException((Throwable)x);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Runnable> shutdownNow() {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        this.shutdown();
        LinkedList<Runnable> queuedTasks = new LinkedList<Runnable>();
        if (this.state.compareAndSet(State.ENQUEUE_STOPPED, State.TASKS_CANCELING)) {
            if (trace && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"state: ENQUEUE_STOPPED --> TASKS_CANCELING", (Object[])new Object[0]);
            }
            PolicyTaskFuture<?> f = this.queue.poll();
            while (f != null) {
                if (f.cancel(false)) {
                    if (((PolicyTaskFuture)f).task instanceof Runnable) {
                        queuedTasks.add((Runnable)((PolicyTaskFuture)f).task);
                    } else {
                        queuedTasks.add(new RunnableFromCallable((Callable)((PolicyTaskFuture)f).task));
                    }
                }
                f = this.queue.poll();
            }
            Iterator<PolicyTaskFuture<?>> it = this.running.iterator();
            while (it.hasNext()) {
                it.next().cancel(true);
            }
            if (this.state.compareAndSet(State.TASKS_CANCELING, State.TASKS_CANCELED) && trace && tc.isEventEnabled()) {
                Tr.event((Object)this, (TraceComponent)tc, (String)"state: TASKS_CANCELING --> TASKS_CANCELED", (Object[])new Object[0]);
            }
            this.shutdownNowLatch.countDown();
        } else {
            while (this.state.get() == State.TASKS_CANCELING) {
                try {
                    this.shutdownNowLatch.await();
                }
                catch (InterruptedException it) {
                    void x;
                    FFDCFilter.processException((Throwable)it, (String)"com.ibm.ws.threading.internal.PolicyExecutorImpl", (String)"935", (Object)this, (Object[])new Object[0]);
                    throw new RuntimeException((Throwable)x);
                }
            }
        }
        return queuedTasks;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        PolicyTaskFuture policyTaskFuture = new PolicyTaskFuture(task);
        this.enqueue(policyTaskFuture, this.maxWaitForEnqueueNS.get(), null);
        return policyTaskFuture;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        PolicyTaskFuture policyTaskFuture = new PolicyTaskFuture(task, result);
        this.enqueue(policyTaskFuture, this.maxWaitForEnqueueNS.get(), null);
        return policyTaskFuture;
    }

    @Override
    public Future<?> submit(Runnable task) {
        PolicyTaskFuture policyTaskFuture = new PolicyTaskFuture(task, null);
        this.enqueue(policyTaskFuture, this.maxWaitForEnqueueNS.get(), null);
        return policyTaskFuture;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private static class RunnableFromCallable
    implements Runnable {
        private final Callable<?> callable;
        static final long serialVersionUID = -5567018484392606170L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private RunnableFromCallable(Callable<?> callable) {
            this.callable = callable;
        }

        @Override
        @FFDCIgnore(value={Exception.class, RuntimeException.class})
        public void run() {
            try {
                this.callable.call();
            }
            catch (RuntimeException x) {
                throw x;
            }
            catch (Exception x) {
                throw new RuntimeException(x);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(RunnableFromCallable.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class PollingTask
    implements QueueItem,
    Runnable {
        private boolean expedite;
        static final long serialVersionUID = 866473790635698049L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private PollingTask() {
        }

        @Override
        public boolean isExpedited() {
            return this.expedite;
        }

        @Override
        public void run() {
            boolean canRun;
            PolicyTaskFuture next;
            do {
                State currentState;
                canRun = (currentState = (State)((Object)PolicyExecutorImpl.this.state.get())) == State.ACTIVE || currentState == State.ENQUEUE_STOPPING || currentState == State.ENQUEUE_STOPPED;
                PolicyTaskFuture policyTaskFuture = next = canRun ? (PolicyTaskFuture)PolicyExecutorImpl.this.queue.poll() : null;
                if (next == null) break;
                PolicyExecutorImpl.this.maxQueueSizeConstraint.release();
            } while (next.isCancelled());
            if (next != null) {
                PolicyExecutorImpl.this.runTask(next);
            }
            if (this.expedite) {
                PolicyExecutorImpl.this.coreConcurrencyAvailable.incrementAndGet();
            }
            PolicyExecutorImpl.this.maxConcurrencyConstraint.release();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)PolicyExecutorImpl.this, (TraceComponent)tc, (String)"core/maxConcurrency available", (Object[])new Object[]{PolicyExecutorImpl.this.coreConcurrencyAvailable, PolicyExecutorImpl.this.maxConcurrencyConstraint.availablePermits(), canRun});
            }
            if (canRun && PolicyExecutorImpl.this.withheldConcurrency.get() > 0 && PolicyExecutorImpl.this.maxConcurrencyConstraint.tryAcquire()) {
                PolicyExecutorImpl.this.decrementWithheldConcurrency();
                if (PolicyExecutorImpl.this.acquireCoreConcurrency() > 0) {
                    PolicyExecutorImpl.this.expediteGlobal(this);
                } else {
                    PolicyExecutorImpl.this.enqueueGlobal(this);
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PollingTask.class);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class PolicyTaskFuture<T>
    implements Future<T> {
        private final FutureTask<T> futureTask;
        private final Object task;
        static final long serialVersionUID = 4654868613619820170L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private PolicyTaskFuture(Callable<T> task) {
            this.futureTask = new FutureTask<T>(PolicyExecutorImpl.this.globalExecutor.wrap(task));
            this.task = task;
        }

        private PolicyTaskFuture(Runnable task, T result) {
            this.futureTask = new FutureTask<T>(PolicyExecutorImpl.this.globalExecutor.wrap(task), result);
            this.task = task;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            boolean canceled = this.futureTask.cancel(mayInterruptIfRunning);
            if (canceled && PolicyExecutorImpl.this.queue.remove(this)) {
                PolicyExecutorImpl.this.maxQueueSizeConstraint.release();
            }
            return canceled;
        }

        @Override
        public T get() throws ExecutionException, InterruptedException {
            return this.futureTask.get();
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
            return this.futureTask.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return this.futureTask.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.futureTask.isDone();
        }

        @Trivial
        public String toString() {
            return "PolicyTaskFuture@" + Integer.toHexString(this.hashCode()) + " for " + this.task + " on " + PolicyExecutorImpl.this.identifier;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(PolicyTaskFuture.class);
        }
    }

    @Trivial
    private static enum State {
        ACTIVE,
        ENQUEUE_STOPPING,
        ENQUEUE_STOPPED,
        TASKS_CANCELING,
        TASKS_CANCELED,
        TERMINATED;

    }
}

