/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.common.internal.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.util.ByteArray;
import com.ibm.ws.webcontainer.security.SSOCookieHelper;
import com.ibm.ws.webcontainer.security.WebAppSecurityConfig;
import com.ibm.ws.webcontainer.security.internal.StringUtil;
import com.ibm.wsspi.security.token.SingleSignonToken;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SSOCookieHelperImpl
implements SSOCookieHelper {
    private static final TraceComponent tc = Tr.register(SSOCookieHelperImpl.class);
    protected static final ConcurrentMap<ByteArray, String> cookieByteStringCache = new ConcurrentHashMap<ByteArray, String>(20);
    private static int MAX_COOKIE_STRING_ENTRIES = 100;
    private String cookieName = null;
    private final WebAppSecurityConfig config;
    static final long serialVersionUID = 1094383513590032677L;

    public SSOCookieHelperImpl(WebAppSecurityConfig config) {
        this(config, null);
    }

    public SSOCookieHelperImpl(WebAppSecurityConfig config, String ssoCookieName) {
        this.config = config;
        this.cookieName = ssoCookieName;
    }

    @Override
    public void addSSOCookiesToResponse(Subject subject, HttpServletRequest req, HttpServletResponse resp) {
        if (!this.allowToAddCookieToResponse(req)) {
            return;
        }
        SingleSignonToken ssoToken = this.getDefaultSSOTokenFromSubject(subject);
        if (ssoToken == null) {
            return;
        }
        byte[] ssoTokenBytes = ssoToken.getBytes();
        if (ssoTokenBytes == null) {
            return;
        }
        ByteArray cookieBytes = new ByteArray(ssoTokenBytes);
        String cookieByteString = (String)cookieByteStringCache.get(cookieBytes);
        if (cookieByteString == null) {
            cookieByteString = StringUtil.toString(Base64Coder.base64Encode((byte[])ssoTokenBytes));
            this.updateCookieCache(cookieBytes, cookieByteString);
        }
        Cookie ssoCookie = this.createCookie(req, cookieByteString);
        resp.addCookie(ssoCookie);
    }

    public Cookie createCookie(HttpServletRequest req, String cookieValue) {
        Cookie ssoCookie = new Cookie(this.getSSOCookiename(), cookieValue);
        ssoCookie.setMaxAge(-1);
        ssoCookie.setPath("/");
        ssoCookie.setSecure(this.config.getSSORequiresSSL());
        ssoCookie.setHttpOnly(this.config.getHttpOnlyCookies());
        String domainName = this.getSSODomainName(req, this.config.getSSODomainList(), this.config.getSSOUseDomainFromURL());
        if (domainName != null) {
            ssoCookie.setDomain(domainName);
        }
        return ssoCookie;
    }

    @Override
    public boolean allowToAddCookieToResponse(HttpServletRequest req) {
        if (!this.config.isSingleSignonEnabled()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSO is not enabled. Not setting the SSO Cookie", (Object[])new Object[0]);
            }
            return false;
        }
        boolean secureRequest = req.isSecure();
        if (this.config.getSSORequiresSSL() && !secureRequest) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"SSO requires SSL. The cookie will not be sent back because the request is not over https.", (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    @Override
    public void removeSSOCookieFromResponse(HttpServletResponse resp) {
        ((IExtendedResponse)resp).removeCookie(this.getSSOCookiename());
    }

    protected synchronized void updateCookieCache(ByteArray cookieBytes, String cookieByteString) {
        if (cookieByteStringCache.size() > MAX_COOKIE_STRING_ENTRIES) {
            cookieByteStringCache.clear();
        }
        if (cookieByteString != null) {
            cookieByteStringCache.put(cookieBytes, cookieByteString);
        }
    }

    @Override
    public void createLogoutCookies(HttpServletRequest req, HttpServletResponse res) {
        Cookie[] cookies = req.getCookies();
        ArrayList<Cookie> logoutCookieList = new ArrayList<Cookie>();
        if (cookies != null) {
            String ssoCookieName = this.resolveCookieName(cookies);
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equalsIgnoreCase(ssoCookieName)) continue;
                cookies[i].setValue(null);
                this.addLogoutCookieToList(req, ssoCookieName, logoutCookieList);
            }
            for (Cookie cookie : logoutCookieList) {
                res.addCookie(cookie);
            }
        }
    }

    protected String resolveCookieName(Cookie[] cookies) {
        boolean foundCookie = false;
        String ssoCookieName = this.getSSOCookiename();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equalsIgnoreCase(ssoCookieName)) continue;
                foundCookie = true;
                break;
            }
        }
        if (!foundCookie && !this.config.isUseOnlyCustomCookieName()) {
            return "LtpaToken2";
        }
        return ssoCookieName;
    }

    protected void addLogoutCookieToList(HttpServletRequest req, String cookieName, ArrayList<Cookie> cookieList) {
        String domainName;
        Cookie c = new Cookie(cookieName, "");
        c.setMaxAge(0);
        c.setPath("/");
        c.setSecure(req.isSecure());
        if (this.config.getHttpOnlyCookies()) {
            c.setHttpOnly(true);
        }
        if ((domainName = this.getSSODomainName(req, this.config.getSSODomainList(), this.config.getSSOUseDomainFromURL())) != null) {
            c.setDomain(domainName);
        }
        cookieList.add(c);
    }

    @Override
    public SingleSignonToken getDefaultSSOTokenFromSubject(final Subject subject) {
        if (subject == null) {
            return null;
        }
        SingleSignonToken ssoToken = null;
        Set privateCredentials = null;
        try {
            privateCredentials = (Set)AccessController.doPrivileged(new PrivilegedAction(){
                static final long serialVersionUID = -7306312076967563729L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Object run() {
                    return subject.getPrivateCredentials(SingleSignonToken.class);
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register(1.class);
                }
            });
            Iterator ssoIterator = privateCredentials.iterator();
            while (ssoIterator.hasNext() && !(ssoToken = (SingleSignonToken)ssoIterator.next()).getName().equals(this.getSSOCookiename())) {
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.webcontainer.security.SSOCookieHelperImpl", (String)"255", (Object)this, (Object[])new Object[]{subject});
        }
        return ssoToken;
    }

    @Override
    public String getSSOCookiename() {
        if (this.cookieName != null) {
            return this.cookieName;
        }
        return this.config.getSSOCookieName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getSSODomainName(HttpServletRequest req, List<String> ssoDomainList, boolean useDomainFromURL) {
        block7: {
            try {
                final String host = this.getHostNameFromRequestURL(req);
                String ipAddr = AccessController.doPrivileged(new PrivilegedAction<String>(){
                    static final long serialVersionUID = -6311881630860690631L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public String run() {
                        return SSOCookieHelperImpl.this.getHostIPAddr(host);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register(2.class);
                    }
                });
                if (host.equals(ipAddr) || host.indexOf(".") == -1) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"URL host is an IP or locahost, no SSO domain will be set.", (Object[])new Object[0]);
                    }
                    return null;
                }
                String domain = host.substring(host.indexOf("."));
                if (ssoDomainList != null && !ssoDomainList.isEmpty()) {
                    for (String dm : ssoDomainList) {
                        if (!domain.endsWith(dm)) continue;
                        return dm;
                    }
                }
                if (useDomainFromURL) {
                    return domain;
                }
            }
            catch (MalformedURLException host) {
                void e;
                FFDCFilter.processException((Throwable)host, (String)"com.ibm.ws.webcontainer.security.SSOCookieHelperImpl", (String)"312", (Object)this, (Object[])new Object[]{req, ssoDomainList, useDomainFromURL});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"Unexpected exception getting request SSO domain", (Object[])new Object[]{e});
            }
        }
        return null;
    }

    @FFDCIgnore(value={UnknownHostException.class})
    private String getHostIPAddr(String host) {
        String iAddr;
        block2: {
            iAddr = "";
            try {
                iAddr = InetAddress.getByName(host).getHostAddress().trim();
            }
            catch (UnknownHostException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)"Exception in getting IP address for URL host, assuming URL host is not an IP", (Object[])new Object[]{e});
            }
        }
        return iAddr;
    }

    private String getHostNameFromRequestURL(HttpServletRequest req) throws MalformedURLException {
        String requestUrl = req.getRequestURL().toString();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("URL: " + requestUrl), (Object[])new Object[0]);
        }
        URL url = new URL(requestUrl);
        String host = url.getHost().trim();
        return host;
    }
}

