/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.security.metadata;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.annotations.FragmentAnnotations;
import com.ibm.ws.container.service.annotations.WebAnnotations;
import com.ibm.ws.container.service.config.ServletConfigurator;
import com.ibm.ws.container.service.config.ServletConfiguratorHelper;
import com.ibm.ws.container.service.config.WebFragmentInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.common.EnvEntry;
import com.ibm.ws.javaee.dd.common.RunAs;
import com.ibm.ws.javaee.dd.common.SecurityRole;
import com.ibm.ws.javaee.dd.common.SecurityRoleRef;
import com.ibm.ws.javaee.dd.web.WebApp;
import com.ibm.ws.javaee.dd.web.WebFragment;
import com.ibm.ws.javaee.dd.web.common.AuthConstraint;
import com.ibm.ws.javaee.dd.web.common.FormLoginConfig;
import com.ibm.ws.javaee.dd.web.common.LoginConfig;
import com.ibm.ws.javaee.dd.web.common.Servlet;
import com.ibm.ws.javaee.dd.web.common.ServletMapping;
import com.ibm.ws.javaee.dd.web.common.UserDataConstraint;
import com.ibm.ws.javaee.dd.webbnd.WebBnd;
import com.ibm.ws.javaee.dd.webext.WebExt;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.mp.jwt.proxy.MpJwtHelper;
import com.ibm.ws.webcontainer.security.metadata.FormLoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.FormLoginConfigurationImpl;
import com.ibm.ws.webcontainer.security.metadata.LoginConfiguration;
import com.ibm.ws.webcontainer.security.metadata.LoginConfigurationImpl;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraint;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraintCollection;
import com.ibm.ws.webcontainer.security.metadata.SecurityConstraintCollectionImpl;
import com.ibm.ws.webcontainer.security.metadata.SecurityMetadata;
import com.ibm.ws.webcontainer.security.metadata.WebResourceCollection;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.AnnotationInfo;
import com.ibm.wsspi.anno.info.AnnotationValue;
import com.ibm.wsspi.anno.info.ClassInfo;
import com.ibm.wsspi.anno.info.InfoStore;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.security.DeclareRoles;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class SecurityServletConfiguratorHelper
implements ServletConfiguratorHelper,
SecurityMetadata {
    public static final String AUTH_METHOD_KEY = "auth-method";
    public static final String FORM_LOGIN_CONFIG_KEY = "form-login-config";
    public static final String REALM_NAME_KEY = "realm-name";
    public static final String LOGIN_CONFIG_KEY = "login-config";
    public static final String RUN_AS_KEY = "run-as";
    public static final String SERVLET_NAME_KEY = "servlet-name";
    public static final String SERVLET_KEY = "servlet";
    public static final String SECURITY_CONSTRAINT_KEY = "security-constraint";
    public static final String AUTH_CONSTRAINT_KEY = "auth-constraint";
    public static final String USER_DATA_CONSTRAINT_KEY = "user-data-constraint";
    public static final String DENY_UNCOVERED_HTTP_METHODS_KEY = "deny-uncovered-http-methods";
    protected static final String SYNC_TO_OS_THREAD_ENV_ENTRY_KEY = "com.ibm.websphere.security.SyncToOSThread";
    private static final TraceComponent tc = Tr.register(SecurityServletConfiguratorHelper.class);
    private ServletConfigurator configurator;
    private static final String ALL_ROLES_MARKER = "*";
    private SecurityConstraintCollection securityConstraintCollection;
    protected LoginConfiguration loginConfiguration;
    private List<String> allRoles = new ArrayList<String>();
    private final Map<String, Map<String, String>> securityRoleRefsByServlet = new HashMap<String, Map<String, String>>();
    private Map<String, String> urlPatternToServletName = new HashMap<String, String>();
    private final Map<String, String> servletNameToRunAsRole = new HashMap<String, String>();
    private boolean syncToOSThread = false;
    private boolean denyUncoveredHttpMethods = false;
    static final long serialVersionUID = 3937804347548930695L;

    public SecurityServletConfiguratorHelper(ServletConfigurator configurator) {
        this.configurator = configurator;
    }

    public void configureInit() {
    }

    public void configureFromWebApp(WebApp webApp) {
        this.configureSecurity(webApp.getSecurityConstraints(), webApp.getLoginConfig(), webApp.getSecurityRoles(), webApp.getServletMappings(), webApp.getEnvEntries(), webApp.isSetDenyUncoveredHttpMethods());
        if (webApp.isSetDenyUncoveredHttpMethods()) {
            this.setDenyUncoveredHttpMethods(true);
        }
        for (Servlet servlet : webApp.getServlets()) {
            this.processSecurityRoleRefs(servlet.getServletName(), servlet.getSecurityRoleRefs());
            this.processRunAs(servlet);
        }
    }

    public void configureFromWebFragment(WebFragmentInfo webFragmentItem) {
        WebFragment webFragment = webFragmentItem.getWebFragment();
        this.configureSecurity(webFragment.getSecurityConstraints(), webFragment.getLoginConfig(), webFragment.getSecurityRoles(), webFragment.getServletMappings(), webFragment.getEnvEntries(), false);
        for (Servlet servlet : webFragment.getServlets()) {
            this.processSecurityRoleRefs(servlet.getServletName(), servlet.getSecurityRoleRefs());
            this.processRunAs(servlet);
        }
    }

    public void configureFromAnnotations(WebFragmentInfo webFragmentItem) throws UnableToAdaptException {
        WebAnnotations webAnnotations = this.configurator.getWebAnnotations();
        FragmentAnnotations fragmentAnnotations = webAnnotations.getFragmentAnnotations(webFragmentItem);
        this.processSecurityRoles(webAnnotations, fragmentAnnotations.selectAnnotatedClasses(DeclareRoles.class));
        this.configureMpJwt(true);
    }

    public void configureDefaults() throws UnableToAdaptException {
        if (this.loginConfiguration == null) {
            this.loginConfiguration = new LoginConfigurationImpl("BASIC", null, null);
            ((LoginConfigurationImpl)this.loginConfiguration).setAuthenticationMethodDefaulted();
        }
    }

    protected void configureMpJwt(boolean doFeatureCheck) {
        String realmNameString;
        if (doFeatureCheck && !MpJwtHelper.isMpJwtFeatureActive()) {
            return;
        }
        String annoName = "org.eclipse.microprofile.auth.LoginConfig";
        Set annotatedClasses = null;
        InfoStore annosInfo = null;
        try {
            annotatedClasses = this.configurator.getWebAnnotations().getAnnotationTargets().getAnnotatedClasses(annoName);
            annosInfo = this.configurator.getWebAnnotations().getInfoStore();
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.webcontainer.security.metadata.SecurityServletConfiguratorHelper", (String)"165", (Object)this, (Object[])new Object[]{doFeatureCheck});
            return;
        }
        if (annotatedClasses.size() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"no annotated classes found, return", (Object[])new Object[0]);
            }
            return;
        }
        if (this.loginConfiguration != null && !this.loginConfiguration.isAuthenticationMethodDefaulted()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"already have auth method determined, return", (Object[])new Object[0]);
            }
            return;
        }
        String className = (String)annotatedClasses.iterator().next();
        ClassInfo ci = annosInfo.getDelayableClassInfo(className);
        if (!ci.getSuperclassName().equals("javax.ws.rs.core.Application")) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("loginConfig annotation  found, but on wrong class, " + ci.getSuperclassName() + ", return"), (Object[])new Object[0]);
            }
            return;
        }
        AnnotationInfo ai = ci.getAnnotation(annoName);
        AnnotationValue authMethod = ai.getValue("authMethod");
        AnnotationValue realmName = ai.getValue("realmName");
        String authMethodString = authMethod == null ? null : authMethod.getStringValue();
        String string = realmNameString = realmName == null ? null : realmName.getStringValue();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)("setting authMethod and realm to: " + authMethodString + " " + realmNameString), (Object[])new Object[0]);
        }
        this.loginConfiguration = new LoginConfigurationImpl(authMethodString, realmNameString, null);
    }

    public void configureWebBnd(WebBnd webBnd) throws UnableToAdaptException {
    }

    public void configureWebExt(WebExt webExt) throws UnableToAdaptException {
    }

    public void finish() {
        WebModuleMetaData wmmd = (WebModuleMetaData)this.configurator.getFromModuleCache(WebModuleMetaData.class);
        this.configurator = null;
        wmmd.setSecurityMetaData((Object)this);
    }

    private void configureSecurity(List<com.ibm.ws.javaee.dd.web.common.SecurityConstraint> securityConstraints, LoginConfig loginConfig, List<SecurityRole> securityRoles, List<ServletMapping> servletMappings, List<EnvEntry> envEntries, boolean denyUncoveredHttpMethods) {
        this.processSecurityConstraints(securityConstraints, denyUncoveredHttpMethods);
        this.processLoginConfig(loginConfig);
        this.processSecurityRoles(securityRoles);
        this.processURLPatterns(servletMappings);
        this.processEnvEntries(envEntries);
        this.processDenyUncoveredHttpMethods(denyUncoveredHttpMethods);
    }

    private void processDenyUncoveredHttpMethods(boolean denyUncoveredHttpMethods) {
        if (!denyUncoveredHttpMethods) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"deny-uncovered-http-methods element NOT found", (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"deny-uncovered-http-methods element IS found", (Object[])new Object[0]);
        }
    }

    private void processSecurityConstraints(List<com.ibm.ws.javaee.dd.web.common.SecurityConstraint> archiveSecurityConstraints, boolean denyUncoveredHttpMethods) {
        ArrayList<SecurityConstraint> securityConstraints = new ArrayList<SecurityConstraint>();
        for (com.ibm.ws.javaee.dd.web.common.SecurityConstraint archiveSecurityConstraint : archiveSecurityConstraints) {
            SecurityConstraint securityConstraint = this.createSecurityConstraint(archiveSecurityConstraint, denyUncoveredHttpMethods);
            securityConstraints.add(securityConstraint);
        }
        if (this.securityConstraintCollection == null) {
            this.securityConstraintCollection = new SecurityConstraintCollectionImpl(securityConstraints);
        } else {
            this.securityConstraintCollection.addSecurityConstraints(securityConstraints);
        }
    }

    protected void processLoginConfig(LoginConfig loginConfig) {
        boolean authMethodDefaulted = false;
        if (loginConfig != null) {
            String authenticationMethod = loginConfig.getAuthMethod();
            if (authenticationMethod != null) {
                Map authMethodMap = this.configurator.getConfigItemMap(AUTH_METHOD_KEY);
                ServletConfigurator.ConfigItem existingAuthMethod = (ServletConfigurator.ConfigItem)authMethodMap.get(LOGIN_CONFIG_KEY);
                if (existingAuthMethod == null) {
                    authMethodMap.put(LOGIN_CONFIG_KEY, this.configurator.createConfigItem((Object)authenticationMethod));
                } else {
                    this.configurator.validateDuplicateConfiguration(LOGIN_CONFIG_KEY, AUTH_METHOD_KEY, (Object)authenticationMethod, existingAuthMethod);
                }
            } else {
                authenticationMethod = "BASIC";
                authMethodDefaulted = true;
            }
            String realmName = loginConfig.getRealmName();
            if (realmName != null) {
                Map realmNameMap = this.configurator.getConfigItemMap(REALM_NAME_KEY);
                ServletConfigurator.ConfigItem existingRealmName = (ServletConfigurator.ConfigItem)realmNameMap.get(LOGIN_CONFIG_KEY);
                if (existingRealmName == null) {
                    realmNameMap.put(LOGIN_CONFIG_KEY, this.configurator.createConfigItem((Object)realmName));
                } else {
                    this.configurator.validateDuplicateConfiguration(LOGIN_CONFIG_KEY, REALM_NAME_KEY, (Object)realmName, existingRealmName);
                }
            }
            FormLoginConfig formLoginConfig = loginConfig.getFormLoginConfig();
            FormLoginConfiguration formLoginConfiguration = null;
            if (formLoginConfig != null) {
                Map formLoginConfigMap = this.configurator.getConfigItemMap(FORM_LOGIN_CONFIG_KEY);
                ServletConfigurator.ConfigItem existingFormLoginConfig = (ServletConfigurator.ConfigItem)formLoginConfigMap.get(LOGIN_CONFIG_KEY);
                if (existingFormLoginConfig == null) {
                    formLoginConfigMap.put(LOGIN_CONFIG_KEY, this.configurator.createConfigItem((Object)loginConfig.getFormLoginConfig()));
                    formLoginConfiguration = this.createFormLoginConfiguration(loginConfig);
                } else {
                    this.configurator.validateDuplicateConfiguration(LOGIN_CONFIG_KEY, FORM_LOGIN_CONFIG_KEY, (Object)formLoginConfig, existingFormLoginConfig);
                }
            }
            LoginConfigurationImpl lci = new LoginConfigurationImpl(authenticationMethod, realmName, formLoginConfiguration);
            if (authMethodDefaulted) {
                lci.setAuthenticationMethodDefaulted();
            }
            this.loginConfiguration = lci;
        }
    }

    private void processSecurityRoles(List<SecurityRole> securityRoles) {
        for (SecurityRole securityRole : securityRoles) {
            if (this.allRoles.contains(securityRole.getRoleName())) continue;
            this.allRoles.add(securityRole.getRoleName());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("allRoles: " + this.allRoles), (Object[])new Object[0]);
        }
    }

    private void processSecurityRoles(WebAnnotations webAnnotations, Set<String> classesWithSecurityRoles) throws UnableToAdaptException {
        for (String classWithSecurityRole : classesWithSecurityRoles) {
            AnnotationInfo declareRolesAnnotation;
            ClassInfo classInfo = webAnnotations.getClassInfo(classWithSecurityRole);
            String fullyQualifiedClassName = classWithSecurityRole;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"@DeclareRoles found on class ", (Object[])new Object[]{fullyQualifiedClassName});
            }
            if ((declareRolesAnnotation = classInfo.getAnnotation(DeclareRoles.class)) == null) continue;
            AnnotationValue value = declareRolesAnnotation.getValue("value");
            List roleValues = value.getArrayValue();
            for (AnnotationValue roleValue : roleValues) {
                String role = roleValue.getStringValue();
                if (this.allRoles.contains(role)) continue;
                this.allRoles.add(role);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("allRoles: " + this.allRoles), (Object[])new Object[0]);
        }
    }

    private void processURLPatterns(List<ServletMapping> servletMappings) {
        for (ServletMapping servletMapping : servletMappings) {
            String servletName = servletMapping.getServletName();
            List urlPatterns = servletMapping.getURLPatterns();
            if (urlPatterns == null) continue;
            for (String pattern : urlPatterns) {
                this.urlPatternToServletName.put(pattern, servletName);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("urlPatternToServletName: " + this.urlPatternToServletName), (Object[])new Object[0]);
        }
    }

    private void processEnvEntries(List<EnvEntry> envEntries) {
        if (envEntries != null) {
            for (EnvEntry envEntry : envEntries) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"processing envEntry", (Object[])new Object[]{envEntry.getName(), envEntry.getValue()});
                }
                if (!SYNC_TO_OS_THREAD_ENV_ENTRY_KEY.equals(envEntry.getName())) continue;
                this.syncToOSThread = Boolean.parseBoolean(envEntry.getValue());
            }
        }
    }

    private void processSecurityRoleRefs(String servletName, List<SecurityRoleRef> servletSecurityRoleRefs) {
        HashMap<String, String> securityRoleRefs = new HashMap<String, String>();
        this.securityRoleRefsByServlet.put(servletName, securityRoleRefs);
        for (SecurityRoleRef secRoleRef : servletSecurityRoleRefs) {
            if (secRoleRef.getLink() == null) {
                Tr.warning((TraceComponent)tc, (String)"MISSING_SEC_ROLE_REF_ROLE_LINK", (Object[])new Object[]{servletName, secRoleRef.getName()});
                continue;
            }
            if (this.allRoles.contains(secRoleRef.getLink())) {
                securityRoleRefs.put(secRoleRef.getName(), secRoleRef.getLink());
                continue;
            }
            Tr.warning((TraceComponent)tc, (String)"INVALID_SEC_ROLE_REF_ROLE_LINK", (Object[])new Object[]{servletName, secRoleRef.getLink(), secRoleRef.getName()});
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("securityRoleRefsByServlet: " + this.securityRoleRefsByServlet), (Object[])new Object[0]);
        }
    }

    private void processRunAs(Servlet servlet) {
        String roleName;
        String servletName = servlet.getServletName();
        Map runAsMap = this.configurator.getConfigItemMap(RUN_AS_KEY);
        ServletConfigurator.ConfigItem existingRunAs = (ServletConfigurator.ConfigItem)runAsMap.get(servletName);
        RunAs runAs = servlet.getRunAs();
        String string = roleName = runAs != null ? runAs.getRoleName() : null;
        if (runAs != null) {
            if (existingRunAs == null) {
                runAsMap.put(servletName, this.configurator.createConfigItem((Object)roleName));
                if (roleName != null) {
                    this.servletNameToRunAsRole.put(servletName, roleName);
                }
            } else {
                this.configurator.validateDuplicateKeyValueConfiguration(SERVLET_KEY, SERVLET_NAME_KEY, servletName, RUN_AS_KEY, (Object)roleName, existingRunAs);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("servletNameToRunAsRole: " + this.servletNameToRunAsRole), (Object[])new Object[0]);
        }
    }

    private SecurityConstraint createSecurityConstraint(com.ibm.ws.javaee.dd.web.common.SecurityConstraint archiveConstraint, boolean denyUncoveredHttpMethods) {
        List<WebResourceCollection> webResourceCollections = this.createWebResourceCollections(archiveConstraint, denyUncoveredHttpMethods);
        List<String> roles = this.createRoles(archiveConstraint);
        boolean sslRequired = this.isSSLRequired(archiveConstraint);
        boolean accessPrecluded = this.isAccessPrecluded(archiveConstraint);
        boolean fromHttpConstraint = false;
        boolean accessUncovered = false;
        return new SecurityConstraint(webResourceCollections, roles, sslRequired, accessPrecluded, fromHttpConstraint, accessUncovered);
    }

    private List<WebResourceCollection> createWebResourceCollections(com.ibm.ws.javaee.dd.web.common.SecurityConstraint archiveConstraint, boolean denyUncoveredHttpMethods) {
        ArrayList<WebResourceCollection> webResourceCollections = new ArrayList<WebResourceCollection>();
        List archiveWebResourceCollections = archiveConstraint.getWebResourceCollections();
        for (com.ibm.ws.javaee.dd.web.common.WebResourceCollection archiveWebResourceCollection : archiveWebResourceCollections) {
            List urlPatterns = archiveWebResourceCollection.getURLPatterns();
            List methods = archiveWebResourceCollection.getHTTPMethods();
            List omissionMethods = archiveWebResourceCollection.getHTTPMethodOmissions();
            webResourceCollections.add(new WebResourceCollection(urlPatterns, methods, omissionMethods, denyUncoveredHttpMethods));
        }
        return webResourceCollections;
    }

    private List<String> createRoles(com.ibm.ws.javaee.dd.web.common.SecurityConstraint archiveConstraint) {
        List<String> roles = new ArrayList<String>();
        AuthConstraint authConstraint = archiveConstraint.getAuthConstraint();
        if (authConstraint != null) {
            Map authConstraintMap = this.configurator.getConfigItemMap(AUTH_CONSTRAINT_KEY);
            String webResourceName = ((com.ibm.ws.javaee.dd.web.common.WebResourceCollection)archiveConstraint.getWebResourceCollections().get(0)).getWebResourceName();
            ServletConfigurator.ConfigItem existingAuthConstraint = (ServletConfigurator.ConfigItem)authConstraintMap.get(webResourceName);
            roles = authConstraint.getRoleNames();
            if (roles.contains(ALL_ROLES_MARKER)) {
                roles = this.allRoles;
            }
            if (existingAuthConstraint == null) {
                authConstraintMap.put(webResourceName, this.configurator.createConfigItem(roles));
            } else {
                this.configurator.validateDuplicateConfiguration(SECURITY_CONSTRAINT_KEY, AUTH_CONSTRAINT_KEY, roles, existingAuthConstraint);
                if (ServletConfigurator.ConfigSource.WEB_FRAGMENT == this.configurator.getConfigSource() && ServletConfigurator.ConfigSource.WEB_XML == existingAuthConstraint.getSource()) {
                    return new ArrayList<String>();
                }
            }
        }
        return roles;
    }

    private boolean isSSLRequired(com.ibm.ws.javaee.dd.web.common.SecurityConstraint archiveConstraint) {
        boolean sslRequired = false;
        UserDataConstraint dataConstraint = archiveConstraint.getUserDataConstraint();
        if (dataConstraint != null) {
            int transportGuarantee = dataConstraint.getTransportGuarantee();
            String webResourceName = ((com.ibm.ws.javaee.dd.web.common.WebResourceCollection)archiveConstraint.getWebResourceCollections().get(0)).getWebResourceName();
            Map userDataConstraintMap = this.configurator.getConfigItemMap(USER_DATA_CONSTRAINT_KEY);
            ServletConfigurator.ConfigItem existingUserDataConstraint = (ServletConfigurator.ConfigItem)userDataConstraintMap.get(webResourceName);
            if (existingUserDataConstraint == null) {
                userDataConstraintMap.put(webResourceName, this.configurator.createConfigItem((Object)String.valueOf(transportGuarantee)));
                if (transportGuarantee != 0) {
                    sslRequired = true;
                }
            } else {
                this.configurator.validateDuplicateConfiguration(SECURITY_CONSTRAINT_KEY, USER_DATA_CONSTRAINT_KEY, (Object)String.valueOf(transportGuarantee), existingUserDataConstraint);
                if (ServletConfigurator.ConfigSource.WEB_FRAGMENT == this.configurator.getConfigSource() && ServletConfigurator.ConfigSource.WEB_XML == existingUserDataConstraint.getSource()) {
                    return false;
                }
            }
        }
        return sslRequired;
    }

    private boolean isAccessPrecluded(com.ibm.ws.javaee.dd.web.common.SecurityConstraint archiveConstraint) {
        List roles;
        boolean accessPrecluded = false;
        AuthConstraint authConstraint = archiveConstraint.getAuthConstraint();
        if (authConstraint != null && ((roles = authConstraint.getRoleNames()) == null || roles.isEmpty())) {
            accessPrecluded = true;
        }
        return accessPrecluded;
    }

    private FormLoginConfiguration createFormLoginConfiguration(LoginConfig loginConfig) {
        FormLoginConfigurationImpl formLoginConfiguration = null;
        FormLoginConfig formLoginConfig = loginConfig.getFormLoginConfig();
        if (formLoginConfig != null) {
            String loginPage = formLoginConfig.getFormLoginPage();
            String errorPage = formLoginConfig.getFormErrorPage();
            formLoginConfiguration = new FormLoginConfigurationImpl(loginPage, errorPage);
        }
        return formLoginConfiguration;
    }

    @Override
    public SecurityConstraintCollection getSecurityConstraintCollection() {
        return this.securityConstraintCollection;
    }

    @Override
    public LoginConfiguration getLoginConfiguration() {
        return this.loginConfiguration;
    }

    @Override
    public String getSecurityRoleReferenced(String servletName, String roleName) {
        Map<String, String> secRoleRefs = this.securityRoleRefsByServlet.get(servletName);
        if (secRoleRefs == null) {
            if (this.allRoles.contains(roleName)) {
                return roleName;
            }
        } else {
            String roleLink = secRoleRefs.get(roleName);
            if (roleLink == null) {
                if (this.allRoles.contains(roleName)) {
                    return roleName;
                }
            } else {
                return roleLink;
            }
        }
        return null;
    }

    @Override
    public Map<String, String> getRoleRefs(String servletName) {
        Map<String, String> secRoleRefs = this.securityRoleRefsByServlet.get(servletName);
        return secRoleRefs;
    }

    @Override
    public String getRunAsRoleForServlet(String servletName) {
        return this.servletNameToRunAsRole.get(servletName);
    }

    @Override
    public Map<String, String> getRunAsMap() {
        return this.servletNameToRunAsRole;
    }

    @Override
    public List<String> getRoles() {
        return this.allRoles;
    }

    @Override
    public void setSecurityConstraintCollection(SecurityConstraintCollection constraintCollection) {
        this.securityConstraintCollection = constraintCollection;
    }

    @Override
    public void setRoles(List<String> roles) {
        this.allRoles = roles;
    }

    @Override
    public void setLoginConfiguration(LoginConfiguration loginConfiguration) {
        this.loginConfiguration = loginConfiguration;
    }

    @Override
    public void setUrlPatternToServletNameMap(Map<String, String> urlPatternToServletName) {
        this.urlPatternToServletName = urlPatternToServletName;
    }

    @Override
    public boolean isSyncToOSThreadRequested() {
        return this.syncToOSThread;
    }

    @Override
    public void setDenyUncoveredHttpMethods(boolean denyUncoveredHttpMethodsValue) {
        this.denyUncoveredHttpMethods = denyUncoveredHttpMethodsValue;
    }

    @Override
    public boolean isDenyUncoveredHttpMethods() {
        return this.denyUncoveredHttpMethods;
    }
}

