/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.internal.osgi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TrConfigurator;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.logging.WsLogHandler;
import com.ibm.ws.logging.internal.osgi.MessageRouterConfigListenerImpl;
import com.ibm.ws.logging.internal.osgi.WsMessageRouterImpl;
import com.ibm.wsspi.logging.LogHandler;
import com.ibm.wsspi.logging.MessageRouter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class MessageRouterConfigurator
implements BundleListener {
    private final TraceComponent tc = Tr.register(this.getClass(), null, (String)"com.ibm.ws.logging.internal.resources.LoggingMessages");
    private BundleContext bundleContext = null;
    private WsMessageRouterImpl msgRouter = null;
    private final HashMap<String, ArrayList<String>> previousHandlerMessageMap = new HashMap();
    private MessageRouterConfigListenerImpl configListener = new MessageRouterConfigListenerImpl(this);
    private final ServiceListener logHandlerListener = new ServiceListener(){

        public void serviceChanged(ServiceEvent event) {
            switch (event.getType()) {
                case 1: {
                    MessageRouterConfigurator.this.setLogHandler((ServiceReference<LogHandler>)event.getServiceReference());
                    break;
                }
                case 4: {
                    MessageRouterConfigurator.this.unsetLogHandler((ServiceReference<LogHandler>)event.getServiceReference());
                    break;
                }
            }
        }
    };
    private final ServiceListener wsLogHandlerListener = new ServiceListener(){

        public void serviceChanged(ServiceEvent event) {
            switch (event.getType()) {
                case 1: {
                    MessageRouterConfigurator.this.setWsLogHandler((ServiceReference<WsLogHandler>)event.getServiceReference());
                    break;
                }
                case 4: {
                    MessageRouterConfigurator.this.unsetWsLogHandler((ServiceReference<WsLogHandler>)event.getServiceReference());
                    break;
                }
            }
        }
    };

    public MessageRouterConfigurator(BundleContext context) {
        this.bundleContext = context;
        try {
            this.bundleContext.addServiceListener(this.logHandlerListener, "(objectClass=com.ibm.wsspi.logging.LogHandler)");
            this.bundleContext.addServiceListener(this.wsLogHandlerListener, "(objectClass=com.ibm.ws.logging.WsLogHandler)");
            this.processInitialLogHandlerServices();
            this.processInitialWsLogHandlerServices();
        }
        catch (InvalidSyntaxException ise) {
            throw new RuntimeException(ise);
        }
        this.configListener = this.configListener.register(this.bundleContext);
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 1: {
                this.processBundle(event.getBundle());
                break;
            }
        }
    }

    protected void setLogHandler(ServiceReference<LogHandler> ref) {
        this.getMessageRouter().setLogHandler((String)ref.getProperty("id"), (LogHandler)this.bundleContext.getService(ref));
    }

    protected void unsetLogHandler(ServiceReference<LogHandler> ref) {
        this.getMessageRouter().unsetLogHandler((String)ref.getProperty("id"), (LogHandler)this.bundleContext.getService(ref));
    }

    protected void setWsLogHandler(ServiceReference<WsLogHandler> ref) {
        this.getMessageRouter().setWsLogHandler((String)ref.getProperty("id"), (WsLogHandler)this.bundleContext.getService(ref));
    }

    protected void unsetWsLogHandler(ServiceReference<WsLogHandler> ref) {
        this.getMessageRouter().unsetWsLogHandler((String)ref.getProperty("id"), (WsLogHandler)this.bundleContext.getService(ref));
    }

    protected void processInitialLogHandlerServices() throws InvalidSyntaxException {
        ServiceReference[] servRefs = this.bundleContext.getServiceReferences(LogHandler.class.getName(), null);
        if (servRefs != null) {
            for (ServiceReference servRef : servRefs) {
                this.setLogHandler((ServiceReference<LogHandler>)servRef);
            }
        }
    }

    protected void processInitialWsLogHandlerServices() throws InvalidSyntaxException {
        ServiceReference[] servRefs = this.bundleContext.getServiceReferences(WsLogHandler.class.getName(), null);
        if (servRefs != null) {
            for (ServiceReference servRef : servRefs) {
                this.setWsLogHandler((ServiceReference<WsLogHandler>)servRef);
            }
        }
    }

    protected void processInitialBundles() {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            this.processBundle(bundle);
        }
    }

    protected void processBundle(Bundle bundle) {
        Properties props = this.readMessageRouterProps(bundle);
        if (props != null) {
            this.msgRouter.modified(props);
        }
    }

    protected Properties readMessageRouterProps(Bundle bundle) {
        Properties props = null;
        String mrpFileName = "/META-INF/MessageRouter.properties";
        URL propFile = bundle.getEntry("/META-INF/MessageRouter.properties");
        if (propFile != null) {
            props = new Properties();
            try {
                props.load(propFile.openStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return props;
    }

    protected WsMessageRouterImpl getMessageRouter() {
        if (this.msgRouter == null) {
            this.msgRouter = MessageRouterSingleton.singleton;
            TrConfigurator.setMessageRouter((MessageRouter)this.msgRouter);
            this.bundleContext.addBundleListener((BundleListener)this);
            this.processInitialBundles();
        }
        return this.msgRouter;
    }

    public void stop() {
        if (this.msgRouter != null) {
            TrConfigurator.unsetMessageRouter((MessageRouter)this.msgRouter);
        }
        if (this.configListener != null) {
            this.configListener.unregister();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void updateMessageListForHandler(String msgIds, String handlerId) {
        void var8_11;
        if (msgIds == null) {
            return;
        }
        String[] msgStr = msgIds.split(",");
        ArrayList<String> newMsgList = new ArrayList<String>(Arrays.asList(msgStr));
        newMsgList.remove("");
        ArrayList<String> prevMsgList = this.previousHandlerMessageMap.get(handlerId);
        if (prevMsgList == null) {
            prevMsgList = new ArrayList();
        }
        if (prevMsgList.equals(newMsgList)) {
            return;
        }
        this.getMessageRouter();
        ArrayList<String> addedMsgs = new ArrayList<String>(newMsgList);
        addedMsgs.removeAll(prevMsgList);
        for (String string : addedMsgs) {
            this.msgRouter.addMsgToLogHandler(string, handlerId);
        }
        ArrayList<String> removedMsgs = new ArrayList<String>(prevMsgList);
        removedMsgs.removeAll(newMsgList);
        for (String msgId : removedMsgs) {
            this.msgRouter.removeMsgFromLogHandler(msgId, handlerId);
        }
        this.previousHandlerMessageMap.put(handlerId, newMsgList);
        String string = "";
        for (String msg : newMsgList) {
            void var8_13;
            if (!var8_11.equals("")) {
                String string2 = var8_11.concat(" ");
            }
            String string3 = var8_13.concat(msg);
        }
        Tr.info((TraceComponent)this.tc, (String)"MSG_ROUTER_UPDATED", (Object[])new Object[]{handlerId, var8_11});
    }

    private static class MessageRouterSingleton {
        public static final WsMessageRouterImpl singleton = new WsMessageRouterImpl();

        private MessageRouterSingleton() {
        }
    }
}

