/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.configuration;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyJaxRsClientTimeOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(LibertyJaxRsClientTimeOutInterceptor.class);
    static final long serialVersionUID = -2328618012220501126L;

    public LibertyJaxRsClientTimeOutInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        Object connection_timeout = message.get((Object)"com.ibm.ws.jaxrs.client.connection.timeout");
        Object receive_timeout = message.get((Object)"com.ibm.ws.jaxrs.client.receive.timeout");
        Conduit conduit = message.getExchange().getConduit(message);
        this.configClientTimeout(conduit, connection_timeout, receive_timeout);
    }

    /*
     * WARNING - void declaration
     */
    private void configClientTimeout(Conduit conduit, Object connection_timeout, Object receive_timeout) {
        if (conduit instanceof HTTPConduit) {
            HTTPConduit httpConduit = (HTTPConduit)conduit;
            try {
                if (connection_timeout != null) {
                    String sconnection_timeout = connection_timeout.toString();
                    httpConduit.getClient().setConnectionTimeout(Long.parseLong(sconnection_timeout));
                }
            }
            catch (NumberFormatException sconnection_timeout) {
                void e;
                FFDCFilter.processException((Throwable)sconnection_timeout, (String)"com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientTimeOutInterceptor", (String)"60", (Object)((Object)this), (Object[])new Object[]{conduit, connection_timeout, receive_timeout});
                httpConduit.getClient().setConnectionTimeout(30000L);
                Tr.error((TraceComponent)tc, (String)"error.jaxrs.client.configuration.timeout.valueinvalid", (Object[])new Object[]{connection_timeout, "com.ibm.ws.jaxrs.client.connection.timeout", 30000L, e.getMessage()});
            }
            try {
                if (receive_timeout != null) {
                    String sreceive_timeout = receive_timeout.toString();
                    httpConduit.getClient().setReceiveTimeout(Long.parseLong(sreceive_timeout));
                }
            }
            catch (NumberFormatException sreceive_timeout) {
                void e;
                FFDCFilter.processException((Throwable)sreceive_timeout, (String)"com.ibm.ws.jaxrs20.client.configuration.LibertyJaxRsClientTimeOutInterceptor", (String)"73", (Object)((Object)this), (Object[])new Object[]{conduit, connection_timeout, receive_timeout});
                httpConduit.getClient().setReceiveTimeout(30000L);
                Tr.error((TraceComponent)tc, (String)"error.jaxrs.client.configuration.timeout.valueinvalid", (Object[])new Object[]{receive_timeout, "com.ibm.ws.jaxrs.client.receive.timeout", 30000L, e.getMessage()});
            }
        }
    }
}

