/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.client.security;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jaxrs20.client.component.JaxRsAppSecurity;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.net.ssl.SSLSocketFactory;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.client.spec.TLSConfiguration;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.http.HTTPConduit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LibertyJaxRsClientSSLOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(LibertyJaxRsClientSSLOutInterceptor.class);
    private static final String HTTPS_SCHEMA = "https";
    private TLSConfiguration secConfig = null;
    static final long serialVersionUID = 5301461117519296372L;

    public LibertyJaxRsClientSSLOutInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        boolean isSecured = false;
        String address = (String)message.get((Object)Message.ENDPOINT_ADDRESS);
        isSecured = address == null ? false : address.startsWith(HTTPS_SCHEMA);
        Object sslRefObj = message.get((Object)"com.ibm.ws.jaxrs.client.ssl.config");
        String sslRef = null;
        if (sslRefObj != null) {
            sslRef = (String)sslRefObj;
        }
        Object disableCNCheckObj = message.get((Object)"com.ibm.ws.jaxrs.client.disableCNCheck");
        if (isSecured && JaxRsAppSecurity.getSSLSocketFactory(sslRef, null) != null) {
            boolean disableCNCheck = false;
            if (disableCNCheckObj instanceof Boolean) {
                disableCNCheck = (Boolean)disableCNCheckObj;
            } else if (disableCNCheckObj instanceof String) {
                disableCNCheck = Boolean.parseBoolean((String)disableCNCheckObj);
            }
            Conduit cd = message.getExchange().getConduit(message);
            this.configClientSSL(cd, sslRef, disableCNCheck);
        }
    }

    private void configClientSSL(Conduit conduit, String sslRef, boolean disableCNCheck) {
        HTTPConduit httpConduit;
        TLSClientParameters tlsClientParams;
        if (conduit instanceof HTTPConduit && null != (tlsClientParams = this.retriveHTTPTLSClientParametersUsingSSLRef(httpConduit = (HTTPConduit)conduit, sslRef, disableCNCheck))) {
            httpConduit.setTlsClientParameters(tlsClientParams);
        }
    }

    private TLSClientParameters retriveHTTPTLSClientParametersUsingSSLRef(HTTPConduit httpConduit, String sslRef, boolean disableCNCheck) {
        TLSClientParameters tlsClientParams = null;
        tlsClientParams = this.secConfig == null ? httpConduit.getTlsClientParameters() : this.secConfig.getTlsClientParams();
        SSLSocketFactory sslSocketFactory = null;
        if (!StringUtils.isEmpty((String)sslRef)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Use the sslRef = " + sslRef + " to create the SSLSocketFactory."), (Object[])new Object[0]);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Get Liberty default SSLSocketFactory.", (Object[])new Object[0]);
        }
        if (null != (sslSocketFactory = JaxRsAppSecurity.getSSLSocketFactory(sslRef, null))) {
            if (null == tlsClientParams) {
                tlsClientParams = new TLSClientParameters();
            }
            tlsClientParams.setSSLSocketFactory(sslSocketFactory);
            tlsClientParams.setDisableCNCheck(disableCNCheck);
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"May not enable feature ssl-1.0 or appSecurity-2.0.", (Object[])new Object[0]);
        }
        return tlsClientParams;
    }

    public void setTLSConfiguration(TLSConfiguration secConfig) {
        this.secConfig = secConfig;
    }
}

