/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.genericbnf.PasswordNullifier;
import com.ibm.ws.genericbnf.internal.BNFHeadersImpl;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferUtils;
import java.io.IOException;
import java.io.ObjectInput;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;

public class GenericUtils {
    private static final TraceComponent tc = Tr.register(GenericUtils.class, (String)"GenericBNF", null);
    private static final byte ZERO = 48;
    private static final byte DASH = 45;
    private static final byte[] ZERO_BYTEARRAY = new byte[]{48};
    private static final int SIZE_MAXLONG = Long.toString(Long.MAX_VALUE).length();
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private GenericUtils() {
    }

    public static WsByteBuffer[] putByte(WsByteBuffer[] buffers, byte value, BNFHeadersImpl bnfObj) {
        if (null == buffers) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null buffers sent to putByte", (Object[])new Object[0]);
            }
            return null;
        }
        WsByteBuffer buffer = buffers[buffers.length - 1];
        try {
            buffer.put(value);
        }
        catch (BufferOverflowException boe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("putByte overflow: " + buffer), (Object[])new Object[0]);
            }
            buffer.flip();
            buffer = bnfObj.allocateBuffer(bnfObj.getOutgoingBufferSize());
            buffer.put(value);
            return WsByteBufferUtils.expandBufferArray((WsByteBuffer[])buffers, (WsByteBuffer)buffer);
        }
        return buffers;
    }

    public static WsByteBuffer[] putInt(WsByteBuffer[] buffers, int value, BNFHeadersImpl bnfObj) {
        if (null == buffers) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null buffers sent to putInt", (Object[])new Object[0]);
            }
            return null;
        }
        WsByteBuffer buffer = buffers[buffers.length - 1];
        byte[] data = GenericUtils.asBytes(value);
        try {
            buffer.put(data);
        }
        catch (BufferOverflowException boe) {
            return GenericUtils.putByteArrayKnownOverflow(buffers, data, bnfObj);
        }
        return buffers;
    }

    public static WsByteBuffer[] putByteArray(WsByteBuffer[] buffers, byte[] value, BNFHeadersImpl bnfObj) {
        return GenericUtils.putByteArray(buffers, value, 0, value.length, bnfObj);
    }

    public static WsByteBuffer[] putByteArray(WsByteBuffer[] buffers, byte[] value, int inOffset, int length, BNFHeadersImpl bnfObj) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (null == buffers) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Null buffers sent to putByteArray", (Object[])new Object[0]);
                }
                return null;
            }
            if (null == value || 0 == value.length) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Empty value provided to putByteArray: " + value), (Object[])new Object[0]);
                }
                return buffers;
            }
        }
        int offset = inOffset;
        WsByteBuffer buffer = buffers[buffers.length - 1];
        try {
            buffer.put(value, offset, length);
        }
        catch (BufferOverflowException boe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("putByteArray overflow: " + buffer), (Object[])new Object[0]);
            }
            int avail = buffer.capacity() - buffer.position();
            buffer.put(value, offset, avail);
            buffer.flip();
            int remaining = length - (offset += avail);
            int numBuffers = remaining / bnfObj.getOutgoingBufferSize();
            if (0 != remaining % bnfObj.getOutgoingBufferSize()) {
                ++numBuffers;
            }
            WsByteBuffer[] newBuffers = new WsByteBuffer[numBuffers];
            for (int i = 0; i < numBuffers; ++i) {
                newBuffers[i] = bnfObj.allocateBuffer(bnfObj.getOutgoingBufferSize());
                avail = newBuffers[i].capacity();
                if (remaining <= avail) {
                    newBuffers[i].put(value, offset, remaining);
                    break;
                }
                newBuffers[i].put(value, offset, avail);
                newBuffers[i].flip();
                offset += avail;
                remaining -= avail;
            }
            return WsByteBufferUtils.expandBufferArray((WsByteBuffer[])buffers, (WsByteBuffer[])newBuffers);
        }
        return buffers;
    }

    private static WsByteBuffer[] putByteArrayKnownOverflow(WsByteBuffer[] inBuffers, byte[] value, BNFHeadersImpl bnfObj) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Known buffer overflow in put.", (Object[])new Object[0]);
        }
        WsByteBuffer[] buffers = inBuffers;
        boolean bDone = false;
        int remaining = value.length;
        int offset = 0;
        WsByteBuffer buffer = buffers[buffers.length - 1];
        int avail = buffer.capacity() - buffer.position();
        while (!bDone) {
            if (remaining <= avail) {
                buffer.put(value, offset, remaining);
                bDone = true;
                continue;
            }
            buffer.put(value, offset, avail);
            buffer.flip();
            offset += avail;
            remaining -= avail;
            buffer = bnfObj.allocateBuffer(bnfObj.getOutgoingBufferSize());
            buffers = WsByteBufferUtils.expandBufferArray((WsByteBuffer[])buffers, (WsByteBuffer)buffer);
            avail = buffer.capacity();
        }
        return buffers;
    }

    public static int getBytes(WsByteBuffer wsbb, byte[] dst, int offset) {
        try {
            wsbb.get(dst, offset, dst.length - offset);
            return dst.length;
        }
        catch (BufferUnderflowException bue) {
            int numOfBytesAvail = wsbb.remaining();
            wsbb.get(dst, offset, numOfBytesAvail);
            return offset + numOfBytesAvail;
        }
    }

    public static int asInt(byte[] array) {
        if (null == array || 4 != array.length) {
            throw new IllegalArgumentException("Length of the byte array should be 4");
        }
        return (array[0] << 24) + ((array[1] & 0xFF) << 16) + ((array[2] & 0xFF) << 8) + (array[3] & 0xFF);
    }

    public static int asIntValue(byte[] array) {
        return GenericUtils.asIntValue(array, 0, array.length);
    }

    public static int asIntValue(byte[] array, int offset, int length) {
        char c;
        int i;
        if (null == array || array.length <= offset) {
            return -1;
        }
        int intVal = 0;
        int mark = 1;
        for (i = offset + length - 1; offset <= i && (' ' == (c = (char)array[i]) || '\t' == c); --i) {
        }
        while (offset <= i) {
            int digit = array[i] - 48;
            if (0 > digit || 9 < digit) {
                if (45 == array[i]) break;
                throw new NumberFormatException("Invalid digit: " + array[i]);
            }
            intVal += digit * mark;
            mark *= 10;
            --i;
        }
        if (offset <= i && array[i] == 45) {
            intVal = -intVal;
        }
        return intVal;
    }

    public static long asLongValue(byte[] array) {
        return GenericUtils.asLongValue(array, 0, array.length);
    }

    public static long asLongValue(byte[] array, int offset, int length) {
        char c;
        int i;
        if (null == array || array.length <= offset) {
            return -1L;
        }
        long longVal = 0L;
        long mark = 1L;
        for (i = offset + length - 1; offset <= i && (' ' == (c = (char)array[i]) || '\t' == c); --i) {
        }
        while (offset <= i) {
            int digit = array[i] - 48;
            if (0 > digit || 9 < digit) {
                if (45 == array[i]) break;
                throw new NumberFormatException("Invalid digit: " + array[i]);
            }
            longVal += (long)digit * mark;
            mark *= 10L;
            --i;
        }
        if (offset <= i && array[i] == 45) {
            longVal = -longVal;
        }
        return longVal;
    }

    public static byte[] asByteArray(long inValue) {
        int index;
        long value = inValue;
        if (0L == value) {
            return ZERO_BYTEARRAY;
        }
        byte[] bytes = new byte[SIZE_MAXLONG];
        boolean bNegative = false;
        if (0L > value) {
            bNegative = true;
            value = -value;
        }
        for (index = SIZE_MAXLONG - 1; 0 <= index && 0L != value; value /= 10L, --index) {
            bytes[index] = HEX_BYTES[(int)(value % 10L)];
        }
        int len = SIZE_MAXLONG - 1 - index;
        if (bNegative) {
            ++len;
        }
        byte[] realBytes = new byte[len];
        int i = len - 1;
        int x = SIZE_MAXLONG - 1;
        while (0 <= i) {
            realBytes[i] = bytes[x];
            --i;
            --x;
        }
        if (bNegative) {
            realBytes[0] = 45;
        }
        return realBytes;
    }

    public static byte[] asBytes(int value) {
        if (0 > value) {
            throw new IllegalArgumentException("value cannot be less than zero");
        }
        byte[] result = new byte[]{(byte)(value >>> 24 & 0xFF), (byte)(value >>> 16 & 0xFF), (byte)(value >>> 8 & 0xFF), (byte)(value & 0xFF)};
        return result;
    }

    public static String getEnglishString(WsByteBuffer[] list) {
        int i;
        if (null == list) {
            return null;
        }
        int size = 0;
        for (i = 0; i < list.length && null != list[i]; ++i) {
            size += list[i].remaining();
        }
        if (0 == size) {
            return null;
        }
        byte[] value = new byte[size];
        int offset = 0;
        for (int x = 0; x < i; ++x) {
            size = list[x].remaining();
            list[x].get(value, offset, size);
            offset += size;
            list[x].position(0);
        }
        return GenericUtils.getEnglishString(value);
    }

    public static String asLowerCaseString(byte[] bytes) {
        char[] chars = new char[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            char c = (char)(bytes[i] & 0xFF);
            chars[i] = 'A' <= chars[i] && 'Z' >= chars[i] ? (char)(c + 32) : c;
        }
        return new String(chars);
    }

    public static void dumpArrayToTraceLog(byte[] arr) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"[ ", (Object[])new Object[0]);
            if (null == arr) {
                Tr.debug((TraceComponent)tc, (String)"null", (Object[])new Object[0]);
            } else {
                for (int i = 0; i < arr.length; ++i) {
                    Tr.debug((TraceComponent)tc, (String)(arr[i] + " "), (Object[])new Object[0]);
                }
            }
            Tr.debug((TraceComponent)tc, (String)"]", (Object[])new Object[0]);
        }
    }

    public static int byteIndexOf(byte[] bytes, byte target, int start_index) {
        int rc = -1;
        for (int index = start_index; index < bytes.length; ++index) {
            if (target != bytes[index]) continue;
            rc = index;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("byteIndexOf returning [" + rc + "]"), (Object[])new Object[0]);
        }
        return rc;
    }

    public static int byteIndexOf(byte[] bytes, byte target, int start_index, int max_length) {
        int rc = -1;
        int length = 0;
        for (int index = start_index; index < bytes.length && length < max_length; ++index, ++length) {
            if (target != bytes[index]) continue;
            rc = index;
            break;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("byteIndexOf returning [" + rc + "]"), (Object[])new Object[0]);
        }
        return rc;
    }

    public static byte[] byteSubstring(byte[] bytes, int start, int end) {
        byte[] rc = null;
        if (0 > start || start > bytes.length || start > end) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Invalid start position in byteSubstring: " + start), (Object[])new Object[0]);
            }
        } else if (0 > end || end > bytes.length) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Invalid end position in byteSubstring: " + end), (Object[])new Object[0]);
            }
        } else {
            int len = end - start;
            rc = new byte[len];
            System.arraycopy(bytes, start, rc, 0, len);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("byteSubstring returning: [" + GenericUtils.getEnglishString(rc) + "]"), (Object[])new Object[0]);
        }
        return rc;
    }

    public static byte[] expandByteArray(byte[] src, byte[] dst) {
        int srcLength = null != src ? src.length : 0;
        int dstLength = null != dst ? dst.length : 0;
        return GenericUtils.expandByteArray(src, dst, 0, srcLength, 0, dstLength);
    }

    public static byte[] expandByteArray(byte[] src, byte[] dst, int srcPos, int srcLength, int dstPos, int dstLength) {
        byte[] rc = null;
        int totalLen = 0;
        if (null != src) {
            totalLen += srcLength;
        }
        if (null != dst) {
            totalLen += dstLength;
        }
        if (0 < totalLen) {
            rc = new byte[totalLen];
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Created byte[] of size " + totalLen), (Object[])new Object[0]);
            }
            try {
                if (null != src) {
                    System.arraycopy(src, srcPos, rc, 0, srcLength);
                }
                if (null != dst) {
                    System.arraycopy(dst, dstPos, rc, srcLength, dstLength);
                }
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception " + e + " while copying."), (Object[])new Object[0]);
                }
                rc = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("expandByteArray returning: [" + GenericUtils.getEnglishString(rc) + "]"), (Object[])new Object[0]);
        }
        return rc;
    }

    public static byte[] expandByteArray(byte[] src, byte[] dst, int dstPos, int dstLength) {
        int srcLength;
        byte[] rc = null;
        int totalLen = srcLength = null != src ? src.length : 0;
        if (null != dst) {
            totalLen += dstLength;
        }
        if (0 < totalLen) {
            rc = new byte[totalLen];
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Created byte[] of size " + totalLen), (Object[])new Object[0]);
            }
            try {
                if (null != src) {
                    System.arraycopy(src, 0, rc, 0, srcLength);
                }
                if (null != dst) {
                    System.arraycopy(dst, dstPos, rc, srcLength, dstLength);
                }
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception " + e + " while copying."), (Object[])new Object[0]);
                }
                rc = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("expandByteArray returning: [" + GenericUtils.getEnglishString(rc) + "]"), (Object[])new Object[0]);
        }
        return rc;
    }

    public static byte[] expandByteArray(byte[] src, byte b) {
        int srcLength = null != src ? src.length : 0;
        int totalLen = srcLength + 1;
        byte[] rc = new byte[totalLen];
        try {
            if (null != src) {
                System.arraycopy(src, 0, rc, 0, srcLength);
            }
            rc[srcLength] = b;
        }
        catch (Exception e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Exception " + e + " while copying."), (Object[])new Object[0]);
            }
            rc = null;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("expandByteArray returning: [" + GenericUtils.getEnglishString(rc) + "]"), (Object[])new Object[0]);
        }
        return rc;
    }

    public static byte[] getBytes(StringBuffer data) {
        if (null == data) {
            return null;
        }
        int len = data.length();
        char[] chars = new char[len];
        data.getChars(0, len, chars, 0);
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static byte[] getBytes(StringBuilder data) {
        if (null == data) {
            return null;
        }
        int len = data.length();
        char[] chars = new char[len];
        data.getChars(0, len, chars, 0);
        byte[] bytes = new byte[len];
        for (int i = 0; i < len; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static byte[] getBytes(String input) {
        if (null != input) {
            char[] chars = input.toCharArray();
            byte[] output = new byte[chars.length];
            for (int i = 0; i < chars.length; ++i) {
                output[i] = (byte)chars[i];
            }
            return output;
        }
        return null;
    }

    public static byte[] getEnglishBytes(String data) {
        return GenericUtils.getBytes(data);
    }

    public static String getEnglishString(byte[] data) {
        if (null == data) {
            return null;
        }
        char[] chars = new char[data.length];
        for (int i = 0; i < data.length; ++i) {
            chars[i] = (char)(data[i] & 0xFF);
        }
        return new String(chars);
    }

    private static char convertHex(int value) {
        return (char)HEX_BYTES[value & 0xF];
    }

    private static StringBuilder formatLineId(StringBuilder buffer, int value) {
        int id = value;
        char[] chars = new char[4];
        for (int i = 3; i >= 0; --i) {
            chars[i] = (char)HEX_BYTES[id % 16 & 0xF];
            id >>= 4;
        }
        return buffer.append(chars);
    }

    private static StringBuilder formatHexData(StringBuilder buffer, byte[] data, int inOffset) {
        int offset = inOffset;
        int end = offset + 8;
        if (offset >= data.length) {
            buffer.append("                       ");
            return buffer;
        }
        buffer.append(GenericUtils.convertHex((0xFF & data[offset]) / 16));
        buffer.append(GenericUtils.convertHex((0xFF & data[offset]) % 16));
        ++offset;
        while (offset < end) {
            if (offset >= data.length) {
                buffer.append("   ");
            } else {
                buffer.append(' ');
                buffer.append(GenericUtils.convertHex((0xFF & data[offset]) / 16));
                buffer.append(GenericUtils.convertHex((0xFF & data[offset]) % 16));
            }
            ++offset;
        }
        return buffer;
    }

    private static StringBuilder formatTextData(StringBuilder buffer, byte[] data, int inOffset) {
        int offset;
        int end = offset + 16;
        for (offset = inOffset; offset < end; ++offset) {
            if (offset >= data.length) {
                buffer.append(" ");
                continue;
            }
            if (Character.isLetterOrDigit(data[offset])) {
                buffer.append((char)data[offset]);
                continue;
            }
            buffer.append('.');
        }
        return buffer;
    }

    public static String getHexDump(byte[] data) {
        return null == data ? null : GenericUtils.getHexDump(data, data.length);
    }

    public static String getHexDump(byte[] data, int inLength) {
        if (null == data || 0 > inLength) {
            return null;
        }
        int length = inLength;
        if (data.length < length) {
            length = data.length;
        }
        int numlines = length / 16 + (length % 16 > 0 ? 1 : 0);
        StringBuilder buffer = new StringBuilder(73 * numlines);
        int i = 0;
        int line = 0;
        while (line < numlines) {
            buffer = GenericUtils.formatLineId(buffer, i);
            buffer.append(": ");
            buffer = GenericUtils.formatHexData(buffer, data, i);
            buffer.append("  ");
            buffer = GenericUtils.formatHexData(buffer, data, i + 8);
            buffer.append("  ");
            buffer = GenericUtils.formatTextData(buffer, data, i);
            buffer.append('\n');
            ++line;
            i += 16;
        }
        return buffer.toString();
    }

    public static String getEnglishString(byte[] data, int start, int end) {
        int len = end - start;
        if (null == data || 0 > len) {
            return null;
        }
        char[] chars = new char[len];
        int x = 0;
        for (int i = start; i < end; ++i) {
            chars[x] = (char)(data[i] & 0xFF);
            ++x;
        }
        return new String(chars);
    }

    public static int skipToChar(byte[] data, int start, byte target) {
        int index;
        for (index = start; index < data.length && target != data[index]; ++index) {
        }
        return index;
    }

    public static int skipToChars(byte[] data, int start, byte[] targets) {
        int index;
        int y = 0;
        for (index = start; index < data.length; ++index) {
            byte current = data[index];
            for (y = 0; y < targets.length; ++y) {
                if (current != targets[y]) continue;
                return index;
            }
        }
        return index;
    }

    public static int skipWhiteSpace(byte[] data, int start) {
        int index;
        for (index = start + 1; index < data.length && 32 == data[index]; ++index) {
        }
        return index;
    }

    public static byte reverseCase(byte c) {
        return (byte)(c + (65 <= c && 90 >= c ? 32 : -32));
    }

    public static char reverseCase(char c) {
        return (char)(c + ('A' <= c && 'Z' >= c ? 32 : -32));
    }

    public static int sizeOf(WsByteBuffer[] list) {
        if (null == list) {
            return 0;
        }
        int size = 0;
        for (int i = 0; i < list.length; ++i) {
            if (null == list[i]) continue;
            size += list[i].remaining();
        }
        return size;
    }

    public static byte[] readValue(ObjectInput in, int len) throws IOException {
        int bytesRead = 0;
        byte[] data = new byte[len];
        for (int offset = 0; offset < len; offset += bytesRead) {
            bytesRead = in.read(data, offset, len - offset);
            if (bytesRead != -1) continue;
            throw new IOException("Could not retrieve ");
        }
        return data;
    }

    public static String nullOutPasswords(byte[] value, byte delimiter) {
        return GenericUtils.nullOutPasswords(GenericUtils.getEnglishString(value), delimiter);
    }

    public static String nullOutPasswords(String value, byte delimiter) {
        return PasswordNullifier.nullify(value, delimiter);
    }

    public static String blockContents(byte[] value) {
        if (null == value) {
            return null;
        }
        char[] data = new char[value.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = 42;
        }
        return new String(data);
    }

    public static String blockContents(String value) {
        if (null == value) {
            return null;
        }
        char[] data = new char[value.length()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = 42;
        }
        return new String(data);
    }
}

