/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.FrameSettings;
import javax.xml.bind.DatatypeConverter;

public class H2ConnectionSettings {
    public int headerTableSize = 4096;
    public int enablePush = 1;
    public int maxConcurrentStreams = 100;
    public int initialWindowSize = 65535;
    public int maxFrameSize = 16384;
    public int maxHeaderListSize = -1;

    protected void processUpgradeHeaderSettings(String settings) throws ProtocolException {
        byte[] decoded;
        if (settings != null && (decoded = DatatypeConverter.parseBase64Binary((String)settings)) != null) {
            FrameSettings settingsFrame = new FrameSettings(0, decoded.length, 0, false, Frame.FrameDirection.READ);
            settingsFrame.processPayload(decoded);
            this.updateSettings(settingsFrame);
        }
    }

    public void updateSettings(FrameSettings settings) {
        if (settings.getHeaderTableSize() != -1) {
            this.headerTableSize = settings.getHeaderTableSize();
        }
        if (settings.getEnablePush() != -1) {
            this.enablePush = settings.getEnablePush();
        }
        if (settings.getMaxConcurrentStreams() != -1) {
            this.maxConcurrentStreams = settings.getMaxConcurrentStreams();
        }
        if (settings.getInitialWindowSize() != -1) {
            this.initialWindowSize = settings.getInitialWindowSize();
        }
        if (settings.getMaxFrameSize() != -1) {
            this.maxFrameSize = settings.getMaxFrameSize();
        }
        if (settings.getMaxHeaderListSize() != -1) {
            this.maxHeaderListSize = settings.getMaxHeaderListSize();
        }
    }

    public int getEnablePush() {
        return this.enablePush;
    }
}

