/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.Constants;
import com.ibm.ws.http.channel.h2internal.H2ConnectionLinkProxy;
import com.ibm.ws.http.channel.h2internal.H2InboundLink;
import com.ibm.ws.http.channel.h2internal.H2StreamProcessor;
import com.ibm.ws.http.channel.h2internal.H2TCPConnectionContext;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.FrameContinuation;
import com.ibm.ws.http.channel.h2internal.frames.FrameData;
import com.ibm.ws.http.channel.h2internal.frames.FrameHeaders;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderField;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderTable;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundChannel;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundLink;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class H2HttpInboundLinkWrap
extends HttpInboundLink {
    Integer streamID = null;
    public H2InboundLink muxLink = null;
    H2TCPConnectionContext h2TCPConnectionContext = null;
    H2ConnectionLinkProxy h2ConnectionProxy = null;
    VirtualConnection vc = null;
    boolean isPushPromise = false;
    private HashMap<String, String> pseudoHeaders = null;
    private ArrayList<H2HeaderField> headers = null;
    private static final TraceComponent tc = Tr.register(H2HttpInboundLinkWrap.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");

    public H2HttpInboundLinkWrap(HttpInboundChannel channel, VirtualConnection v, Integer id, H2InboundLink link) {
        super(channel, v);
        this.streamID = id;
        this.muxLink = link;
        this.vc = v;
        this.h2TCPConnectionContext = new H2TCPConnectionContext(this.streamID, this.muxLink, v);
        this.h2ConnectionProxy = new H2ConnectionLinkProxy(this);
    }

    public H2TCPConnectionContext getConnectionContext() {
        return this.h2TCPConnectionContext;
    }

    public void closeDeviceLink(Exception e) {
    }

    public ConnectionLink getDeviceLink() {
        return this.h2ConnectionProxy;
    }

    @Override
    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroying wrapped H2 inbound link: " + (Object)((Object)this) + " " + this.getVirtualConnection()), (Object[])new Object[0]);
        }
        super.destroy(e);
        this.vc = null;
        this.streamID = null;
        this.muxLink = null;
        this.h2TCPConnectionContext = null;
        this.h2ConnectionProxy = null;
        this.vc = null;
    }

    public ArrayList<Frame> prepareHeaders(byte[] marshalledHeaders, boolean complete) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prepareHeaders entry: stream: marked as complete: " + complete), (Object[])new Object[0]);
        }
        int maxFrameSize = this.muxLink.getConnectionSettings().maxFrameSize;
        ArrayList<Frame> frameList = new ArrayList<Frame>();
        boolean endHeaders = true;
        if (marshalledHeaders.length > maxFrameSize) {
            int remaining = marshalledHeaders.length;
            int frameSize = maxFrameSize;
            int position = 0;
            endHeaders = false;
            byte[] firstFragment = Arrays.copyOfRange(marshalledHeaders, position, frameSize);
            FrameHeaders fh = new FrameHeaders(this.streamID, firstFragment, complete, endHeaders);
            frameList.add(fh);
            remaining -= frameSize;
            while (remaining > 0) {
                frameSize = remaining >= maxFrameSize ? maxFrameSize : remaining;
                byte[] fragment = Arrays.copyOfRange(marshalledHeaders, position += frameSize, position + frameSize);
                endHeaders = (remaining -= frameSize) == 0;
                FrameContinuation continued = new FrameContinuation((int)this.streamID, fragment, endHeaders, false, false);
                frameList.add(continued);
                if (!endHeaders) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("prepareHeaders exit : " + frameList), (Object[])new Object[0]);
                }
                return frameList;
            }
        }
        FrameHeaders fh = new FrameHeaders(this.streamID, marshalledHeaders, complete, endHeaders);
        frameList.add(fh);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prepareHeaders exit : " + frameList), (Object[])new Object[0]);
        }
        return frameList;
    }

    public ArrayList<Frame> prepareBody(byte[] body, boolean isFinalWrite) {
        FrameData dataFrame;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prepareBody entry : final write: " + isFinalWrite), (Object[])new Object[0]);
        }
        ArrayList<Frame> dataFrames = new ArrayList<Frame>();
        boolean endStream = isFinalWrite;
        int maxFrameSize = this.muxLink.getConnectionSettings().maxFrameSize;
        if (body == null) {
            body = new byte[]{};
        }
        if (body.length > maxFrameSize) {
            endStream = false;
            int remaining = body.length;
            int frameSize = maxFrameSize;
            int position = 0;
            byte[] dataBytes = Arrays.copyOfRange(body, position, frameSize);
            dataFrame = new FrameData(this.streamID, dataBytes, endStream);
            dataFrames.add(dataFrame);
            remaining -= frameSize;
            while (remaining > 0) {
                frameSize = remaining >= maxFrameSize ? maxFrameSize : remaining;
                dataBytes = Arrays.copyOfRange(body, position += frameSize, position + frameSize);
                boolean lastData = (remaining -= frameSize) == 0;
                endStream = lastData && isFinalWrite;
                dataFrame = new FrameData(this.streamID, dataBytes, endStream);
                dataFrames.add(dataFrame);
                if (!lastData) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("prepareBody exit : " + dataFrames), (Object[])new Object[0]);
                }
                return dataFrames;
            }
        }
        dataFrame = new FrameData(this.streamID, body, isFinalWrite);
        dataFrames.add(dataFrame);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prepareBody exit : " + dataFrames), (Object[])new Object[0]);
        }
        return dataFrames;
    }

    public int getStreamId() {
        return this.streamID;
    }

    public H2HeaderTable getReadTable() {
        return this.muxLink.getReadTable();
    }

    public H2HeaderTable getWriteTable() {
        return this.muxLink.getWriteTable();
    }

    public void setPushPromise(boolean isPushPromise) {
        this.isPushPromise = isPushPromise;
    }

    public boolean isPushPromise() {
        return this.isPushPromise;
    }

    @Override
    public void close(VirtualConnection inVC, Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("close() called H2InboundLink: " + (Object)((Object)this) + " " + inVC), (Object[])new Object[0]);
        }
        this.muxLink.close(inVC, e);
    }

    public void writeFramesSync(CopyOnWriteArrayList<Frame> frames) {
        if (frames == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"writeFramesSync entry: # of frames: 0 - returning", (Object[])new Object[0]);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeFramesSync entry: # of frames: " + frames.size()), (Object[])new Object[0]);
        }
        Iterator<Frame> i = frames.iterator();
        while (i.hasNext()) {
            try {
                Frame currentFrame = i.next();
                H2StreamProcessor streamProcessor = this.muxLink.getStreamProcessor(this.streamID);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("writeFramesSync processing frame ID: " + (Object)((Object)currentFrame.getFrameType())), (Object[])new Object[0]);
                }
                streamProcessor.processNextFrame(currentFrame, Constants.Direction.WRITING_OUT);
            }
            catch (Http2Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processRead an error occurred processing a frame: " + e.getErrorString()), (Object[])new Object[0]);
                }
                try {
                    this.muxLink.getStreamProcessor(0).sendGOAWAYFrame(e);
                }
                catch (ProtocolException x) {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("writeFramesSync, ProtocolException occurred while sending a goaway frame: " + x), (Object[])new Object[0]);
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("writeFramesSync, Exception occurred while writing the data : " + e), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"writeFramesSync exit", (Object[])new Object[0]);
        }
    }

    public void setReadPseudoHeaders(HashMap<String, String> pseudoHeaders) {
        this.pseudoHeaders = pseudoHeaders;
    }

    public HashMap<String, String> getReadPseudoHeaders() {
        return this.pseudoHeaders;
    }

    public void setReadHeaders(ArrayList<H2HeaderField> headers) {
        this.headers = headers;
    }

    public ArrayList<H2HeaderField> getReadHeaders() {
        return this.headers;
    }
}

