/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.frames;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.FrameReadProcessor;
import com.ibm.ws.http.channel.h2internal.FrameTypes;
import com.ibm.ws.http.channel.h2internal.H2ConnectionSettings;
import com.ibm.ws.http.channel.h2internal.exceptions.FrameSizeException;
import com.ibm.ws.http.channel.h2internal.exceptions.ProtocolException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.utils;

public class FramePing
extends Frame {
    byte[] opaquePayload;

    public FramePing(int streamId, int payloadLength, byte flags, boolean reserveBit, Frame.FrameDirection direction) {
        super(streamId, payloadLength, flags, reserveBit, direction);
        this.frameType = FrameTypes.PING;
    }

    public FramePing(int streamId, byte[] payload, boolean reserveBit) {
        super(streamId, 8, (byte)0, reserveBit, Frame.FrameDirection.WRITE);
        this.frameType = FrameTypes.PING;
        this.payloadLength = 8;
        this.opaquePayload = new byte[this.payloadLength];
        if (payload != null) {
            this.opaquePayload = payload;
        } else {
            for (int i = 0; i < this.payloadLength; ++i) {
                this.opaquePayload[i] = 115;
            }
        }
        this.setInitialized();
    }

    @Override
    public void processPayload(FrameReadProcessor frp) throws FrameSizeException {
        this.setFlags();
        int payloadIndex = 0;
        this.opaquePayload = new byte[this.payloadLength];
        int i = 0;
        while (payloadIndex++ < this.payloadLength) {
            this.opaquePayload[i] = frp.grabNextByte();
            ++i;
        }
    }

    @Override
    public byte[] buildFrameForWrite() {
        byte[] frame = super.buildFrameForWrite();
        this.setFrameHeaders(frame, (byte)6);
        int frameIndex = 9;
        for (int i = 0; i < this.opaquePayload.length; ++i) {
            frame[i + 9] = this.opaquePayload[i];
        }
        return frame;
    }

    @Override
    public void validate(H2ConnectionSettings settings) throws ProtocolException, FrameSizeException {
        if (this.streamId != 0) {
            throw new ProtocolException("PING frame streamID must be 0x0; received " + this.streamId);
        }
        if (this.payloadLength != 8) {
            throw new FrameSizeException("PING opaque data must have a length of 8.  Actual length : " + this.payloadLength);
        }
    }

    @Override
    protected void setFlags() {
        this.ACK_FLAG = utils.getFlag(this.flags, 0);
    }

    public boolean isAckSet() {
        return this.ACK_FLAG;
    }

    public byte[] getPayload() {
        return this.opaquePayload;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof FramePing)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Object is not a FramePing", (Object[])new Object[0]);
            }
            return false;
        }
        FramePing framePingToCompare = (FramePing)object;
        if (!super.equals(framePingToCompare)) {
            return false;
        }
        byte[] baThis = this.getPayload();
        byte[] baToCompare = framePingToCompare.getPayload();
        for (int i = 0; i < baThis.length; ++i) {
            if (baThis[i] == baToCompare[i]) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("equals: payload first difference is at byte: " + i), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder frameToString = new StringBuilder();
        frameToString.append(super.toString());
        if (this.getPayload() == null) {
            frameToString.append("OpaqueData length: 0 - null \n");
        } else {
            frameToString.append("OpaqueData length: " + this.getPayload().length + "\n");
        }
        return frameToString.toString();
    }
}

