/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal.priority;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.http.channel.h2internal.H2WriteQEntry;
import com.ibm.ws.http.channel.h2internal.priority.Node;
import java.util.ArrayList;
import java.util.Iterator;

public class Tree {
    private static final TraceComponent tc = Tr.register(Tree.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    Node root = new Node(Node.ROOT_STREAM_ID, Node.ROOT_PRIORITY);

    public synchronized boolean findNode(int streamID) {
        Node node;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findNode entry: starting at root for stream ID: " + streamID), (Object[])new Object[0]);
        }
        return (node = this.root.findNode(streamID)) != null;
    }

    public synchronized Node getRoot() {
        return this.root;
    }

    public synchronized boolean addNode(Node nodeToAdd, int parentStreamID, boolean exclusive) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addNode entry: Node to add: " + nodeToAdd), (Object[])new Object[0]);
        }
        if (nodeToAdd == null) {
            return false;
        }
        Node parentNode = this.root.findNode(parentStreamID);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("found parent node of: " + parentNode.hashCode()), (Object[])new Object[0]);
        }
        if (parentNode != null) {
            nodeToAdd.setParent(parentNode);
            if (exclusive) {
                this.makeExclusiveDependency(nodeToAdd, parentNode);
            } else {
                parentNode.clearDependentsWriteCount();
                parentNode.sortDependents();
            }
            return true;
        }
        return false;
    }

    public synchronized boolean updateNode(int streamID, Node.NODE_STATUS status, Node.WRITE_COUNT_ACTION writeCountAction, H2WriteQEntry entry) {
        Node nodeToUpdate;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            if (entry == null) {
                Tr.debug((TraceComponent)tc, (String)("updateNode entry: null streamID: " + streamID + " status: " + (Object)((Object)status) + " writeCountAction: " + (Object)((Object)writeCountAction)), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("updateNode entry: " + entry.hashCode() + " streamID: " + streamID + " status: " + (Object)((Object)status) + " writeCountAction: " + (Object)((Object)writeCountAction)), (Object[])new Object[0]);
            }
        }
        if ((nodeToUpdate = this.root.findNode(streamID)) == null) {
            return false;
        }
        if (entry != null) {
            nodeToUpdate.setEntry(entry);
        }
        if (status != Node.NODE_STATUS.ACTION_NO_CHANGE) {
            nodeToUpdate.setStatus(status);
        }
        if (writeCountAction == Node.WRITE_COUNT_ACTION.INCREMENT) {
            nodeToUpdate.incrementWriteCount();
            Node parentNode = nodeToUpdate.getParent();
            if (parentNode != null) {
                parentNode.incrementDependentWriteCount();
                parentNode.sortDependents();
            } else if (writeCountAction == Node.WRITE_COUNT_ACTION.CLEAR) {
                nodeToUpdate.setWriteCount(0);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateNode exit: node updated to: " + nodeToUpdate.toStringDetails()), (Object[])new Object[0]);
        }
        return true;
    }

    public synchronized H2WriteQEntry findNextWriteEntry() {
        Node node;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("findNextWriteEntry entry: from root " + this.root), (Object[])new Object[0]);
        }
        if ((node = this.root.findNextWrite()) != null) {
            H2WriteQEntry e = node.getEntry();
            return e;
        }
        return null;
    }

    public synchronized boolean changeNodePriority(int streamID, int newPriority) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("changeNodePriority entry: streamID to change: " + streamID + " new Priority: " + newPriority), (Object[])new Object[0]);
        }
        Node nodeToChange = this.root.findNode(streamID);
        Node parentNode = nodeToChange.getParent();
        if (nodeToChange == null || parentNode == null) {
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("node to change: " + nodeToChange + " has parent node of: " + parentNode), (Object[])new Object[0]);
        }
        nodeToChange.setPriority(newPriority);
        parentNode.clearDependentsWriteCount();
        parentNode.sortDependents();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("changeNodePriority exit: node changed: " + nodeToChange.toStringDetails()), (Object[])new Object[0]);
        }
        return true;
    }

    public synchronized boolean makeExclusiveDependency(int depStreamID, int exclusiveParentStreamID) {
        Node depNode = this.root.findNode(depStreamID);
        Node exclusiveParentNode = this.root.findNode(exclusiveParentStreamID);
        return this.makeExclusiveDependency(depNode, exclusiveParentNode);
    }

    public synchronized boolean makeExclusiveDependency(Node depNode, Node exclusiveParentNode) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("makeExclusiveDependency entry: depNode: " + depNode + " exclusiveParentNode: " + exclusiveParentNode), (Object[])new Object[0]);
        }
        if (depNode == null || exclusiveParentNode == null) {
            return false;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"make dependent Node parent of all current Parent dependents", (Object[])new Object[0]);
        }
        ArrayList<Node> dependents = exclusiveParentNode.getDependents();
        for (int i = 0; i < dependents.size(); ++i) {
            Node n = dependents.get(i);
            if (n.getStreamID() == depNode.getStreamID()) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("node stream-id: " + n.getStreamID() + " will now have a parent stream of: " + depNode.getStreamID()), (Object[])new Object[0]);
            }
            n.setParent(depNode);
        }
        depNode.setParent(exclusiveParentNode);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"set up exclusive parent, clear counts and resort nodes", (Object[])new Object[0]);
        }
        depNode.setWriteCount(0);
        depNode.clearDependentsWriteCount();
        depNode.sortDependents();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("makeExclusiveDependency exit: depNode changed to: " + depNode.toStringDetails()), (Object[])new Object[0]);
        }
        return true;
    }

    public synchronized boolean changeParent(int depStreamID, int newPriority, int newParentStreamID, boolean exclusive) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("changeParent entry: depStreamID: " + depStreamID + " newParentStreamID: " + newParentStreamID + " exclusive: " + exclusive), (Object[])new Object[0]);
        }
        Node depNode = this.root.findNode(depStreamID);
        Node newParentNode = this.root.findNode(newParentStreamID);
        if (depNode == null || newParentNode == null) {
            return false;
        }
        if (depNode.findNode(newParentStreamID) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"new parent is not a dependent of the stream that is changing parents", (Object[])new Object[0]);
            }
            Node oldParent = depNode.getParent();
            depNode.setParent(newParentNode);
            depNode.setPriority(newPriority);
            newParentNode.clearDependentsWriteCount();
            newParentNode.sortDependents();
            oldParent.clearDependentsWriteCount();
            oldParent.sortDependents();
            if (exclusive) {
                this.makeExclusiveDependency(depNode, newParentNode);
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"new parent is a dependent of the stream that is changing parents", (Object[])new Object[0]);
            }
            Node grandParent = depNode.getParent();
            Node oldDepParent = newParentNode.getParent();
            newParentNode.setParent(grandParent);
            depNode.setParent(newParentNode);
            depNode.setPriority(newPriority);
            grandParent.clearDependentsWriteCount();
            grandParent.sortDependents();
            newParentNode.clearDependentsWriteCount();
            newParentNode.sortDependents();
            oldDepParent.clearDependentsWriteCount();
            oldDepParent.sortDependents();
            if (exclusive) {
                this.makeExclusiveDependency(depNode, newParentNode);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("changeParent exit: depNode on exit: " + depNode.toStringDetails()), (Object[])new Object[0]);
        }
        return true;
    }

    public synchronized boolean removeNode(int streamIDToRemove) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeNode entry: streamIDToRemove: " + streamIDToRemove), (Object[])new Object[0]);
        }
        int prioritySum = 0;
        Node nodeToRemove = this.root.findNode(streamIDToRemove);
        if (nodeToRemove == null) {
            return false;
        }
        int nodeToRemovePriority = nodeToRemove.getPriority();
        Node newParent = nodeToRemove.getParent();
        ArrayList<Node> dependents = nodeToRemove.getDependents();
        Iterator<Node> iter = dependents.iterator();
        while (iter.hasNext()) {
            prioritySum += iter.next().getPriority();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sum of dependent priorities is: " + prioritySum), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)"reset dependent priorities and set the new parent", (Object[])new Object[0]);
        }
        for (Node depNode : dependents) {
            depNode.setParent(newParent);
            int priority = nodeToRemovePriority * depNode.getPriority() / prioritySum;
            if (priority != 0) continue;
            priority = 1;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"remove the node from the tree", (Object[])new Object[0]);
        }
        nodeToRemove.setParent(null);
        return true;
    }

    public synchronized boolean updateNodeFrameParameters(int streamID, int newPriority, int newParentStreamID, boolean exclusive) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateNodeFrameParameters entry: streamID to udpate: " + streamID + " new Priority: " + newPriority + " new Parent stream ID: " + newParentStreamID + " exclusive: " + exclusive), (Object[])new Object[0]);
        }
        Node nodeToChange = this.root.findNode(streamID);
        Node oldParent = nodeToChange.getParent();
        if (nodeToChange == null || oldParent == null) {
            return false;
        }
        int oldParentStreamID = oldParent.getStreamID();
        int oldPriority = nodeToChange.getPriority();
        if (newParentStreamID != oldParentStreamID || exclusive) {
            this.changeParent(streamID, newPriority, newParentStreamID, exclusive);
        } else if (newPriority != oldPriority) {
            nodeToChange.setPriority(newPriority);
            oldParent.clearDependentsWriteCount();
            oldParent.sortDependents();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateNodeFrameParameters exit: node changed: " + nodeToChange.toStringDetails()), (Object[])new Object[0]);
        }
        return true;
    }

    public synchronized String getTreeDump() {
        StringBuffer s = new StringBuffer("\nDump Tree: " + this.hashCode());
        this.root.dumpDependents(s);
        return s.toString();
    }
}

