/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.artifact.zip.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.artifact.zip.cache.ZipFileHandle;
import com.ibm.ws.artifact.zip.internal.ContainerFactoryHolder;
import com.ibm.ws.artifact.zip.internal.Utils;
import com.ibm.ws.artifact.zip.internal.ZipFileArtifactNotifier;
import com.ibm.ws.artifact.zip.internal.ZipFileEntry;
import com.ibm.ws.artifact.zip.internal.ZipFileEntryIterator;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.artifact.ArtifactEntry;
import com.ibm.wsspi.artifact.ArtifactNotifier;
import com.ibm.wsspi.kernel.service.utils.FileUtils;
import com.ibm.wsspi.kernel.service.utils.ParserUtils;
import com.ibm.wsspi.kernel.service.utils.PathUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ZipFileContainer
implements ArtifactContainer {
    static final TraceComponent tc = Tr.register(ZipFileContainer.class);
    private final ContainerFactoryHolder containerFactoryHolder;
    private final ArtifactContainer parent;
    private final ArtifactEntry thisInParent;
    private static final ConcurrentHashMap<String, CountDownLatch> cacheLocks = new ConcurrentHashMap();
    private File archiveFile;
    private final File cacheDir;
    private ZipFileHandle zipFileHandle;
    private static final boolean isRoot = true;
    private NavigableMap<String, ZipEntry> allEntries = null;
    private final FastModeLock fastModeLock;
    private int fastModeCount;
    private final ArtifactNotifier artifactNotifier;
    static final long serialVersionUID = -6615880763070944999L;

    ZipFileContainer(File cacheDir, File f, ContainerFactoryHolder c) {
        this.cacheDir = cacheDir;
        this.archiveFile = f;
        this.parent = null;
        this.thisInParent = null;
        this.containerFactoryHolder = c;
        this.artifactNotifier = new ZipFileArtifactNotifier(this, c, f.getAbsolutePath());
        this.fastModeLock = new FastModeLock();
    }

    ZipFileContainer(File cacheDir, ArtifactContainer parent, ArtifactEntry e, File f, ContainerFactoryHolder c) {
        this.cacheDir = cacheDir;
        this.archiveFile = f;
        this.parent = parent;
        this.thisInParent = e;
        this.containerFactoryHolder = c;
        this.artifactNotifier = this.archiveFile != null ? new ZipFileArtifactNotifier(this, c, f.getAbsolutePath()) : new ZipFileArtifactNotifier(this, c, e);
        this.fastModeLock = new FastModeLock();
    }

    protected void finalize() throws Throwable {
        try {
            this.resetFastMode();
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void useFastMode() {
        FastModeLock fastModeLock = this.fastModeLock;
        synchronized (fastModeLock) {
            ++this.fastModeCount;
            if (this.zipFileHandle == null) {
                try {
                    this.zipFileHandle = this.getZipFileHandle();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"162", (Object)this, (Object[])new Object[0]);
                }
                this.listEntries();
            }
            if (this.zipFileHandle != null) {
                this.openZipHandle(this.zipFileHandle);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopUsingFastMode() {
        FastModeLock fastModeLock = this.fastModeLock;
        synchronized (fastModeLock) {
            if (this.fastModeCount > 0) {
                --this.fastModeCount;
                if (this.zipFileHandle != null) {
                    this.zipFileHandle.close();
                }
                if (this.fastModeCount == 0) {
                    this.zipFileHandle = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resetFastMode() {
        FastModeLock fastModeLock = this.fastModeLock;
        synchronized (fastModeLock) {
            if (this.zipFileHandle != null) {
                for (int i = 0; i < this.fastModeCount; ++i) {
                    this.zipFileHandle.close();
                }
                this.fastModeCount = 0;
            }
            if (this.fastModeCount > 0) {
                throw new IllegalStateException();
            }
        }
    }

    File getNewCacheDirForEntry(ArtifactEntry e) {
        String relativeLocation;
        File newCacheDir = new File(this.cacheDir, ".cache");
        if (this.thisInParent != null) {
            newCacheDir = new File(newCacheDir, this.thisInParent.getName());
        }
        if (!(relativeLocation = e.getEnclosingContainer().getPath()).equals("/")) {
            newCacheDir = new File(newCacheDir, relativeLocation.substring(1));
        }
        return newCacheDir;
    }

    private boolean removeFile(File f) {
        if (FileUtils.fileIsFile((File)f)) {
            return Utils.delete(f);
        }
        boolean ok = true;
        File[] children = FileUtils.listFiles((File)f);
        if (children != null) {
            for (File child : children) {
                ok &= this.removeFile(child);
            }
        }
        if (ok) {
            ok &= Utils.delete(f);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    File extractEntryToCacheFile(ArtifactEntry e) throws IOException {
        block38: {
            block37: {
                block35: {
                    block36: {
                        block39: {
                            block33: {
                                block34: {
                                    block31: {
                                        block32: {
                                            i = null;
                                            i = e.getInputStream();
                                            if (i != null) break block31;
                                            var3_3 = null;
                                            if (i == null) break block32;
                                            try {
                                                i.close();
                                            }
                                            catch (IOException var4_5) {
                                                FFDCFilter.processException((Throwable)var4_5, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"420", (Object)this, (Object[])new Object[]{e});
                                            }
                                        }
                                        return var3_3;
                                    }
                                    dirForExtract = this.cacheDir;
                                    targetOutputFile = new File(dirForExtract, e.getName());
                                    lockKey = targetOutputFile.getCanonicalPath();
                                    creator = false;
                                    creatorLatch = c = new CountDownLatch(1);
                                    c = ZipFileContainer.cacheLocks.putIfAbsent(lockKey, c);
                                    if (c != null) {
                                        try {
                                            c.await(60L, TimeUnit.SECONDS);
                                        }
                                        catch (InterruptedException var9_11) {
                                            FFDCFilter.processException((Throwable)var9_11, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"327", (Object)this, (Object[])new Object[]{e});
                                        }
                                    } else {
                                        creator = true;
                                        c = creatorLatch;
                                    }
                                    creatorLatch = null;
                                    if (!FileUtils.fileExists((File)targetOutputFile)) ** GOTO lbl57
                                    if (!FileUtils.fileIsFile((File)targetOutputFile)) ** GOTO lbl53
                                    targetLastModified = FileUtils.fileLastModified((File)targetOutputFile);
                                    if (Math.abs(targetLastModified - (entryLastModified = e.getLastModified())) >= 1010L) break block33;
                                    if (creator) {
                                        c.countDown();
                                        ZipFileContainer.cacheLocks.remove(lockKey);
                                    }
                                    var13_17 = targetOutputFile;
                                    if (i == null) break block34;
                                    try {
                                        i.close();
                                    }
                                    catch (IOException var14_19) {
                                        FFDCFilter.processException((Throwable)var14_19, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"420", (Object)this, (Object[])new Object[]{e});
                                    }
                                }
                                return var13_17;
                            }
                            break block39;
lbl53:
                            // 1 sources

                            if (FileUtils.fileIsDirectory((File)targetOutputFile)) {
                                this.removeFile(targetOutputFile);
                                Tr.warning((TraceComponent)ZipFileContainer.tc, (String)"remove.cache.data", (Object[])new Object[]{targetOutputFile.getAbsolutePath()});
                            }
                        }
                        if (FileUtils.ensureDirExists((File)dirForExtract)) break block35;
                        if (creator) {
                            c.countDown();
                            ZipFileContainer.cacheLocks.remove(lockKey);
                        }
                        targetLastModified = null;
                        if (i == null) break block36;
                        try {
                            i.close();
                        }
                        catch (IOException var10_21) {
                            FFDCFilter.processException((Throwable)var10_21, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"420", (Object)this, (Object[])new Object[]{e});
                        }
                    }
                    return targetLastModified;
                }
                f = targetOutputFile;
                fos = null;
                fos = Utils.getOutputStream(f, false);
                i = new BufferedInputStream(i);
                buf = new byte[1024];
                while ((len = i.read(buf)) > 0) {
                    fos.write(buf, 0, len);
                }
                fos.close();
                fos = null;
                if (!Utils.setLastModified(f, e.getLastModified())) {
                    // empty if block
                }
                var13_18 = f;
                if (!creator) break block37;
                c.countDown();
                ZipFileContainer.cacheLocks.remove(lockKey);
            }
            if (fos != null) {
                fos.close();
            }
            if (i == null) break block38;
            try {
                i.close();
            }
            catch (IOException var14_20) {
                FFDCFilter.processException((Throwable)var14_20, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"420", (Object)this, (Object[])new Object[]{e});
            }
        }
        return var13_18;
        {
            catch (Throwable var15_24) {
                try {
                    if (creator) {
                        c.countDown();
                        ZipFileContainer.cacheLocks.remove(lockKey);
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    throw var15_24;
                }
                catch (Throwable var16_25) {
                    if (i != null) {
                        try {
                            i.close();
                        }
                        catch (IOException var17_26) {
                            FFDCFilter.processException((Throwable)var17_26, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"420", (Object)this, (Object[])new Object[]{e});
                        }
                    }
                    throw var16_25;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void setupArchiveFile() {
        if (this.archiveFile != null) {
            return;
        }
        try {
            this.archiveFile = this.extractEntryToCacheFile(this.thisInParent);
        }
        catch (IOException iOException) {
            void io;
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"436", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"extract.cache.fail", (Object[])new Object[]{io.getMessage()});
        }
    }

    NavigableMap<String, ZipEntry> listEntries() {
        if (this.allEntries != null) {
            return this.allEntries;
        }
        TreeMap<String, ZipEntry> zeMap = new TreeMap<String, ZipEntry>(PathUtils.PATH_COMPARATOR);
        this.setupArchiveFile();
        if (this.archiveFile != null) {
            this.populateListFromZipArchive(zeMap);
        }
        this.allEntries = zeMap;
        return zeMap;
    }

    private ZipFile openZipHandle(ZipFileHandle zfh) {
        try {
            return zfh.open();
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"475", (Object)this, (Object[])new Object[]{zfh});
            this.zipFileHandle = null;
            Tr.error((TraceComponent)tc, (String)"bad.zip.data", (Object[])new Object[]{this.archiveFile.getAbsolutePath()});
            return null;
        }
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    synchronized ZipFileHandle getZipFileHandle() throws IOException {
        if (this.zipFileHandle != null) {
            return this.zipFileHandle;
        }
        if (this.archiveFile == null) {
            this.setupArchiveFile();
        }
        if (this.archiveFile != null) {
            String path;
            block8: {
                path = this.archiveFile.getAbsolutePath();
                try {
                    if (System.getSecurityManager() == null) {
                        path = this.archiveFile.getCanonicalPath();
                        break block8;
                    }
                    final File f_archiveFile = this.archiveFile;
                    try {
                        path = AccessController.doPrivileged(new PrivilegedExceptionAction<String>(){
                            static final long serialVersionUID = 1191493626107080049L;
                            private static final /* synthetic */ TraceComponent $$$tc$$$;

                            @Override
                            public String run() throws IOException {
                                return f_archiveFile.getCanonicalPath();
                            }

                            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                            static {
                                $$$tc$$$ = Tr.register(1.class);
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        throw (IOException)e.getException();
                    }
                }
                catch (IOException f_archiveFile) {
                    FFDCFilter.processException((Throwable)f_archiveFile, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"515", (Object)this, (Object[])new Object[0]);
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)("Unable to resolve canonical path for " + path), (Object[])new Object[]{this.archiveFile});
                }
            }
            ZipFileHandle zfh = this.containerFactoryHolder.getZipCachingService().openZipFile(path);
            return zfh;
        }
        throw new FileNotFoundException(this.thisInParent.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateListFromZipArchive(NavigableMap<String, ZipEntry> zeMap) {
        block8: {
            try {
                ZipFileHandle zfh = this.getZipFileHandle();
                ZipFile useZipFile = this.openZipHandle(zfh);
                if (useZipFile == null) break block8;
                try {
                    Enumeration<? extends ZipEntry> entryEnum = useZipFile.entries();
                    while (entryEnum.hasMoreElements()) {
                        ZipEntry ze = entryEnum.nextElement();
                        String zeName = ze.getName();
                        if (ze.isDirectory()) {
                            zeName = zeName.substring(0, zeName.length() - 1);
                        }
                        zeMap.put(zeName, ze);
                    }
                }
                finally {
                    zfh.close();
                }
            }
            catch (IllegalStateException zfh) {
                FFDCFilter.processException((Throwable)zfh, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"565", (Object)this, (Object[])new Object[]{zeMap});
                this.zipFileHandle = null;
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"569", (Object)this, (Object[])new Object[]{zeMap});
                this.zipFileHandle = null;
            }
        }
    }

    public Iterator<ArtifactEntry> iterator() {
        if (this.allEntries == null) {
            this.allEntries = this.listEntries();
        }
        return new ZipFileEntryIterator(this, this, this.archiveFile, this.allEntries, this.getPath(), this.containerFactoryHolder);
    }

    public ArtifactContainer getEnclosingContainer() {
        return this.parent;
    }

    public ArtifactEntry getEntryInEnclosingContainer() {
        return this.thisInParent;
    }

    public String getPath() {
        return "/";
    }

    public String getName() {
        return "/";
    }

    public ArtifactEntry getEntry(String pathAndName) {
        return this.getEntry(pathAndName, false);
    }

    public ArtifactEntry getEntry(String pathAndName, boolean normalized) {
        boolean found;
        ZipEntry zipEntry;
        if (this.allEntries == null) {
            this.allEntries = this.listEntries();
        }
        if (pathAndName.equals("/") || pathAndName.equals("")) {
            return null;
        }
        if (pathAndName.endsWith("/")) {
            pathAndName = pathAndName.substring(0, pathAndName.length() - 1);
        }
        String absolutePathAndName = pathAndName;
        if (pathAndName.startsWith("/")) {
            pathAndName = pathAndName.substring(1);
        }
        if ((zipEntry = (ZipEntry)this.allEntries.get(pathAndName)) == null) {
            if (!normalized) {
                pathAndName = PathUtils.normalizeUnixStylePath((String)absolutePathAndName);
                normalized = true;
            }
            if (!PathUtils.isNormalizedPathAbsolute((String)pathAndName)) {
                return null;
            }
            if (pathAndName.equals("/") || pathAndName.equals("")) {
                return null;
            }
            absolutePathAndName = pathAndName;
            if (pathAndName.startsWith("/")) {
                pathAndName = pathAndName.substring(1);
            }
            zipEntry = (ZipEntry)this.allEntries.get(pathAndName);
        }
        boolean bl = found = zipEntry != null;
        if (zipEntry == null) {
            String higherKey = this.allEntries.higherKey(pathAndName);
            boolean bl2 = found = higherKey != null && higherKey.startsWith(pathAndName) && higherKey.length() > pathAndName.length() && higherKey.charAt(pathAndName.length()) == '/';
        }
        if (found) {
            String name = PathUtils.getName((String)pathAndName);
            if (!absolutePathAndName.startsWith("/")) {
                absolutePathAndName = '/' + absolutePathAndName;
            }
            ZipFileEntry ze = new ZipFileEntry(this, zipEntry, name, absolutePathAndName, this.archiveFile, this.allEntries, this.containerFactoryHolder);
            return ze;
        }
        return null;
    }

    public ArtifactContainer getRoot() {
        return this;
    }

    public Collection<URL> getURLs() {
        this.setupArchiveFile();
        if (this.archiveFile != null) {
            try {
                URL zipUrl = this.archiveFile.toURI().toURL();
                return Collections.singleton(zipUrl);
            }
            catch (MalformedURLException malformedURLException) {
                FFDCFilter.processException((Throwable)malformedURLException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer", (String)"705", (Object)this, (Object[])new Object[0]);
            }
        }
        return Collections.emptySet();
    }

    URI createEntryUri(final String path, final File jarFile) {
        URI zipUri = AccessController.doPrivileged(new PrivilegedAction<URI>(){
            static final long serialVersionUID = 1566510929448434426L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public URI run() {
                String updatedPath = path;
                updatedPath = updatedPath.startsWith("/") && updatedPath.length() > 1 ? updatedPath.substring(1) : "";
                URI parentUri = jarFile.toURI();
                if (parentUri != null) {
                    String uriString = ZipFileContainer.this.getProtocol() + ":" + parentUri.toString() + "!/" + ParserUtils.encode((String)updatedPath);
                    try {
                        return new URI(uriString);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        FFDCFilter.processException((Throwable)uRISyntaxException, (String)"com.ibm.ws.artifact.zip.internal.ZipFileContainer$2", (String)"748", (Object)this, (Object[])new Object[0]);
                    }
                }
                return null;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(2.class);
            }
        });
        return zipUri;
    }

    private String getProtocol() {
        if (this.containerFactoryHolder.useJarUrls()) {
            return "jar";
        }
        return "wsjar";
    }

    public String getPhysicalPath() {
        if (this.archiveFile != null) {
            return this.archiveFile.getAbsolutePath();
        }
        if (this.allEntries == null) {
            this.allEntries = this.listEntries();
        }
        if (this.archiveFile != null) {
            return this.archiveFile.getAbsolutePath();
        }
        return null;
    }

    File getCacheDir() {
        return this.cacheDir;
    }

    public ArtifactNotifier getArtifactNotifier() {
        return this.artifactNotifier;
    }

    public boolean isRoot() {
        return true;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    private class FastModeLock {
        static final long serialVersionUID = 4802073794035911189L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private FastModeLock() {
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(FastModeLock.class);
        }
    }
}

