/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.concurrent.persistent.serializable;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.concurrent.persistent.internal.PersistentExecutorImpl;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TaskFailure
implements Serializable {
    private static final long serialVersionUID = -3056770769390754606L;
    private static final TraceComponent tc = Tr.register(TaskFailure.class);
    public static final short FAILURE_LIMIT_REACHED = 1;
    public static final short NONSER_RESULT = 2;
    private static final String FAILURE = "F";
    private static final String PARAMS = "P";
    private static final String REASON = "R";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("F", Throwable.class), new ObjectStreamField("P", String[].class), new ObjectStreamField("R", Short.TYPE)};
    private transient Throwable failure;
    private transient String[] params;
    private transient short reason;

    @FFDCIgnore(value={Throwable.class})
    public TaskFailure(Throwable failure, ClassLoader loader, PersistentExecutorImpl persistentExecutor, short reason, String ... params) {
        block7: {
            this.reason = reason;
            this.params = params;
            if (failure != null) {
                try {
                    persistentExecutor.deserialize(persistentExecutor.serialize(failure), loader);
                }
                catch (Throwable x) {
                    if (params.length == 0) {
                        this.params = new String[]{failure.getClass().getName()};
                    }
                    Throwable previous = null;
                    for (Throwable cause = failure; cause != null; cause = cause.getCause()) {
                        RuntimeException current = new RuntimeException(cause.getClass().getName() + ": " + cause.getMessage());
                        current.setStackTrace(cause.getStackTrace());
                        if (previous == null) {
                            failure = current;
                        } else {
                            previous.initCause(current);
                        }
                        previous = current;
                    }
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block7;
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"serialize of failure failed", (Object[])new Object[]{x});
                    Tr.debug((Object)this, (TraceComponent)tc, (String)"replace with", (Object[])new Object[]{failure});
                }
            }
        }
        this.failure = failure;
    }

    public final Throwable getCause() {
        return this.failure;
    }

    public final String getParameter(int index) {
        return this.params.length > 0 ? this.params[index] : null;
    }

    @Trivial
    public final short getReason() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"getReason", (Object[])new Object[]{TaskFailure.toString(this.reason)});
        }
        return this.reason;
    }

    @Trivial
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.failure = (Throwable)fields.get(FAILURE, null);
        this.params = (String[])fields.get(PARAMS, new String[0]);
        this.reason = fields.get(REASON, (short)0);
    }

    @Trivial
    private static final String toString(short reason) {
        switch (reason) {
            case 1: {
                return "FAILURE_LIMIT_REACHED";
            }
            case 2: {
                return "NONSER_RESULT";
            }
        }
        return null;
    }

    @Trivial
    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put(FAILURE, this.failure);
        fields.put(PARAMS, this.params);
        fields.put(REASON, this.reason);
        out.writeFields();
    }
}

