/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.FFDCSelfIntrospectable;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.DSConfig;
import com.ibm.ws.rsadapter.FFDCLogger;
import com.ibm.ws.rsadapter.exceptions.DataStoreAdapterException;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.impl.WSStateManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicReference;
import javax.resource.ResourceException;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.LocalTransactionException;

public class WSRdbSpiLocalTransactionImpl
implements LocalTransaction,
FFDCSelfIntrospectable {
    private static final Class<?> currClass = WSRdbSpiLocalTransactionImpl.class;
    private static final TraceComponent tc = Tr.register(currClass, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");
    private final Connection ivConnection;
    private final WSRdbManagedConnectionImpl ivMC;
    private final WSStateManager ivStateManager;
    private final AtomicReference<DSConfig> dsConfig;

    public WSRdbSpiLocalTransactionImpl(WSRdbManagedConnectionImpl mc, Connection conn) {
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"<init>", (Object[])new Object[]{mc, conn});
        }
        this.ivMC = mc;
        this.ivConnection = conn;
        this.ivStateManager = this.ivMC.stateMgr;
        this.dsConfig = mc.mcf.dsConfig;
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"<init>", (Object)this);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void begin() throws ResourceException {
        block16: {
            block17: {
                ResourceException re;
                block15: {
                    if (tc.isEntryEnabled()) {
                        Tr.entry((Object)this, (TraceComponent)tc, (String)"begin", (Object[])new Object[]{this.ivMC});
                    }
                    if (this.ivMC._mcStale) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((Object)this, (TraceComponent)tc, (String)"MC is stale", (Object[])new Object[0]);
                        }
                        throw new DataStoreAdapterException("INVALID_CONNECTION", AdapterUtil.staleX(), WSRdbSpiLocalTransactionImpl.class, new Object[0]);
                    }
                    if (this.dsConfig.get().enableMultithreadedAccessDetection) {
                        this.ivMC.detectMultithreadedAccess();
                    }
                    if (!this.ivMC.isTransactional()) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((Object)this, (TraceComponent)tc, (String)"begin", (Object)"no-op.  Enlistment disabled");
                        }
                        return;
                    }
                    if (tc.isDebugEnabled()) {
                        String cId = null;
                        try {
                            cId = this.ivMC.mcf.getCorrelator(this.ivMC);
                        }
                        catch (SQLException x) {
                            Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator, exception is: ", (Object[])new Object[]{x});
                        }
                        if (cId != null) {
                            StringBuffer stbuf = new StringBuffer(200);
                            stbuf.append("Correlator: DB2, ID: ");
                            stbuf.append(cId);
                            stbuf.append(" Transaction : ");
                            stbuf.append(this);
                            stbuf.append(" BEGIN");
                            Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
                        }
                    }
                    if ((re = this.ivStateManager.isValid(1)) != null) break block15;
                    try {
                        if (this.ivMC.getAutoCommit()) {
                            this.ivMC.setAutoCommit(false);
                        }
                    }
                    catch (SQLException sqle) {
                        FFDCFilter.processException((Throwable)sqle, (String)(currClass.getName() + ".begin"), (String)"126", (Object)this);
                        throw new DataStoreAdapterException("DSA_ERROR", sqle, currClass, new Object[0]);
                    }
                    this.ivStateManager.transtate = 1;
                    if (!tc.isEventEnabled()) break block16;
                    break block17;
                }
                LocalTransactionException local_tran_excep = new LocalTransactionException(re.getMessage());
                DataStoreAdapterException dsae = new DataStoreAdapterException("WS_INTERNAL_ERROR", (Throwable)local_tran_excep, currClass, "Cannot start SPI local transaction.", "", local_tran_excep.getMessage());
                FFDCFilter.processException((Throwable)((Object)dsae), (String)"com.ibm.ws.rsadapter.spi.WSRdbSpiLocalTransactionImpl.begin", (String)"127", (Object)this, (Object[])new Object[]{"Possible components: WebSphere J2C Implementation"});
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"begin", (Object)"Exception");
                }
                throw dsae;
            }
            Tr.event((TraceComponent)tc, (String)("SpiLocalTransaction started.  ManagedConnection state is " + this.ivMC.getTransactionStateAsString()), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"begin");
        }
    }

    public void commit() throws ResourceException {
        ResourceException re;
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"commit", (Object[])new Object[]{this.ivMC});
        }
        if (this.ivMC._mcStale) {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"MC is stale", (Object[])new Object[0]);
            }
            throw new DataStoreAdapterException("INVALID_CONNECTION", AdapterUtil.staleX(), WSRdbSpiLocalTransactionImpl.class, new Object[0]);
        }
        if (this.dsConfig.get().enableMultithreadedAccessDetection) {
            this.ivMC.detectMultithreadedAccess();
        }
        if (!this.ivMC.isTransactional()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)"no-op.  Enlistment disabled");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            String cId = null;
            try {
                cId = this.ivMC.mcf.getCorrelator(this.ivMC);
            }
            catch (SQLException x) {
                Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator, exception is: ", (Object[])new Object[]{x});
            }
            if (cId != null) {
                StringBuffer stbuf = new StringBuffer(200);
                stbuf.append("Correlator: DB2, ID: ");
                stbuf.append(cId);
                stbuf.append(" Transaction : ");
                stbuf.append(this);
                stbuf.append(" COMMIT");
                Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
            }
        }
        if ((re = this.ivStateManager.isValid(2)) == null) {
            try {
                this.ivConnection.commit();
                this.ivStateManager.transtate = 0;
            }
            catch (SQLException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.rsadapter.spi.WSRdbSpiLocalTransactionImpl.commit", (String)"139", (Object)this);
                ResourceException x = AdapterUtil.translateSQLException(se, this.ivMC, true, currClass);
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)"Exception");
                }
                throw x;
            }
        } else {
            LocalTransactionException local_tran_excep = new LocalTransactionException(re.getMessage());
            DataStoreAdapterException ds = new DataStoreAdapterException("WS_INTERNAL_ERROR", (Throwable)local_tran_excep, currClass, "Cannot commit SPI local transaction.", "", local_tran_excep.getMessage());
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"commit", (Object)"Exception");
            }
            throw ds;
        }
        this.ivMC.wasLazilyEnlistedInGlobalTran = false;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("SPILocalTransaction committed. ManagedConnection state is " + this.ivMC.getTransactionStateAsString()), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"commit");
        }
    }

    public final String[] introspectSelf() {
        return this.ivMC.introspectSelf();
    }

    void introspectThisClassOnly(FFDCLogger info) {
        info.createFFDCHeader(this);
        info.append("Connection:", AdapterUtil.toString(this.ivConnection));
        info.append("ManagedConnection:", this.ivMC);
    }

    public void rollback() throws ResourceException {
        ResourceException re;
        if (tc.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)tc, (String)"rollback", (Object[])new Object[]{this.ivMC});
        }
        if (this.ivMC._mcStale) {
            if (tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"MC is stale", (Object[])new Object[0]);
            }
            throw new DataStoreAdapterException("INVALID_CONNECTION", AdapterUtil.staleX(), WSRdbSpiLocalTransactionImpl.class, new Object[0]);
        }
        if (!this.ivMC.isTransactional()) {
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"no-op.  Enlistment disabled");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            String cId = null;
            try {
                cId = this.ivMC.mcf.getCorrelator(this.ivMC);
            }
            catch (SQLException x) {
                Tr.debug((TraceComponent)tc, (String)"got an exception trying to get the correlator, exception is: ", (Object[])new Object[]{x});
            }
            if (cId != null) {
                StringBuffer stbuf = new StringBuffer(200);
                stbuf.append("Correlator: DB2, ID: ");
                stbuf.append(cId);
                stbuf.append(" Transaction : ");
                stbuf.append(this);
                stbuf.append("ROLLBACK");
                Tr.debug((Object)this, (TraceComponent)tc, (String)stbuf.toString(), (Object[])new Object[0]);
            }
        }
        if ((re = this.ivStateManager.isValid(3)) == null) {
            try {
                this.ivConnection.rollback();
                this.ivStateManager.transtate = 0;
            }
            catch (SQLException se) {
                FFDCFilter.processException((Throwable)se, (String)"com.ibm.ws.rsadapter.spi.WSRdbSpiLocalTransactionImpl.rollback", (String)"192", (Object)this);
                ResourceException resX = AdapterUtil.translateSQLException(se, this.ivMC, true, currClass);
                if (tc.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"Exception");
                }
                throw resX;
            }
        } else {
            LocalTransactionException local_tran_excep = new LocalTransactionException(re.getMessage());
            DataStoreAdapterException dsae = new DataStoreAdapterException("WS_INTERNAL_ERROR", (Throwable)local_tran_excep, currClass, "Cannot rollback SPI local transaction.", "", local_tran_excep.getMessage());
            FFDCFilter.processException((Throwable)((Object)dsae), (String)"com.ibm.ws.rsadapter.spi.WSRdbSpiLocalTransactionImpl.rollback", (String)"291", (Object)this, (Object[])new Object[]{" Possible components: WebSphere J2C Implementation"});
            if (tc.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback", (Object)"Exception");
            }
            throw dsae;
        }
        this.ivMC.wasLazilyEnlistedInGlobalTran = false;
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("SpiLocalTransaction rolled back.  ManagedConnection state is " + this.ivMC.getTransactionStateAsString()), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)tc, (String)"rollback");
        }
    }
}

