/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.jdbc;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.impl.WSManagedConnectionFactoryImpl;
import com.ibm.ws.rsadapter.impl.WSRdbManagedConnectionImpl;
import com.ibm.ws.rsadapter.jdbc.WSJdbcConnection;
import com.ibm.ws.rsadapter.jdbc.WSJdbcObject;
import com.ibm.ws.rsadapter.jdbc.WSJdbcWrapper;
import java.sql.SQLException;

public class WSJdbcUtil {
    private static final TraceComponent tc = Tr.register(WSJdbcUtil.class, (String)"RRA", (String)"com.ibm.ws.rsadapter.resources.IBMDataStoreAdapterNLS");

    public static void handleStaleStatement(WSJdbcWrapper jdbcWrapper) {
        block5: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)("Encountered a Stale Statement: " + jdbcWrapper), (Object[])new Object[0]);
            }
            if (jdbcWrapper instanceof WSJdbcObject) {
                try {
                    WSJdbcConnection connWrapper = (WSJdbcConnection)((WSJdbcObject)jdbcWrapper).getConnectionWrapper();
                    WSRdbManagedConnectionImpl mc = connWrapper.managedConn;
                    connWrapper.markStmtsAsNotPoolable();
                    if (mc != null) {
                        mc.clearStatementCache();
                    }
                }
                catch (NullPointerException nullX) {
                    if (((WSJdbcObject)jdbcWrapper).isClosed()) break block5;
                    throw nullX;
                }
            }
        }
    }

    public static SQLException mapException(WSJdbcWrapper jdbcWrapper, SQLException sqlX) {
        WSManagedConnectionFactoryImpl mapper = null;
        WSJdbcConnection connWrapper = null;
        if (jdbcWrapper instanceof WSJdbcObject) {
            connWrapper = (WSJdbcConnection)((WSJdbcObject)jdbcWrapper).getConnectionWrapper();
            if (connWrapper != null) {
                mapper = connWrapper.isClosed() ? connWrapper.mcf : connWrapper.managedConn;
            }
        } else {
            mapper = jdbcWrapper.mcf;
        }
        return (SQLException)AdapterUtil.mapException(sqlX, connWrapper, (Object)mapper, true);
    }
}

