/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.el.ELContext;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import org.apache.el.util.MessageFactory;
import org.apache.el.util.ReflectionUtil;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
public final class ValueExpressionLiteral
extends ValueExpression
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private Object value;
    private Class<?> expectedType;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ValueExpressionLiteral() {
    }

    public ValueExpressionLiteral(Object value, Class<?> expectedType) {
        this.value = value;
        this.expectedType = expectedType;
    }

    public Object getValue(ELContext context) {
        context.notifyBeforeEvaluation(this.getExpressionString());
        Object result = this.expectedType != null ? context.convertToType(this.value, this.expectedType) : this.value;
        context.notifyAfterEvaluation(this.getExpressionString());
        return result;
    }

    public void setValue(ELContext context, Object value) {
        context.notifyBeforeEvaluation(this.getExpressionString());
        throw new PropertyNotWritableException(MessageFactory.get("error.value.literal.write", this.value));
    }

    public boolean isReadOnly(ELContext context) {
        context.notifyBeforeEvaluation(this.getExpressionString());
        context.notifyAfterEvaluation(this.getExpressionString());
        return true;
    }

    public Class<?> getType(ELContext context) {
        context.notifyBeforeEvaluation(this.getExpressionString());
        Class<?> result = this.value != null ? this.value.getClass() : null;
        context.notifyAfterEvaluation(this.getExpressionString());
        return result;
    }

    public Class<?> getExpectedType() {
        return this.expectedType;
    }

    public String getExpressionString() {
        return this.value != null ? this.value.toString() : null;
    }

    public boolean equals(Object obj) {
        return obj instanceof ValueExpressionLiteral && this.equals((ValueExpressionLiteral)obj);
    }

    public boolean equals(ValueExpressionLiteral ve) {
        return ve != null && this.value != null && ve.value != null && (this.value == ve.value || this.value.equals(ve.value));
    }

    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }

    public boolean isLiteralText() {
        return true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.value);
        out.writeUTF(this.expectedType != null ? this.expectedType.getName() : "");
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.value = in.readObject();
        String type = in.readUTF();
        if (!"".equals(type)) {
            this.expectedType = ReflectionUtil.forName(type);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ValueExpressionLiteral.class);
    }
}

