/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.utils.metagen;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jca.utils.xml.metatype.MetatypeOcd;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
class ChildAliasSelector {
    private final Map<MetatypeOcd, List<String>> rankings = new HashMap<MetatypeOcd, List<String>>();
    private final Map<String, MetatypeOcd> unavailableSuffixes = new HashMap<String, MetatypeOcd>();
    static final long serialVersionUID = -843958570496794750L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    ChildAliasSelector() {
    }

    void assign(String raIdentifier, String baseChildAliasName) {
        for (Map.Entry<MetatypeOcd, List<String>> entry : this.rankings.entrySet()) {
            MetatypeOcd ocd = entry.getKey();
            String suffix = null;
            if (entry.getValue() != null && !entry.getValue().isEmpty()) {
                suffix = entry.getValue().get(0);
            }
            if (suffix == null || suffix.length() == 0) {
                ocd.setExtendsAlias(baseChildAliasName);
            } else {
                ocd.setExtendsAlias(baseChildAliasName + '.' + suffix);
            }
            if (ocd.getName() != null) continue;
            if (suffix == null || suffix.length() == 0) {
                ocd.setName(raIdentifier + " Properties");
                continue;
            }
            ocd.setName(raIdentifier + ' ' + suffix + " Properties");
        }
    }

    void rank(MetatypeOcd ocd, List<String> rankedSuffixes) {
        LinkedList<String> childAliasSuffixes = new LinkedList<String>();
        for (String suffix : rankedSuffixes) {
            if (childAliasSuffixes.contains(suffix)) continue;
            MetatypeOcd collision = this.unavailableSuffixes.put(suffix, ocd);
            if (collision == null) {
                childAliasSuffixes.add(suffix);
                continue;
            }
            List<String> suffixesForCollisionOCD = this.rankings.get(collision);
            if (suffixesForCollisionOCD == null) continue;
            suffixesForCollisionOCD.remove(suffix);
        }
        this.rankings.put(ocd, childAliasSuffixes);
    }

    void reserve(String suffix, MetatypeOcd ocd) {
        MetatypeOcd previous = this.unavailableSuffixes.put(suffix, ocd);
        if (previous != null) {
            throw new IllegalArgumentException("aliasSuffix: " + suffix);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ChildAliasSelector.class);
    }
}

