/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.mp.jwt.impl.utils.ClaimsUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class DefaultJsonWebTokenImpl
implements JsonWebToken,
Serializable {
    private static TraceComponent tc = Tr.register(DefaultJsonWebTokenImpl.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    private static final long serialVersionUID = 1L;
    private static final String PRINCIPAL = "principal";
    private static final String JWT = "jwt";
    private static final String TYPE = "type";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("principal", String.class), new ObjectStreamField("jwt", String.class), new ObjectStreamField("type", String.class)};
    public static final char SERVICE_NAME_SEPARATOR = ';';
    private transient String principal;
    private transient String jwt;
    private transient String type;
    private JwtClaims claimsSet;
    private ClaimsUtils claimsUtils = new ClaimsUtils();

    @ManualTrace
    public DefaultJsonWebTokenImpl(String jwt, String type, String name) {
        String methodName = "<init>";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{jwt, type, name});
        }
        this.jwt = jwt;
        this.type = type;
        this.principal = name;
        this.handleClaims(jwt);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName);
        }
    }

    public final JsonWebToken clone() {
        return new DefaultJsonWebTokenImpl(this.jwt, this.type, this.principal);
    }

    /*
     * WARNING - void declaration
     */
    private void handleClaims(String jwt) {
        try {
            if (this.claimsUtils == null) {
                this.claimsUtils = new ClaimsUtils();
            }
            this.claimsSet = this.claimsUtils.getJwtClaims(jwt);
        }
        catch (JoseException joseException) {
            void e;
            FFDCFilter.processException((Throwable)joseException, (String)"com.ibm.ws.security.mp.jwt.impl.DefaultJsonWebTokenImpl", (String)"98", (Object)this, (Object[])new Object[]{jwt});
            Tr.error((TraceComponent)tc, (String)"ERROR_GETTING_CLAIMS_FROM_JWT_STRING", (Object[])new Object[]{e.getLocalizedMessage()});
        }
    }

    public <T> Optional<T> claim(String claimName) {
        Object claim = this.getClaim(claimName);
        return Optional.ofNullable(claim);
    }

    @FFDCIgnore(value={IllegalArgumentException.class})
    public Object getClaim(String claimName) {
        Claims claimType = Claims.UNKNOWN;
        Object claim = null;
        try {
            claimType = Claims.valueOf((String)claimName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (claimType) {
            case exp: 
            case iat: 
            case auth_time: 
            case nbf: 
            case updated_at: {
                try {
                    claim = this.claimsSet.getClaimValue(claimType.name(), Long.class);
                    if (claim != null) break;
                    claim = new Long(0L);
                }
                catch (MalformedClaimException malformedClaimException) {
                    FFDCFilter.processException((Throwable)malformedClaimException, (String)"com.ibm.ws.security.mp.jwt.impl.DefaultJsonWebTokenImpl", (String)"138", (Object)this, (Object[])new Object[]{claimName});
                }
                break;
            }
            case groups: {
                claim = this.getGroups();
                break;
            }
            case aud: {
                claim = this.getAudience();
                break;
            }
            case UNKNOWN: {
                claim = this.claimsSet.getClaimValue(claimName);
                break;
            }
            default: {
                claim = this.claimsSet.getClaimValue(claimType.name());
            }
        }
        return claim;
    }

    public String toString() {
        return this.claimsSet.toJson();
    }

    public Set<String> getClaimNames() {
        return new HashSet<String>(this.claimsSet.getClaimNames());
    }

    public String getName() {
        return this.principal;
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> getAudience() {
        HashSet<String> audSet = new HashSet<String>();
        try {
            List audList = this.claimsSet.getStringListClaimValue("aud");
            if (audList != null) {
                audSet.addAll(audList);
            }
        }
        catch (MalformedClaimException audList) {
            FFDCFilter.processException((Throwable)audList, (String)"com.ibm.ws.security.mp.jwt.impl.DefaultJsonWebTokenImpl", (String)"182", (Object)this, (Object[])new Object[0]);
            try {
                String aud = this.claimsSet.getStringClaimValue("aud");
                audSet.add(aud);
            }
            catch (MalformedClaimException aud) {
                void e;
                FFDCFilter.processException((Throwable)aud, (String)"com.ibm.ws.security.mp.jwt.impl.DefaultJsonWebTokenImpl", (String)"186", (Object)this, (Object[])new Object[0]);
                Tr.warning((TraceComponent)tc, (String)"CLAIM_MALFORMED", (Object[])new Object[]{"aud", e.getLocalizedMessage()});
            }
        }
        return audSet;
    }

    /*
     * WARNING - void declaration
     */
    public Set<String> getGroups() {
        HashSet<String> groups = new HashSet<String>();
        try {
            List globalGroups = this.claimsSet.getStringListClaimValue("groups");
            if (globalGroups != null) {
                groups.addAll(globalGroups);
            }
        }
        catch (MalformedClaimException globalGroups) {
            void e;
            FFDCFilter.processException((Throwable)globalGroups, (String)"com.ibm.ws.security.mp.jwt.impl.DefaultJsonWebTokenImpl", (String)"201", (Object)this, (Object[])new Object[0]);
            Tr.warning((TraceComponent)tc, (String)"CLAIM_MALFORMED", (Object[])new Object[]{"groups", e.getLocalizedMessage()});
        }
        return groups;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this.principal = (String)fields.get(PRINCIPAL, null);
        this.jwt = (String)fields.get(JWT, null);
        this.type = (String)fields.get(TYPE, null);
        this.handleClaims(this.jwt);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put(PRINCIPAL, this.principal);
        fields.put(JWT, this.jwt);
        fields.put(TYPE, this.type);
        out.writeFields();
    }
}

