/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.mp.jwt.tai;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.jwt.JwtConsumer;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.mp.jwt.error.MpJwtProcessingException;
import com.ibm.ws.security.mp.jwt.impl.DefaultJsonWebTokenImpl;
import java.util.ArrayList;
import org.eclipse.microprofile.jwt.JsonWebToken;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class TAIJwtUtils {
    private static TraceComponent tc = Tr.register(TAIJwtUtils.class, (String)"MPJWT", (String)"com.ibm.ws.security.mp.jwt.resources.MicroProfileJwtMessages");
    public static final String TYPE_JWT_TOKEN = "Json Web Token";
    static final long serialVersionUID = -5203365654697477190L;

    protected TAIJwtUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @ManualTrace
    public JwtToken createJwt(@Sensitive String idToken, String jwtConfigId) throws MpJwtProcessingException {
        String methodName = "createJwt";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{idToken, jwtConfigId});
        }
        try {
            JwtToken token = JwtConsumer.create((String)jwtConfigId).createJwt(idToken);
            if (tc.isDebugEnabled()) {
                Tr.exit((TraceComponent)tc, (String)methodName, (Object)token);
            }
            return token;
        }
        catch (Exception token) {
            void e;
            Object[] objectArray = new Object[2];
            objectArray[0] = "<sensitive java.lang.String>";
            objectArray[1] = jwtConfigId;
            FFDCFilter.processException((Throwable)token, (String)"com.ibm.ws.security.mp.jwt.tai.TAIJwtUtils", (String)"47", (Object)this, (Object[])objectArray);
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ERROR_CREATING_JWT", (Object[])new Object[]{jwtConfigId, e.getLocalizedMessage()});
            Tr.error((TraceComponent)tc, (String)msg, (Object[])new Object[0]);
            throw new MpJwtProcessingException(msg, (Throwable)e);
        }
    }

    @Sensitive
    @ManualTrace
    public JsonWebToken createJwtPrincipal(String username, ArrayList<String> groups, @Sensitive JwtToken jwtToken) {
        String methodName = "createJwtPrincipal";
        if (tc.isDebugEnabled()) {
            Tr.entry((TraceComponent)tc, (String)methodName, (Object[])new Object[]{username, groups, jwtToken});
        }
        String compact = null;
        String type = TYPE_JWT_TOKEN;
        if (jwtToken != null) {
            compact = jwtToken.compact();
            type = (String)jwtToken.getClaims().get((Object)"token_type");
        }
        DefaultJsonWebTokenImpl token = new DefaultJsonWebTokenImpl(compact, type, username);
        if (tc.isDebugEnabled()) {
            Tr.exit((TraceComponent)tc, (String)methodName, (Object)token);
        }
        return token;
    }
}

