/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.ldap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.websphere.security.wim.ras.WIMTraceHelper;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.adapter.ldap.Filter;
import com.ibm.ws.security.wim.adapter.ldap.LdapAttribute;
import com.ibm.ws.security.wim.adapter.ldap.LdapEntity;
import com.ibm.ws.security.wim.adapter.ldap.LdapHelper;
import com.ibm.ws.security.wim.util.NodeHelper;
import com.ibm.ws.security.wim.util.StringLengthComparator;
import com.ibm.ws.security.wim.util.UniqueNameHelper;
import com.ibm.wsspi.security.wim.exception.CertificateMapperException;
import com.ibm.wsspi.security.wim.exception.EntityTypeNotSupportedException;
import com.ibm.wsspi.security.wim.exception.InitializationException;
import com.ibm.wsspi.security.wim.exception.InvalidInitPropertyException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.exception.WIMSystemException;
import com.ibm.wsspi.security.wim.model.Entity;
import com.ibm.wsspi.security.wim.model.Group;
import com.ibm.wsspi.security.wim.model.LangType;
import com.ibm.wsspi.security.wim.model.Person;
import com.ibm.wsspi.security.wim.model.PersonAccount;
import java.io.UnsupportedEncodingException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LdapConfigManager {
    private static final String GROUP_PROPERTIES = "groupProperties";
    private static final String LDAP_ENTITY_TYPE = "ldapEntityType";
    private static final TraceComponent tc = Tr.register(LdapConfigManager.class);
    static final String BASE_ENTRY_NAME = "name";
    static final String BASE_ENTRY = "registryBaseEntry";
    static final String BASE_DN = "baseDN";
    private static final Pattern PATTERN_EXTENSIBLE_MATCH_FILTER = Pattern.compile("(.+):(.+):(.*)");
    public MessageFormat[] CONDITION_FORMATS = new MessageFormat[]{new MessageFormat("({0}={1})"), new MessageFormat("(!({0}={1}))"), new MessageFormat("(&({0}>={1})(!({0}={1})))"), new MessageFormat("(&({0}<={1})(!({0}={1})))"), new MessageFormat("({0}>={1})"), new MessageFormat("({0}<={1})")};
    private String iMembershipAttrName;
    private boolean iUseDefaultMbrAttr = false;
    private String iLdapType = null;
    private short iMembershipAttrScope = 0;
    private String[] iDynaMbrAttrs = null;
    private List<String> iLdapEntityTypeList = null;
    private Map<String, String> iPropToAttrMap = null;
    private Map<String, Set<String>> iAttrToPropMap = null;
    private Map<String, LdapAttribute> iAttrNameToAttrMap = null;
    private List<LdapEntity> iLdapEntities = null;
    private List<String> iPersonAccountTypes = null;
    private List<String> iPersonTypes = null;
    private List<String> iGroupTypes = null;
    private final char[] iSpecialChars = new char[]{'(', ')', '\\'};
    private String useEncodingInSearchExpression = null;
    private String iGrpMbrFilter = null;
    private String[] iGroupSearchBases = null;
    private String[] iNodesForCompare = null;
    private String[] iLdapNodes = null;
    private boolean iNeedSwitchNode = false;
    private boolean iNeedTranslateRDN = false;
    private Map<String, String> iDynaMbrAttrMap = null;
    private final List<String> iDynaMbrObjectClass = new ArrayList<String>();
    private boolean iMbrAttrsNestedScope = false;
    private boolean iMbrAttrsAllScope = false;
    private String[] iTopLdapNodes = null;
    private String[] iMbrAttrs = null;
    private Map<String, String> iMbrAttrMap = null;
    private final boolean includeGroupInSearchEntityTypes = false;
    private Map<String, String> iDummyMbrMap;
    private List<String> iLoginAttrs = null;
    private List<String> iLoginProps = null;
    private String iCertMapMode = null;
    private String[] iCertFilterEles = null;
    private final boolean usePrincipalNameForLogin = false;
    private Set<String> iAttrs = null;
    private Set<String> iOperAttrs = null;
    private Set<String> iDefaultValueAttrs = null;
    private Set<String> iDefaultAttrAttrs = null;
    private List<String> iDataTypes = null;
    private final List<String> entityTypeProps = new ArrayList<String>();
    private Set<String> iExtIds = null;
    private Set<String> iConAttrs = null;
    private boolean isAnyExtIdDN = false;
    private String[] iLdapNodesForCompare = null;
    private String[] iNodes = null;
    private String iDynaGrpFilter = null;
    private short[] iMbrAttrScope;
    private final String[] iGroupSupportedProps = Group.getPropertyNames((String)"Group").toArray(new String[0]);
    private final String[] iPersonSupportedProps = PersonAccount.getPropertyNames((String)"PersonAccount").toArray(new String[0]);
    private String iUserFilter = null;
    private Filter userFilter = null;
    private String iGroupFilter = null;
    private Filter groupFilter = null;
    private String iUserIdMap = null;
    private String iGroupIdMap = null;
    private String iGroupMemberIdMap = null;
    private boolean iRecursiveSearch = false;
    private final String IBM_ALL_GROUPS = "ibm-allGroups";
    private boolean iLdapOperationalAttr = false;
    private boolean isVMMRdnPropertiesDefined = false;
    private boolean isRacf = false;
    private String timestampFormat;
    private boolean iDefaultMembershipAttr = true;
    static final long serialVersionUID = 6015435960722413902L;

    /*
     * WARNING - void declaration
     */
    public void initialize(Map<String, Object> configProps) throws WIMException {
        String METHODNAME = "initialize(configProps, configAdminRef)";
        this.iLdapType = (String)configProps.get("ldapType");
        this.iLdapType = this.iLdapType == null ? "IDS52" : this.iLdapType.toUpperCase();
        this.setCertificateMapMode((String)configProps.get("certificateMapMode"));
        if ("CERTIFICATE_FILTER".equalsIgnoreCase(this.getCertificateMapMode())) {
            this.setCertificateFilter((String)configProps.get("certificateFilter"));
        }
        ArrayList<HashMap<String, String>> baseEntries = new ArrayList<HashMap<String, String>>();
        String baseDN = (String)configProps.get(BASE_DN);
        String name = (String)configProps.get(BASE_ENTRY_NAME);
        HashMap<String, String> baseEntryMap = new HashMap<String, String>();
        if (name != null) {
            baseEntryMap.put(name, baseDN);
        } else {
            baseEntryMap.put(baseDN, baseDN);
        }
        baseEntries.add(baseEntryMap);
        Map<String, List<Map<String, Object>>> configMap = Nester.nest(configProps, BASE_ENTRY, LDAP_ENTITY_TYPE, GROUP_PROPERTIES);
        for (Map<String, Object> entry : configMap.get(BASE_ENTRY)) {
            baseDN = (String)entry.get(BASE_DN);
            name = (String)entry.get(BASE_ENTRY_NAME);
            if (baseDN == null || baseDN.trim().length() == 0) {
                Tr.error((TraceComponent)tc, (String)"INVALID_BASE_ENTRY_DEFINITION", (Object[])new Object[]{name});
                continue;
            }
            baseEntryMap = new HashMap();
            if (name != null) {
                baseEntryMap.put(name, baseDN);
            } else {
                baseEntryMap.put(baseDN, baseDN);
            }
            baseEntries.add(baseEntryMap);
        }
        this.timestampFormat = configProps.containsKey("timestampFormat") ? (String)configProps.get("timestampFormat") : null;
        this.setNodes(baseEntries);
        this.setLDAPEntities(configMap.get(LDAP_ENTITY_TYPE), baseEntries);
        List<Map<String, Object>> groupPropList = configMap.get(GROUP_PROPERTIES);
        Map<String, Object> groupProps = groupPropList.isEmpty() ? Collections.emptyMap() : groupPropList.get(0);
        this.setMemberAttributes(groupProps);
        this.setMembershipAttribute(groupProps);
        this.setDynaMemberAttributes(groupProps);
        this.setGroupSeachScope(configProps);
        this.setAttributes(configProps);
        this.setExtIdAttributes(configProps);
        this.setConfidentialAttributes();
        this.setLoginProperties((String)configProps.get("loginProperty"));
        this.setFilters(configProps);
        this.setGroupMemberFilter();
        this.useEncodingInSearchExpression = System.getProperty("useEncodingInSearchExpression");
        if (this.useEncodingInSearchExpression != null) {
            try {
                "string to test encoding".getBytes(this.useEncodingInSearchExpression);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConfigManager", (String)"541", (Object)this, (Object[])new Object[]{configProps});
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("initialize(configProps, configAdminRef) java.io.UnsupportedEncodingException: " + e.getMessage()), (Object[])new Object[0]);
                }
                this.useEncodingInSearchExpression = "ISO8859_1";
            }
        }
        this.entityTypeProps.add("parent");
        this.entityTypeProps.add("children");
        this.entityTypeProps.add("members");
        if (tc.isDebugEnabled()) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append(" LDAPServerType: ").append(this.iLdapType).append("\n");
            strBuf.append("Nodes: ").append(WIMTraceHelper.printObjectArray((Object[])this.iNodes)).append("\n");
            strBuf.append("ReposNodes: ").append(WIMTraceHelper.printObjectArray((Object[])this.iLdapNodes)).append("\n");
            strBuf.append("TopReposNodes: ").append(WIMTraceHelper.printObjectArray((Object[])this.iTopLdapNodes)).append("\n");
            strBuf.append("NeedSwitchNode: ").append(this.iNeedSwitchNode).append("\n");
            strBuf.append("LDAPEntities: ").append("\n");
            for (int i = 0; i < this.iLdapEntities.size(); ++i) {
                strBuf.append(this.iLdapEntities.get(i).toString());
            }
            strBuf.append("\r\nGroupMemberAttrs: ").append(this.iMbrAttrMap).append("memberAttrs: ").append(WIMTraceHelper.printObjectArray((Object[])this.iMbrAttrs)).append("scopes: ").append(WIMTraceHelper.printPrimitiveArray((Object)this.iMbrAttrScope)).append("\n");
            strBuf.append("GroupMemberFilter: ").append(this.iGrpMbrFilter).append("\n");
            strBuf.append("GroupDynaMemberAttrs: ").append(this.iDynaMbrAttrMap).append("\n");
            strBuf.append("DynaGroupFilter: ").append(this.iDynaGrpFilter).append("\n");
            strBuf.append("GroupMembershipAttrs: ").append(this.iMembershipAttrName).append(" scope: ").append(this.iMembershipAttrScope).append("\n");
            strBuf.append("PropToAttrMap: ").append(this.iPropToAttrMap).append("\n");
            strBuf.append("AttrToPropMap: ").append(this.iAttrToPropMap).append("\n");
            strBuf.append("ExtIds: ").append(this.iExtIds).append("\n");
            strBuf.append("AllAttrs: ").append(this.iAttrs).append("\n");
            strBuf.append("LoginAttrs: ").append(this.iLoginAttrs).append("\n");
            strBuf.append("iUserFilter: ").append(this.iUserFilter).append("\n");
            strBuf.append("iGroupFilter: ").append(this.iGroupFilter).append("\n");
            strBuf.append("iUserIdMap: ").append(this.iUserIdMap).append("\n");
            strBuf.append("iGroupIdMap: ").append(this.iGroupIdMap).append("\n");
            strBuf.append("iGroupMemberIdMap: ").append(this.iGroupMemberIdMap).append("\n");
            Tr.debug((TraceComponent)tc, (String)("initialize(configProps, configAdminRef)" + strBuf.toString()), (Object[])new Object[0]);
        }
    }

    private void setFilters(Map<String, Object> configProps) {
        if (this.iLdapType == null) {
            return;
        }
        String key = null;
        if (this.iLdapType.equalsIgnoreCase("MICROSOFT ACTIVE DIRECTORY")) {
            key = "activedFilters";
        } else if (this.iLdapType.equalsIgnoreCase("CUSTOM")) {
            key = "customFilters";
        } else if (this.iLdapType.equalsIgnoreCase("IBM LOTUS DOMINO")) {
            key = "domino50Filters";
        } else if (this.iLdapType.equalsIgnoreCase("NOVELL EDIRECTORY")) {
            key = "edirectoryFilters";
        } else if (this.iLdapType.equalsIgnoreCase("IBM TIVOLI DIRECTORY SERVER")) {
            key = "idsFilters";
        } else if (this.iLdapType.equalsIgnoreCase("SUN JAVA SYSTEM DIRECTORY SERVER")) {
            key = "iplanetFilters";
        } else if (this.iLdapType.equalsIgnoreCase("NETSCAPE DIRECTORY SERVER")) {
            key = "netscapeFilters";
        } else if (this.iLdapType.equalsIgnoreCase("IBM SECUREWAY DIRECTORY SERVER")) {
            key = "securewayFilters";
        } else {
            return;
        }
        List<Map<String, Object>> filterList = Nester.nest(key, configProps);
        if (!filterList.isEmpty()) {
            String[][] rdnProps;
            LdapEntity ldapEntity;
            StringTokenizer strtok;
            String objectClass;
            int endIndex;
            int index;
            HashSet<String> objClsSet;
            LdapEntity ldapEntity2;
            Map<String, Object> props = filterList.get(0);
            if (props.get("userFilter") != null) {
                this.iUserFilter = (String)props.get("userFilter");
            }
            if (props.get("groupFilter") != null) {
                this.iGroupFilter = (String)props.get("groupFilter");
            }
            if (props.get("userIdMap") != null) {
                this.iUserIdMap = (String)props.get("userIdMap");
            }
            if (props.get("groupIdMap") != null) {
                this.iGroupIdMap = (String)props.get("groupIdMap");
            }
            if (props.get("groupMemberIdMap") != null) {
                this.iGroupMemberIdMap = (String)props.get("groupMemberIdMap");
            }
            String objectClassStr = "objectclass=";
            if (this.iLdapType.equalsIgnoreCase("MICROSOFT ACTIVE DIRECTORY")) {
                objectClassStr = "objectcategory=";
            }
            int length = objectClassStr.length();
            if (this.iUserFilter != null) {
                ldapEntity2 = this.getLdapEntity("PersonAccount");
                if (ldapEntity2 != null) {
                    objClsSet = new HashSet<String>();
                    index = this.iUserFilter.indexOf(objectClassStr);
                    while (index > -1) {
                        endIndex = this.iUserFilter.indexOf(")", index);
                        objectClass = this.iUserFilter.substring(index + length, endIndex);
                        objClsSet.add(objectClass);
                        index = endIndex + 1;
                        index = this.iUserFilter.indexOf(objectClassStr, endIndex);
                    }
                    if (objClsSet.size() > 0) {
                        ldapEntity2.getObjectClasses().clear();
                        ldapEntity2.getObjectClasses().addAll(objClsSet);
                    }
                }
                if (this.iLoginAttrs != null) {
                    this.iLoginAttrs.remove(0);
                }
                if (this.iLoginProps != null) {
                    this.iLoginProps.remove(0);
                }
                String pattern = "=%v";
                int startIndex = 0;
                boolean hasLoginProperties = true;
                LdapEntity acct = this.getLdapEntity(this.iPersonAccountTypes.get(this.iPersonAccountTypes.size() - 1));
                while (hasLoginProperties) {
                    int index2;
                    if (index2 > -1) {
                        int beginIndex;
                        for (beginIndex = index2 = this.iUserFilter.indexOf(pattern, startIndex); beginIndex > 0 && this.iUserFilter.charAt(beginIndex) != ' ' && this.iUserFilter.charAt(beginIndex) != '('; --beginIndex) {
                        }
                        String propName = this.iUserFilter.substring(beginIndex + 1, index2);
                        if (this.iLoginAttrs != null && !this.iLoginAttrs.contains(propName)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("Setting login property from UserFilter as [" + propName + "]"), (Object[])new Object[0]);
                            }
                            this.iLoginAttrs.add(this.getAttributeName(acct, propName));
                            this.iLoginProps.add(propName);
                        }
                        startIndex = index2 + 1;
                        continue;
                    }
                    hasLoginProperties = false;
                }
                if (ldapEntity2 != null) {
                    ldapEntity2.addPropertyAttributeMap("principalName", this.iLoginAttrs.get(0));
                }
            }
            if (this.iGroupFilter != null && (ldapEntity2 = this.getLdapEntity("Group")) != null) {
                objClsSet = new HashSet();
                index = this.iGroupFilter.indexOf(objectClassStr);
                while (index > -1) {
                    endIndex = this.iGroupFilter.indexOf(")", index);
                    objectClass = this.iGroupFilter.substring(index + length, endIndex);
                    objClsSet.add(objectClass);
                    index = endIndex + 1;
                    index = this.iGroupFilter.indexOf(objectClassStr, endIndex);
                }
                if (objClsSet.size() > 0) {
                    ldapEntity2.getObjectClasses().clear();
                    ldapEntity2.getObjectClasses().addAll(objClsSet);
                }
            }
            if (this.iUserIdMap != null) {
                strtok = new StringTokenizer(this.iUserIdMap, ":;");
                ldapEntity = this.getLdapEntity("PersonAccount");
                if (ldapEntity != null) {
                    ArrayList<String> rdnPropList = new ArrayList<String>();
                    ArrayList<String> objClsList = new ArrayList<String>();
                    while (strtok.hasMoreTokens()) {
                        objectClass = strtok.nextToken();
                        String attribute = strtok.nextToken();
                        Set<String> propNames = null;
                        propNames = "samAccountName".equalsIgnoreCase(attribute) ? this.getPropertyName(ldapEntity, "cn") : this.getPropertyName(ldapEntity, attribute);
                        rdnPropList.add(propNames.iterator().next());
                        if ("*".equalsIgnoreCase(objectClass)) continue;
                        objClsList.add(objectClass);
                    }
                    if (rdnPropList.size() > 0) {
                        rdnProps = new String[rdnPropList.size()][];
                        String[][] rdnAttrs = new String[rdnPropList.size()][];
                        String[][] rdnObjCls = new String[objClsList.size()][];
                        String[] objCls = new String[objClsList.size()];
                        objCls = objClsList.toArray(objCls);
                        for (int j = 0; j < rdnPropList.size(); ++j) {
                            rdnProps[j] = LdapHelper.getRDNs((String)rdnPropList.get(j));
                            rdnAttrs[j] = new String[rdnProps[j].length];
                            for (int k = 0; k < rdnProps[j].length; ++k) {
                                String rdnProp = rdnProps[j][k];
                                rdnAttrs[j][k] = this.getAttributeName(ldapEntity, rdnProp);
                            }
                            if (objCls.length <= 0) continue;
                            rdnObjCls[j] = new String[objCls.length];
                            rdnObjCls[j][0] = objCls[j];
                        }
                        ldapEntity.setRDNProperties(rdnProps, rdnAttrs);
                        if (this.isVMMRdnPropertiesDefined) {
                            int j;
                            int i;
                            int len;
                            int j2;
                            int i2;
                            String[][] updatedRdnAttrs = null;
                            String[][] updatedRdnObjCls = null;
                            if (ldapEntity.getRDNAttributes().length > 0) {
                                String[][] orgRdnAttr = ldapEntity.getRDNAttributes();
                                updatedRdnAttrs = new String[orgRdnAttr.length + rdnAttrs.length][];
                                for (i2 = 0; i2 < orgRdnAttr.length; ++i2) {
                                    updatedRdnAttrs[i2] = new String[orgRdnAttr[i2].length];
                                    for (j2 = 0; j2 < orgRdnAttr[i2].length; ++j2) {
                                        updatedRdnAttrs[i2][j2] = orgRdnAttr[i2][j2];
                                    }
                                }
                                len = orgRdnAttr.length;
                                for (i = 0; i < rdnAttrs.length; ++i) {
                                    updatedRdnAttrs[len] = new String[rdnAttrs[i].length];
                                    for (j = 0; j < rdnAttrs[i].length; ++j) {
                                        updatedRdnAttrs[len][j] = rdnAttrs[i][j];
                                    }
                                    ++len;
                                }
                            }
                            if (ldapEntity.getRDNObjectclasses().length > 0) {
                                String[][] orgRdnObjCls = ldapEntity.getRDNObjectclasses();
                                updatedRdnObjCls = new String[orgRdnObjCls.length + rdnObjCls.length][];
                                for (i2 = 0; i2 < orgRdnObjCls.length; ++i2) {
                                    updatedRdnObjCls[i2] = new String[orgRdnObjCls[i2].length];
                                    for (j2 = 0; j2 < orgRdnObjCls[i2].length; ++j2) {
                                        updatedRdnObjCls[i2][j2] = orgRdnObjCls[i2][j2];
                                    }
                                }
                                len = orgRdnObjCls.length;
                                for (i = 0; i < rdnObjCls.length; ++i) {
                                    updatedRdnObjCls[len] = new String[rdnObjCls[i].length];
                                    for (j = 0; j < rdnObjCls[i].length; ++j) {
                                        updatedRdnObjCls[len][j] = rdnObjCls[i][j];
                                    }
                                    ++len;
                                }
                            }
                            ldapEntity.setRDNAttributes(updatedRdnAttrs, updatedRdnObjCls);
                        } else {
                            ldapEntity.setRDNAttributes(rdnAttrs, rdnObjCls);
                        }
                        if (ldapEntity.needTranslateRDN()) {
                            this.iNeedTranslateRDN = true;
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not find entity for person account!!", (Object[])new Object[0]);
                }
            }
            if (this.iGroupIdMap != null) {
                strtok = new StringTokenizer(this.iGroupIdMap, ":;");
                ldapEntity = this.getLdapEntity("Group");
                if (ldapEntity != null) {
                    ArrayList<String> rdnPropList = new ArrayList<String>();
                    HashSet<String> objClsSet2 = new HashSet<String>();
                    while (strtok.hasMoreTokens()) {
                        objectClass = strtok.nextToken();
                        String attribute = strtok.nextToken();
                        Set<String> propNames = this.getPropertyName(ldapEntity, attribute);
                        rdnPropList.add(propNames.iterator().next());
                        if ("*".equalsIgnoreCase(objectClass)) continue;
                        objClsSet2.add(objectClass);
                    }
                    if (rdnPropList.size() > 0) {
                        rdnProps = new String[rdnPropList.size()][];
                        String[][] rdnAttrs = new String[rdnPropList.size()][];
                        for (int j = 0; j < rdnPropList.size(); ++j) {
                            rdnProps[j] = LdapHelper.getRDNs((String)rdnPropList.get(j));
                            rdnAttrs[j] = new String[rdnProps[j].length];
                            for (int k = 0; k < rdnProps[j].length; ++k) {
                                String rdnProp = rdnProps[j][k];
                                rdnAttrs[j][k] = this.getAttributeName(ldapEntity, rdnProp);
                            }
                        }
                        ldapEntity.setRDNProperties(rdnProps, rdnAttrs);
                        if (ldapEntity.needTranslateRDN()) {
                            this.iNeedTranslateRDN = true;
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not find entity for Group!!", (Object[])new Object[0]);
                }
            }
            if (this.iGroupMemberIdMap != null) {
                this.iLdapOperationalAttr = this.iGroupMemberIdMap.contains("ibm-allGroups");
                if (this.iDefaultMembershipAttr) {
                    this.iMembershipAttrName = null;
                }
                ldapEntity2 = null;
                List<String> grpTypes = this.getGroupTypes();
                ArrayList<String> objectClasses = new ArrayList<String>();
                for (int i = 0; i < grpTypes.size(); ++i) {
                    ldapEntity2 = this.getLdapEntity(grpTypes.get(i));
                    List<String> objClses = ldapEntity2.getObjectClasses();
                    for (int j = 0; j < objClses.size(); ++j) {
                        String objCls = objClses.get(j);
                        objectClasses.add(objCls);
                    }
                }
                ArrayList<String> attrScopes = new ArrayList<String>();
                ArrayList<String> attrNames = new ArrayList<String>();
                StringTokenizer strtok2 = new StringTokenizer(this.iGroupMemberIdMap, ":;");
                if (ldapEntity2 != null) {
                    while (strtok2.hasMoreTokens()) {
                        String objectClass2 = strtok2.nextToken();
                        String attribute = strtok2.nextToken();
                        String scope = "direct";
                        if ("*".equalsIgnoreCase(objectClass2)) {
                            for (int j = 0; j < objectClasses.size(); ++j) {
                                this.iMbrAttrMap.put((String)objectClasses.get(j), attribute);
                            }
                        } else {
                            this.iMbrAttrMap.put(objectClass2.toLowerCase(), attribute);
                        }
                        if (!attrNames.contains(attribute)) {
                            attrNames.add(attribute);
                            attrScopes.add(scope);
                        }
                        if (objectClass2 == null || objectClasses.contains(objectClass2.toLowerCase()) || this.getGroupTypes() == null || this.getGroupTypes().size() <= 0) continue;
                        this.getLdapEntity(this.getGroupTypes().get(0)).addObjectClass(objectClass2);
                    }
                    this.iMbrAttrs = attrNames.toArray(new String[0]);
                    this.iMbrAttrScope = new short[this.iMbrAttrs.length];
                    this.iMbrAttrsAllScope = true;
                    this.iMbrAttrsNestedScope = true;
                    for (int i = 0; i < attrScopes.size(); ++i) {
                        this.iMbrAttrScope[i] = LdapHelper.getMembershipScope((String)attrScopes.get(i));
                        if (this.iMbrAttrScope[i] == 0) {
                            this.iMbrAttrsAllScope = false;
                            this.iMbrAttrsNestedScope = false;
                            continue;
                        }
                        if (this.iMbrAttrScope[i] != 1) continue;
                        this.iMbrAttrsAllScope = false;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Could not find entity for Group!!", (Object[])new Object[0]);
                }
            }
            if (this.checkIfRacf()) {
                this.initializeRacfFilters();
            }
            this.resetEntitySearchFilters();
        }
    }

    private boolean checkIfRacf() {
        return this.iUserFilter != null && this.iUserFilter.toLowerCase().contains("racfid=%v") && this.iGroupFilter != null && this.iGroupFilter.toLowerCase().contains("racfid=%v") && this.iUserIdMap != null && this.iUserIdMap.equalsIgnoreCase("*:racfid") && this.iGroupIdMap != null && this.iGroupIdMap.equalsIgnoreCase("*:racfid") && this.iGroupMemberIdMap != null && this.iGroupMemberIdMap.toLowerCase().contains("racfconnectgroupname:racfgroupuserids");
    }

    private void initializeRacfFilters() {
        this.isRacf = true;
        this.iMembershipAttrName = "racfconnectgroupname";
        this.iMembershipAttrScope = 0;
        List<String> grpTypes = this.getGroupTypes();
        for (int i = 0; i < grpTypes.size(); ++i) {
            LdapEntity ldapEntity = this.getLdapEntity(grpTypes.get(i));
            List<String> objClses = ldapEntity.getObjectClasses();
            for (int j = 0; j < objClses.size(); ++j) {
                String objCls = objClses.get(j);
                this.iMbrAttrMap.put(objCls, "racfgroupuserids");
            }
        }
        this.iMbrAttrs = new String[1];
        this.iMbrAttrs[0] = "racfgroupuserids";
        this.iMbrAttrScope = new short[1];
        this.iMbrAttrScope[0] = 0;
        this.iMbrAttrsAllScope = false;
        this.iMbrAttrsNestedScope = false;
        LdapEntity ldapEntity = this.getLdapEntity("Group");
        ldapEntity.addPropertyAttributeMap("cn", "racfid");
    }

    private void resetEntitySearchFilters() {
        LdapEntity entity = this.getLdapEntity("PersonAccount");
        if (entity != null) {
            entity.setSearchFilter(null);
        }
        if ((entity = this.getLdapEntity("Group")) != null) {
            entity.setSearchFilter(null);
        }
    }

    public Filter getUserFilter() {
        if (this.iUserFilter != null && this.userFilter == null) {
            this.userFilter = new Filter(this.iUserFilter);
        }
        return this.userFilter;
    }

    public Filter getGroupFilter() {
        if (this.iGroupFilter != null && this.groupFilter == null) {
            this.groupFilter = new Filter(this.iGroupFilter);
        }
        return this.groupFilter;
    }

    private void setConfidentialAttributes() {
        this.iConAttrs = new HashSet<String>();
        this.iConAttrs.add("unicodePwd");
        this.iConAttrs.add("userPassword");
    }

    private void setGroupMemberFilter() {
        LdapEntity grpEntity = this.getLdapEntity("Group");
        String grpSearchFilter = grpEntity.getSearchFilter();
        StringBuffer filterBuffer = new StringBuffer("(&");
        filterBuffer.append(grpSearchFilter);
        if (this.iMbrAttrs.length == 1) {
            filterBuffer.append("(").append(this.iMbrAttrs[0]).append("={0}))");
        } else {
            filterBuffer.append("(|");
            for (int i = 0; i < this.iMbrAttrs.length; ++i) {
                filterBuffer.append("(").append(this.iMbrAttrs[i]).append("={0})");
            }
            filterBuffer.append("))");
        }
        this.iGrpMbrFilter = filterBuffer.toString();
    }

    private void setLoginProperties(String loginProps) {
        if (this.iPersonAccountTypes.size() > 0) {
            LdapEntity acct = this.getLdapEntity(this.iPersonAccountTypes.get(this.iPersonAccountTypes.size() - 1));
            this.iLoginAttrs = new ArrayList<String>();
            this.iLoginProps = new ArrayList<String>();
            if (loginProps != null) {
                String[] loginProperties = loginProps.split(";");
                for (int i = 0; i < loginProperties.length; ++i) {
                    String propName = loginProperties[i];
                    this.iLoginAttrs.add(this.getAttributeName(acct, propName));
                    this.iLoginProps.add(propName);
                }
            }
            if (this.iLoginAttrs.size() == 0) {
                String[][] rdns = acct.getRDNAttributes();
                if (rdns != null && rdns.length > 0) {
                    this.iLoginAttrs.add(rdns[0][0]);
                    this.iLoginProps.add(rdns[0][0]);
                } else {
                    this.iLoginAttrs.add("uid");
                    this.iLoginProps.add("uid");
                }
            }
            for (int i = 0; i < this.iPersonAccountTypes.size(); ++i) {
                String acctType = this.iPersonAccountTypes.get(i);
                LdapEntity acctEntity = this.getLdapEntity(acctType);
                String firstLoginAttr = this.iLoginAttrs.get(0);
                acctEntity.addPropertyAttributeMap("principalName", firstLoginAttr);
            }
        }
    }

    private void setAttributes(Map<String, Object> configProps) {
        int j;
        this.iAttrs = new HashSet<String>();
        this.iOperAttrs = new HashSet<String>();
        this.iAttrNameToAttrMap = new Hashtable<String, LdapAttribute>();
        this.iPropToAttrMap = new Hashtable<String, String>();
        this.iAttrToPropMap = new Hashtable<String, Set<String>>();
        this.iDefaultValueAttrs = new HashSet<String>();
        this.iDefaultAttrAttrs = new HashSet<String>();
        this.iDataTypes = new ArrayList<String>();
        HashSet<String> unProps = new HashSet<String>();
        HashMap<String, HashSet<String>> entityUnProps = new HashMap<String, HashSet<String>>();
        Map<String, List<Map<String, Object>>> propMap = Nester.nest(configProps, "attributeConfiguration");
        List<Map<String, Object>> attrConfigList = propMap.get("attributeConfiguration");
        this.setDefaultAttributes();
        if (!attrConfigList.isEmpty()) {
            Map<String, Object> attrConfig = attrConfigList.get(0);
            List<Map<String, Object>> attrDOs = Nester.nest("attribute", attrConfig);
            for (Map<String, Object> map : attrDOs) {
                this.addAttribute(map);
            }
            List<Map<String, Object>> propNotSupported = Nester.nest("propertyNotSupported", attrConfig);
            for (Map<String, Object> map : propNotSupported) {
                String unPropName = (String)map.get("propertyName");
                List entityTypes = (List)map.get("entityTypes");
                if (entityTypes == null || entityTypes.size() == 0) {
                    unProps.add(unPropName);
                    if (unPropName.equals("ibm-primaryEmail")) {
                        unProps.add("ibmPrimaryEmail");
                        continue;
                    }
                    if (!unPropName.equals("ibm-jobTitle")) continue;
                    unProps.add("ibmJobTitle");
                    continue;
                }
                for (j = 0; j < entityTypes.size(); ++j) {
                    String qTypeName = (String)entityTypes.get(j);
                    HashSet<String> props = (HashSet<String>)entityUnProps.get(qTypeName);
                    if (props == null) {
                        props = new HashSet<String>();
                        entityUnProps.put(qTypeName, props);
                    }
                    props.add(unPropName);
                    if (unPropName.equals("ibm-primaryEmail")) {
                        props.add("ibmPrimaryEmail");
                        continue;
                    }
                    if (!unPropName.equals("ibm-jobTitle")) continue;
                    props.add("ibmJobTitle");
                }
            }
        } else {
            unProps.add("homeAddress");
            unProps.add("businessAddress");
            if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
                unProps.add("description");
                unProps.add("jpegPhoto");
                unProps.add("labeledURI");
                unProps.add("carLicense");
                unProps.add("pager");
                unProps.add("roomNumber");
                unProps.add("localityName");
                unProps.add("stateOrProvinceName");
                unProps.add("countryName");
                unProps.add("employeeNumber");
                unProps.add("employeeType");
                unProps.add("businessCategory");
                unProps.add("departmentNumber");
            }
        }
        this.iOperAttrs.add("createTimestamp");
        this.iOperAttrs.add("modifyTimestamp");
        for (int i = 0; i < this.iLdapEntities.size(); ++i) {
            LdapEntity ldapEntity = this.iLdapEntities.get(i);
            String qName = ldapEntity.getName();
            if (qName == null || !qName.equalsIgnoreCase("Person") && !qName.equalsIgnoreCase("PersonAccount") && !qName.equalsIgnoreCase("Group")) continue;
            Set set = (Set)entityUnProps.get(qName);
            HashSet<String> hashSet = unProps;
            if (set != null) {
                hashSet.addAll(set);
            }
            String[] supportedProps = null;
            Group entity = null;
            if (qName.equalsIgnoreCase("Group")) {
                supportedProps = this.iGroupSupportedProps;
                entity = new Group();
            } else {
                supportedProps = this.iPersonSupportedProps;
                entity = new Person();
            }
            for (j = 0; j < supportedProps.length; ++j) {
                String qPropName = supportedProps[j];
                if (hashSet.contains(qPropName)) continue;
                String attrName = this.getAttributeName(ldapEntity, qPropName);
                String dataType = entity.getDataType(qPropName);
                if (!this.iDataTypes.contains(dataType)) {
                    this.iDataTypes.add(dataType);
                }
                if (!this.iOperAttrs.contains(attrName)) {
                    this.iAttrs.add(attrName);
                }
                if (ldapEntity.getAttribute(qPropName) != null) continue;
                ldapEntity.addPropertyAttributeMap(qPropName, attrName);
            }
        }
    }

    private void setDefaultAttributes() {
        this.iDataTypes.add("String");
        this.iDataTypes.add("Base64Binary");
        if (this.iLdapType.equals("ADAM")) {
            LdapAttribute ldapAttr = new LdapAttribute("unicodePwd");
            ldapAttr.setSyntax("unicodePwd");
            this.iAttrNameToAttrMap.put("unicodePwd".toLowerCase(), ldapAttr);
            this.iPropToAttrMap.put("password", "unicodePwd");
            HashSet<String> propSet = new HashSet<String>();
            propSet.add("password");
            this.iAttrToPropMap.put("unicodePwd".toLowerCase(), propSet);
            ldapAttr = new LdapAttribute("groupType");
            this.iDefaultValueAttrs.add("groupType".toLowerCase());
            ldapAttr.setDefaultValue("Group", "8");
            this.iAttrNameToAttrMap.put("groupType".toLowerCase(), ldapAttr);
        } else if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
            LdapAttribute ldapAttr = new LdapAttribute("samAccountName");
            LdapEntity ldapEntity = this.getLdapEntity("PersonAccount");
            ldapEntity.addPropertyAttributeMap("uid", "samAccountName");
            this.iDefaultAttrAttrs.add("samAccountName".toLowerCase());
            ldapAttr.addEntityType("Group");
            ldapAttr.setDefaultAttribute("Group", "cn");
            ldapAttr = new LdapAttribute("unicodePwd");
            ldapAttr.setSyntax("unicodePwd");
            this.iAttrNameToAttrMap.put("unicodePwd".toLowerCase(), ldapAttr);
            this.iPropToAttrMap.put("password", "unicodePwd");
            HashSet<String> propSet = new HashSet<String>();
            propSet.add("password");
            this.iAttrToPropMap.put("unicodePwd".toLowerCase(), propSet);
            ldapAttr = new LdapAttribute("userAccountControl");
            this.iDefaultValueAttrs.add("userAccountControl".toLowerCase());
            ldapAttr.setDefaultValue("PersonAccount", "544");
            this.iAttrNameToAttrMap.put("userAccountControl".toLowerCase(), ldapAttr);
            ldapAttr = new LdapAttribute("groupType");
            this.iDefaultValueAttrs.add("groupType".toLowerCase());
            ldapAttr.setDefaultValue("Group", "8");
            this.iAttrNameToAttrMap.put("groupType".toLowerCase(), ldapAttr);
        } else {
            LdapAttribute ldapAttr = new LdapAttribute("userPassword");
            this.iAttrNameToAttrMap.put("userPassword".toLowerCase(), ldapAttr);
            this.iPropToAttrMap.put("password", "userPassword");
            HashSet<String> propSet = new HashSet<String>();
            propSet.add("password");
            this.iAttrToPropMap.put("userPassword".toLowerCase(), propSet);
        }
    }

    private void addAttribute(Map<String, Object> attrDO) {
        String attrName = (String)attrDO.get(BASE_ENTRY_NAME);
        String attrKey = attrName.toLowerCase();
        LdapAttribute ldapAttr = this.iAttrNameToAttrMap.get(attrKey);
        if (ldapAttr == null) {
            ldapAttr = new LdapAttribute(attrName);
            this.iAttrNameToAttrMap.put(attrKey, ldapAttr);
        }
        ldapAttr.setSyntax((String)attrDO.get("syntax"));
        String propName = (String)attrDO.get("propertyName");
        String entityType = (String)attrDO.get("entityType");
        if (entityType == null || entityType.length() == 0) {
            if (propName != null) {
                this.iPropToAttrMap.put(propName, attrName);
                Set<String> propSet = this.iAttrToPropMap.get(attrKey);
                if (propSet == null) {
                    propSet = new HashSet<String>();
                    this.iAttrToPropMap.put(attrKey, propSet);
                }
                propSet.add(propName);
            }
            if (attrDO.get("defaultValue") != null) {
                this.iDefaultValueAttrs.add(attrKey);
                for (int j = 0; j < this.iLdapEntityTypeList.size(); ++j) {
                    ldapAttr.setDefaultValue(this.iLdapEntityTypeList.get(j), (String)attrDO.get("defaultValue"));
                }
            }
            if (attrDO.get("substituteWithValueOf") != null) {
                this.iDefaultAttrAttrs.add(attrKey);
                for (int j = 0; j < this.iLdapEntityTypeList.size(); ++j) {
                    ldapAttr.setDefaultAttribute(this.iLdapEntityTypeList.get(j), (String)attrDO.get("substituteWithValueOf"));
                }
            }
            if (propName != null) {
                for (int i = 0; i < this.iLdapEntities.size(); ++i) {
                    if (this.iLdapEntities.get(i).getProperty(propName) == null) continue;
                    this.iLdapEntities.get(i).addPropertyAttributeMap(propName, attrName);
                }
            }
        } else {
            String qTypeName = entityType;
            if (propName != null) {
                LdapEntity ldapEntity = this.getLdapEntity(qTypeName);
                ldapEntity.addPropertyAttributeMap(propName, attrName);
            }
            ldapAttr.addEntityType(qTypeName);
            if (attrDO.get("defaultValue") != null) {
                this.iDefaultValueAttrs.add(attrKey);
                ldapAttr.setDefaultValue(qTypeName, (String)attrDO.get("defaultValue"));
            }
            if (attrDO.get("substituteWithValueOf") != null) {
                this.iDefaultAttrAttrs.add(attrKey);
                ldapAttr.setDefaultAttribute(qTypeName, (String)attrDO.get("substituteWithValueOf"));
            }
        }
    }

    private void setExtIdAttributes(Map<String, Object> configProps) {
        this.iExtIds = new HashSet<String>();
        List<Map<String, Object>> attrConfigList = Nester.nest("attributeConfiguration", configProps);
        if (!attrConfigList.isEmpty()) {
            Map<String, Object> attrConfig = attrConfigList.get(0);
            List<Map<String, Object>> extIds = Nester.nest("externalIdAttribute", attrConfig);
            for (Map<String, Object> extIdDO : extIds) {
                String attrName = (String)extIdDO.get(BASE_ENTRY_NAME);
                LdapAttribute ldapAttr = new LdapAttribute(attrName);
                ldapAttr.setSyntax((String)extIdDO.get("syntax"));
                ldapAttr.setWIMGenerate((Boolean)extIdDO.get("autoGenerate"));
                this.iAttrNameToAttrMap.put(attrName.toLowerCase(), ldapAttr);
                String entityType = (String)extIdDO.get("entityType");
                if (entityType == null) {
                    for (int j = 0; j < this.iLdapEntities.size(); ++j) {
                        this.iLdapEntities.get(j).setExtId(attrName);
                    }
                } else {
                    LdapEntity ldapEntity = this.getLdapEntity(entityType);
                    ldapEntity.setExtId(attrName);
                }
                if (attrName.equalsIgnoreCase("DistinguishedName")) {
                    this.isAnyExtIdDN = true;
                }
                this.iExtIds.add(attrName.toLowerCase());
            }
        }
        String extId = null;
        String syntax = "string";
        if (this.iLdapType.startsWith("IBM TIVOLI DIRECTORY SERVER") && !this.iLdapType.startsWith("IDS4")) {
            extId = "ibm-entryuuid";
        } else if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
            extId = "objectguid";
            syntax = "octetString";
        } else if (this.iLdapType.startsWith("SUN JAVA SYSTEM DIRECTORY SERVER")) {
            extId = "nsuniqueid";
        } else if (this.iLdapType.startsWith("NOVELL EDIRECTORY")) {
            extId = "guid";
            syntax = "octetString";
        } else {
            extId = "DistinguishedName";
        }
        boolean useDefault = false;
        for (int i = 0; i < this.iLdapEntities.size(); ++i) {
            if (this.iLdapEntities.get(i).getExtId() != null) continue;
            this.iLdapEntities.get(i).setExtId(extId);
            useDefault = true;
        }
        if (useDefault) {
            if (!extId.equalsIgnoreCase("DistinguishedName")) {
                this.iExtIds.add(extId.toLowerCase());
                LdapAttribute ldapAttr = new LdapAttribute(extId);
                ldapAttr.setSyntax(syntax);
                this.iAttrNameToAttrMap.put(extId.toLowerCase(), ldapAttr);
            } else {
                this.isAnyExtIdDN = true;
            }
        }
    }

    private void setMembershipAttribute(Map<String, Object> groupConfig) {
        List<Map<String, Object>> membershipPropList = Nester.nest("membershipAttribute", groupConfig);
        if (membershipPropList.isEmpty()) {
            if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
                this.iMembershipAttrName = "memberof";
                this.iMembershipAttrScope = 0;
            }
            if (this.iLdapType.startsWith("SUN JAVA SYSTEM DIRECTORY SERVER")) {
                this.iMembershipAttrName = "nsRoleDN";
                this.iMembershipAttrScope = 0;
            }
        } else {
            this.iDefaultMembershipAttr = false;
            Map<String, Object> mbrshipAttr = membershipPropList.get(0);
            String name = (String)mbrshipAttr.get(BASE_ENTRY_NAME);
            if (name.trim().length() == 0) {
                this.iMembershipAttrName = null;
            } else {
                this.iMembershipAttrName = name;
                String scope = (String)mbrshipAttr.get("scope");
                this.iMembershipAttrScope = scope == null ? (short)0 : LdapHelper.getMembershipScope(scope);
            }
        }
    }

    private void setMemberAttributes(Map<String, Object> groupConfig) {
        int i;
        List<Map<String, Object>> memberPropList = Nester.nest("memberAttribute", groupConfig);
        int size = memberPropList.size();
        List<String> grpTypes = this.getGroupTypes();
        ArrayList<String> objectClasses = new ArrayList<String>();
        for (i = 0; i < grpTypes.size(); ++i) {
            LdapEntity ldapEntity = this.getLdapEntity(grpTypes.get(i));
            List<String> objClses = ldapEntity.getObjectClasses();
            for (int j = 0; j < objClses.size(); ++j) {
                String objCls = objClses.get(j);
                objectClasses.add(objCls);
            }
        }
        this.iDummyMbrMap = new HashMap<String, String>();
        if (size > 0) {
            this.iMbrAttrMap = new HashMap<String, String>(size);
            ArrayList<String> attrScopes = new ArrayList<String>(size);
            ArrayList<String> attrNames = new ArrayList<String>(size);
            for (Map map : memberPropList) {
                String name = (String)map.get(BASE_ENTRY_NAME);
                if (name == null || name.trim().length() <= 0) continue;
                String objCls = (String)map.get("objectClass");
                String scope = (String)map.get("scope");
                String dummy = (String)map.get("dummyMember");
                if (scope == null) {
                    scope = "direct";
                }
                if (objCls == null) {
                    for (int j = 0; j < objectClasses.size(); ++j) {
                        this.iMbrAttrMap.put((String)objectClasses.get(j), name);
                    }
                } else {
                    this.iMbrAttrMap.put(objCls.toLowerCase(), name);
                }
                if (dummy != null) {
                    if (dummy.trim().length() == 0) {
                        this.iDummyMbrMap.remove(name);
                    } else {
                        this.iDummyMbrMap.put(name, dummy);
                    }
                } else if (this.iLdapType.startsWith("IBM TIVOLI DIRECTORY SERVER") || this.iLdapType.startsWith("IBM LOTUS DOMINO")) {
                    this.iDummyMbrMap.put(name, "uid=dummy");
                }
                if (!attrNames.contains(name)) {
                    attrNames.add(name);
                    attrScopes.add(scope);
                }
                if (objCls == null || objectClasses.contains(objCls.toLowerCase()) || this.getGroupTypes() == null || this.getGroupTypes().size() <= 0) continue;
                this.getLdapEntity(this.getGroupTypes().get(0)).addObjectClass(objCls);
            }
            this.iMbrAttrs = attrNames.toArray(new String[0]);
            this.iMbrAttrScope = new short[this.iMbrAttrs.length];
            this.iMbrAttrsAllScope = true;
            this.iMbrAttrsNestedScope = true;
            for (int i2 = 0; i2 < attrScopes.size(); ++i2) {
                this.iMbrAttrScope[i2] = LdapHelper.getMembershipScope((String)attrScopes.get(i2));
                if (this.iMbrAttrScope[i2] == 0) {
                    this.iMbrAttrsAllScope = false;
                    this.iMbrAttrsNestedScope = false;
                    continue;
                }
                if (this.iMbrAttrScope[i2] != 1) continue;
                this.iMbrAttrsAllScope = false;
            }
        } else {
            this.iMbrAttrMap = new HashMap<String, String>(objectClasses.size());
            this.iMbrAttrScope = new short[objectClasses.size()];
            for (i = 0; i < objectClasses.size(); ++i) {
                this.iMbrAttrMap.put((String)objectClasses.get(i), "member");
                this.iMbrAttrScope[i] = 0;
            }
            this.iMbrAttrs = new String[1];
            this.iMbrAttrs[0] = "member";
            if (this.iLdapType.startsWith("IBM TIVOLI DIRECTORY SERVER") || this.iLdapType.startsWith("IBM LOTUS DOMINO")) {
                this.iDummyMbrMap.put("member", "uid=dummy");
            }
            this.iUseDefaultMbrAttr = true;
        }
    }

    private void setDynaMemberAttributes(Map<String, Object> groupConfig) {
        int j;
        List<Map<String, Object>> dynaMbrAttrList = Nester.nest("dynamicMemberAttribute", groupConfig);
        LdapEntity ldapEntry = this.getLdapEntity("Group");
        this.iDynaMbrAttrMap = new HashMap<String, String>();
        ArrayList<String> attrNames = new ArrayList<String>();
        List<String> grpTypes = this.getGroupTypes();
        ArrayList<String> objectClasses = new ArrayList<String>();
        for (int i = 0; i < grpTypes.size(); ++i) {
            LdapEntity ldapEntity = this.getLdapEntity(grpTypes.get(i));
            List<String> objClses = ldapEntity.getObjectClasses();
            for (j = 0; j < objClses.size(); ++j) {
                String objCls = objClses.get(j);
                objectClasses.add(objCls);
            }
        }
        if (!dynaMbrAttrList.isEmpty()) {
            Map<String, Object> mbrshipAttrDO = dynaMbrAttrList.get(0);
            String name = (String)mbrshipAttrDO.get(BASE_ENTRY_NAME);
            if (name != null && name.trim().length() > 0) {
                String objCls = (String)mbrshipAttrDO.get("objectClass");
                if (objCls == null) {
                    for (j = 0; j < objectClasses.size(); ++j) {
                        this.iDynaMbrAttrMap.put((String)objectClasses.get(j), name);
                        this.iDynaMbrObjectClass.add((String)objectClasses.get(j));
                    }
                } else {
                    this.iDynaMbrAttrMap.put(objCls.toLowerCase(), name);
                    this.iDynaMbrObjectClass.add(objCls);
                }
                if (!attrNames.contains(name)) {
                    attrNames.add(name);
                }
                if (objCls != null && !ldapEntry.getObjectClasses().contains(objCls.toLowerCase())) {
                    ldapEntry.addObjectClass(objCls);
                }
            }
            this.iDynaMbrAttrs = attrNames.toArray(new String[0]);
            this.setDynamicGroupFilter();
        }
    }

    private void setDynamicGroupFilter() {
        int i;
        LdapEntity grpEntity = this.getLdapEntity("Group");
        String grpSearchFilter = grpEntity.getSearchFilter();
        StringBuffer filterBuffer = new StringBuffer("(&");
        if (this.iDynaMbrObjectClass != null && this.iDynaMbrObjectClass.size() > 0) {
            if (this.iDynaMbrObjectClass.size() == 1) {
                filterBuffer.append("(|(objectclass=").append(this.iDynaMbrObjectClass.get(0)).append(")");
                filterBuffer.append(grpSearchFilter);
                filterBuffer.append(")");
            } else {
                filterBuffer.append("(|");
                for (i = 0; i < this.iDynaMbrObjectClass.size(); ++i) {
                    filterBuffer.append("(objectclass=").append(this.iDynaMbrObjectClass.get(i)).append(")");
                }
                filterBuffer.append(grpSearchFilter);
                filterBuffer.append(")");
            }
        } else {
            filterBuffer.append(grpSearchFilter);
        }
        if (this.iDynaMbrAttrs.length == 1) {
            filterBuffer.append("(").append(this.iDynaMbrAttrs[0]).append("=*))");
        } else {
            filterBuffer.append("(|");
            for (i = 0; i < this.iDynaMbrAttrs.length; ++i) {
                filterBuffer.append("(").append(this.iDynaMbrAttrs[i]).append("=*)");
            }
            filterBuffer.append("))");
        }
        this.iDynaGrpFilter = filterBuffer.toString();
    }

    private void setLDAPEntities(List<Map<String, Object>> entityList, List<HashMap<String, String>> baseEntries) throws WIMException {
        if (!entityList.isEmpty()) {
            int size = entityList.size();
            this.iLdapEntityTypeList = new ArrayList<String>(size);
            this.iLdapEntities = new ArrayList<LdapEntity>(size);
            this.iPersonAccountTypes = new ArrayList<String>(size);
            this.iPersonTypes = new ArrayList<String>(size);
            this.iGroupTypes = new ArrayList<String>(size);
            ArrayList<? extends String> grpSearchBases = new ArrayList<String>();
            for (Map<String, Object> entityProps : entityList) {
                ArrayList<String> objclsList;
                String entityType = (String)entityProps.get(BASE_ENTRY_NAME);
                String entityTypeSearchFilter = (String)entityProps.get("searchFilter");
                String[] objectClasses = (String[])entityProps.get("objectClass");
                if (this.getLdapEntity(entityType) != null) {
                    throw new InitializationException("DUPLICATE_ENTITY_TYPE", Tr.formatMessage((TraceComponent)tc, (String)"DUPLICATE_ENTITY_TYPE", (Object[])WIMMessageHelper.generateMsgParms((Object)entityType)));
                }
                List<Map<String, Object>> rdnAttributes = Nester.nest("rdnProperty", entityProps);
                if (!rdnAttributes.isEmpty()) {
                    this.isVMMRdnPropertiesDefined = true;
                }
                LdapEntity ldapEntity = new LdapEntity(entityType, entityTypeSearchFilter, objectClasses, rdnAttributes);
                if (rdnAttributes.isEmpty()) {
                    this.setDefaultRDNs(ldapEntity);
                }
                if (entityTypeSearchFilter == null || entityTypeSearchFilter.trim().length() == 0) {
                    if ("PersonAccount".equals(entityType) || Entity.getSubEntityTypes((String)"PersonAccount").contains(entityType)) {
                        if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
                            ldapEntity.setSearchFilter("(ObjectCategory=Person)");
                        } else {
                            ldapEntity.setSearchFilter(null);
                        }
                        this.iPersonAccountTypes.add("PersonAccount");
                    } else if ("Group".equals(entityType) || Entity.getSubEntityTypes((String)"Group") != null && Entity.getSubEntityTypes((String)"Group").contains(entityType)) {
                        if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
                            ldapEntity.setSearchFilter("(ObjectCategory=Group)");
                        } else {
                            ldapEntity.setSearchFilter(null);
                        }
                    } else if ("OrgContainer".equals(entityType) || Entity.getSubEntityTypes((String)"OrgContainer").contains(entityType)) {
                        ldapEntity.setSearchFilter(null);
                    }
                } else {
                    ldapEntity.setSearchFilter(entityTypeSearchFilter);
                    if ("PersonAccount".equals(entityType) || Entity.getSubEntityTypes((String)"PersonAccount").contains(entityType)) {
                        this.iPersonAccountTypes.add("PersonAccount");
                    }
                }
                if (objectClasses != null) {
                    objclsList = new ArrayList<String>();
                    for (int j = 0; j < objectClasses.length; ++j) {
                        objclsList.add(objectClasses[j]);
                    }
                    ldapEntity.setObjectClasses(objclsList);
                    ldapEntity.setObjectClassesForCreate(objclsList);
                } else if ("PersonAccount".equals(entityType) || Entity.getSubEntityTypes((String)"PersonAccount").contains(entityType)) {
                    objclsList = new ArrayList();
                    if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
                        objclsList.add("user");
                    } else {
                        objclsList.add("inetOrgPerson");
                    }
                    ldapEntity.setObjectClasses(objclsList);
                    ldapEntity.setObjectClassesForCreate(objclsList);
                } else if ("Group".equals(entityType) || Entity.getSubEntityTypes((String)"Group").contains(entityType)) {
                    objclsList = new ArrayList();
                    if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
                        objclsList.add("group");
                    } else {
                        objclsList.add("groupOfNames");
                    }
                    ldapEntity.setObjectClasses(objclsList);
                    ldapEntity.setObjectClassesForCreate(objclsList);
                } else if ("OrgContainer".equals(entityType) || Entity.getSubEntityTypes((String)"OrgContainer").contains(entityType)) {
                    objclsList = new ArrayList();
                    objclsList.add("organization");
                    objclsList.add("organizationalUnit");
                    ldapEntity.setObjectClasses(objclsList);
                    ldapEntity.setObjectClassesForCreate(objclsList);
                }
                String[] searchBases = (String[])entityProps.get("searchBase");
                if (searchBases != null) {
                    searchBases = this.validateSearchBases(searchBases, baseEntries);
                    ldapEntity.setSearchBases(searchBases);
                }
                if (ldapEntity.getSearchBases() == null) {
                    ldapEntity.setSearchBases(this.getTopLdapNodes());
                } else {
                    String[] bases = ldapEntity.getSearchBases();
                    String[] ldapBases = new String[bases.length];
                    for (int j = 0; j < bases.length; ++j) {
                        ldapBases[j] = this.switchToLdapNode(bases[j]);
                    }
                    ldapEntity.setSearchBases(ldapBases);
                }
                this.iLdapEntityTypeList.add(entityType);
                this.iLdapEntities.add(ldapEntity);
                if (Entity.getSubEntityTypes((String)"PersonAccount").contains(entityType)) {
                    this.iPersonAccountTypes.add(entityType);
                    continue;
                }
                if (Entity.getSubEntityTypes((String)"Person").contains(entityType)) {
                    this.iPersonTypes.add(entityType);
                    continue;
                }
                if (!"Group".equalsIgnoreCase(entityType) && (Entity.getSubEntityTypes((String)"Group") == null || !Entity.getSubEntityTypes((String)"Group").contains(entityType))) continue;
                this.iGroupTypes.add(entityType);
                grpSearchBases.addAll(ldapEntity.getSearchBaseList());
            }
            this.iGroupSearchBases = grpSearchBases.toArray(new String[0]);
            this.iGroupSearchBases = NodeHelper.getTopNodes((String[])this.iGroupSearchBases);
            this.setDefaultLDAPEntries();
        } else {
            this.setDefaultLDAPEntries();
        }
    }

    private String[] validateSearchBases(String[] searchBases, List<HashMap<String, String>> baseEntries) {
        String METHODNAME = "validateSearchBases(String[], List<HashMap<String, String>>)";
        ArrayList<String> validSearchBase = new ArrayList<String>();
        boolean isValid = false;
        for (int j = 0; j < searchBases.length; ++j) {
            for (int i = 0; i < baseEntries.size(); ++i) {
                Set<String> keys = baseEntries.get(i).keySet();
                for (String key : keys) {
                    if (searchBases[j].trim().toLowerCase().endsWith(key.toLowerCase())) {
                        isValid = true;
                        validSearchBase.add(searchBases[j]);
                        break;
                    }
                    isValid = false;
                }
                if (isValid) break;
            }
            if (isValid || !tc.isDebugEnabled()) continue;
            Tr.debug((TraceComponent)tc, (String)("validateSearchBases(String[], List<HashMap<String, String>>) Invalid search bases are" + searchBases[j]), (Object[])new Object[0]);
        }
        return validSearchBase.toArray(new String[0]);
    }

    private void setDefaultRDNs(LdapEntity ldapEntity) {
        String name = ldapEntity.getName();
        if (name.contains("PersonAccount")) {
            String[][] rdnAttrs = new String[1][1];
            String[][] rdnObjCls = new String[1][1];
            if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
                rdnAttrs[0][0] = "cn";
                rdnObjCls[0][0] = "user";
            } else {
                rdnAttrs[0][0] = "uid";
                rdnObjCls[0][0] = "inetOrgPerson";
            }
            ldapEntity.setRDNAttributes(rdnAttrs, rdnObjCls);
        } else if (name.contains("Group")) {
            String[][] rdnAttrs = new String[1][1];
            rdnAttrs[0][0] = "cn";
            String[][] rdnObjCls = new String[1][1];
            if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
                rdnObjCls[0][0] = "group";
            }
            rdnObjCls[0][0] = this.iLdapType.startsWith("SUN JAVA SYSTEM DIRECTORY SERVER") ? "ldapsubentry" : "groupOfNames";
            ldapEntity.setRDNAttributes(rdnAttrs, rdnObjCls);
        } else if (name.contains("OrgContainer")) {
            String[][] rdnAttrs = new String[][]{{"o"}, {"ou"}};
            String[][] rdnObjCls = new String[][]{{"organization"}, {"organizationalUnit"}};
            ldapEntity.setRDNAttributes(rdnAttrs, rdnObjCls);
        }
    }

    private void setDefaultLDAPEntries() {
        String[][] rdnObjCls;
        String[][] rdnAttrs;
        ArrayList<String> objclsList;
        LdapEntity ldapEntity;
        int size = 3;
        if (this.iLdapEntityTypeList == null) {
            this.iLdapEntityTypeList = new ArrayList<String>(size);
        }
        if (this.iLdapEntities == null) {
            this.iLdapEntities = new ArrayList<LdapEntity>(size);
        }
        if (this.iPersonAccountTypes == null) {
            this.iPersonAccountTypes = new ArrayList<String>(size);
        }
        if (this.iPersonTypes == null) {
            this.iPersonTypes = new ArrayList<String>(size);
        }
        if (this.iGroupTypes == null) {
            this.iGroupTypes = new ArrayList<String>(size);
        }
        if (!this.iLdapEntityTypeList.contains("PersonAccount")) {
            ldapEntity = new LdapEntity("PersonAccount");
            objclsList = new ArrayList<String>();
            rdnAttrs = new String[1][1];
            rdnObjCls = new String[1][1];
            if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
                objclsList.add("user");
                rdnAttrs[0][0] = "cn";
                rdnObjCls[0][0] = "user";
            } else {
                objclsList.add("inetOrgPerson");
                rdnAttrs[0][0] = "uid";
                rdnObjCls[0][0] = "inetOrgPerson";
            }
            ldapEntity.setRDNAttributes(rdnAttrs, rdnObjCls);
            ldapEntity.setObjectClasses(objclsList);
            ldapEntity.setObjectClassesForCreate(objclsList);
            if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
                ldapEntity.setSearchFilter("(ObjectCategory=Person)");
            } else {
                ldapEntity.setSearchFilter(null);
            }
            ldapEntity.setSearchBases(this.getTopLdapNodes());
            this.iLdapEntityTypeList.add("PersonAccount");
            this.iLdapEntities.add(ldapEntity);
            this.iPersonAccountTypes.add("PersonAccount");
        }
        if (!this.iLdapEntityTypeList.contains("Group")) {
            ldapEntity = new LdapEntity("Group");
            objclsList = new ArrayList();
            rdnAttrs = new String[1][1];
            rdnAttrs[0][0] = "cn";
            rdnObjCls = new String[1][1];
            if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
                objclsList.add("group");
                rdnObjCls[0][0] = "group";
            }
            if (this.iLdapType.startsWith("SUN JAVA SYSTEM DIRECTORY SERVER")) {
                objclsList.add("ldapsubentry");
                rdnObjCls[0][0] = "ldapsubentry";
            } else {
                objclsList.add("groupOfNames");
                rdnObjCls[0][0] = "groupOfNames";
            }
            ldapEntity.setRDNAttributes(rdnAttrs, rdnObjCls);
            ldapEntity.setObjectClasses(objclsList);
            ldapEntity.setObjectClassesForCreate(objclsList);
            if (this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY")) {
                ldapEntity.setSearchFilter("(ObjectCategory=Group)");
            } else {
                ldapEntity.setSearchFilter(null);
            }
            this.iLdapEntityTypeList.add("Group");
            this.iLdapEntities.add(ldapEntity);
            this.iGroupTypes.add("Group");
            ldapEntity.setSearchBases(this.getTopLdapNodes());
            ArrayList<? extends String> grpSearchBases = new ArrayList<String>();
            grpSearchBases.addAll(ldapEntity.getSearchBaseList());
            this.iGroupSearchBases = grpSearchBases.toArray(new String[0]);
            this.iGroupSearchBases = NodeHelper.getTopNodes((String[])this.iGroupSearchBases);
        }
        if (!this.iLdapEntityTypeList.contains("OrgContainer")) {
            ldapEntity = new LdapEntity("OrgContainer");
            String[][] rdnAttrs2 = new String[][]{{"o"}, {"ou"}};
            String[][] rdnObjCls2 = new String[][]{{"organization"}, {"organizationalUnit"}};
            ldapEntity.setRDNAttributes(rdnAttrs2, rdnObjCls2);
            ArrayList<String> objclsList2 = new ArrayList<String>();
            objclsList2.add("organization");
            objclsList2.add("organizationalUnit");
            ldapEntity.setObjectClasses(objclsList2);
            ldapEntity.setObjectClassesForCreate(objclsList2);
            ldapEntity.setSearchFilter(null);
            this.iLdapEntityTypeList.add("OrgContainer");
            this.iLdapEntities.add(ldapEntity);
            ldapEntity.setSearchBases(this.getTopLdapNodes());
        }
    }

    @Trivial
    public String getMembershipAttribute() {
        return this.iMembershipAttrName;
    }

    @Trivial
    public short getMembershipAttributeScope() {
        return this.iMembershipAttrScope;
    }

    @Trivial
    public boolean isDefaultMbrAttr() {
        return this.iUseDefaultMbrAttr;
    }

    @Trivial
    public boolean supportDynamicGroup() {
        return this.iDynaMbrAttrs != null;
    }

    public List<String> getSupportedProperties(String inEntityTypes, List<String> propNames) throws EntityTypeNotSupportedException {
        List<Object> prop = null;
        HashSet<String> s = null;
        if (propNames != null && propNames.size() > 0) {
            if (inEntityTypes == null) {
                return propNames;
            }
            prop = new ArrayList();
            if (inEntityTypes.equals("Entity")) {
                s = new HashSet<String>();
                List<LdapEntity> ldapEntities = this.getAllLdapEntities(inEntityTypes);
                List<String> tmpProp = null;
                for (int i = 0; i < ldapEntities.size(); ++i) {
                    tmpProp = this.getSupportedProperties(ldapEntities.get(i), propNames);
                    s.addAll(tmpProp);
                }
                prop.addAll(s);
            } else {
                LdapEntity ldapEntity = this.getLdapEntity(inEntityTypes);
                if (ldapEntity == null) {
                    throw new EntityTypeNotSupportedException("ENTITY_TYPE_NOT_SUPPORTED", Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_TYPE_NOT_SUPPORTED", (Object[])WIMMessageHelper.generateMsgParms((Object)inEntityTypes)));
                }
                prop = this.getSupportedProperties(ldapEntity, propNames);
            }
        }
        return prop;
    }

    public List<String> getSupportedProperties(LdapEntity ldapEntity, List<String> propNames) {
        ArrayList<String> prop = new ArrayList<String>();
        for (String propName : propNames) {
            if (propName.equals("*")) {
                prop.add(propName);
                continue;
            }
            String attrName = ldapEntity.getAttribute(propName);
            if (attrName == null) {
                attrName = this.iPropToAttrMap.get(propName);
            }
            if (attrName == null) continue;
            prop.add(propName);
        }
        return prop;
    }

    public List<LdapEntity> getAllLdapEntities(String qualifiedType) {
        ArrayList<LdapEntity> entityTypes = new ArrayList<LdapEntity>();
        if (qualifiedType != null) {
            String entityType;
            for (int i = 0; i < this.iLdapEntityTypeList.size(); ++i) {
                entityType = this.iLdapEntityTypeList.get(i);
                if (entityType == null || !entityType.equals(qualifiedType)) continue;
                entityTypes.add(this.iLdapEntities.get(i));
            }
            if (entityTypes.size() != 0) {
                return entityTypes;
            }
            for (int j = 0; j < this.iLdapEntityTypeList.size(); ++j) {
                entityType = this.iLdapEntityTypeList.get(j);
                if (!qualifiedType.equalsIgnoreCase(entityType) && (Entity.getSubEntityTypes((String)qualifiedType) == null || !Entity.getSubEntityTypes((String)qualifiedType).contains(entityType))) continue;
                entityTypes.add(this.iLdapEntities.get(j));
            }
            if (entityTypes.size() != 0) {
                return entityTypes;
            }
        }
        return entityTypes;
    }

    @Trivial
    public boolean isPerson(String qualifiedEntityType) {
        return this.iPersonTypes.contains(qualifiedEntityType);
    }

    @Trivial
    public boolean isPersonAccount(String qualifiedEntityType) {
        return this.iPersonAccountTypes.contains(qualifiedEntityType);
    }

    @Trivial
    public boolean isGroup(String qualifiedEntityType) {
        return this.iGroupTypes.contains(qualifiedEntityType);
    }

    public LdapEntity getLdapEntity(String qualifiedType) {
        if (qualifiedType != null) {
            for (int i = 0; i < this.iLdapEntityTypeList.size(); ++i) {
                String entityType = this.iLdapEntityTypeList.get(i);
                if (entityType != null && entityType.equals(qualifiedType)) {
                    return this.iLdapEntities.get(i);
                }
                if (Entity.getSubEntityTypes((String)qualifiedType) != null && Entity.getSubEntityTypes((String)qualifiedType).contains(entityType)) {
                    return this.iLdapEntities.get(i);
                }
                if (!qualifiedType.equalsIgnoreCase("LoginAccount") || !entityType.equalsIgnoreCase("PersonAccount")) continue;
                return this.iLdapEntities.get(i);
            }
        }
        return null;
    }

    public Set<String> getPropertyName(LdapEntity ldapEntity, String attrName) {
        Set<String> propNames = ldapEntity.getProperty(attrName);
        if (propNames == null) {
            propNames = this.iAttrToPropMap.get(attrName.toLowerCase());
        }
        if (propNames == null || propNames.size() == 0) {
            String stAttrName;
            int pos = attrName.indexOf(";");
            if (pos > 0 && (propNames = ldapEntity.getProperty(stAttrName = attrName.substring(0, pos))) == null) {
                propNames = this.iAttrToPropMap.get(stAttrName.toLowerCase());
            }
            if (propNames == null || propNames.size() == 0) {
                propNames = new HashSet<String>();
                propNames.add(attrName);
            }
        }
        return propNames;
    }

    @Trivial
    public LdapAttribute getLdapAttribute(String attrName) {
        return this.iAttrNameToAttrMap.get(attrName.toLowerCase());
    }

    @Trivial
    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    @Trivial
    public String getLdapType() {
        return this.iLdapType;
    }

    @Trivial
    private char[] getSpecialCharactors() {
        return this.iSpecialChars;
    }

    @Trivial
    public String escapeSpecialCharacters(String attributeValue) {
        if (attributeValue == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        char[] str = attributeValue.toCharArray();
        int size = attributeValue.length();
        char[] specialChars = this.getSpecialCharactors();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < specialChars.length; ++j) {
                if (str[i] != specialChars[j] || i <= 0 && i != 0) continue;
                result.append("\\");
            }
            result.append(str[i]);
        }
        if (this.useEncodingInSearchExpression != null) {
            result = new StringBuilder(LdapHelper.encodeAttribute(result.toString(), this.useEncodingInSearchExpression));
        }
        int z = 0;
        int y = 0;
        while (y < result.length()) {
            if ((z = result.indexOf("\\*", z)) < 0) {
                y = result.length();
                continue;
            }
            result.deleteCharAt(z);
            y = z;
        }
        return result.toString();
    }

    public String getGroupMemberFilter(String groupMemberDN) {
        groupMemberDN = this.escapeSpecialCharacters(groupMemberDN);
        Object[] args = new Object[]{groupMemberDN};
        return new MessageFormat(this.iGrpMbrFilter).format(args);
    }

    @Trivial
    public String[] getGroupSearchBases() {
        return (String[])this.iGroupSearchBases.clone();
    }

    @Trivial
    public String getLdapNode(String node) {
        node = node.toLowerCase();
        for (int i = 0; i < this.iNodesForCompare.length; ++i) {
            if (!this.iNodesForCompare[i].equals(node)) continue;
            return this.iLdapNodes[i];
        }
        return null;
    }

    public String switchToLdapNode(String uniqueName) {
        if (uniqueName == null || !this.iNeedSwitchNode) {
            return uniqueName;
        }
        StringBuffer DNBuf = new StringBuffer(uniqueName);
        String uniqueNameForCompare = uniqueName.toLowerCase();
        String ldapNode = null;
        int n = this.iNodesForCompare.length;
        for (int i = 0; i < n; ++i) {
            int pos = uniqueNameForCompare.lastIndexOf(this.iNodesForCompare[i]);
            if (pos <= -1) continue;
            if (pos == 0) {
                if (this.iNodesForCompare[i].length() > 0 && this.iNodesForCompare[i].length() == uniqueName.length()) {
                    return this.iLdapNodes[i];
                }
                if (this.iLdapNodes[i].length() > 0) {
                    ldapNode = "," + this.iLdapNodes[i];
                    continue;
                }
                ldapNode = this.iLdapNodes[i];
                continue;
            }
            if (uniqueName.length() - pos != this.iNodesForCompare[i].length()) continue;
            ldapNode = this.iLdapNodes[i];
            if (ldapNode != null && ldapNode.length() == 0 && DNBuf.charAt(pos - 1) == ',') {
                DNBuf = new StringBuffer(DNBuf.substring(0, pos - 1));
                break;
            }
            DNBuf = new StringBuffer(DNBuf.substring(0, pos));
            break;
        }
        if (ldapNode != null) {
            DNBuf.append(ldapNode);
        }
        return DNBuf.toString();
    }

    public boolean needTranslateRDN() {
        return this.iNeedTranslateRDN;
    }

    public boolean needTranslateRDN(String entityType) {
        LdapEntity ldapEntity;
        if (entityType != null && (ldapEntity = this.getLdapEntity(entityType)) != null) {
            return ldapEntity.needTranslateRDN();
        }
        return this.iNeedTranslateRDN;
    }

    @Trivial
    public List<String> getGroupTypes() {
        return this.iGroupTypes;
    }

    /*
     * WARNING - void declaration
     */
    public String getDynamicMemberAttribute(Attribute grpObjCls) throws WIMSystemException {
        if (this.iDynaMbrAttrs == null) {
            return null;
        }
        if (grpObjCls != null) {
            try {
                NamingEnumeration<?> nenu = grpObjCls.getAll();
                while (nenu.hasMoreElements()) {
                    String mbrAttr;
                    String objectClass = (String)nenu.nextElement();
                    if (objectClass == null || (mbrAttr = this.iDynaMbrAttrMap.get(objectClass.toLowerCase())) == null) continue;
                    return mbrAttr;
                }
            }
            catch (NamingException nenu) {
                void e;
                FFDCFilter.processException((Throwable)nenu, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConfigManager", (String)"2324", (Object)this, (Object[])new Object[]{grpObjCls});
                throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
            }
        }
        return null;
    }

    @Trivial
    public boolean isMemberAttributesNestedScope() {
        return this.iMbrAttrsNestedScope;
    }

    @Trivial
    public boolean isMemberAttributesAllScope() {
        return this.iMbrAttrsAllScope;
    }

    @Trivial
    public List getLdapEntities() {
        return (List)((ArrayList)this.iLdapEntities).clone();
    }

    @Trivial
    public String[] getTopLdapNodes() {
        return (String[])this.iTopLdapNodes.clone();
    }

    @Trivial
    public boolean containGroup(List<String> qualifiedEntityTypes) {
        if (qualifiedEntityTypes != null) {
            for (int i = 0; i < qualifiedEntityTypes.size(); ++i) {
                String thisType = qualifiedEntityTypes.get(i);
                if (!this.isGroup(thisType)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public String[] getMemberAttribute(Attribute grpObjCls) throws WIMSystemException {
        if (this.iMbrAttrs.length == 1) {
            return (String[])this.iMbrAttrs.clone();
        }
        if (grpObjCls != null) {
            try {
                NamingEnumeration<?> nenu = grpObjCls.getAll();
                ArrayList<String> attributes = new ArrayList<String>();
                while (nenu.hasMoreElements()) {
                    String mbrAttr;
                    String objectClass = (String)nenu.nextElement();
                    if (objectClass == null || (mbrAttr = this.iMbrAttrMap.get(objectClass.toLowerCase())) == null) continue;
                    attributes.add(mbrAttr);
                }
                return attributes.toArray(new String[0]);
            }
            catch (NamingException nenu) {
                void e;
                FFDCFilter.processException((Throwable)nenu, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConfigManager", (String)"2401", (Object)this, (Object[])new Object[]{grpObjCls});
                throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
            }
        }
        return (String[])this.iMbrAttrs.clone();
    }

    @Trivial
    public String[] getMemberAttributes() {
        if (this.iMbrAttrs != null) {
            return (String[])this.iMbrAttrs.clone();
        }
        return new String[0];
    }

    public Attribute[] getGroupMemberAttrs(Attributes attrs, Attribute objClsAttr) throws WIMException {
        ArrayList<Attribute> memberAttrs = new ArrayList<Attribute>();
        String[] mbrAttrName = null;
        mbrAttrName = objClsAttr != null ? this.getMemberAttribute(objClsAttr) : this.getMemberAttributes();
        if (mbrAttrName != null) {
            for (int i = 0; i < mbrAttrName.length; ++i) {
                Attribute attr = attrs.remove(mbrAttrName[i]);
                if (attr == null) continue;
                memberAttrs.add(attr);
            }
        }
        if (memberAttrs.size() > 0) {
            return memberAttrs.toArray(new Attribute[0]);
        }
        return null;
    }

    @Trivial
    public boolean isIncludeGroupInSearchEntityTypes() {
        return false;
    }

    @Trivial
    public boolean isDummyMember(String dn) {
        return this.iDummyMbrMap.containsValue(dn);
    }

    @Trivial
    public boolean isActiveDirectory() {
        return this.iLdapType.startsWith("MICROSOFT ACTIVE DIRECTORY");
    }

    @Trivial
    public String getUseEncodingInSearchExpression() {
        return this.useEncodingInSearchExpression;
    }

    public List<String> getLdapSubEntityTypes(String entityType) {
        ArrayList<String> subTypes = new ArrayList<String>();
        if (Entity.getSubEntityTypes((String)entityType) != null) {
            subTypes.addAll(Entity.getSubEntityTypes((String)entityType));
        } else if (entityType.equalsIgnoreCase("LoginAccount")) {
            subTypes.add("PersonAccount");
        }
        ArrayList<String> typesToRemove = new ArrayList<String>(subTypes.size());
        for (int i = 0; i < subTypes.size(); ++i) {
            String subType = (String)subTypes.get(i);
            if (this.getLdapEntity(subType) != null) continue;
            typesToRemove.add(subType);
        }
        subTypes.removeAll(typesToRemove);
        return subTypes;
    }

    public String getEntityTypesFilter(Set<String> entityTypes) {
        StringBuffer filter = new StringBuffer();
        if (entityTypes.size() > 1) {
            filter.append("(|");
        }
        Iterator<String> iter = entityTypes.iterator();
        while (iter.hasNext()) {
            String str;
            LdapEntity ldapEntity = this.getLdapEntity(iter.next());
            if (ldapEntity == null || filter.indexOf(str = ldapEntity.getSearchFilter()) != -1) continue;
            filter.append(ldapEntity.getSearchFilter());
        }
        if (entityTypes.size() > 1) {
            filter.append(")");
        }
        return filter.toString();
    }

    @Trivial
    public List<String> getLoginAttributes() {
        return this.iLoginAttrs;
    }

    @Trivial
    public String getCertificateMapMode() {
        return this.iCertMapMode;
    }

    private String removeSpacesInDN(String DN) {
        String[] attrs = DN.split(",");
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < attrs.length; ++i) {
            if (attrs[i].indexOf("=") >= 0) {
                result.append(attrs[i].trim());
            } else {
                result.append(attrs[i]);
            }
            if (i == attrs.length - 1) continue;
            result.append(",");
        }
        return result.toString();
    }

    public String getCertificateLDAPFilter(X509Certificate cert) throws CertificateMapperException {
        if (this.iCertFilterEles == null) {
            throw new CertificateMapperException("INVALID_CERTIFICATE_FILTER", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_CERTIFICATE_FILTER", (Object[])new Object[]{"null"}));
        }
        StringBuffer filter = new StringBuffer();
        for (int idx = 0; idx < this.iCertFilterEles.length; ++idx) {
            String str = this.iCertFilterEles[idx];
            if (str.charAt(0) != '$') {
                filter.append(str);
                continue;
            }
            if (str.equals("${UniqueKey}") || str.equals("$[UniqueKey]")) {
                filter.append(LdapHelper.getUniqueKey(cert));
                continue;
            }
            if (str.equals("${PublicKey}") || str.equals("$[PublicKey]")) {
                filter.append(new String(cert.getPublicKey().getEncoded()));
                continue;
            }
            if (str.equals("${BasicConstraints}") || str.equals("$[BasicConstraints]")) continue;
            if (str.startsWith("${Issuer") || str.startsWith("$[Issuer")) {
                filter.append(LdapHelper.getDNSubField(str.substring(8, str.length() - 1), this.removeSpacesInDN(cert.getIssuerX500Principal().toString())));
                continue;
            }
            if (str.equals("${IssuerUniqueID}") || str.equals("$[IssuerUniqueID]") || str.equals("${KeyUsage}") || str.equals("$[KeyUsage]")) continue;
            if (str.equals("${NotAfter}") || str.equals("$[NotAfter]")) {
                filter.append(cert.getNotAfter().toString());
                continue;
            }
            if (str.equals("${NotBefore}") || str.equals("$[NotBefore]")) {
                filter.append(cert.getNotBefore().toString());
                continue;
            }
            if (str.equals("${SerialNumber}") || str.equals("$[SerialNumber]")) {
                filter.append(cert.getSerialNumber());
                continue;
            }
            if (str.equals("${SigAlgName}") || str.equals("$[SigAlgName]")) {
                filter.append(cert.getSigAlgName());
                continue;
            }
            if (str.equals("${SigAlgOID}") || str.equals("$[SigAlgOID]")) {
                filter.append(cert.getSigAlgOID());
                continue;
            }
            if (str.equals("${SigAlgParams}") || str.equals("$[SigAlgParams]")) {
                filter.append(new String(cert.getSigAlgParams()));
                continue;
            }
            if (str.equals("${Signature}") || str.equals("$[Signature]")) continue;
            if (str.startsWith("${Subject") || str.startsWith("$[Subject")) {
                filter.append(LdapHelper.getDNSubField(str.substring(9, str.length() - 1), this.removeSpacesInDN(cert.getSubjectX500Principal().toString())));
                continue;
            }
            if (str.equals("${SubjectUniqueID}") || str.equals("$[SubjectUniqueID]")) continue;
            if (str.equals("${TBSCertificate}") || str.equals("$[TBSCertificate]")) {
                throw new CertificateMapperException("TBS_CERTIFICATE_UNSUPPORTED", Tr.formatMessage((TraceComponent)tc, (String)"TBS_CERTIFICATE_UNSUPPORTED", null));
            }
            if (str.equals("${Version}") || str.equals("$[Version]")) {
                filter.append(cert.getVersion());
                continue;
            }
            throw new CertificateMapperException("UNKNOWN_CERTIFICATE_ATTRIBUTE", Tr.formatMessage((TraceComponent)tc, (String)"UNKNOWN_CERTIFICATE_ATTRIBUTE", (Object[])WIMMessageHelper.generateMsgParms((Object)str)));
        }
        return filter.toString();
    }

    @Trivial
    public boolean isSetUsePrincipalNameForLogin() {
        return false;
    }

    @Trivial
    public Set<String> getAllSuppotedAttributes() {
        return this.iAttrs;
    }

    public String[] getAttributeNames(List<String> inEntityTypes, List<String> propNames, boolean getMbrshipAttr, boolean getMbrAttr) {
        HashSet<String> attrNames = new HashSet<String>();
        ArrayList<LdapEntity> ldapEntities = null;
        if (inEntityTypes != null && inEntityTypes.size() > 0) {
            ldapEntities = new ArrayList<LdapEntity>(inEntityTypes.size());
            for (String entityType : inEntityTypes) {
                List<LdapEntity> tempLdapEntities = this.getAllLdapEntities(entityType);
                if (tempLdapEntities == null) continue;
                ldapEntities.addAll(tempLdapEntities);
            }
        }
        if (propNames != null) {
            for (int i = 0; i < propNames.size(); ++i) {
                LdapEntity ldapEntity;
                int j;
                String propName = propNames.get(i);
                if ("*".equals(propName)) {
                    if (ldapEntities != null && ldapEntities.size() > 0) {
                        for (j = 0; j < ldapEntities.size(); ++j) {
                            ldapEntity = (LdapEntity)ldapEntities.get(j);
                            attrNames.addAll(ldapEntity.getAttributes());
                        }
                    } else {
                        attrNames.addAll(this.getAllSuppotedAttributes());
                    }
                    attrNames.removeAll(this.entityTypeProps);
                    continue;
                }
                if (ldapEntities != null && ldapEntities.size() > 0) {
                    for (j = 0; j < ldapEntities.size(); ++j) {
                        ldapEntity = (LdapEntity)ldapEntities.get(j);
                        attrNames.add(this.getAttributeName(ldapEntity, propName));
                    }
                    continue;
                }
                attrNames.addAll(this.getAttributeNames(propName));
            }
        }
        if (ldapEntities != null && ldapEntities.size() > 0) {
            for (int i = 0; i < ldapEntities.size(); ++i) {
                LdapEntity ldapEntity = (LdapEntity)ldapEntities.get(i);
                if (!"distinguishedName".equalsIgnoreCase(ldapEntity.getExtId())) {
                    attrNames.add(ldapEntity.getExtId());
                }
                if (!this.needTranslateRDN() || !this.needTranslateRDN(ldapEntity.getName())) continue;
                attrNames.addAll(ldapEntity.getRDNAttributesList());
            }
        } else {
            if (this.needTranslateRDN()) {
                List allEntities = this.getLdapEntities();
                for (int i = 0; i < allEntities.size(); ++i) {
                    attrNames.addAll(((LdapEntity)allEntities.get(i)).getRDNAttributesList());
                }
            }
            attrNames.addAll(this.getExtIds());
        }
        attrNames.add("objectClass");
        if (getMbrshipAttr && this.getMembershipAttribute() != null) {
            attrNames.add(this.getMembershipAttribute());
        }
        if (getMbrAttr) {
            String[] mbrAttrs = this.getMemberAttributes();
            for (int i = 0; i < mbrAttrs.length; ++i) {
                if (mbrAttrs[i] == null) continue;
                attrNames.add(mbrAttrs[i]);
            }
            if (this.supportDynamicGroup()) {
                String[] dynaMbrAttrNames = this.getDynamicMemberAttributes();
                for (int i = 0; i < dynaMbrAttrNames.length; ++i) {
                    if (dynaMbrAttrNames[i] == null) continue;
                    attrNames.add(dynaMbrAttrNames[i]);
                }
            }
        }
        return attrNames.toArray(new String[0]);
    }

    private Set<String> getExtIds() {
        return this.iExtIds;
    }

    public String getAttributeName(LdapEntity ldapEntity, String propName) {
        Matcher matcher = PATTERN_EXTENSIBLE_MATCH_FILTER.matcher(propName);
        if (matcher.matches()) {
            String value;
            String attrName = matcher.find(0) ? matcher.group(1) : null;
            String oid = matcher.find(1) ? matcher.group(2) : null;
            String string = value = matcher.find(2) ? matcher.group(3) : null;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Attribute name: " + attrName + ", OID: " + oid + ", Value:" + value), (Object[])new Object[0]);
            }
            return propName;
        }
        String attrName = ldapEntity.getAttribute(propName);
        if (attrName == null) {
            attrName = this.iPropToAttrMap.get(propName);
        }
        if (attrName == null) {
            int pos = propName.indexOf(":");
            if (pos > -1) {
                return propName.substring(pos + 1);
            }
            return propName;
        }
        return attrName;
    }

    public Set<String> getAttributeNames(String propName) {
        HashSet<String> attrs = new HashSet<String>();
        for (int i = 0; i < this.iLdapEntities.size(); ++i) {
            String attr = this.iLdapEntities.get(i).getAttribute(propName);
            if (attr == null) continue;
            attrs.add(attr);
        }
        String attr = this.iPropToAttrMap.get(propName);
        if (attr != null) {
            attrs.add(attr);
        }
        if (attrs.size() == 0) {
            int pos = propName.indexOf(":");
            if (pos > -1) {
                attrs.add(propName.substring(pos + 1));
            } else {
                attrs.add(propName);
            }
        }
        return attrs;
    }

    @Trivial
    public boolean isAnyExtIdDN() {
        return this.isAnyExtIdDN;
    }

    public String getEntityType(Attributes attrs, String uniqueName, String dn, String extId, List<String> inEntityTypes) throws WIMSystemException {
        Attribute objClsAttr;
        String entityType = "Entity";
        if (this.isRacf()) {
            if (dn.toLowerCase().contains("profiletype=user")) {
                return "PersonAccount";
            }
            if (dn.toLowerCase().contains("profiletype=group")) {
                return "Group";
            }
        }
        if ((objClsAttr = attrs.get("objectClass")) != null) {
            int size = this.iLdapEntities.size();
            ArrayList<String> possibleTypes = new ArrayList<String>(size);
            block0: for (int i = 0; i < size; ++i) {
                LdapEntity ldapEntity = this.iLdapEntities.get(size - (i + 1));
                List<String> objClsList = ldapEntity.getObjectClasses();
                for (String objCls : objClsList) {
                    if (!LdapHelper.containIgnorecaseValue(objClsAttr, objCls)) continue;
                    String type = ldapEntity.getName();
                    if (inEntityTypes != null && inEntityTypes.size() > 0) {
                        for (String inputType : inEntityTypes) {
                            if (inputType.equalsIgnoreCase(type) || Entity.getSubEntityTypes((String)inputType) != null && Entity.getSubEntityTypes((String)inputType).contains(type)) {
                                possibleTypes.add(type);
                                continue;
                            }
                            if (!inputType.equalsIgnoreCase("LoginAccount") || !type.equalsIgnoreCase("PersonAccount")) continue;
                            possibleTypes.add(type);
                        }
                        continue block0;
                    }
                    possibleTypes.add(ldapEntity.getName());
                    continue block0;
                }
            }
            int possibleSize = possibleTypes.size();
            if (possibleSize == 1) {
                entityType = (String)possibleTypes.get(0);
            } else if (possibleSize > 1) {
                entityType = (String)possibleTypes.get(0);
            }
        } else {
            entityType = inEntityTypes.get(0);
        }
        return entityType;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={ClassCastException.class})
    public String getExtIdFromAttributes(String dn, String entityType, Attributes attrs) throws WIMSystemException {
        String extIdName = this.getExtId(entityType);
        if ("distinguishedName".equalsIgnoreCase(extIdName)) {
            return LdapHelper.toUpperCase(dn);
        }
        Attribute extIdAttr = null;
        extIdAttr = attrs.get(extIdName);
        if (extIdAttr == null) {
            return null;
        }
        if (extIdAttr.size() > 1) {
            throw new WIMSystemException("EXT_ID_HAS_MULTIPLE_VALUES", Tr.formatMessage((TraceComponent)tc, (String)"EXT_ID_HAS_MULTIPLE_VALUES", (Object[])WIMMessageHelper.generateMsgParms((Object)extIdName)));
        }
        LdapAttribute ldapAttr = this.getAttribute(extIdName);
        try {
            Object val = extIdAttr.get();
            if (ldapAttr != null && "octetString".equalsIgnoreCase(ldapAttr.getSyntax())) {
                try {
                    byte[] bytes = (byte[])val;
                    return LdapHelper.getOctetString(bytes);
                }
                catch (ClassCastException e) {
                    e.getMessage();
                    return val.toString();
                }
            }
            if (val == null) {
                return null;
            }
            return val.toString();
        }
        catch (NamingException val) {
            void e;
            FFDCFilter.processException((Throwable)val, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConfigManager", (String)"2864", (Object)this, (Object[])new Object[]{dn, entityType, attrs});
            throw new WIMSystemException("NAMING_EXCEPTION", Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true))));
        }
    }

    public String getExtId(String entityType) {
        LdapEntity ldapEntity = this.getLdapEntity(entityType);
        if (ldapEntity != null) {
            return ldapEntity.getExtId();
        }
        if (this.iExtIds.size() == 1) {
            return this.iExtIds.iterator().next();
        }
        return "distinguishedName";
    }

    public LdapAttribute getAttribute(String attrName) {
        return this.iAttrNameToAttrMap.get(attrName.toLowerCase());
    }

    public String switchToNode(String DN) {
        if (DN == null || !this.iNeedSwitchNode) {
            return DN;
        }
        String DNForComparison = DN.toLowerCase();
        StringBuffer uNameBuf = new StringBuffer(DN);
        boolean isUnderNode = false;
        String node = null;
        int n = this.iLdapNodesForCompare.length;
        for (int i = 0; i < n; ++i) {
            int pos = DNForComparison.indexOf(this.iLdapNodesForCompare[i]);
            if (pos <= -1) continue;
            if (pos == 0) {
                if (this.iLdapNodesForCompare[i].length() > 0) {
                    return this.iNodes[i];
                }
                node = this.iNodes[i];
                if (node != null && node.length() != 0) {
                    uNameBuf.append(",");
                }
                isUnderNode = true;
                break;
            }
            uNameBuf = new StringBuffer(uNameBuf.substring(0, pos));
            node = this.iNodes[i];
            isUnderNode = true;
            break;
        }
        if (!isUnderNode) {
            return DN;
        }
        if (node != null && node.length() != 0) {
            uNameBuf.append(node);
        } else if (node != null) {
            uNameBuf = new StringBuffer(uNameBuf.substring(0, uNameBuf.length() - 1));
        }
        return uNameBuf.toString();
    }

    public String getLdapRDNFilter(LdapEntity ldapEntity, String rdnFilter) {
        int i;
        StringBuffer ldapRDNFilter = new StringBuffer();
        ArrayList<String> RDNs = new ArrayList<String>();
        char[] RDNChars = rdnFilter.toCharArray();
        int startPos = 0;
        for (i = 0; i < RDNChars.length; ++i) {
            if (RDNChars[i] != '+' || RDNChars[i - 1] == '\\') continue;
            RDNs.add(rdnFilter.substring(startPos, i));
            startPos = i + 1;
        }
        RDNs.add(rdnFilter.substring(startPos));
        for (i = 0; i < RDNs.size(); ++i) {
            String RDN = (String)RDNs.get(i);
            int pos = RDN.indexOf(61);
            if (pos <= 0) continue;
            String RDNName = RDN.substring(0, pos);
            String RDNValue = RDN.substring(pos + 1);
            if (ldapEntity != null) {
                String ldapRDNName = this.getAttributeName(ldapEntity, RDNName);
                ldapRDNFilter.append("(").append(ldapRDNName).append("=").append(RDNValue).append(")");
                continue;
            }
            Set<String> ldapRDNNames = this.getAttributeNames(RDNName);
            if (ldapRDNNames.size() > 1) {
                ldapRDNFilter.append("(|");
            }
            for (String ldapRDNName : ldapRDNNames) {
                ldapRDNFilter.append("(").append(ldapRDNName).append("=").append(RDNValue).append(")");
            }
            if (ldapRDNNames.size() <= 1) continue;
            ldapRDNFilter.append(")");
        }
        if (RDNs.size() > 1) {
            ldapRDNFilter.insert(0, "(&").append(")");
        }
        return ldapRDNFilter.toString();
    }

    @Trivial
    public String[] getDynamicMemberAttributes() {
        return (String[])this.iDynaMbrAttrs.clone();
    }

    @Trivial
    public String getDynamicGroupFilter() {
        return this.iDynaGrpFilter;
    }

    public Set<String> getAttributeNames(Set<String> entityTypes, String propName) {
        HashSet<String> attrs = new HashSet();
        if (entityTypes == null) {
            attrs = this.getAttributeNames(propName);
        } else {
            for (String entityType : entityTypes) {
                String attr;
                LdapEntity ldapEntity = this.getLdapEntity(entityType);
                if (ldapEntity == null || (attr = this.getAttributeName(ldapEntity, propName)) == null) continue;
                attrs.add(attr);
            }
        }
        return attrs;
    }

    public Object getLdapValue(Object value, String dataType, String ldapAttrName) throws WIMSystemException {
        LdapAttribute ldapAttr = this.getLdapAttribute(ldapAttrName);
        Object ldapValue = "String".equals(dataType) ? LdapHelper.getStringLdapValue(value, ldapAttr, this.getLdapType()) : ("DateTime".equals(dataType) || "Date".equals(dataType) ? LdapHelper.getDateLdapValue(value, ldapAttr, this.getLdapType()) : ("Int".equals(dataType) ? LdapHelper.getIntLdapValue(value, ldapAttr, this.getLdapType()) : ("LangType".equals(dataType) ? (value instanceof LangType ? ((LangType)value).getValue() : value.toString()) : value)));
        return ldapValue;
    }

    public short getOperator(String operator) {
        if (operator == null) {
            return -1;
        }
        if (operator.equals("=")) {
            return 0;
        }
        if (operator.equals("!=")) {
            return 1;
        }
        if (operator.equals(">")) {
            return 2;
        }
        if (operator.equals("<")) {
            return 3;
        }
        if (operator.equals(">=")) {
            return 4;
        }
        if (operator.equals("<=")) {
            return 5;
        }
        return -1;
    }

    public String getSyntax(String ldapAttrName) {
        LdapAttribute attr = this.iAttrNameToAttrMap.get(ldapAttrName.toLowerCase());
        if (attr != null) {
            return attr.getSyntax();
        }
        return "string";
    }

    private void setCertificateMapMode(String certMapMode) {
        this.iCertMapMode = "CERTIFICATE_FILTER".equalsIgnoreCase(certMapMode) ? "CERTIFICATE_FILTER" : "EXACT_DN";
    }

    private void setCertificateFilter(String certFilter) throws CertificateMapperException {
        this.iCertFilterEles = LdapHelper.parseFilterDescriptor(certFilter);
    }

    private void setNodes(List<HashMap<String, String>> entryList) throws InvalidInitPropertyException {
        int size = entryList.size();
        HashMap<String, String> nodeMap = new HashMap<String, String>(size);
        HashMap<String, String> reposNodeMap = new HashMap<String, String>(size);
        String[] originReposNodes = new String[size];
        for (int i = 0; i < entryList.size(); ++i) {
            HashMap<String, String> entry = entryList.get(i);
            String nodeName = UniqueNameHelper.getValidUniqueName((String)entry.keySet().iterator().next());
            if (nodeName == null) {
                throw new InvalidInitPropertyException("INVALID_UNIQUE_NAME_SYNTAX", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_UNIQUE_NAME_SYNTAX", null));
            }
            String reposNodeName = entry.get(nodeName);
            if (reposNodeName == null) {
                reposNodeName = nodeName;
            } else if ((reposNodeName = LdapHelper.getValidDN(reposNodeName)) == null) {
                throw new InvalidInitPropertyException("INVALID_DN_SYNTAX", Tr.formatMessage((TraceComponent)tc, (String)"INVALID_DN_SYNTAX", null));
            }
            if (!this.iNeedSwitchNode && !nodeName.equalsIgnoreCase(reposNodeName)) {
                this.iNeedSwitchNode = true;
            }
            originReposNodes[i] = reposNodeName;
            String lowNodeName = nodeName.toLowerCase();
            nodeMap.put(lowNodeName, nodeName);
            reposNodeMap.put(lowNodeName, reposNodeName);
        }
        int nodeSize = nodeMap.size();
        String[] keyNodes = nodeMap.keySet().toArray(new String[0]);
        Arrays.sort(keyNodes, new StringLengthComparator());
        this.iNodes = new String[nodeSize];
        this.iNodesForCompare = new String[nodeSize];
        this.iLdapNodes = new String[nodeSize];
        this.iLdapNodesForCompare = new String[nodeSize];
        for (int i = 0; i < nodeSize; ++i) {
            String nodeForCompare = keyNodes[i];
            String node = (String)nodeMap.get(nodeForCompare);
            String reposNode = (String)reposNodeMap.get(nodeForCompare);
            String reposNodeForCompare = reposNode.toLowerCase();
            this.iNodes[i] = node;
            this.iNodesForCompare[i] = nodeForCompare;
            this.iLdapNodes[i] = reposNode;
            this.iLdapNodesForCompare[i] = reposNodeForCompare;
        }
        this.iTopLdapNodes = NodeHelper.getTopNodes((String[])originReposNodes);
    }

    private void setGroupSeachScope(Map<String, Object> configProps) {
        if (configProps.get("recursiveSearch") != null && configProps.get("recursiveSearch") instanceof Boolean) {
            this.iRecursiveSearch = (Boolean)configProps.get("recursiveSearch");
        }
    }

    @Trivial
    public boolean isRecursiveSearch() {
        return this.iRecursiveSearch;
    }

    @Trivial
    public boolean isLdapOperationalAttributeSet() {
        return this.iLdapOperationalAttr;
    }

    @Trivial
    public boolean updateGroupMembership() {
        return this.getLdapType().startsWith("DOMINO") || this.getLdapType().startsWith("SUNONE");
    }

    @Trivial
    public String getDummyMember(String mbrAttr) {
        if (this.iDummyMbrMap.containsKey(mbrAttr)) {
            return this.iDummyMbrMap.get(mbrAttr);
        }
        return this.defaultDummyMember();
    }

    private String defaultDummyMember() {
        if (this.iLdapType.startsWith("IBM TIVOLI DIRECTORY SERVER") || this.iLdapType.startsWith("IBM LOTUS DOMINO")) {
            return "uid=dummy";
        }
        return null;
    }

    @Trivial
    public Set<String> getAttributesWithDefaultValue() {
        return this.iDefaultValueAttrs;
    }

    @Trivial
    public Set<String> getAttributesWithDefaultAttribute() {
        return this.iDefaultAttrAttrs;
    }

    public String getGroupMemberIdMap() {
        return this.iGroupMemberIdMap;
    }

    public boolean isRacf() {
        return this.isRacf;
    }

    public List<String> getLoginProperties() {
        return this.iLoginProps;
    }

    public Map getAttributes() {
        return this.iAttrNameToAttrMap;
    }
}

