/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.wim.adapter.ldap;

import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.security.wim.ConfigConstants;
import com.ibm.websphere.security.wim.ras.WIMMessageHelper;
import com.ibm.websphere.security.wim.ras.WIMTraceHelper;
import com.ibm.ws.config.xml.internal.nester.Nester;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.wim.FactoryManager;
import com.ibm.ws.security.wim.adapter.ldap.CachedNamingEnumeration;
import com.ibm.ws.security.wim.adapter.ldap.LdapAttribute;
import com.ibm.ws.security.wim.adapter.ldap.LdapConfigManager;
import com.ibm.ws.security.wim.adapter.ldap.LdapEntity;
import com.ibm.ws.security.wim.adapter.ldap.LdapEntry;
import com.ibm.ws.security.wim.adapter.ldap.LdapHelper;
import com.ibm.ws.security.wim.adapter.ldap.LdapURL;
import com.ibm.ws.security.wim.adapter.ldap.TimedDirContext;
import com.ibm.ws.security.wim.env.ICacheUtil;
import com.ibm.wsspi.kernel.service.utils.SerializableProtectedString;
import com.ibm.wsspi.security.wim.exception.EntityAlreadyExistsException;
import com.ibm.wsspi.security.wim.exception.EntityHasDescendantsException;
import com.ibm.wsspi.security.wim.exception.EntityNotFoundException;
import com.ibm.wsspi.security.wim.exception.InvalidInitPropertyException;
import com.ibm.wsspi.security.wim.exception.MissingInitPropertyException;
import com.ibm.wsspi.security.wim.exception.OperationNotSupportedException;
import com.ibm.wsspi.security.wim.exception.WIMApplicationException;
import com.ibm.wsspi.security.wim.exception.WIMException;
import com.ibm.wsspi.security.wim.exception.WIMSystemException;
import com.ibm.wsspi.security.wim.model.IdentifierType;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.naming.CommunicationException;
import javax.naming.ContextNotEmptyException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.ServiceUnavailableException;
import javax.naming.SizeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.Control;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.PagedResultsControl;
import javax.naming.ldap.PagedResultsResponseControl;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class LdapConnection {
    private static final String SERVER2 = "server";
    private static final String FAILOVER_SERVERS = "failoverServers";
    private static final TraceComponent tc = Tr.register(LdapConnection.class);
    private String reposId = null;
    private static final String KEY_ID = "config.id";
    private final Object lock = new Object(){
        static final long serialVersionUID = 3219853865938305873L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(1.class);
        }
    };
    private boolean iSearchResultsCacheEnabled = true;
    private String iSearchResultsCacheName = "SearchResultsCache";
    private ICacheUtil iSearchResultsCache = null;
    private int iSearchResultsCacheSize = 2000;
    private long iSearchResultsCacheTimeOut = 1200000L;
    private int iSearchResultSizeLmit = 2000;
    private boolean iAttrsCacheEnabled = true;
    private String iAttrsCacheName = "AttributesCache";
    private ICacheUtil iAttrsCache = null;
    private int iAttrsCacheSize = 4000;
    private long iAttrsCacheTimeOut = 1200000L;
    private int iAttrsSizeLmit = 2000;
    private String iServerTTLAttr = null;
    private int iCountLimit = 1000;
    private int iTimeLimit = 60000;
    private final long DEFAULT_TIMEOUT = 600000L;
    private LdapConfigManager iLdapConfigMgr = null;
    private int iAttrRangeStep;
    private boolean iEnableContextPool = true;
    private static final String ATTR_RANGE_KEYWORD = ";range=";
    private static final String ATTR_RANGE_QUERY = ";range={0}-{1}";
    private static final String ATTR_RANGE_LAST_QUERY = ";range={0}-*";
    private List<TimedDirContext> iContexts = null;
    private int iInitPoolSize = 1;
    private int iLiveContexts = 0;
    private int iMaxPoolSize = 0;
    private int iPrefPoolSize = 3;
    private long iPoolWaitTime = 3000L;
    private long iPoolTimeOut = 0L;
    private long iPoolCreateTimestampSeconds = 0L;
    private long iPoolCreateTimestampMillisec = 0L;
    private static final int URLTYPE_SINGLE = 0;
    private static final int URLTYPE_SEQUENCE = 1;
    private static final String ENVKEY_ACTIVE_URL = "_ACTIVE_URL_";
    private static final String ENVKEY_URL_LIST = "_URL_LIST_";
    private static final String LDAP_DN = "distinguishedName";
    public static final String WAS_SSL_SOCKET_FACTORY = "com.ibm.ws.ssl.protocol.LibertySSLSocketFactory";
    private static final AtomicLong LDAP_STATS_TIMER = new AtomicLong(0L);
    private static final AtomicInteger QUICK_LDAP_BIND = new AtomicInteger(0);
    private static int LDAP_CONNECT_TIMEOUT_TRACE = 1000;
    private Hashtable<String, Object> iEnvironment = null;
    private boolean iReturnToPrimary = false;
    private long iQueryInterval = 900L;
    private long iLastQueryTime = System.currentTimeMillis() / 1000L;
    private String iSSLAlias = null;
    private final Control[] iConnCtls = null;
    private int iPageSize = 0;
    private NameParser iNameParser = null;
    private boolean iWriteToSecondary = false;
    protected String iSSLFactory = null;
    private Hashtable<String, String[]> iEnityAttrIds = null;
    private String[] iAttrIds = null;
    private boolean ignoreDNCase = true;
    static final long serialVersionUID = 6489547541052574842L;

    @Trivial
    private String getActiveURL() {
        return (String)this.iEnvironment.get(ENVKEY_ACTIVE_URL);
    }

    @Trivial
    private String getPrimaryURL() {
        return this.getEnvURLList().get(0);
    }

    @Trivial
    private List<String> getEnvURLList() {
        return (List)this.iEnvironment.get(ENVKEY_URL_LIST);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Trivial
    private void setActiveURL(String activeURL) {
        Object object = this.lock;
        synchronized (object) {
            this.iEnvironment.put(ENVKEY_ACTIVE_URL, activeURL);
        }
    }

    @Trivial
    private String getNextURL(String currentURL) {
        List<String> urlList = this.getEnvURLList();
        int urlIndex = this.getURLIndex(currentURL, urlList);
        return urlList.get((urlIndex + 1) % urlList.size());
    }

    @Trivial
    private static String toKey(String name, String filter, SearchControls cons) {
        int length = name.length() + filter.length() + 100;
        StringBuffer key = new StringBuffer(length);
        key.append(name);
        key.append("|");
        key.append(filter);
        key.append("|");
        key.append(cons.getSearchScope());
        key.append("|");
        key.append(cons.getCountLimit());
        key.append("|");
        key.append(cons.getTimeLimit());
        String[] attrIds = cons.getReturningAttributes();
        if (attrIds != null) {
            for (int i = 0; i < attrIds.length; ++i) {
                key.append("|");
                key.append(attrIds[i]);
            }
        }
        return key.toString();
    }

    @Trivial
    private static String toKey(String name, String filterExpr, Object[] filterArgs, SearchControls cons) {
        int i;
        int length = name.length() + filterExpr.length() + filterArgs.length + 200;
        StringBuffer key = new StringBuffer(length);
        key.append(name);
        key.append("|");
        key.append(filterExpr);
        String[] attrIds = cons.getReturningAttributes();
        for (i = 0; i < filterArgs.length; ++i) {
            key.append("|");
            key.append(filterArgs[i]);
        }
        if (attrIds != null) {
            for (i = 0; i < attrIds.length; ++i) {
                key.append("|");
                key.append(attrIds[i]);
            }
        }
        return key.toString();
    }

    /*
     * WARNING - void declaration
     */
    public NameParser getNameParser() throws WIMException {
        String METHODNAME = "getNameParser()";
        if (this.iNameParser == null) {
            TimedDirContext ctx = this.getDirContext();
            try {
                try {
                    this.iNameParser = ctx.getNameParser("");
                }
                catch (NamingException namingException) {
                    void e;
                    FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"521", (Object)this, (Object[])new Object[0]);
                    if (!this.isConnectionException((NamingException)e, "getNameParser()")) {
                        throw e;
                    }
                    ctx = this.reCreateDirContext(ctx, e.toString());
                    this.iNameParser = ctx.getNameParser("");
                }
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"528", (Object)this, (Object[])new Object[0]);
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])new Object[]{WIMMessageHelper.generateMsgParms((Object)e.toString(true)), e});
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
            finally {
                this.releaseDirContext(ctx);
            }
        }
        return this.iNameParser;
    }

    public LdapConnection(LdapConfigManager ldapConfigMgr) {
        this.iLdapConfigMgr = ldapConfigMgr;
    }

    /*
     * WARNING - void declaration
     */
    public void initialize(Map<String, Object> configProps) throws WIMException {
        block3: {
            String METHODNAME = "initialize(DataObject)";
            this.reposId = (String)configProps.get(KEY_ID);
            this.initializeServers(configProps);
            this.initializeContextPool(configProps);
            this.iAttrsCacheName = this.reposId + "/" + this.iAttrsCacheName;
            this.iSearchResultsCacheName = this.reposId + "/" + this.iSearchResultsCacheName;
            try {
                this.createContextPool(this.iInitPoolSize, null);
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"565", (Object)this, (Object[])new Object[]{configProps});
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)("initialize(DataObject) Can not create context pool: " + e.toString(true)), (Object[])new Object[0]);
            }
        }
        this.initializeCaches(configProps);
        this.ignoreDNCase = (Boolean)configProps.get(ConfigConstants.CONFIG_IGNORE_CASE);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Set ignoreDNCase as [" + this.ignoreDNCase + "]"), (Object[])new Object[0]);
        }
    }

    private void initializeCaches(Map<String, Object> configProps) {
        String METHODNAME = "initializeCaches(DataObject)";
        List<Map<String, Object>> cacheConfigs = Nester.nest("ldapCache", configProps);
        Map<String, Object> attrCacheConfig = null;
        Map<String, Object> searchResultsCacheConfig = null;
        if (!cacheConfigs.isEmpty()) {
            List<Map<String, Object>> searchList;
            Map<String, Object> cacheConfig = cacheConfigs.get(0);
            Map<String, List<Map<String, Object>>> cacheInfo = Nester.nest(cacheConfig, "attributesCache", "searchResultsCache");
            List<Map<String, Object>> attrList = cacheInfo.get("attributesCache");
            if (!attrList.isEmpty()) {
                attrCacheConfig = attrList.get(0);
            }
            if (!(searchList = cacheInfo.get("searchResultsCache")).isEmpty()) {
                searchResultsCacheConfig = searchList.get(0);
            }
            if (attrCacheConfig != null) {
                this.iAttrsCacheEnabled = (Boolean)attrCacheConfig.get("enabled");
                if (this.iAttrsCacheEnabled) {
                    this.iAttrsCacheSize = (Integer)attrCacheConfig.get("size");
                    this.iAttrsCacheTimeOut = (Long)attrCacheConfig.get("timeout");
                    this.iAttrsSizeLmit = (Integer)attrCacheConfig.get("sizeLimit");
                    this.iServerTTLAttr = (String)attrCacheConfig.get("serverTTLAttribute");
                    this.initializeRetrieveAttrIds();
                }
            }
            if (searchResultsCacheConfig != null) {
                this.iSearchResultsCacheEnabled = (Boolean)searchResultsCacheConfig.get("enabled");
                if (this.iSearchResultsCacheEnabled) {
                    this.iSearchResultsCacheSize = (Integer)searchResultsCacheConfig.get("size");
                    this.iSearchResultsCacheTimeOut = (Long)searchResultsCacheConfig.get("timeout");
                    this.iSearchResultSizeLmit = (Integer)searchResultsCacheConfig.get("resultsSizeLimit");
                }
            }
        }
        if (this.iAttrsCacheEnabled) {
            this.createAttributesCache();
            if (this.iAttrsCache == null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("initializeCaches(DataObject) Attributes Cache: " + this.iAttrsCacheName + " is not available because cache is not available yet."), (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initializeCaches(DataObject) Attributes Cache: " + this.iAttrsCacheName + " is disabled."), (Object[])new Object[0]);
        }
        if (this.iSearchResultsCacheEnabled) {
            this.createSearchResultsCache();
            if (this.iSearchResultsCache == null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("initializeCaches(DataObject) Search Results Cache: " + this.iSearchResultsCacheName + " is not available because cache is not available yet."), (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initializeCaches(DataObject) Search Results Cache: " + this.iSearchResultsCacheName + " is disabled."), (Object[])new Object[0]);
        }
    }

    public void initializeRetrieveAttrIds() {
        this.iEnityAttrIds = new Hashtable();
        List ldapEntities = this.iLdapConfigMgr.getLdapEntities();
        HashSet<String> allAttrIds = new HashSet<String>();
        String[] temp = new String[]{};
        for (int i = 0; i < ldapEntities.size(); ++i) {
            String membershipAttr;
            Set<String> attrIds = ((LdapEntity)ldapEntities.get(i)).getAttributes();
            attrIds.add("objectClass");
            String extId = ((LdapEntity)ldapEntities.get(i)).getExtId();
            if (!LDAP_DN.equalsIgnoreCase(extId)) {
                attrIds.add(extId);
            }
            attrIds.remove("userPassword");
            attrIds.remove("unicodePwd");
            if (this.iServerTTLAttr != null) {
                attrIds.add(this.iServerTTLAttr);
            }
            if ((membershipAttr = this.iLdapConfigMgr.getMembershipAttribute()) != null) {
                attrIds.add(membershipAttr);
            }
            this.iEnityAttrIds.put(((LdapEntity)ldapEntities.get(i)).getName(), attrIds.toArray(temp));
            allAttrIds.addAll(attrIds);
        }
        allAttrIds.add("objectClass");
        String[] mbrAttrs = this.iLdapConfigMgr.getMemberAttributes();
        HashSet<String> allAttrIdsWithGrpMbrs = new HashSet<String>(allAttrIds);
        for (int i = 0; i < mbrAttrs.length; ++i) {
            allAttrIdsWithGrpMbrs.add(mbrAttrs[i]);
        }
        this.iAttrIds = allAttrIds.toArray(temp);
    }

    private void initializeContextPool(Map<String, Object> configProps) throws InvalidInitPropertyException {
        String METHODNAME = "initializeContextPool(DataObject)";
        this.iEnableContextPool = true;
        List<Map<String, Object>> poolConfigs = Nester.nest("contextPool", configProps);
        Map<String, Object> poolConfig = null;
        if (!poolConfigs.isEmpty()) {
            poolConfig = poolConfigs.get(0);
        }
        boolean reuseConn = (Boolean)configProps.get("reuseConnection");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Set reuseConnection as [" + reuseConn + "]"), (Object[])new Object[0]);
        }
        if (poolConfig != null) {
            this.iEnableContextPool = (Boolean)poolConfig.get("enabled");
        }
        if (!reuseConn) {
            this.iEnableContextPool = false;
        }
        long providedPoolTimeOut = this.iPoolTimeOut;
        if (this.iEnableContextPool) {
            if (poolConfig != null) {
                if (poolConfig.get("initialSize") != null) {
                    this.iInitPoolSize = (Integer)poolConfig.get("initialSize");
                }
                if (poolConfig.get("maxSize") != null) {
                    this.iMaxPoolSize = (Integer)poolConfig.get("maxSize");
                }
                if (poolConfig.get("preferredSize") != null) {
                    this.iPrefPoolSize = (Integer)poolConfig.get("preferredSize");
                }
                if (this.iMaxPoolSize != 0 && this.iMaxPoolSize < this.iInitPoolSize) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"INIT_POOL_SIZE_TOO_BIG", (Object[])WIMMessageHelper.generateMsgParms((Object)this.iInitPoolSize, (Object)this.iMaxPoolSize));
                    throw new InvalidInitPropertyException("INIT_POOL_SIZE_TOO_BIG", msg);
                }
                if (this.iMaxPoolSize != 0 && this.iPrefPoolSize != 0 && this.iMaxPoolSize < this.iPrefPoolSize) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"PREF_POOL_SIZE_TOO_BIG", (Object[])WIMMessageHelper.generateMsgParms((Object)this.iInitPoolSize, (Object)this.iMaxPoolSize));
                    throw new InvalidInitPropertyException("PREF_POOL_SIZE_TOO_BIG", msg);
                }
                if (poolConfig.get("timeout") != null) {
                    providedPoolTimeOut = (Long)poolConfig.get("timeout");
                    this.iPoolTimeOut = providedPoolTimeOut > 0L && providedPoolTimeOut <= 1000L ? 1L : this.roundToSeconds(providedPoolTimeOut);
                }
                if (poolConfig.get("waitTime") != null) {
                    this.iPoolWaitTime = (Long)poolConfig.get("waitTime");
                }
            }
            if (tc.isDebugEnabled()) {
                StringBuffer strBuf = new StringBuffer();
                strBuf.append("\nContext Pool is enabled: ").append("\n");
                strBuf.append("\tInitPoolSize: ").append(this.iInitPoolSize).append("\n");
                strBuf.append("\tMaxPoolSize: ").append(this.iMaxPoolSize).append("\n");
                strBuf.append("\tPrefPoolSize: ").append(this.iPrefPoolSize).append("\n");
                strBuf.append("\tPoolTimeOut: ").append(providedPoolTimeOut).append(" rounded to ").append(this.iPoolTimeOut).append("\n");
                strBuf.append("\tPoolWaitTime: ").append(this.iPoolWaitTime);
                Tr.debug((TraceComponent)tc, (String)("initializeContextPool(DataObject)" + strBuf.toString()), (Object[])new Object[0]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"initializeContextPool(DataObject)\nContext Pool is disabled.", (Object[])new Object[0]);
        }
    }

    private void initializeServers(Map<String, Object> configProps) throws WIMException {
        if (configProps.containsKey("searchTimeout")) {
            long val = Long.parseLong(String.valueOf(configProps.get("searchTimeout")));
            this.iTimeLimit = (int)val;
        }
        if (configProps.containsKey("searchCountLimit")) {
            this.iCountLimit = (Integer)configProps.get("searchCountLimit");
        }
        if (configProps.containsKey("searchPageSize")) {
            this.iPageSize = (Integer)configProps.get("searchPageSize");
        } else if (this.iLdapConfigMgr.getLdapType().startsWith("MICROSOFT ACTIVE DIRECTORY")) {
            this.iPageSize = 1000;
        }
        if (configProps.containsKey("attributeRangeStep")) {
            this.iAttrRangeStep = Integer.parseInt((String)configProps.get("attributeRangeStep"));
        } else if (this.iLdapConfigMgr.getLdapType().equals("AD2000") || this.iLdapConfigMgr.getLdapType().equals("ADAM")) {
            this.iAttrRangeStep = 1000;
        } else if (this.iLdapConfigMgr.getLdapType().startsWith("AD2003")) {
            this.iAttrRangeStep = 1500;
        } else if (this.iLdapConfigMgr.getLdapType().startsWith("MICROSOFT ACTIVE DIRECTORY")) {
            this.iAttrRangeStep = 1000;
        }
        this.iWriteToSecondary = Boolean.getBoolean((String)configProps.get("allowWriteToSecondaryServers"));
        this.iReturnToPrimary = (Boolean)configProps.get("returnToPrimaryServer");
        this.iQueryInterval = (Integer)configProps.get("primaryServerQueryTimeInterval") * 60;
        this.initializeSSL(configProps);
        List<Map<String, Object>> serversConfig = Nester.nest(FAILOVER_SERVERS, configProps);
        boolean sslEnabled = (Boolean)configProps.get("sslEnabled");
        this.iEnvironment = this.initializeEnvironmentProperties(sslEnabled, serversConfig, configProps);
    }

    private Hashtable<String, Object> initializeEnvironmentProperties(boolean sslEnabled, List<Map<String, Object>> serversConfig, Map<String, Object> configProps) throws WIMApplicationException {
        Long cTimeout;
        String bindDN;
        String METHODNAME = "initializeEnvironmentProperties";
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        String urlPrefix = null;
        if (sslEnabled) {
            env.put("java.naming.ldap.factory.socket", WAS_SSL_SOCKET_FACTORY);
            env.put("java.naming.security.protocol", "ssl");
            urlPrefix = "ldaps://";
        } else {
            urlPrefix = "ldap://";
        }
        ArrayList<String> urlList = new ArrayList<String>();
        String mainHost = (String)configProps.get("host");
        int mainPort = (Integer)configProps.get("port");
        urlList.add(urlPrefix + mainHost.trim() + ":" + mainPort);
        for (Map<String, Object> serverConfig : serversConfig) {
            List<Map<String, Object>> servers = Nester.nest(SERVER2, serverConfig);
            for (Map<String, Object> server : servers) {
                String ldapHost = (String)server.get("host");
                if (!(ldapHost.startsWith("[") && ldapHost.endsWith("]") || !LdapHelper.isIPv6Addr(ldapHost))) {
                    ldapHost = LdapHelper.formatIPv6Addr(ldapHost);
                }
                if (server.get("port") == null) continue;
                int ldapPort = (Integer)server.get("port");
                urlList.add(urlPrefix + ldapHost.trim() + ":" + ldapPort);
            }
        }
        if (urlList != null && urlList.size() > 0) {
            String url = (String)urlList.get(0);
            env.put(ENVKEY_URL_LIST, urlList);
            env.put(ENVKEY_ACTIVE_URL, url);
            env.put("java.naming.provider.url", url);
        }
        if ((bindDN = (String)configProps.get("bindDN")) != null && bindDN.length() > 0) {
            env.put("java.naming.security.principal", bindDN);
            SerializableProtectedString sps = (SerializableProtectedString)configProps.get("bindPassword");
            String password = sps == null ? "" : new String(sps.getChars());
            String decodedPassword = PasswordUtil.passwordDecode((String)password.trim());
            if (decodedPassword == null || decodedPassword.length() == 0) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"MISSING_INI_PROPERTY", (Object[])WIMMessageHelper.generateMsgParms((Object)"bindPassword"));
                throw new MissingInitPropertyException("MISSING_INI_PROPERTY", msg);
            }
            env.put("java.naming.security.credentials", new ProtectedString(decodedPassword.toCharArray()));
        }
        if ((cTimeout = (Long)configProps.get("connectTimeout")) != null) {
            env.put("com.sun.jndi.ldap.connect.timeout", cTimeout.toString());
        } else {
            env.put("com.sun.jndi.ldap.connect.timeout", 600000L);
        }
        String referal = (String)configProps.get("referal");
        String referral = (String)configProps.get("referral");
        referral = referal != null ? referal : referral;
        env.put("java.naming.referral", referral.toLowerCase());
        String binAttrNames = this.getBinaryAttributes();
        if (binAttrNames != null && binAttrNames.length() > 0) {
            env.put("java.naming.ldap.attributes.binary", binAttrNames);
        }
        if (tc.isDebugEnabled()) {
            StringBuffer strBuf = new StringBuffer();
            strBuf.append("\nLDAP Server(s): ").append(urlList).append("\n");
            strBuf.append("\tBind DN: ").append(bindDN).append("\n");
            strBuf.append("\tReferral: ").append(referral).append("\n");
            Tr.debug((TraceComponent)tc, (String)("initializeEnvironmentProperties" + strBuf.toString()), (Object[])new Object[0]);
        }
        return env;
    }

    private void initializeSSL(Map<String, Object> configProps) {
        String METHODNAME = "initializeSSL(DataObject)";
        String sslAlias = (String)configProps.get("sslRef");
        if (sslAlias != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("initializeSSL(DataObject) Use WAS SSL Configuration. " + sslAlias), (Object[])new Object[0]);
            }
            this.iSSLAlias = sslAlias;
        }
    }

    private void createSearchResultsCache() {
        String METHODNAME = "createSearchResultsCache";
        if (this.iSearchResultsCacheEnabled && FactoryManager.getCacheUtil().isCacheAvailable()) {
            this.iSearchResultsCache = FactoryManager.getCacheUtil().initialize(this.iSearchResultsCacheSize, this.iSearchResultsCacheSize, this.iSearchResultsCacheTimeOut);
            if (this.iSearchResultsCache != null && tc.isDebugEnabled()) {
                StringBuilder strBuf = new StringBuilder("createSearchResultsCache");
                strBuf.append(" \nSearch Results Cache: ").append(this.iSearchResultsCacheName).append(" is enabled:\n");
                strBuf.append("\tCacheSize: ").append(this.iSearchResultsCacheSize).append("\n");
                strBuf.append("\tCacheTimeOut: ").append(this.iSearchResultsCacheTimeOut).append("\n");
                strBuf.append("\tCacheResultSizeLimit: ").append(this.iSearchResultSizeLmit).append("\n");
                Tr.debug((TraceComponent)tc, (String)strBuf.toString(), (Object[])new Object[0]);
            }
        }
    }

    private void createAttributesCache() {
        String METHODNAME = "createAttributesCache";
        if (this.iAttrsCacheEnabled && FactoryManager.getCacheUtil().isCacheAvailable()) {
            this.iAttrsCache = FactoryManager.getCacheUtil().initialize(this.iAttrsCacheSize, this.iAttrsCacheSize, this.iAttrsCacheTimeOut);
            if (this.iAttrsCache != null && tc.isDebugEnabled()) {
                StringBuilder strBuf = new StringBuilder("createAttributesCache");
                strBuf.append(" \nAttributes Cache: ").append(this.iAttrsCacheName).append(" is enabled:\n");
                strBuf.append("\tCacheSize: ").append(this.iAttrsCacheSize).append("\n");
                strBuf.append("\tCacheTimeOut: ").append(this.iAttrsCacheTimeOut).append("\n");
                strBuf.append("\tCacheSizeLimit: ").append(this.iAttrsSizeLmit).append("\n");
                strBuf.append("\tCacheTTLAttr: ").append(this.iServerTTLAttr).append("\n");
                Tr.debug((TraceComponent)tc, (String)strBuf.toString(), (Object[])new Object[0]);
            }
        }
    }

    private ICacheUtil getSearchResultsCache() {
        if (this.iSearchResultsCache == null) {
            this.createSearchResultsCache();
        }
        return this.iSearchResultsCache;
    }

    private ICacheUtil getAttributesCache() {
        if (this.iAttrsCache == null) {
            this.createAttributesCache();
        }
        return this.iAttrsCache;
    }

    public void invalidateAttributes(String DN, String extId, String uniqueName) {
        String METHODNAME = "invalidateAttributes(String, String, String)";
        if (this.getAttributesCache() != null) {
            if (DN != null) {
                this.getAttributesCache().invalidate((Object)this.toKey(DN));
            }
            if (extId != null) {
                this.getAttributesCache().invalidate((Object)extId);
            }
            if (uniqueName != null) {
                this.getAttributesCache().invalidate((Object)this.toKey(uniqueName));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("invalidateAttributes(String, String, String) " + this.iAttrsCacheName + " size: " + this.getAttributesCache().size()), (Object[])new Object[0]);
            }
        }
    }

    public void invalidateNamesCache() {
        if (this.getSearchResultsCache() != null) {
            this.getSearchResultsCache().clear();
        }
    }

    public void invalidateAttributeCache() {
        if (this.getAttributesCache() != null) {
            this.getAttributesCache().clear();
        }
    }

    @Trivial
    private String toKey(String name) {
        if (this.ignoreDNCase) {
            return name.toLowerCase();
        }
        return name;
    }

    @Trivial
    public boolean isIgnoreCase() {
        return this.ignoreDNCase;
    }

    public LdapEntry getEntityByIdentifier(IdentifierType id, List<String> inEntityTypes, List<String> propNames, boolean getMbrshipAttr, boolean getMbrAttr) throws WIMException {
        return this.getEntityByIdentifier(id.getExternalName(), id.getExternalId(), id.getUniqueName(), inEntityTypes, propNames, getMbrshipAttr, getMbrAttr);
    }

    /*
     * Enabled aggressive block sorting
     */
    public LdapEntry getEntityByIdentifier(String dn, String extId, String uniqueName, List<String> inEntityTypes, List<String> propNames, boolean getMbrshipAttr, boolean getMbrAttr) throws WIMException {
        Attributes attrs;
        block7: {
            String[] attrIds;
            block9: {
                block8: {
                    attrIds = this.iLdapConfigMgr.getAttributeNames(inEntityTypes, propNames, getMbrshipAttr, getMbrAttr);
                    attrs = null;
                    if (dn == null && !this.iLdapConfigMgr.needTranslateRDN()) {
                        dn = this.iLdapConfigMgr.switchToLdapNode(uniqueName);
                    }
                    if (dn == null) break block8;
                    attrs = this.checkAttributesCache(dn, attrIds);
                    break block7;
                }
                if (extId == null) break block9;
                if (this.iLdapConfigMgr.isAnyExtIdDN()) {
                    dn = LdapHelper.getValidDN(extId);
                    if (dn != null) {
                        attrs = this.checkAttributesCache(dn, attrIds);
                        break block7;
                    } else {
                        if (uniqueName == null) {
                            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms(null));
                            throw new EntityNotFoundException("ENTITY_NOT_FOUND", msg);
                        }
                        attrs = this.getAttributesByUniqueName(uniqueName, attrIds, inEntityTypes);
                        dn = LdapHelper.getDNFromAttributes(attrs);
                    }
                    break block7;
                } else {
                    attrs = this.getAttributesByUniqueName(extId, attrIds, inEntityTypes);
                    dn = LdapHelper.getDNFromAttributes(attrs);
                }
                break block7;
            }
            if (uniqueName == null) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms(null));
                throw new EntityNotFoundException("ENTITY_NOT_FOUND", msg);
            }
            attrs = this.getAttributesByUniqueName(uniqueName, attrIds, inEntityTypes);
            dn = LdapHelper.getDNFromAttributes(attrs);
        }
        String entityType = this.iLdapConfigMgr.getEntityType(attrs, uniqueName, dn, extId, inEntityTypes);
        uniqueName = this.getUniqueName(dn, entityType, attrs);
        if (extId != null) return new LdapEntry(dn, extId, uniqueName, entityType, attrs);
        extId = this.iLdapConfigMgr.getExtIdFromAttributes(dn, entityType, attrs);
        return new LdapEntry(dn, extId, uniqueName, entityType, attrs);
    }

    /*
     * WARNING - void declaration
     */
    private String getUniqueName(String dn, String entityType, Attributes attrs) throws WIMException {
        String METHODNAME = "getUniqueName";
        String uniqueName = null;
        dn = this.iLdapConfigMgr.switchToNode(dn);
        if (this.iLdapConfigMgr.needTranslateRDN() && this.iLdapConfigMgr.needTranslateRDN(entityType)) {
            try {
                LdapEntity ldapEntity;
                if (entityType != null && (ldapEntity = this.iLdapConfigMgr.getLdapEntity(entityType)) != null) {
                    String[] rdnName = LdapHelper.getRDNAttributes(dn);
                    String[][] rdnWIMProps = ldapEntity.getWIMRDNProperties();
                    String[][] rdnWIMAttrs = ldapEntity.getWIMRDNAttributes();
                    String[][] rdnAttrs = ldapEntity.getRDNAttributes();
                    Attribute[] rdnAttributes = new Attribute[rdnWIMProps.length];
                    String[] rdnAttrValues = new String[rdnWIMProps.length];
                    for (int i = 0; i < rdnAttrs.length; ++i) {
                        int k;
                        String[] rdnAttr = rdnAttrs[i];
                        boolean isRDN = true;
                        for (int j = 0; j < rdnAttr.length; ++j) {
                            if (rdnAttr[j].equalsIgnoreCase(rdnName[j])) continue;
                            isRDN = false;
                        }
                        if (!isRDN) continue;
                        String[] rdnWIMProp = rdnWIMProps[i];
                        String[] rdnWIMAttr = rdnWIMAttrs[i];
                        boolean retrieveRDNs = false;
                        if (attrs == null) {
                            retrieveRDNs = true;
                        } else {
                            for (k = 0; k < rdnWIMAttr.length; ++k) {
                                if (attrs.get(rdnWIMAttr[k]) != null) continue;
                                retrieveRDNs = true;
                                break;
                            }
                        }
                        if (retrieveRDNs) {
                            attrs = this.getAttributes(dn, rdnWIMAttr);
                        }
                        for (k = 0; k < rdnWIMAttr.length; ++k) {
                            rdnAttributes[k] = attrs.get(rdnWIMAttr[k]);
                            if (rdnAttributes[k] == null) continue;
                            rdnAttrValues[k] = (String)rdnAttributes[k].get();
                        }
                        uniqueName = LdapHelper.replaceRDN(dn, rdnWIMProp, rdnAttrValues);
                    }
                }
            }
            catch (NamingException ldapEntity) {
                void e;
                FFDCFilter.processException((Throwable)ldapEntity, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1221", (Object)this, (Object[])new Object[]{dn, entityType, attrs});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
        }
        if (uniqueName == null) {
            uniqueName = dn;
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getUniqueName Translated uniqueName: " + uniqueName), (Object[])new Object[0]);
        }
        return uniqueName;
    }

    @FFDCIgnore(value={NamingException.class, NameNotFoundException.class})
    private Attributes getAttributes(String name, String[] attrIds) throws WIMException {
        Attributes attributes;
        block14: {
            String METHODNAME = "getAttributes";
            attributes = null;
            if (this.iLdapConfigMgr.getUseEncodingInSearchExpression() != null) {
                name = LdapHelper.encodeAttribute(name, this.iLdapConfigMgr.getUseEncodingInSearchExpression());
            }
            if (this.iAttrRangeStep > 0) {
                attributes = this.getRangeAttributes(name, attrIds);
            } else {
                TimedDirContext ctx = this.getDirContext();
                try {
                    try {
                        if (attrIds.length > 0) {
                            attributes = ctx.getAttributes(new LdapName(name), attrIds);
                            break block14;
                        }
                        attributes = new BasicAttributes();
                    }
                    catch (NamingException e) {
                        if (!this.isConnectionException(e, "getAttributes")) {
                            throw e;
                        }
                        ctx = this.reCreateDirContext(ctx, e.toString());
                        if (attrIds.length > 0) {
                            attributes = ctx.getAttributes(new LdapName(name), attrIds);
                            break block14;
                        }
                        attributes = new BasicAttributes();
                    }
                }
                catch (NameNotFoundException e) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"LDAP_ENTRY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)name, (Object)e.toString(true)));
                    throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", msg, (Throwable)e);
                }
                catch (NamingException e) {
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                    throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
                }
                finally {
                    this.releaseDirContext(ctx);
                }
            }
        }
        return attributes;
    }

    @FFDCIgnore(value={NameNotFoundException.class, NamingException.class})
    private Attributes getRangeAttributes(String name, String[] attrIds) throws WIMException {
        String METHODNAME = "getRangeAttributes";
        Attributes attributes = null;
        TimedDirContext ctx = this.getDirContext();
        try {
            try {
                attributes = ctx.getAttributes(new LdapName(name), attrIds);
            }
            catch (NamingException e) {
                if (!this.isConnectionException(e, "getRangeAttributes")) {
                    throw e;
                }
                ctx = this.reCreateDirContext(ctx, e.toString());
                attributes = ctx.getAttributes(new LdapName(name), attrIds);
            }
            this.supportRangeAttributes(attributes, name, ctx);
        }
        catch (NameNotFoundException e) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"LDAP_ENTRY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)name, (Object)e.toString(true)));
            throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", msg, (Throwable)e);
        }
        catch (NamingException e) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        finally {
            this.releaseDirContext(ctx);
        }
        return attributes;
    }

    public Attributes checkAttributesCache(String name, String[] attrIds) throws WIMException {
        String METHODNAME = "checkAttributesCache";
        Attributes attributes = null;
        if (this.getAttributesCache() != null) {
            String key = this.toKey(name);
            Object cached = this.getAttributesCache().get((Object)key);
            if (cached != null && cached instanceof Attributes) {
                ArrayList<String> missAttrIdList = new ArrayList<String>(attrIds.length);
                Attributes cachedAttrs = (Attributes)cached;
                attributes = new BasicAttributes(true);
                for (int i = 0; i < attrIds.length; ++i) {
                    Attribute attr = LdapHelper.getIngoreCaseAttribute(cachedAttrs, attrIds[i]);
                    if (attr != null) {
                        attributes.put(attr);
                        continue;
                    }
                    missAttrIdList.add(attrIds[i]);
                }
                if (missAttrIdList.size() > 0) {
                    Object[] missAttrIds = missAttrIdList.toArray(new String[0]);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("checkAttributesCache Miss cache: " + key + " " + WIMTraceHelper.printObjectArray((Object[])missAttrIds)), (Object[])new Object[0]);
                    }
                    Attributes missAttrs = this.getAttributes(name, (String[])missAttrIds);
                    this.addAttributes(missAttrs, attributes);
                    this.updateAttributesCache(key, missAttrs, cachedAttrs, (String[])missAttrIds);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkAttributesCache Hit cache: " + key), (Object[])new Object[0]);
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkAttributesCache Miss cache: " + key), (Object[])new Object[0]);
                }
                attributes = this.getAttributes(name, attrIds);
                this.updateAttributesCache(key, attributes, null, attrIds);
            }
        } else {
            attributes = this.getAttributes(name, attrIds);
        }
        return attributes;
    }

    @Trivial
    private void addAttributes(Attributes sourceAttrs, Attributes descAttrs) {
        NamingEnumeration<? extends Attribute> neu = sourceAttrs.getAll();
        while (neu.hasMoreElements()) {
            descAttrs.put((Attribute)neu.nextElement());
        }
    }

    private void updateAttributesCache(String uniqueNameKey, String dn, Attributes newAttrs, String[] attrIds) {
        String METHODNAME = "updateAttributesCache(key,dn,newAttrs)";
        this.getAttributesCache().put((Object)uniqueNameKey, (Object)dn, 1, this.iAttrsCacheTimeOut, 0, null);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("updateAttributesCache(key,dn,newAttrs) Update " + this.iAttrsCacheName + "(size: " + this.getAttributesCache().size() + ")\n" + uniqueNameKey + ": " + dn), (Object[])new Object[0]);
        }
        String dnKey = this.toKey(dn);
        Object cached = this.getAttributesCache().get((Object)dnKey);
        Attributes cachedAttrs = null;
        if (cached != null && cached instanceof Attributes) {
            cachedAttrs = (Attributes)cached;
        }
        this.updateAttributesCache(dnKey, newAttrs, cachedAttrs, attrIds);
    }

    private void updateAttributesCache(String key, Attributes missAttrs, Attributes cachedAttrs, String[] missAttrIds) {
        String METHODNAME = "updateAttributesCache(key,missAttrs,cachedAttrs,missAttrIds)";
        if (missAttrIds != null) {
            if (missAttrIds.length > 0) {
                cachedAttrs = cachedAttrs != null ? (Attributes)cachedAttrs.clone() : new BasicAttributes(true);
                for (int i = 0; i < missAttrIds.length; ++i) {
                    boolean findAttr = false;
                    NamingEnumeration<? extends Attribute> neu = missAttrs.getAll();
                    while (neu.hasMoreElements()) {
                        Attribute attr = (Attribute)neu.nextElement();
                        if (attr.getID().equalsIgnoreCase(missAttrIds[i])) {
                            findAttr = true;
                            if (this.iAttrsSizeLmit > 0 && attr.size() > this.iAttrsSizeLmit) break;
                            cachedAttrs.put(attr);
                            break;
                        }
                        int pos = attr.getID().indexOf(";");
                        if (pos <= 0 || !missAttrIds[i].equalsIgnoreCase(attr.getID().substring(0, pos))) continue;
                        findAttr = true;
                        if (this.iAttrsSizeLmit > 0 && attr.size() > this.iAttrsSizeLmit) break;
                        cachedAttrs.put(attr);
                        break;
                    }
                    if (findAttr) continue;
                    BasicAttribute nullAttr = new BasicAttribute(missAttrIds[i], null);
                    cachedAttrs.put(nullAttr);
                }
                this.getAttributesCache().put((Object)key, (Object)cachedAttrs, 1, this.iAttrsCacheTimeOut, 0, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("updateAttributesCache(key,missAttrs,cachedAttrs,missAttrIds) Update " + this.iAttrsCacheName + "(size: " + this.getAttributesCache().size() + ")\n" + key + ": " + cachedAttrs), (Object[])new Object[0]);
                }
            }
        } else {
            this.updateAttributesCache(key, missAttrs, cachedAttrs);
        }
    }

    private void updateAttributesCache(String key, Attributes missAttrs, Attributes cachedAttrs) {
        String METHODNAME = "updateAttributeCache(key,missAttrs,cachedAttrs)";
        if (missAttrs.size() > 0) {
            cachedAttrs = cachedAttrs != null ? (Attributes)cachedAttrs.clone() : new BasicAttributes(true);
            NamingEnumeration<? extends Attribute> neu = missAttrs.getAll();
            while (neu.hasMoreElements()) {
                Attribute attr = (Attribute)neu.nextElement();
                if (this.iAttrsSizeLmit > 0 && attr.size() > this.iAttrsSizeLmit) continue;
                cachedAttrs.put(attr);
            }
            this.getAttributesCache().put((Object)key, (Object)cachedAttrs, 1, this.iAttrsCacheTimeOut, 0, null);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("updateAttributeCache(key,missAttrs,cachedAttrs) Update " + this.iAttrsCacheName + "(size: " + this.getAttributesCache().size() + ")\n" + key + ": " + cachedAttrs), (Object[])new Object[0]);
            }
        }
    }

    public NamingEnumeration<SearchResult> search(String name, String filter, int scope, String[] attrIds) throws WIMException {
        SearchControls controls = new SearchControls(scope, this.iCountLimit, this.iTimeLimit, attrIds, false, false);
        return this.checkSearchCache(name, filter, null, controls);
    }

    private NamingEnumeration<SearchResult> checkSearchCache(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws WIMException {
        String METHODNAME = "checkSearchCache";
        NamingEnumeration<SearchResult> neu = null;
        if (this.getSearchResultsCache() != null) {
            String key = null;
            key = filterArgs == null ? LdapConnection.toKey(name, filterExpr, cons) : LdapConnection.toKey(name, filterExpr, filterArgs, cons);
            CachedNamingEnumeration cached = (CachedNamingEnumeration)this.getSearchResultsCache().get((Object)key);
            if (cached == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkSearchCache Miss cache: " + key), (Object[])new Object[0]);
                }
                neu = this.search(name, filterExpr, filterArgs, cons, null);
                String[] reqAttrIds = cons.getReturningAttributes();
                neu = this.updateSearchCache(name, key, neu, reqAttrIds);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("checkSearchCache Hit cache: " + key), (Object[])new Object[0]);
                }
                neu = (CachedNamingEnumeration)cached.clone();
            }
        } else {
            neu = this.search(name, filterExpr, filterArgs, cons, null);
        }
        return neu;
    }

    @FFDCIgnore(value={NamingException.class})
    private NamingEnumeration<SearchResult> updateSearchCache(String searchBase, String key, NamingEnumeration<SearchResult> neu, String[] reqAttrIds) throws WIMSystemException {
        String METHODNAME = "updateSearchCache";
        CachedNamingEnumeration clone1 = new CachedNamingEnumeration();
        CachedNamingEnumeration clone2 = new CachedNamingEnumeration();
        int count = LdapConnection.cloneSearchResults(neu, clone1, clone2);
        if (this.iSearchResultSizeLmit == 0 || count < this.iSearchResultSizeLmit) {
            this.getSearchResultsCache().put((Object)key, (Object)clone2, 1, this.iSearchResultsCacheTimeOut, 0, null);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("updateSearchCache Update " + this.iSearchResultsCacheName + "(size: " + this.getSearchResultsCache().size() + ")\n" + key), (Object[])new Object[0]);
            }
            if (this.getAttributesCache() != null) {
                try {
                    count = 0;
                    while (clone2.hasMore()) {
                        SearchResult result = clone2.nextElement();
                        String dnKey = LdapHelper.prepareDN(result.getName(), searchBase);
                        Object cached = this.getAttributesCache().get((Object)dnKey);
                        Attributes cachedAttrs = null;
                        if (cached != null && cached instanceof Attributes) {
                            cachedAttrs = (Attributes)cached;
                        }
                        this.updateAttributesCache(dnKey, result.getAttributes(), cachedAttrs, reqAttrIds);
                        if (++count <= 20) continue;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("updateSearchCache attribute cache updated with " + (count - 1) + " entries. skipping rest."), (Object[])new Object[0]);
                        }
                        break;
                    }
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
        }
        return clone1;
    }

    @FFDCIgnore(value={SizeLimitExceededException.class})
    private static int cloneSearchResults(NamingEnumeration<SearchResult> results, CachedNamingEnumeration clone1, CachedNamingEnumeration clone2) throws WIMSystemException {
        String METHODNAME = "cloneSearchResults(NamingEnumeration, CachedNamingEnumeration, CachedNamingEnumeration)";
        int count = 0;
        try {
            while (results.hasMore()) {
                SearchResult result = (SearchResult)results.nextElement();
                Attributes attrs = (Attributes)result.getAttributes().clone();
                SearchResult cachedResult = new SearchResult(result.getName(), null, null, attrs);
                clone1.add(result);
                clone2.add(cachedResult);
                ++count;
            }
        }
        catch (SizeLimitExceededException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cloneSearchResults(NamingEnumeration, CachedNamingEnumeration, CachedNamingEnumeration) " + e.toString(true)), (Object[])new Object[]{e});
            }
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1607", null, (Object[])new Object[]{results, clone1, clone2});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        return count;
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons, Control[] requestControls) throws WIMException {
        CachedNamingEnumeration cachedNamingEnumeration;
        TimedDirContext ctx;
        block33: {
            String METHODNAME = "search(String, String, Object[], SearchControls)";
            if (this.iPageSize == 0) {
                TimedDirContext ctx2 = this.getDirContext();
                NamingEnumeration<SearchResult> neu = null;
                try {
                    try {
                        if (filterArgs == null) {
                            neu = ctx2.search(new LdapName(name), filterExpr, cons);
                            return neu;
                        }
                        neu = ctx2.search(new LdapName(name), filterExpr, filterArgs, cons);
                        return neu;
                    }
                    catch (NamingException namingException) {
                        void e;
                        FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1629", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                        if (!this.isConnectionException((NamingException)e, "search(String, String, Object[], SearchControls)")) {
                            throw e;
                        }
                        ctx2 = this.reCreateDirContext(ctx2, e.toString());
                        if (filterArgs == null) {
                            neu = ctx2.search(new LdapName(name), filterExpr, cons);
                            return neu;
                        }
                        neu = ctx2.search(new LdapName(name), filterExpr, filterArgs, cons);
                        return neu;
                    }
                }
                catch (NameNotFoundException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1640", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"LDAP_ENTRY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)name, (Object)e.toString(true)));
                    throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", msg, (Throwable)e);
                }
                catch (NamingException e) {
                    FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1643", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                    throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
                }
                finally {
                    this.releaseDirContext(ctx2);
                }
            }
            ctx = this.getDirContext();
            try {
                if (requestControls != null) {
                    ctx.setRequestControls(new Control[]{requestControls[0], new PagedResultsControl(this.iPageSize, false)});
                } else {
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(this.iPageSize, false)});
                }
                byte[] cookie = null;
                int pageCount = 1;
                int count = 0;
                CachedNamingEnumeration allNeu = new CachedNamingEnumeration();
                do {
                    PagedResultsResponseControl resCtrl;
                    NamingEnumeration<SearchResult> neu = null;
                    try {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("search(String, String, Object[], SearchControls) Search page: " + pageCount), (Object[])new Object[0]);
                        }
                        neu = filterArgs == null ? ctx.search(new LdapName(name), filterExpr, cons) : ctx.search(new LdapName(name), filterExpr, filterArgs, cons);
                    }
                    catch (NamingException namingException) {
                        void e;
                        FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1675", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                        if (!(e instanceof CommunicationException)) {
                            if (!(e instanceof ServiceUnavailableException)) throw e;
                        }
                        ctx = this.reCreateDirContext(ctx, e.toString());
                        PagedResultsControl pagedResultsControl = null;
                        pagedResultsControl = cookie != null && cookie.length > 0 ? new PagedResultsControl(this.iPageSize, cookie, false) : new PagedResultsControl(this.iPageSize, false);
                        if (requestControls != null) {
                            ctx.setRequestControls(new Control[]{requestControls[0], pagedResultsControl});
                        } else {
                            ctx.setRequestControls(new Control[]{pagedResultsControl});
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("search(String, String, Object[], SearchControls) Search page (retry): " + pageCount), (Object[])new Object[0]);
                        }
                        neu = filterArgs == null ? ctx.search(new LdapName(name), filterExpr, cons) : ctx.search(new LdapName(name), filterExpr, filterArgs, cons);
                    }
                    if (neu == null) continue;
                    ++pageCount;
                    while (neu.hasMoreElements()) {
                        allNeu.add((SearchResult)neu.nextElement());
                        ++count;
                    }
                    Control[] resCtrls = ctx.getResponseControls();
                    if (resCtrls == null || resCtrls.length <= 0 || (cookie = (resCtrl = (PagedResultsResponseControl)resCtrls[0]).getCookie()) == null || cookie.length <= 0) continue;
                    ctx.setRequestControls(new Control[]{new PagedResultsControl(this.iPageSize, cookie, false)});
                } while (cookie != null && cookie.length > 0 && (long)count < cons.getCountLimit());
                cachedNamingEnumeration = allNeu;
            }
            catch (NamingException cookie) {
                try {
                    void e23333332;
                    FFDCFilter.processException((Throwable)cookie, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1724", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e23333332.toString(true)));
                    throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e23333332);
                    catch (IOException e23333332) {
                        FFDCFilter.processException((Throwable)e23333332, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1727", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                        msg = Tr.formatMessage((TraceComponent)tc, (String)"GENERIC", (Object[])WIMMessageHelper.generateMsgParms((Object)e23333332.toString()));
                        throw new WIMSystemException("GENERIC", msg, (Throwable)e23333332);
                    }
                }
                catch (Throwable throwable) {
                    block32: {
                        try {
                            ctx.setRequestControls(null);
                        }
                        catch (NamingException namingException) {
                            void e;
                            FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1733", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                            if (!tc.isDebugEnabled()) break block32;
                            Tr.debug((TraceComponent)tc, (String)("search(String, String, Object[], SearchControls)" + e.toString(true)), (Object[])new Object[0]);
                        }
                    }
                    this.releaseDirContext(ctx);
                    throw throwable;
                }
            }
            try {
                ctx.setRequestControls(null);
            }
            catch (NamingException resCtrls) {
                void e;
                FFDCFilter.processException((Throwable)resCtrls, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1733", (Object)this, (Object[])new Object[]{name, filterExpr, filterArgs, cons, requestControls});
                if (!tc.isDebugEnabled()) break block33;
                Tr.debug((TraceComponent)tc, (String)("search(String, String, Object[], SearchControls)" + e.toString(true)), (Object[])new Object[0]);
            }
        }
        this.releaseDirContext(ctx);
        return cachedNamingEnumeration;
    }

    /*
     * WARNING - void declaration
     */
    public Attributes getAttributesByUniqueName(String uniqueName, String[] attrIds, List<String> entityTypes) throws WIMException {
        String METHODNAME = "getAttributesByUniqueName";
        String DN = null;
        Attributes attributes = null;
        uniqueName = this.iLdapConfigMgr.switchToLdapNode(uniqueName);
        boolean needTranslate = false;
        if (this.iLdapConfigMgr.needTranslateRDN()) {
            if (entityTypes != null && entityTypes.size() > 0) {
                for (int i = 0; i < entityTypes.size(); ++i) {
                    if (!this.iLdapConfigMgr.needTranslateRDN(entityTypes.get(i))) continue;
                    needTranslate = true;
                    break;
                }
            } else {
                needTranslate = true;
            }
        }
        if (!needTranslate) {
            DN = uniqueName;
            attributes = this.checkAttributesCache(DN, attrIds);
            attributes.put(LDAP_DN, DN);
            return attributes;
        }
        boolean readFromCache = false;
        String uniqueNameKey = "UNIQUENAME::" + this.toKey(uniqueName);
        if (this.getAttributesCache() != null) {
            readFromCache = true;
            Object cached = this.getAttributesCache().get((Object)uniqueNameKey);
            if (cached != null && cached instanceof String) {
                DN = (String)cached;
                try {
                    attributes = this.checkAttributesCache(DN, attrIds);
                    attributes.put(LDAP_DN, DN);
                    return attributes;
                }
                catch (EntityNotFoundException entityNotFoundException) {
                    FFDCFilter.processException((Throwable)entityNotFoundException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1796", (Object)this, (Object[])new Object[]{uniqueName, attrIds, entityTypes});
                    this.getAttributesCache().invalidate((Object)uniqueNameKey);
                }
            }
        }
        String filter = this.iLdapConfigMgr.getLdapRDNFilter(null, LdapHelper.getRDN(uniqueName));
        String parent = LdapHelper.getParentDN(uniqueName);
        SearchControls controls = new SearchControls();
        controls.setTimeLimit(this.iTimeLimit);
        controls.setCountLimit(this.iCountLimit);
        controls.setSearchScope(1);
        controls.setReturningAttributes(attrIds);
        controls.setReturningObjFlag(false);
        TimedDirContext ctx = this.getDirContext();
        NamingEnumeration<SearchResult> neu = null;
        try {
            SearchResult thisEntry;
            try {
                neu = ctx.search(parent, filter, controls);
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1821", (Object)this, (Object[])new Object[]{uniqueName, attrIds, entityTypes});
                if (!this.isConnectionException((NamingException)e, "getAttributesByUniqueName")) {
                    throw e;
                }
                ctx = this.reCreateDirContext(ctx, e.toString());
                neu = ctx.search(parent, filter, controls);
            }
            if (neu.hasMoreElements() && (thisEntry = (SearchResult)neu.nextElement()) != null) {
                DN = LdapHelper.prepareDN(thisEntry.getName(), parent);
                attributes = thisEntry.getAttributes();
                if (this.iAttrRangeStep > 0) {
                    this.supportRangeAttributes(attributes, DN, ctx);
                }
            }
        }
        catch (NameNotFoundException thisEntry) {
            void e;
            FFDCFilter.processException((Throwable)thisEntry, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1839", (Object)this, (Object[])new Object[]{uniqueName, attrIds, entityTypes});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)parent));
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", msg, (Throwable)e);
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"1842", (Object)this, (Object[])new Object[]{uniqueName, attrIds, entityTypes});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        finally {
            this.releaseDirContext(ctx);
        }
        if (attributes != null) {
            if (readFromCache) {
                this.updateAttributesCache(uniqueNameKey, DN, attributes, attrIds);
            }
        } else {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)uniqueName));
            throw new EntityNotFoundException("ENTITY_NOT_FOUND", msg);
        }
        attributes.put(LDAP_DN, DN);
        return attributes;
    }

    public Map<String, LdapEntry> getDynamicGroups(String[] bases, List<String> propNames, boolean getMbrshipAttr) throws WIMException {
        HashMap<String, LdapEntry> dynaGrps = new HashMap<String, LdapEntry>();
        String[] attrIds = this.iLdapConfigMgr.getAttributeNames(this.iLdapConfigMgr.getGroupTypes(), propNames, getMbrshipAttr, false);
        String[] dynaMbrAttrNames = this.iLdapConfigMgr.getDynamicMemberAttributes();
        String[] temp = attrIds;
        attrIds = new String[temp.length + dynaMbrAttrNames.length];
        System.arraycopy(temp, 0, attrIds, 0, temp.length);
        System.arraycopy(dynaMbrAttrNames, 0, attrIds, temp.length, dynaMbrAttrNames.length);
        String dynaGrpFitler = this.iLdapConfigMgr.getDynamicGroupFilter();
        for (String base : bases) {
            NamingEnumeration<SearchResult> urls = this.search(base, dynaGrpFitler, 2, attrIds);
            while (urls.hasMoreElements()) {
                String entryName;
                SearchResult thisEntry = (SearchResult)urls.nextElement();
                if (thisEntry == null || (entryName = thisEntry.getName()) == null || entryName.trim().length() == 0) continue;
                String dn = LdapHelper.prepareDN(entryName, base);
                Attributes attrs = thisEntry.getAttributes();
                String extId = this.iLdapConfigMgr.getExtIdFromAttributes(dn, "Group", attrs);
                String uniqueName = this.getUniqueName(dn, "Group", attrs);
                LdapEntry ldapEntry = new LdapEntry(dn, extId, uniqueName, "Group", attrs);
                dynaGrps.put(ldapEntry.getDN(), ldapEntry);
            }
        }
        return dynaGrps;
    }

    public boolean isMemberInURLQuery(LdapURL[] urls, String dn) throws WIMException {
        boolean result = false;
        String[] attrIds = new String[]{};
        String rdn = LdapHelper.getRDN(dn);
        if (urls != null) {
            for (int i = 0; i < urls.length; ++i) {
                String returnedDN;
                SearchResult thisEntry;
                NamingEnumeration<SearchResult> nenu;
                String searchBase;
                LdapURL ldapURL = urls[i];
                if (!ldapURL.parsedOK() || !LdapHelper.isUnderBases(dn, searchBase = ldapURL.get_dn())) continue;
                int searchScope = ldapURL.get_searchScope();
                String searchFilter = ldapURL.get_filter();
                if (searchScope == 2) {
                    if (searchFilter == null) {
                        result = true;
                        break;
                    }
                    nenu = this.search(dn, searchFilter, 2, attrIds);
                    if (!nenu.hasMoreElements()) continue;
                    result = true;
                    break;
                }
                nenu = this.search(searchBase, searchFilter = searchFilter == null ? rdn : "(&(" + searchFilter + ")(" + rdn + "))", searchScope, attrIds);
                if (!nenu.hasMoreElements() || (thisEntry = (SearchResult)nenu.nextElement()) == null || !dn.equalsIgnoreCase(returnedDN = LdapHelper.prepareDN(thisEntry.getName(), searchBase))) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Set<LdapEntry> searchEntities(String base, String filter, Object[] filterArgs, int scope, List<String> inEntityTypes, List<String> propNames, boolean getMbrshipAttr, boolean getMbrAttr) throws WIMException {
        return this.searchEntities(base, filter, filterArgs, scope, inEntityTypes, propNames, getMbrshipAttr, getMbrAttr, this.iCountLimit, this.iTimeLimit);
    }

    public NamingEnumeration<SearchResult> search(String name, String filter, int scope, String[] attrIds, int countLimit, int timeLimit) throws WIMException {
        SearchControls controls = new SearchControls(scope, countLimit, timeLimit, attrIds, false, false);
        return this.checkSearchCache(name, filter, null, controls);
    }

    public NamingEnumeration<SearchResult> search(String name, String filter, Object[] filterArgs, int scope, String[] attrIds, int countLimit, int timeLimit) throws WIMException {
        SearchControls controls = new SearchControls(scope, countLimit, timeLimit, attrIds, false, false);
        return this.checkSearchCache(name, filter, filterArgs, controls);
    }

    public Set<LdapEntry> searchEntities(String base, String filter, Object[] filterArgs, int scope, List<String> inEntityTypes, List<String> propNames, boolean getMbrshipAttr, boolean getMbrAttr, int countLimit, int timeLimit) throws WIMException {
        String inEntityType = null;
        List<String> supportedProps = propNames;
        if (inEntityTypes != null && inEntityTypes.size() > 0) {
            inEntityType = inEntityTypes.get(0);
            supportedProps = this.iLdapConfigMgr.getSupportedProperties(inEntityType, propNames);
        }
        String[] attrIds = this.iLdapConfigMgr.getAttributeNames(inEntityTypes, supportedProps, getMbrshipAttr, getMbrAttr);
        NamingEnumeration<SearchResult> neu = null;
        neu = filterArgs == null ? this.search(base, filter, scope, attrIds, countLimit, timeLimit) : this.search(base, filter, filterArgs, scope, attrIds, countLimit, timeLimit);
        Set<LdapEntry> entities = this.populateResultSet(neu, base, scope, inEntityTypes, attrIds);
        return entities;
    }

    @FFDCIgnore(value={SizeLimitExceededException.class})
    private Set<LdapEntry> populateResultSet(NamingEnumeration<SearchResult> neu, String base, int scope, List<String> inEntityTypes, String[] attrIds) throws WIMException {
        String METHODNAME = "populateResultSet";
        HashSet<LdapEntry> entities = new HashSet<LdapEntry>();
        try {
            while (neu.hasMore()) {
                SearchResult thisEntry = (SearchResult)neu.nextElement();
                if (thisEntry == null) continue;
                String entryName = thisEntry.getName();
                String dn = LdapHelper.prepareDN(entryName, base);
                if (scope != 0 && base.equalsIgnoreCase(dn)) continue;
                Attributes attrs = thisEntry.getAttributes();
                if (this.iLdapConfigMgr.isRacf() && attrs.size() == 0) {
                    attrs = this.getAttributes(dn, attrIds);
                }
                String entityType = this.iLdapConfigMgr.getEntityType(attrs, null, dn, null, inEntityTypes);
                if (this.iLdapConfigMgr.isRacf() && !inEntityTypes.contains(entityType)) continue;
                String extId = this.iLdapConfigMgr.getExtIdFromAttributes(dn, entityType, attrs);
                String uniqueName = this.getUniqueName(dn, entityType, attrs);
                LdapEntry ldapEntry = new LdapEntry(dn, extId, uniqueName, entityType, attrs);
                entities.add(ldapEntry);
            }
        }
        catch (SizeLimitExceededException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("populateResultSet " + e.toString(true)), (Object[])new Object[0]);
            }
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2026", (Object)this, (Object[])new Object[]{neu, base, scope, inEntityTypes, attrIds});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        return entities;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getAncestorDNs(String DN, int level) throws WIMException {
        if (DN == null || DN.trim().length() == 0) {
            return null;
        }
        try {
            NameParser nameParser = this.getNameParser();
            Name name = nameParser.parse(DN);
            int size = name.size();
            ArrayList<String> ancestorDNs = new ArrayList<String>();
            if (level == 0) {
                level = size;
            }
            for (int i = size - 1; i >= size - level; --i) {
                name.remove(i);
                ancestorDNs.add(name.toString());
            }
            return ancestorDNs;
        }
        catch (NamingException nameParser) {
            void e;
            FFDCFilter.processException((Throwable)nameParser, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2052", (Object)this, (Object[])new Object[]{DN, level});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
    }

    @FFDCIgnore(value={NumberFormatException.class, NamingException.class})
    private void supportRangeAttributes(Attributes attributes, String dn, TimedDirContext ctx) throws WIMException, NamingException {
        String METHODNAME = "supportRangeAttributes";
        NamingEnumeration<? extends Attribute> anu = attributes.getAll();
        while (anu.hasMoreElements()) {
            Attribute attr = (Attribute)anu.nextElement();
            String attrName = attr.getID();
            int pos = attrName.indexOf(ATTR_RANGE_KEYWORD);
            if (pos <= -1) continue;
            String attrId = attrName.substring(0, pos);
            BasicAttribute newAttr = new BasicAttribute(attrId);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("supportRangeAttributes Range attriute retrieved: " + attrName), (Object[])new Object[0]);
            }
            NamingEnumeration<?> neu2 = attr.getAll();
            while (neu2.hasMoreElements()) {
                newAttr.add(neu2.nextElement());
            }
            int rangeLow = this.iAttrRangeStep;
            try {
                rangeLow = Integer.parseInt(attrName.substring(attrName.indexOf(45) + 1)) + 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            int rangeHigh = rangeLow + this.iAttrRangeStep - 1;
            boolean quitLoop = false;
            boolean lastQuery = false;
            do {
                Object[] args;
                String attributeWithRange = null;
                if (!lastQuery) {
                    args = new Object[]{Integer.valueOf(rangeLow).toString(), Integer.valueOf(rangeHigh).toString()};
                    attributeWithRange = attrId + MessageFormat.format(ATTR_RANGE_QUERY, args);
                } else {
                    args = new Object[]{Integer.valueOf(rangeLow).toString()};
                    attributeWithRange = attrId + MessageFormat.format(ATTR_RANGE_LAST_QUERY, args);
                }
                Attributes results = null;
                String[] rAttrIds = new String[]{attributeWithRange};
                try {
                    results = ctx.getAttributes(new LdapName(dn), rAttrIds);
                }
                catch (NamingException e) {
                    if (e instanceof CommunicationException || e instanceof ServiceUnavailableException) {
                        ctx = this.reCreateDirContext(ctx, e.toString());
                        results = ctx.getAttributes(new LdapName(dn), rAttrIds);
                    }
                    throw e;
                }
                Attribute result = results.get(attributeWithRange);
                if (result == null) {
                    Object[] args2 = new Object[]{Integer.valueOf(rangeLow).toString()};
                    attributeWithRange = attrId + MessageFormat.format(ATTR_RANGE_LAST_QUERY, args2);
                    result = results.get(attributeWithRange);
                    lastQuery = true;
                }
                if (result != null) {
                    NamingEnumeration<?> neu22 = result.getAll();
                    while (neu22.hasMoreElements()) {
                        newAttr.add(neu22.nextElement());
                    }
                    if (lastQuery) {
                        quitLoop = true;
                        continue;
                    }
                    rangeLow = rangeHigh + 1;
                    rangeHigh = rangeLow + this.iAttrRangeStep - 1;
                    continue;
                }
                lastQuery = true;
            } while (!quitLoop);
            attributes.put(newAttr);
            attributes.remove(attrName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={InterruptedException.class, NamingException.class})
    private TimedDirContext getDirContext() throws WIMSystemException {
        String METHODNAME = "getDirContext";
        TimedDirContext ctx = null;
        long currentTime = this.roundToSeconds(System.currentTimeMillis());
        if (this.iEnableContextPool) {
            do {
                String msg;
                Object object = this.lock;
                synchronized (object) {
                    if (this.iContexts == null) {
                        try {
                            this.createContextPool(this.iInitPoolSize, null);
                        }
                        catch (NamingException e) {
                            msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
                        }
                    }
                    if (this.iContexts.size() > 0) {
                        ctx = this.iContexts.remove(this.iContexts.size() - 1);
                    } else {
                        if (this.iLiveContexts >= this.iMaxPoolSize && this.iMaxPoolSize != 0) {
                            try {
                                this.lock.wait(this.iPoolWaitTime);
                            }
                            catch (InterruptedException e) {
                                // empty catch block
                            }
                            continue;
                        }
                        ++this.iLiveContexts;
                    }
                }
                TimedDirContext oldCtx = null;
                if (ctx != null) {
                    if (this.iPoolTimeOut > 0L && currentTime - ctx.getPoolTimestamp() > this.iPoolTimeOut) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("getDirContext ContextPool: context is time out. currentTime=" + currentTime + ", createTime=" + ctx.getPoolTimestamp() + ", iPoolTimeOut=" + this.iPoolTimeOut), (Object[])new Object[0]);
                        }
                        oldCtx = ctx;
                        ctx = null;
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"getDirContext ContextPool: no free context, create a new one...", (Object[])new Object[0]);
                }
                if (ctx == null) {
                    try {
                        ctx = this.createDirContext(this.getEnvironment(1, this.getActiveURL()));
                    }
                    catch (NamingException e) {
                        --this.iLiveContexts;
                        msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                        throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
                    }
                }
                if (this.iReturnToPrimary && currentTime - this.iLastQueryTime > this.iQueryInterval) {
                    try {
                        String currentURL = this.getProviderURL(ctx);
                        String primaryURL = this.getPrimaryURL();
                        if (!primaryURL.equalsIgnoreCase(currentURL)) {
                            boolean primaryOK;
                            block55: {
                                Hashtable<?, ?> env = this.getEnvironment(0, primaryURL);
                                primaryOK = false;
                                try {
                                    TimedDirContext testCtx;
                                    block54: {
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("getDirContext Ping primary server '" + primaryURL + "'..."), (Object[])new Object[0]);
                                        }
                                        testCtx = this.createDirContext(env);
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)("getDirContext Ping primary server '" + primaryURL + "': success"), (Object[])new Object[0]);
                                        }
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug((TraceComponent)tc, (String)"CURRENT_LDAP_SERVER", (Object[])WIMMessageHelper.generateMsgParms((Object)this.getActiveURL()));
                                        }
                                        primaryOK = true;
                                        TimedDirContext tempCtx = ctx;
                                        try {
                                            tempCtx.close();
                                        }
                                        catch (NamingException e) {
                                            if (!tc.isDebugEnabled()) break block54;
                                            Tr.debug((TraceComponent)tc, (String)("getDirContext Can not close LDAP connection: " + e.toString(true)), (Object[])new Object[0]);
                                        }
                                    }
                                    ctx = testCtx;
                                }
                                catch (NamingException e) {
                                    if (tc.isInfoEnabled()) {
                                        Tr.info((TraceComponent)tc, (String)"CANNOT_CONNECT_TO_LDAP_SERVER", (Object[])WIMMessageHelper.generateMsgParms((Object)primaryURL));
                                    }
                                    if (!tc.isDebugEnabled()) break block55;
                                    Tr.debug((TraceComponent)tc, (String)("getDirContext Ping primary server '" + primaryURL + "': fail"), (Object[])new Object[0]);
                                }
                            }
                            if (primaryOK) {
                                Object object2 = this.lock;
                                synchronized (object2) {
                                    if (!this.getActiveURL().equalsIgnoreCase(primaryURL)) {
                                        this.createContextPool(this.iLiveContexts - 1, primaryURL);
                                        ctx.setCreateTimestamp(this.iPoolCreateTimestampSeconds);
                                    }
                                }
                            }
                        }
                        this.iLastQueryTime = currentTime;
                    }
                    catch (NamingException e) {
                        msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                        throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
                    }
                }
                if (oldCtx == null) continue;
                try {
                    oldCtx.close();
                }
                catch (NamingException e) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("getDirContext Can not close LDAP connection: " + e.toString(true)), (Object[])new Object[0]);
                }
            } while (ctx == null);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getDirContext ContextPool: total=" + this.iLiveContexts + ", poolSize=" + this.iContexts.size() + ", currentTime=" + currentTime + ", createTime=" + ctx.getPoolTimestamp()), (Object[])new Object[0]);
            }
        } else {
            try {
                if (this.iReturnToPrimary && currentTime - this.iLastQueryTime > this.iQueryInterval) {
                    block56: {
                        String primaryURL = this.getPrimaryURL();
                        if (!primaryURL.equalsIgnoreCase(this.getActiveURL())) {
                            Hashtable<?, ?> env = this.getEnvironment(0, primaryURL);
                            try {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("getDirContext Ping primary server '" + primaryURL + "'..."), (Object[])new Object[0]);
                                }
                                ctx = this.createDirContext(env);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("getDirContext Ping primary server '" + primaryURL + "': success"), (Object[])new Object[0]);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"CURRENT_LDAP_SERVER", (Object[])WIMMessageHelper.generateMsgParms((Object)this.getActiveURL()));
                                }
                            }
                            catch (NamingException e) {
                                if (tc.isInfoEnabled()) {
                                    Tr.info((TraceComponent)tc, (String)"CANNOT_CONNECT_TO_LDAP_SERVER", (Object[])WIMMessageHelper.generateMsgParms((Object)primaryURL));
                                }
                                if (!tc.isDebugEnabled()) break block56;
                                Tr.debug((TraceComponent)tc, (String)("getDirContext Ping primary server '" + primaryURL + "': fail"), (Object[])new Object[0]);
                            }
                        }
                    }
                    this.iLastQueryTime = currentTime;
                }
                if (ctx == null) {
                    ctx = this.createDirContext(this.getEnvironment(1, this.getActiveURL()));
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"CURRENT_LDAP_SERVER", (Object[])WIMMessageHelper.generateMsgParms((Object)this.getActiveURL()));
                    }
                }
            }
            catch (NamingException e) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public TimedDirContext reCreateDirContext(TimedDirContext oldCtx, String errorMessage) throws WIMSystemException {
        String METHODNAME = "DirContext reCreateDirContext(String errorMessage)";
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("DirContext reCreateDirContext(String errorMessage) Communication exception occurs: " + errorMessage + " Creating a new connection."), (Object[])new Object[0]);
        }
        try {
            TimedDirContext ctx;
            Long oldCreateTimeStamp = oldCtx.getCreateTimestamp();
            if (oldCreateTimeStamp < this.iPoolCreateTimestampMillisec) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DirContext reCreateDirContext(String errorMessage) Pool refreshed, skip to getDirContext. oldCreateTimeStamp: " + oldCreateTimeStamp + " iPoolCreateTimestampMillisec:" + this.iPoolCreateTimestampMillisec), (Object[])new Object[0]);
                }
                ctx = this.getDirContext();
            } else {
                String oldURL = this.getProviderURL(oldCtx);
                ctx = this.createDirContext(this.getEnvironment(1, this.getNextURL(oldURL)));
                String newURL = this.getProviderURL(ctx);
                Object object = this.lock;
                synchronized (object) {
                    if (oldCtx.getCreateTimestamp() >= this.iPoolCreateTimestampSeconds) {
                        this.createContextPool(this.iLiveContexts - 1, newURL);
                        ctx.setCreateTimestamp(this.iPoolCreateTimestampSeconds);
                    }
                }
            }
            oldCtx.close();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"CURRENT_LDAP_SERVER", (Object[])WIMMessageHelper.generateMsgParms((Object)this.getActiveURL()));
            }
            return ctx;
        }
        catch (NamingException oldCreateTimeStamp) {
            void e;
            FFDCFilter.processException((Throwable)oldCreateTimeStamp, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2361", (Object)this, (Object[])new Object[]{oldCtx, errorMessage});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @FFDCIgnore(value={NamingException.class})
    public TimedDirContext createDirContext(String principal, byte[] credential) throws NamingException {
        String METHODNAME = "createDirContext(String, byte[])";
        String activeURL = this.getActiveURL();
        Hashtable<?, ?> environment = this.getEnvironment(0, activeURL);
        environment.put("java.naming.security.principal", principal);
        environment.put("java.naming.security.credentials", credential);
        Properties currentSSLProps = FactoryManager.getSSLUtil().getSSLPropertiesOnThread();
        try {
            if (this.iSSLAlias != null) {
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"createDirContext(String, byte[]) Use WAS SSL Configuration.", (Object[])new Object[0]);
                    }
                    FactoryManager.getSSLUtil().setSSLAlias(this.iSSLAlias, environment);
                }
                catch (Exception exception) {
                    void ssle;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2392", (Object)this, (Object[])new Object[]{principal, credential});
                    throw new NamingException(ssle.getMessage());
                }
            }
            Thread thread = Thread.currentThread();
            ClassLoader origCL = thread.getContextClassLoader();
            thread.setContextClassLoader(this.getClass().getClassLoader());
            try {
                TimedDirContext ctx = null;
                try {
                    ctx = new TimedDirContext(environment, this.getConnectionRequestControls(), this.roundToSeconds(System.currentTimeMillis()));
                }
                catch (NamingException e) {
                    if (!this.isConnectionException(e, "createDirContext(String, byte[])")) {
                        throw e;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Encountered an exception while creating a context : " + e.getMessage()), (Object[])new Object[0]);
                    }
                    environment = this.getEnvironment(1, this.getNextURL(activeURL));
                    environment.put("java.naming.security.principal", principal);
                    environment.put("java.naming.security.credentials", credential);
                    ctx = new TimedDirContext(environment, this.getConnectionRequestControls(), this.roundToSeconds(System.currentTimeMillis()));
                    String newURL = this.getProviderURL(ctx);
                    long creationTimeMillisec = System.currentTimeMillis();
                    Object object = this.lock;
                    synchronized (object) {
                        if (creationTimeMillisec > this.iPoolCreateTimestampMillisec) {
                            this.createContextPool(this.iLiveContexts, newURL);
                            ctx.setCreateTimestamp(this.iPoolCreateTimestampSeconds);
                        }
                    }
                }
                TimedDirContext timedDirContext = ctx;
                thread.setContextClassLoader(origCL);
                return timedDirContext;
            }
            catch (Throwable throwable) {
                thread.setContextClassLoader(origCL);
                throw throwable;
            }
        }
        finally {
            FactoryManager.getSSLUtil().setSSLPropertiesOnThread(currentSSLProps);
        }
    }

    public TimedDirContext createDirContext(Hashtable<?, ?> env) throws NamingException {
        return this.createDirContext(env, this.roundToSeconds(System.currentTimeMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public TimedDirContext createDirContext(Hashtable<?, ?> env, long createTimestamp) throws NamingException {
        Object o = env.get("java.naming.security.credentials");
        if (o instanceof ProtectedString) {
            ProtectedString sps = (ProtectedString)env.get("java.naming.security.credentials");
            String password = sps == null ? "" : new String(sps.getChars());
            String decodedPassword = PasswordUtil.passwordDecode((String)password.trim());
            env.put("java.naming.security.credentials", decodedPassword);
        }
        Properties currentSSLProps = FactoryManager.getSSLUtil().getSSLPropertiesOnThread();
        try {
            if (this.iSSLAlias != null) {
                try {
                    FactoryManager.getSSLUtil().setSSLAlias(this.iSSLAlias, env);
                }
                catch (Exception password) {
                    void ssle;
                    FFDCFilter.processException((Throwable)password, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2475", (Object)this, (Object[])new Object[]{env, createTimestamp});
                    throw new NamingException(ssle.getMessage());
                }
            }
            Thread thread = Thread.currentThread();
            ClassLoader origCL = thread.getContextClassLoader();
            thread.setContextClassLoader(this.getClass().getClassLoader());
            try {
                TimedDirContext ctx = new TimedDirContext(env, this.getConnectionRequestControls(), createTimestamp);
                String newURL = this.getProviderURL(ctx);
                if (!this.iEnableContextPool && !newURL.equalsIgnoreCase(this.getActiveURL())) {
                    this.setActiveURL(newURL);
                }
                TimedDirContext timedDirContext = ctx;
                thread.setContextClassLoader(origCL);
                return timedDirContext;
            }
            catch (Throwable throwable) {
                thread.setContextClassLoader(origCL);
                throw throwable;
            }
        }
        finally {
            FactoryManager.getSSLUtil().setSSLPropertiesOnThread(currentSSLProps);
        }
    }

    private Hashtable<?, ?> getEnvironment(int type, String startingURL) {
        Hashtable<String, Object> env = new Hashtable<String, Object>(this.iEnvironment);
        List urlList = (List)env.remove(ENVKEY_URL_LIST);
        int numURLs = urlList.size();
        int startingURLIndex = this.getURLIndex(startingURL, urlList);
        String ldapUrl = null;
        for (int i = startingURLIndex; i < startingURLIndex + numURLs; ++i) {
            ldapUrl = i > startingURLIndex ? ldapUrl + " " + (String)urlList.get(i % numURLs) : (String)urlList.get(i % numURLs);
            if (type == 0) break;
        }
        env.put("java.naming.provider.url", ldapUrl);
        env.remove(ENVKEY_ACTIVE_URL);
        return env;
    }

    private int getURLIndex(String url, List<String> urlList) {
        int urlIndex = 0;
        int numURLs = urlList.size();
        if (url != null) {
            for (int i = 0; i < numURLs; ++i) {
                if (!urlList.get(i).equalsIgnoreCase(url)) continue;
                urlIndex = i;
                break;
            }
        }
        return urlIndex;
    }

    @Trivial
    @FFDCIgnore(value={NamingException.class})
    private String getProviderURL(TimedDirContext ctx) {
        try {
            return (String)ctx.getEnvironment().get("java.naming.provider.url");
        }
        catch (NamingException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getProviderURL", (Object[])new Object[]{e.toString(true)});
            }
            return "(null)";
        }
    }

    private Control[] getConnectionRequestControls() {
        return this.iConnCtls;
    }

    /*
     * WARNING - void declaration
     */
    private void createContextPool(int poolSize, String providerURL) throws NamingException {
        String METHODNAME = "createContextPool";
        if (providerURL == null) {
            providerURL = this.getPrimaryURL();
        }
        if (this.iEnableContextPool) {
            long currentTimeMillisec = System.currentTimeMillis();
            long currentTimeSeconds = this.roundToSeconds(currentTimeMillisec);
            if (currentTimeMillisec - this.iPoolCreateTimestampMillisec > 1000L) {
                Vector<TimedDirContext> contexts = new Vector<TimedDirContext>(poolSize);
                Hashtable<?, ?> env = this.getEnvironment(1, providerURL);
                String currentURL = null;
                try {
                    for (int i = 0; i < poolSize; ++i) {
                        TimedDirContext ctx = this.createDirContext(env, currentTimeSeconds);
                        currentURL = this.getProviderURL(ctx);
                        if (!providerURL.equalsIgnoreCase(currentURL)) {
                            env = this.getEnvironment(1, currentURL);
                            providerURL = currentURL;
                        }
                        contexts.add(ctx);
                    }
                }
                catch (NamingException i) {
                    void e;
                    FFDCFilter.processException((Throwable)i, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2617", (Object)this, (Object[])new Object[]{poolSize, providerURL});
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("createContextPool Context Pool creation FAILED for " + Thread.currentThread() + ", iLiveContext=" + this.iLiveContexts), (Object[])new Object[]{e});
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("createContextPool Cleanup contexts in temp pool: " + contexts.size()), (Object[])new Object[0]);
                    }
                    for (int j = 0; j < contexts.size(); ++j) {
                        try {
                            TimedDirContext ctx = (TimedDirContext)contexts.get(j);
                            ctx.close();
                            continue;
                        }
                        catch (Exception exception) {
                            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2628", (Object)this, (Object[])new Object[]{poolSize, providerURL});
                        }
                    }
                    throw e;
                }
                this.iLiveContexts += poolSize;
                this.setActiveURL(providerURL);
                List<TimedDirContext> oldCtxs = this.iContexts;
                this.iContexts = contexts;
                this.iPoolCreateTimestampSeconds = currentTimeSeconds;
                this.iPoolCreateTimestampMillisec = currentTimeMillisec;
                this.closeContextPool(oldCtxs);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("createContextPool Active Provider URL: " + this.getActiveURL()), (Object[])new Object[0]);
                    Tr.debug((TraceComponent)tc, (String)("createContextPool ContextPool: total=" + this.iLiveContexts + ", poolSize=" + this.iContexts.size()), (Object[])new Object[]{", iPoolCreateTimestampSeconds=" + this.iPoolCreateTimestampSeconds});
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"createContextPool Pool has already been purged within past second... skipping purge", (Object[])new Object[0]);
            }
        } else {
            this.setActiveURL(providerURL);
        }
    }

    @FFDCIgnore(value={NamingException.class})
    private void closeContextPool(List<TimedDirContext> contexts) {
        String METHODNAME = "closeContextPool";
        if (contexts != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("closeContextPool Context pool being closed by " + Thread.currentThread() + ", Context pool size=" + contexts.size()), (Object[])new Object[0]);
            }
            for (int i = 0; i < contexts.size(); ++i) {
                TimedDirContext context = contexts.get(i);
                try {
                    context.close();
                    --this.iLiveContexts;
                    continue;
                }
                catch (NamingException e) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug((TraceComponent)tc, (String)("closeContextPool Can not close LDAP connection: " + e.toString(true)), (Object[])new Object[0]);
                }
            }
        }
    }

    private boolean isConnectionException(NamingException e, String METHODNAME) {
        if (e instanceof CommunicationException) {
            return true;
        }
        return e instanceof ServiceUnavailableException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={NamingException.class})
    public void releaseDirContext(TimedDirContext ctx) throws WIMException {
        String METHODNAME = "releaseDirContext";
        if (this.iEnableContextPool) {
            Object object = this.lock;
            synchronized (object) {
                if (this.iContexts.size() >= this.iPrefPoolSize || this.iMaxPoolSize != 0 && this.iLiveContexts > this.iMaxPoolSize || ctx.getCreateTimestamp() < this.iPoolCreateTimestampSeconds || !this.getProviderURL(ctx).equalsIgnoreCase(this.getActiveURL())) {
                    try {
                        --this.iLiveContexts;
                        ctx.close();
                    }
                    catch (NamingException e) {
                        String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                        throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"releaseDirContext Context is discarded.", (Object[])new Object[0]);
                    }
                } else {
                    if (this.iContexts != null && this.iContexts.size() > 0 && this.iContexts.contains(ctx)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("releaseDirContext Context already present in Context pool. No need to add it again to context pool.  ContextPool: total=" + this.iLiveContexts + ", poolSize=" + this.iContexts.size()), (Object[])new Object[0]);
                        }
                    } else {
                        if (this.iContexts != null) {
                            this.iContexts.add(ctx);
                        }
                        if (this.iPoolTimeOut > 0L) {
                            ctx.setPoolTimeStamp(this.roundToSeconds(System.currentTimeMillis()));
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("releaseDirContext Before Notifying the waiting threads and Context is back to pool.  ContextPool: total=" + this.iLiveContexts + ", poolSize=" + this.iContexts.size()), (Object[])new Object[0]);
                        }
                    }
                    this.lock.notifyAll();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"releaseDirContext Context is back to pool.", (Object[])new Object[0]);
                    }
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("releaseDirContext ContextPool: total=" + this.iLiveContexts + ", poolSize=" + this.iContexts.size()), (Object[])new Object[0]);
            }
        } else {
            try {
                ctx.close();
            }
            catch (NamingException e) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public SearchResult searchByOperationalAttribute(String DN, String filter, List<String> inEntityTypes, List<String> propNames, String oprAttribute) throws WIMException {
        String inEntityType = null;
        List<String> supportedProps = propNames;
        if (inEntityTypes != null && inEntityTypes.size() > 0) {
            inEntityType = inEntityTypes.get(0);
            supportedProps = this.iLdapConfigMgr.getSupportedProperties(inEntityType, propNames);
        }
        String[] attrIds = this.iLdapConfigMgr.getAttributeNames(inEntityTypes, supportedProps, false, false);
        attrIds = Arrays.copyOf(attrIds, attrIds.length + 1);
        attrIds[attrIds.length - 1] = oprAttribute;
        NamingEnumeration<SearchResult> neu = null;
        neu = this.search(DN, filter, 0, attrIds, this.iCountLimit, this.iTimeLimit);
        if (neu != null) {
            try {
                if (neu.hasMore()) {
                    return neu.next();
                }
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2787", (Object)this, (Object[])new Object[]{DN, filter, inEntityTypes, propNames, oprAttribute});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
        }
        return null;
    }

    private String getBinaryAttributes() {
        StringBuffer binaryAttrNamesBuffer = new StringBuffer();
        Map attrMap = this.iLdapConfigMgr.getAttributes();
        for (String attrName : attrMap.keySet()) {
            LdapAttribute attr = (LdapAttribute)attrMap.get(attrName);
            if (!"octetString".equalsIgnoreCase(attr.getSyntax())) continue;
            binaryAttrNamesBuffer.append(attr.getName()).append(" ");
        }
        return binaryAttrNamesBuffer.toString().trim();
    }

    /*
     * WARNING - void declaration
     */
    public void destroySubcontext(String name) throws WIMException {
        String METHODNAME = "destroySubcontext";
        TimedDirContext ctx = this.getDirContext();
        try {
            try {
                ctx.destroySubcontext(new LdapName(name));
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2834", (Object)this, (Object[])new Object[]{name});
                if (!this.isConnectionException((NamingException)e, "destroySubcontext")) {
                    throw e;
                }
                ctx = this.reCreateDirContext(ctx, e.toString());
                ctx.destroySubcontext(new LdapName(name));
            }
        }
        catch (ContextNotEmptyException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2841", (Object)this, (Object[])new Object[]{name});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_HAS_DESCENDENTS", (Object[])WIMMessageHelper.generateMsgParms((Object)name));
            throw new EntityHasDescendantsException("ENTITY_HAS_DESCENDENTS", msg, (Throwable)e);
        }
        catch (NameNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2844", (Object)this, (Object[])new Object[]{name});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"LDAP_ENTRY_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)name, (Object)e.toString(true)));
            throw new EntityNotFoundException("LDAP_ENTRY_NOT_FOUND", msg, (Throwable)e);
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2847", (Object)this, (Object[])new Object[]{name});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        finally {
            this.releaseDirContext(ctx);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException, WIMException {
        String METHODNAME = "modifyAttributes(Name name, ModificationItem[] mods)";
        TimedDirContext ctx = this.getDirContext();
        try {
            try {
                ctx.modifyAttributes(new LdapName(name), mods);
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2870", (Object)this, (Object[])new Object[]{name, mods});
                if (!this.isConnectionException((NamingException)e, "modifyAttributes(Name name, ModificationItem[] mods)")) {
                    throw e;
                }
                ctx = this.reCreateDirContext(ctx, e.toString());
                ctx.modifyAttributes(new LdapName(name), mods);
            }
        }
        catch (NameNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2877", (Object)this, (Object[])new Object[]{name, mods});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new EntityNotFoundException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2880", (Object)this, (Object[])new Object[]{name, mods});
            throw e;
        }
        finally {
            this.releaseDirContext(ctx);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException, WIMException {
        String METHODNAME = "modifyAttributes(Name, int, Attributes)";
        TimedDirContext ctx = this.getDirContext();
        this.checkWritePermission(ctx);
        try {
            try {
                ctx.modifyAttributes(new LdapName(name), mod_op, attrs);
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2895", (Object)this, (Object[])new Object[]{name, mod_op, attrs});
                if (!this.isConnectionException((NamingException)e, "modifyAttributes(Name, int, Attributes)")) {
                    throw e;
                }
                ctx = this.reCreateDirContext(ctx, e.toString());
                ctx.modifyAttributes(new LdapName(name), mod_op, attrs);
            }
        }
        catch (NameNotFoundException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2902", (Object)this, (Object[])new Object[]{name, mod_op, attrs});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new EntityNotFoundException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2905", (Object)this, (Object[])new Object[]{name, mod_op, attrs});
            throw e;
        }
        finally {
            this.releaseDirContext(ctx);
        }
    }

    /*
     * WARNING - void declaration
     */
    public DirContext createSubcontext(String name, Attributes attrs) throws WIMException {
        DirContext dirContext;
        block14: {
            String METHODNAME = "createSubcontext";
            dirContext = null;
            TimedDirContext ctx = this.getDirContext();
            this.checkWritePermission(ctx);
            try {
                try {
                    long startTime = System.currentTimeMillis();
                    dirContext = ctx.createSubcontext(new LdapName(name), attrs);
                    long endTime = System.currentTimeMillis();
                    if (endTime - startTime > (long)LDAP_CONNECT_TIMEOUT_TRACE) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("createSubcontext **LDAPConnect time: " + (endTime - startTime) + " ms, lock held " + Thread.holdsLock(this.lock) + ", principal=" + name), (Object[])new Object[0]);
                        }
                        break block14;
                    }
                    this.handleBindStat(endTime - startTime);
                }
                catch (NamingException startTime) {
                    void e;
                    FFDCFilter.processException((Throwable)startTime, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2931", (Object)this, (Object[])new Object[]{name, attrs});
                    if (!this.isConnectionException((NamingException)e, "createSubcontext")) {
                        throw e;
                    }
                    ctx = this.reCreateDirContext(ctx, e.toString());
                    long startTime2 = System.currentTimeMillis();
                    dirContext = ctx.createSubcontext(new LdapName(name), attrs);
                    long endTime = System.currentTimeMillis();
                    if (endTime - startTime2 > (long)LDAP_CONNECT_TIMEOUT_TRACE) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("createSubcontext **LDAPConnect time: " + (endTime - startTime2) + " ms, lock held " + Thread.holdsLock(this.lock) + ", principal=" + name), (Object[])new Object[0]);
                        }
                        break block14;
                    }
                    this.handleBindStat(endTime - startTime2);
                }
            }
            catch (NameAlreadyBoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2947", (Object)this, (Object[])new Object[]{name, attrs});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"ENTITY_ALREADY_EXIST", (Object[])WIMMessageHelper.generateMsgParms((Object)name));
                throw new EntityAlreadyExistsException("ENTITY_ALREADY_EXIST", msg, (Throwable)e);
            }
            catch (NameNotFoundException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2950", (Object)this, (Object[])new Object[]{name, attrs});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"PARENT_NOT_FOUND", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new EntityNotFoundException("PARENT_NOT_FOUND", msg, (Throwable)e);
            }
            catch (NamingException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"2953", (Object)this, (Object[])new Object[]{name, attrs});
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
                throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
            }
            finally {
                this.releaseDirContext(ctx);
            }
        }
        return dirContext;
    }

    private void handleBindStat(long elapsedTime) {
        long lastUpdated;
        long now;
        String METHODNAME = "handleBindStat(long)";
        if (elapsedTime < (long)LDAP_CONNECT_TIMEOUT_TRACE) {
            QUICK_LDAP_BIND.getAndIncrement();
        }
        if ((now = System.currentTimeMillis()) - LDAP_STATS_TIMER.get() > 1800000L && now - (lastUpdated = LDAP_STATS_TIMER.getAndSet(now)) > 1800000L && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(METHODNAME + " **LDAPBindStat: " + QUICK_LDAP_BIND.get() + " binds took less then " + LDAP_CONNECT_TIMEOUT_TRACE + " ms"), (Object[])new Object[0]);
        }
    }

    private void checkWritePermission(TimedDirContext ctx) throws OperationNotSupportedException {
        if (!this.iWriteToSecondary) {
            String providerURL = this.getProviderURL(ctx);
            if (!this.getPrimaryURL().equalsIgnoreCase(providerURL)) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"WRITE_TO_SECONDARY_SERVERS_NOT_ALLOWED", (Object[])WIMMessageHelper.generateMsgParms((Object)providerURL));
                throw new OperationNotSupportedException("WRITE_TO_SECONDARY_SERVERS_NOT_ALLOWED", msg);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void rename(String dn, String newDn) throws WIMException {
        String METHODNAME = "rename";
        TimedDirContext ctx = this.getDirContext();
        this.checkWritePermission(ctx);
        try {
            try {
                ctx.rename(dn, newDn);
            }
            catch (NamingException namingException) {
                void e;
                FFDCFilter.processException((Throwable)namingException, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"3009", (Object)this, (Object[])new Object[]{dn, newDn});
                if (!this.isConnectionException((NamingException)e, "rename")) {
                    throw e;
                }
                ctx = this.reCreateDirContext(ctx, e.toString());
                ctx.rename(dn, newDn);
            }
        }
        catch (NamingException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.wim.adapter.ldap.LdapConnection", (String)"3016", (Object)this, (Object[])new Object[]{dn, newDn});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"NAMING_EXCEPTION", (Object[])WIMMessageHelper.generateMsgParms((Object)e.toString(true)));
            throw new WIMSystemException("NAMING_EXCEPTION", msg, (Throwable)e);
        }
        finally {
            this.releaseDirContext(ctx);
        }
    }

    public int getSearchTimeout() {
        return this.iTimeLimit;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName()).append(":{");
        sb.append("Repositoriy ID=").append(this.reposId).append("\n");
        sb.append(", SSL Alias=").append(this.iSSLAlias).append("\n");
        sb.append(", SSL Factory=").append(this.iSSLFactory).append("\n");
        sb.append(", Server TTL Attribute=").append(this.iServerTTLAttr).append("\n");
        sb.append(", Page Size=").append(this.iPageSize).append("\n");
        sb.append(", Attribute Range Step=").append(this.iAttrRangeStep).append("\n");
        sb.append(", Return to primary=").append(this.iReturnToPrimary).append("\n");
        sb.append(", Last Query Time=").append(this.iLastQueryTime).append("\n");
        sb.append(", Query Interval=").append(this.iQueryInterval).append("\n");
        sb.append(", Write To Secondary=").append(this.iWriteToSecondary).append("\n");
        sb.append(", Ignore DN Case=").append(this.ignoreDNCase).append("\n");
        sb.append(", JNDI Environment=").append(this.iEnvironment).append("\n");
        sb.append(", Search Result Count Limit=").append(this.iCountLimit).append("\n");
        sb.append(", Search Result Time Limit=").append(this.iTimeLimit).append("\n");
        sb.append(", Context Pool{ Enabled=").append(this.iEnableContextPool);
        sb.append(", Initial Size=").append(this.iInitPoolSize);
        sb.append(", Max Size=").append(this.iMaxPoolSize);
        sb.append(", Preferred Size=").append(this.iPrefPoolSize);
        sb.append(", Wait Time=").append(this.iPoolWaitTime);
        sb.append(", Timeout=").append(this.iPoolTimeOut);
        sb.append(", Create Timestamp=").append(this.iPoolCreateTimestampSeconds);
        sb.append(" }");
        sb.append(", Attributes Cache{ Enabled=").append(this.iAttrsCacheEnabled);
        sb.append(", Name=").append(this.iAttrsCacheName);
        sb.append(", Size=").append(this.iAttrsCacheSize);
        sb.append(", Limit=").append(this.iAttrsSizeLmit);
        sb.append(", Timeout=").append(this.iAttrsCacheTimeOut);
        sb.append(" }");
        sb.append(", Search Results Cache{ Enabled=").append(this.iSearchResultsCacheEnabled);
        sb.append(", Name=").append(this.iSearchResultsCacheName);
        sb.append(", Size=").append(this.iSearchResultsCacheSize);
        sb.append(", Limit=").append(this.iSearchResultSizeLmit);
        sb.append(", Timeout=").append(this.iSearchResultsCacheTimeOut);
        sb.append(" }");
        sb.append("}");
        return sb.toString();
    }

    private long roundToSeconds(long timeInMilliseconds) {
        long returnInSeconds = timeInMilliseconds / 1000L;
        if (timeInMilliseconds % 1000L > 499L) {
            ++returnInSeconds;
        }
        return returnInSeconds;
    }
}

