/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.internal.providers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.classloading.internal.DeclaredApiAccess;
import com.ibm.ws.classloading.internal.LibertyLoader;
import com.ibm.ws.classloading.internal.providers.GetLibraries;
import com.ibm.ws.classloading.internal.providers.GetLibraryLoaders;
import com.ibm.ws.classloading.internal.providers.GetProviderLoaders;
import com.ibm.ws.classloading.internal.util.BlockingList;
import com.ibm.ws.classloading.internal.util.BlockingListMaker;
import com.ibm.ws.classloading.internal.util.CompositeIterable;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.library.internal.SharedLibraryFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.library.Library;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Providers {
    static final TraceComponent tc = Tr.register(Providers.class);
    static final BundleContext bundleContext;
    static final BlockingList.Logger LOGGER;
    static final long serialVersionUID = -8940215653985952528L;

    public static List<Library> getPrivateLibraries(ClassLoaderConfiguration config) {
        List<String> privateLibraries = config.getSharedLibraries();
        if (privateLibraries == null || privateLibraries.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RETURN (privateLibraries == null || privateLibraries.isEmpty())", (Object[])new Object[0]);
            }
            return Collections.emptyList();
        }
        if (Providers.checkBundleContext() == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RETURN --> checkBundleContext() == null", (Object[])new Object[0]);
            }
            return Collections.emptyList();
        }
        GetLibraries getLibraries = new GetLibraries(config.getId().getId());
        return BlockingListMaker.defineList().waitFor(10L, TimeUnit.SECONDS).fetchElements(getLibraries).listenForElements(getLibraries).log(LOGGER).useKeys(privateLibraries).make();
    }

    public static List<LibertyLoader> getCommonLibraryLoaders(ClassLoaderConfiguration config, DeclaredApiAccess apiAccess) {
        List<String> commonLibIds = config.getCommonLibraries();
        if (commonLibIds == null || commonLibIds.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RETURN (commonLibIds == null || commonLibIds.isEmpty())", (Object[])new Object[0]);
            }
            return Collections.emptyList();
        }
        EnumSet<ApiType> gwApis = apiAccess.getApiTypeVisibility();
        if (gwApis == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"RETURN  -->  gwApis == null !!!!", (Object[])new Object[0]);
            }
            return Collections.emptyList();
        }
        Providers.checkBundleContext();
        GetLibraryLoaders getLibraryLoaders = new GetLibraryLoaders(config.getId().getId(), gwApis);
        return BlockingListMaker.defineList().waitFor(10L, TimeUnit.SECONDS).fetchElements(getLibraryLoaders).listenForElements(getLibraryLoaders).log(LOGGER).useKeys(commonLibIds).make();
    }

    public static List<LibertyLoader> getProviderLoaders(ClassLoaderConfiguration config, DeclaredApiAccess apiAccess) {
        String methodName = "getProviderLoaders(): ";
        List<String> providerIds = config.getClassProviders();
        if (providerIds == null || providerIds.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("getProviderLoaders(): EARLY RETURN: provider ids = " + providerIds), (Object[])new Object[0]);
            }
            return Collections.emptyList();
        }
        EnumSet<ApiType> gwApis = apiAccess.getApiTypeVisibility();
        if (gwApis == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"getProviderLoaders(): EARLY RETURN: gwApis == null", (Object[])new Object[0]);
            }
            return Collections.emptyList();
        }
        Providers.checkBundleContext();
        GetProviderLoaders getProviderLoaders = new GetProviderLoaders(config.getId().getId(), gwApis);
        return BlockingListMaker.defineList().waitFor(10L, TimeUnit.SECONDS).fetchElements(getProviderLoaders).listenForElements(getProviderLoaders).log(LOGGER).useKeys(providerIds).make();
    }

    public static Iterable<LibertyLoader> getDelegateLoaders(ClassLoaderConfiguration config, DeclaredApiAccess apiAccess) {
        return new CompositeIterable<LibertyLoader>(Providers.getCommonLibraryLoaders(config, apiAccess), Providers.getProviderLoaders(config, apiAccess));
    }

    /*
     * WARNING - void declaration
     */
    static Library getSharedLibrary(String id) {
        if (bundleContext == null) {
            return null;
        }
        String filter = "(id=" + id + ")";
        Collection refs = null;
        try {
            refs = bundleContext.getServiceReferences(Library.class, filter);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.classloading.internal.providers.Providers", (String)"135", null, (Object[])new Object[]{id});
            if (tc.isErrorEnabled()) {
                void e;
                Tr.error((TraceComponent)tc, (String)"cls.library.id.invalid", (Object[])new Object[]{id, e.toString()});
            }
            return null;
        }
        if (refs.isEmpty()) {
            return null;
        }
        return (Library)bundleContext.getService(Providers.getHighestRankedService(refs));
    }

    private static ServiceReference<Library> getHighestRankedService(Collection<ServiceReference<Library>> refs) {
        ServiceReference<Library> ref = null;
        if (refs != null) {
            int curHighRanking = -1;
            for (ServiceReference<Library> r : refs) {
                Object o = r.getProperty("service.ranking");
                if (o == null || !(o instanceof Integer)) continue;
                int ranking = (Integer)o;
                if (ref == null) {
                    ref = r;
                    curHighRanking = ranking;
                    continue;
                }
                if (ranking <= curHighRanking) continue;
                ref = r;
                curHighRanking = ranking;
            }
        }
        return ref;
    }

    static boolean checkAPITypesMatch(Library sharedLibrary, String loaderID, EnumSet<ApiType> loaderAPIs) {
        String methodName = "checkAPITypesMatch(for library): ";
        EnumSet<ApiType> libAPIs = sharedLibrary.getApiTypeVisibility();
        if (libAPIs == null ? loaderAPIs == null : ((Object)libAPIs).equals(loaderAPIs)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkAPITypesMatch(for library): Loader " + loaderID + " was allowed to use library " + sharedLibrary.id() + " because their allowed API types were consistent"), (Object[])new Object[]{loaderAPIs, libAPIs});
            }
            return true;
        }
        if (tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"cls.class.space.conflict", (Object[])new Object[]{loaderID, loaderAPIs, sharedLibrary.id(), libAPIs});
        }
        return true;
    }

    static boolean checkAPITypesMatch(String cid, EnumSet<ApiType> consumerApiTypes, String pid, EnumSet<ApiType> providerApiTypes) {
        String methodName = "checkAPITypesMatch(for provider): ";
        if (consumerApiTypes == null ? providerApiTypes == null : consumerApiTypes.equals(providerApiTypes)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkAPITypesMatch(for provider): Loader " + cid + " was allowed to use provider " + pid + " because their allowed API types were consistent"), (Object[])new Object[]{consumerApiTypes, providerApiTypes});
            }
            return true;
        }
        if (tc.isWarningEnabled()) {
            Tr.warning((TraceComponent)tc, (String)"cls.provider.class.space.conflict", (Object[])new Object[]{cid, consumerApiTypes, pid, providerApiTypes});
        }
        return true;
    }

    private static BundleContext checkBundleContext() {
        if (bundleContext == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"BundleContext is null and should not be", (Object[])new Object[0]);
        }
        return bundleContext;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        Bundle ourBundle = FrameworkUtil.getBundle(SharedLibraryFactory.class);
        bundleContext = ourBundle != null ? ourBundle.getBundleContext() : null;
        LOGGER = new BlockingList.Logger(){
            static final long serialVersionUID = -2318779533919245101L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void logTimeoutEvent(BlockingList<?, ?> list) {
                if (tc.isAuditEnabled() && tc.isWarningEnabled()) {
                    for (Object id : list.getUnmatchedKeys()) {
                        Tr.warning((TraceComponent)tc, (String)"cls.library.missing", (Object[])new Object[]{id});
                    }
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register(1.class);
            }
        };
    }
}

