/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.authorization.builtin;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.AccessIdUtil;
import com.ibm.ws.security.SecurityService;
import com.ibm.ws.security.authorization.AuthorizationTableConfigService;
import com.ibm.ws.security.authorization.AuthorizationTableService;
import com.ibm.ws.security.authorization.RoleSet;
import com.ibm.ws.security.authorization.SecurityRole;
import com.ibm.ws.security.authorization.builtin.BaseAuthorizationTableService;
import com.ibm.ws.security.authorization.builtin.SecurityRoleImpl;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.UserRegistry;
import com.ibm.ws.security.registry.UserRegistryChangeListener;
import com.ibm.ws.security.registry.UserRegistryService;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.cm.ConfigurationListener;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class AbstractSecurityAuthorizationTable
extends BaseAuthorizationTableService
implements AuthorizationTableService,
UserRegistryChangeListener,
AuthorizationTableConfigService,
ConfigurationListener {
    private static final TraceComponent tc = Tr.register(AbstractSecurityAuthorizationTable.class);
    public static final String DEFAULT_ROLE_ELEMENT_NAME = "security-role";
    static final String CFG_KEY_ID = "id";
    static final String CFG_KEY_REALM = "realm";
    static final String CFG_KEY_USER = "user";
    static final String CFG_KEY_GROUP = "group";
    static final String CFG_KEY_SPECIAL_SUBJECT = "special-subject";
    static final String CFG_KEY_MEMBER = "member";
    static final String CFG_KEY_NAME = "name";
    static final String CFG_KEY_PASSWORD = "password";
    protected final Set<String> pids = new HashSet<String>();
    private final Map<String, RoleSet> specialSubjectToRoles = new HashMap<String, RoleSet>();
    private final Map<String, String> userToAccessId = new HashMap<String, String>();
    private final Map<String, String> groupToAccessId = new HashMap<String, String>();
    private final Map<String, RoleSet> userToRoles = new HashMap<String, RoleSet>();
    private final Map<String, RoleSet> groupToRoles = new HashMap<String, RoleSet>();
    private final Map<String, RoleSet> accessIdToRoles = new HashMap<String, RoleSet>();
    private final Map<String, Set<String>> explicitAccessIdToRoles = new HashMap<String, Set<String>>();
    protected String roleElementName = this.getRoleElementName();
    protected boolean populated = false;
    protected Set<SecurityRole> roles = new HashSet<SecurityRole>();
    static final long serialVersionUID = -2228228307275980470L;

    @Override
    protected synchronized void activate(ComponentContext cc) {
        super.activate(cc);
    }

    @Override
    protected synchronized void deactivate(ComponentContext cc) {
        super.deactivate(cc);
    }

    public RoleSet getRolesForSpecialSubject(String appName, String specialSubject) {
        if (!this.populated) {
            return null;
        }
        if (this.getApplicationName().equals(appName)) {
            return this.specialSubjectToRoles.get(specialSubject);
        }
        return null;
    }

    public RoleSet getRolesForAccessId(String appName, String accessId) {
        if (!this.populated) {
            return null;
        }
        if (this.getApplicationName().equals(appName)) {
            return this.rolesForAccessId(accessId);
        }
        return null;
    }

    private void clearAuthorizationTable() {
        this.userToAccessId.clear();
        this.groupToAccessId.clear();
        this.userToRoles.clear();
        this.groupToRoles.clear();
        this.specialSubjectToRoles.clear();
        this.accessIdToRoles.clear();
        this.explicitAccessIdToRoles.clear();
    }

    protected void populate() {
        this.clearAuthorizationTable();
        HashMap<String, Set<String>> userToRoleName = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> groupToRoleName = new HashMap<String, Set<String>>();
        HashMap<String, Set<Object>> specialSubjectToRoleName = new HashMap<String, Set<Object>>();
        Iterator<SecurityRole> itr = this.getRoles();
        while (itr.hasNext()) {
            Set<Object> assignedRoles;
            SecurityRole role = itr.next();
            String roleName = role.getRoleName();
            for (String user : role.getUsers()) {
                assignedRoles = (HashSet<String>)userToRoleName.get(user);
                if (assignedRoles == null) {
                    assignedRoles = new HashSet<String>();
                    userToRoleName.put(user, assignedRoles);
                }
                assignedRoles.add(roleName);
            }
            for (String group : role.getGroups()) {
                assignedRoles = (Set)groupToRoleName.get(group);
                if (assignedRoles == null) {
                    assignedRoles = new HashSet();
                    groupToRoleName.put(group, assignedRoles);
                }
                assignedRoles.add(roleName);
            }
            for (String specialSubject : role.getSpecialSubjects()) {
                assignedRoles = (Set)specialSubjectToRoleName.get(specialSubject);
                if (assignedRoles == null) {
                    assignedRoles = new HashSet();
                    specialSubjectToRoleName.put(specialSubject, assignedRoles);
                }
                assignedRoles.add(roleName);
            }
            for (String accessId : role.getAccessIds()) {
                assignedRoles = this.getRoles(this.explicitAccessIdToRoles, accessId);
                if (assignedRoles == null) {
                    assignedRoles = new HashSet();
                    this.explicitAccessIdToRoles.put(accessId, assignedRoles);
                }
                assignedRoles.add(roleName);
            }
        }
        for (Map.Entry entry : userToRoleName.entrySet()) {
            this.userToRoles.put((String)entry.getKey(), new RoleSet((Set)entry.getValue()));
        }
        for (Map.Entry entry : groupToRoleName.entrySet()) {
            this.groupToRoles.put((String)entry.getKey(), new RoleSet((Set)entry.getValue()));
        }
        for (Map.Entry entry : specialSubjectToRoleName.entrySet()) {
            this.specialSubjectToRoles.put((String)entry.getKey(), new RoleSet((Set)entry.getValue()));
        }
        this.populated = true;
    }

    private RoleSet rolesForAccessId(String accessId) {
        RoleSet roles = this.getRoleSet(this.accessIdToRoles, accessId);
        if (roles == null) {
            return this.findRolesForAccessId(accessId);
        }
        return roles;
    }

    private RoleSet findRolesForAccessId(String accessId) {
        if (!AccessIdUtil.isAccessId((String)accessId)) {
            throw new IllegalArgumentException("Invalid accessId");
        }
        if (AccessIdUtil.isUserAccessId((String)accessId)) {
            for (String user : this.userToRoles.keySet()) {
                String userAccessId = this.userToAccessId.get(user);
                if (userAccessId == null) {
                    userAccessId = this.getUserAccessId(user);
                    if (userAccessId == null) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Unable to determine accessId of user " + user), (Object[])new Object[0]);
                        continue;
                    }
                    this.userToAccessId.put(user, userAccessId);
                }
                if (this.getRoleSet(this.accessIdToRoles, userAccessId) == null) {
                    this.accessIdToRoles.put(userAccessId, new RoleSet(this.userToRoles.get(user), this.getRoles(this.explicitAccessIdToRoles, userAccessId)));
                }
                if (!this.isMatch(accessId, userAccessId)) continue;
                return this.getRoleSet(this.accessIdToRoles, userAccessId);
            }
            Set<String> explicitRoleSet = this.getRoles(this.explicitAccessIdToRoles, accessId);
            if (explicitRoleSet != null) {
                RoleSet set = new RoleSet(explicitRoleSet);
                this.accessIdToRoles.put(accessId, set);
                return set;
            }
        } else if (AccessIdUtil.isGroupAccessId((String)accessId)) {
            for (String group : this.groupToRoles.keySet()) {
                String groupAccessId = this.groupToAccessId.get(group);
                if (groupAccessId == null) {
                    groupAccessId = this.getGroupAccessId(group);
                    if (groupAccessId == null) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)("Unable to determine accessId of group " + group), (Object[])new Object[0]);
                        continue;
                    }
                    this.groupToAccessId.put(group, groupAccessId);
                }
                if (this.getRoleSet(this.accessIdToRoles, groupAccessId) == null) {
                    this.accessIdToRoles.put(groupAccessId, new RoleSet(this.groupToRoles.get(group), this.getRoles(this.explicitAccessIdToRoles, groupAccessId)));
                }
                if (!this.isMatch(accessId, groupAccessId)) continue;
                return this.getRoleSet(this.accessIdToRoles, groupAccessId);
            }
            Set<String> explicitRoleSet = this.getRoles(this.explicitAccessIdToRoles, accessId);
            if (explicitRoleSet != null) {
                RoleSet set = new RoleSet((Set)explicitRoleSet);
                this.accessIdToRoles.put(accessId, set);
                return set;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unknown accessId", (Object[])new Object[0]);
            }
            return RoleSet.EMPTY_ROLESET;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"No roles mapped to accessId", (Object[])new Object[]{accessId});
        }
        return RoleSet.EMPTY_ROLESET;
    }

    /*
     * WARNING - void declaration
     */
    private String getUserAccessId(String userName) {
        block4: {
            try {
                SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
                UserRegistryService userRegistryService = securityService.getUserRegistryService();
                UserRegistry userRegistry = userRegistryService.getUserRegistry();
                String realm = userRegistry.getRealm();
                String uniqueId = userRegistry.getUniqueUserId(userName);
                return AccessIdUtil.createAccessId((String)CFG_KEY_USER, (String)realm, (String)uniqueId);
            }
            catch (EntryNotFoundException securityService) {
                FFDCFilter.processException((Throwable)securityService, (String)"com.ibm.ws.security.authorization.builtin.AbstractSecurityAuthorizationTable", (String)"319", (Object)this, (Object[])new Object[]{userName});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception getting the access id for " + userName + ": " + e), (Object[])new Object[0]);
                }
            }
            catch (RegistryException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authorization.builtin.AbstractSecurityAuthorizationTable", (String)"324", (Object)this, (Object[])new Object[]{userName});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting the access id for " + userName + ": " + (Object)((Object)e)), (Object[])new Object[0]);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private String getGroupAccessId(String groupName) {
        block4: {
            try {
                SecurityService securityService = (SecurityService)this.securityServiceRef.getService();
                UserRegistryService userRegistryService = securityService.getUserRegistryService();
                UserRegistry userRegistry = userRegistryService.getUserRegistry();
                String realm = userRegistry.getRealm();
                String groupUniqueId = userRegistry.getUniqueGroupId(groupName);
                return AccessIdUtil.createAccessId((String)CFG_KEY_GROUP, (String)realm, (String)groupUniqueId);
            }
            catch (EntryNotFoundException securityService) {
                FFDCFilter.processException((Throwable)securityService, (String)"com.ibm.ws.security.authorization.builtin.AbstractSecurityAuthorizationTable", (String)"348", (Object)this, (Object[])new Object[]{groupName});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)("Caught exception getting the access id for " + groupName + ": " + e), (Object[])new Object[0]);
                }
            }
            catch (RegistryException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.authorization.builtin.AbstractSecurityAuthorizationTable", (String)"353", (Object)this, (Object[])new Object[]{groupName});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block4;
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting the access id for " + groupName + ": " + (Object)((Object)e)), (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public void notifyOfUserRegistryChange() {
        super.notifyOfUserRegistryChange();
        this.accessIdToRoles.clear();
        this.userToAccessId.clear();
        this.groupToAccessId.clear();
    }

    protected abstract String getApplicationName();

    protected String getRoleElementName() {
        return DEFAULT_ROLE_ELEMENT_NAME;
    }

    protected Iterator<SecurityRole> getRoles() {
        return this.roles.iterator();
    }

    /*
     * WARNING - void declaration
     */
    public void setFeatureRoleConfiguration(String[] rolePids, ConfigurationAdmin configAdmin) {
        this.roles.clear();
        this.pids.clear();
        HashSet<String> badConfigs = new HashSet<String>();
        Dictionary roleProps = null;
        String roleName = null;
        if (rolePids != null) {
            for (String rolePid : rolePids) {
                block5: {
                    this.pids.add(rolePid);
                    try {
                        Configuration config = configAdmin.getConfiguration(rolePid, this.bundleLocation);
                        roleProps = config.getProperties();
                        roleName = (String)roleProps.get(CFG_KEY_NAME);
                        if (!tc.isDebugEnabled()) break block5;
                        Tr.debug((TraceComponent)tc, (String)("Role name " + roleName), (Object[])new Object[0]);
                    }
                    catch (IOException config) {
                        void ioe;
                        FFDCFilter.processException((Throwable)config, (String)"com.ibm.ws.security.authorization.builtin.AbstractSecurityAuthorizationTable", (String)"413", (Object)this, (Object[])new Object[]{rolePids, configAdmin});
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"Invalid role definition", (Object[])new Object[]{rolePid, ioe.getMessage()});
                        continue;
                    }
                }
                SecurityRoleImpl role = new SecurityRoleImpl(configAdmin, this.bundleLocation, roleName, roleProps, this.pids);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Adding role", (Object[])new Object[]{role});
                }
                if (this.roles.add(role)) continue;
                badConfigs.add(roleName);
                Tr.error((TraceComponent)tc, (String)"AUTHZ_TABLE_DUPLICATE_ROLE_DEFINITION", (Object[])new Object[]{role});
                this.roles.remove(role);
            }
        }
        this.populate();
    }

    public void setConfiguration(String[] roleNames, ConfigurationAdmin configAdmin, Map<String, Object> properties) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Auth table configuration", (Object[])new Object[]{properties});
        }
        this.pids.clear();
        for (String roleName : roleNames) {
            this.processRole(roleName, configAdmin, properties);
        }
        this.populate();
    }

    /*
     * WARNING - void declaration
     */
    private void processRole(String roleName, ConfigurationAdmin configAdmin, Map<String, Object> properties) {
        HashSet<String> badConfigs = new HashSet<String>();
        String[] roleDefs = (String[])properties.get(roleName);
        if (roleDefs == null || roleDefs.length == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("No roles were defined with element: " + roleName), (Object[])new Object[0]);
            }
            return;
        }
        if (roleDefs.length > 1 && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Multiple roles were defined with element: " + roleName + ". Using 1st definition"), (Object[])new Object[0]);
        }
        Configuration config = null;
        this.pids.add(roleDefs[0]);
        try {
            config = configAdmin.getConfiguration(roleDefs[0], this.bundleLocation);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.authorization.builtin.AbstractSecurityAuthorizationTable", (String)"468", (Object)this, (Object[])new Object[]{roleName, configAdmin, properties});
            Tr.error((TraceComponent)tc, (String)"AUTHZ_TABLE_INVALID_ROLE_DEFINITION", (Object[])new Object[]{roleDefs[0]});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void ioe;
                Tr.debug((TraceComponent)tc, (String)"Invalid role definition", (Object[])new Object[]{roleDefs[0], ioe.getMessage()});
            }
            return;
        }
        if (config == null || config.getProperties() == null) {
            Tr.error((TraceComponent)tc, (String)"AUTHZ_TABLE_INVALID_ROLE_DEFINITION", (Object[])new Object[]{roleDefs[0]});
            return;
        }
        SecurityRoleImpl role = new SecurityRoleImpl(configAdmin, this.bundleLocation, roleName, config.getProperties(), this.pids);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Adding role", (Object[])new Object[]{role});
        }
        if (!this.roles.add(role)) {
            badConfigs.add(roleName);
            Tr.error((TraceComponent)tc, (String)"AUTHZ_TABLE_DUPLICATE_ROLE_DEFINITION", (Object[])new Object[]{roleName});
            this.roles.remove(role);
        }
    }

    public boolean isAuthzInfoAvailableForApp(String appName) {
        return this.roles != null && !this.roles.isEmpty();
    }
}

