/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.csiv2.server.config.css;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.AuthenticationException;
import com.ibm.ws.security.authentication.utility.SubjectHelper;
import com.ibm.ws.security.context.SubjectManager;
import com.ibm.ws.security.csiv2.Authenticator;
import com.ibm.ws.security.csiv2.server.config.tss.ServerLTPAMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.css.CSSSASMechConfig;
import com.ibm.ws.transport.iiop.security.config.tss.TSSASMechConfig;
import com.ibm.ws.transport.iiop.security.util.Util;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.util.Iterator;
import javax.security.auth.Subject;
import org.omg.CORBA.BAD_PARAM;
import org.omg.IOP.Codec;
import org.omg.PortableInterceptor.ClientRequestInfo;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClientLTPAMechConfig
implements CSSASMechConfig {
    private static final long serialVersionUID = 1L;
    private final String domain;
    private final boolean required;
    private final transient Authenticator authenticator;
    private final String mechanism = "LTPA";
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ClientLTPAMechConfig(Authenticator authenticator, String domain, boolean required) {
        this.authenticator = authenticator;
        this.domain = domain;
        this.required = required;
    }

    public short getSupports() {
        return 64;
    }

    public short getRequires() {
        return this.required ? (short)64 : 0;
    }

    public boolean canHandle(TSSASMechConfig asMech) {
        return asMech instanceof ServerLTPAMechConfig || asMech.getRequires() == 0 && !this.required;
    }

    public String getMechanism() {
        return "LTPA";
    }

    public byte[] encode(TSSASMechConfig tssasMechConfig, CSSSASMechConfig sas_mech, ClientRequestInfo ri, Codec codec) {
        Subject subject = null;
        if (tssasMechConfig instanceof ServerLTPAMechConfig) {
            subject = this.getSubject(sas_mech, subject);
        }
        return this.createEncoding(subject, ri, codec);
    }

    @FFDCIgnore(value={AuthenticationException.class})
    private Subject getSubject(CSSSASMechConfig sas_mech, Subject subject) {
        if (sas_mech.isAsserting()) {
            String trustedIdentity = sas_mech.getTrustedIdentity();
            try {
                subject = this.authenticator.authenticate(trustedIdentity);
            }
            catch (AuthenticationException authenticationException) {}
        } else {
            SubjectManager subjectManager = new SubjectManager();
            subject = subjectManager.getInvocationSubject();
            if (subject == null) {
                subject = subjectManager.getCallerSubject();
            }
        }
        return subject;
    }

    @Sensitive
    private byte[] createEncoding(Subject subject, ClientRequestInfo ri, Codec codec) {
        if (subject != null && !new SubjectHelper().isUnauthenticated(subject)) {
            byte[] ltpaTokenBytes = this.getSSOTokenBytes(subject);
            if (this.isEncodingForWASClassic(ri)) {
                return Util.encodeLTPATokenForWASClassic((Codec)codec, (byte[])ltpaTokenBytes);
            }
            return Util.encodeLTPAToken((Codec)codec, (byte[])ltpaTokenBytes);
        }
        return new byte[0];
    }

    @Sensitive
    public byte[] getSSOTokenBytes(Subject subject) {
        SingleSignonToken ssoToken = null;
        byte[] ssoTokenBytes = null;
        Iterator<SingleSignonToken> ssoIterator = subject.getPrivateCredentials(SingleSignonToken.class).iterator();
        if (ssoIterator.hasNext()) {
            ssoToken = ssoIterator.next();
        }
        if (ssoToken != null) {
            ssoTokenBytes = ssoToken.getBytes();
        }
        return ssoTokenBytes;
    }

    @FFDCIgnore(value={BAD_PARAM.class})
    private boolean isEncodingForWASClassic(ClientRequestInfo ri) {
        try {
            int IBM_PV_TC_ID = 1229081866;
            ri.get_effective_component(IBM_PV_TC_ID);
            return true;
        }
        catch (BAD_PARAM bpe) {
            return false;
        }
    }

    @Trivial
    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString("", buf);
        return buf.toString();
    }

    @Trivial
    public void toString(String spaces, StringBuilder buf) {
        String moreSpaces = spaces + "  ";
        buf.append(spaces).append("CSSLTPAMechConfig: [\n");
        buf.append(moreSpaces).append("domain:   ").append(this.domain).append("\n");
        buf.append(moreSpaces).append("required  :   ").append(this.required).append("\n");
        buf.append(spaces).append("]\n");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(ClientLTPAMechConfig.class);
    }
}

