/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.handlers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.ConversionException;
import com.ibm.ws.jmx.connector.datatypes.NotificationRegistration;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.OutputHelper;
import com.ibm.ws.jmx.connector.server.rest.helpers.RESTHelper;
import com.ibm.ws.jmx.connector.server.rest.notification.NotificationManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.rest.handler.RESTHandler;
import com.ibm.wsspi.rest.handler.RESTRequest;
import com.ibm.wsspi.rest.handler.RESTResponse;
import com.ibm.wsspi.rest.handler.helper.RESTHandlerMethodNotAllowedError;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@Component(service={RESTHandler.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM", "com.ibm.wsspi.rest.handler.custom.routing=true", "com.ibm.wsspi.rest.handler.context.root=/IBMJMXConnectorREST", "com.ibm.wsspi.rest.handler.root=/notifications/{clientID}/registrations", "com.ibm.wsspi.rest.handler.root=/notifications/{clientID}/registrations/{objectName}"})
public class NotificationRegistrationsHandler
implements RESTHandler {
    public static final TraceComponent tc = Tr.register(NotificationRegistrationsHandler.class);
    static final long serialVersionUID = 482329848509139294L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleRequest(RESTRequest request, RESTResponse response) {
        String method = request.getMethod();
        if (request.getPathVariable("objectName") != null) {
            if (RESTHelper.isGetMethod(method)) {
                this.fetchFilters(request, response);
                return;
            } else if (RESTHelper.isPutMethod(method)) {
                this.clientNotificationUpdate(request, response);
                return;
            } else {
                if (!RESTHelper.isDeleteMethod(method)) throw new RESTHandlerMethodNotAllowedError("GET,PUT,DELETE");
                this.clientNotificationDelete(request, response);
            }
            return;
        } else if (RESTHelper.isGetMethod(method)) {
            this.fetchRegistrations(request, response);
            return;
        } else if (RESTHelper.isPostMethod(method)) {
            this.clientNotificationCreation(request, response);
            return;
        } else {
            if (!RESTHelper.isDeleteMethod(method)) throw new RESTHandlerMethodNotAllowedError("GET,POST,DELETE");
            this.removeClientNotifications(request, response);
        }
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={ConversionException.class, IOException.class, ClassNotFoundException.class})
    private void clientNotificationCreation(RESTRequest request, RESTResponse response) {
        RESTHelper.ensureConsumesJson(request);
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationRegistrationsHandler", (String)"96", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        JSONConverter converter = JSONConverter.getConverter();
        NotificationRegistration notificationRegistration = null;
        InputStream is = RESTHelper.getInputStream(request);
        try {
            notificationRegistration = converter.readNotificationRegistration(is);
        }
        catch (ConversionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (IOException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (ClassNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        String url = NotificationManager.getNotificationManager().addClientNotification(request, clientID, notificationRegistration, converter);
        OutputHelper.writeStringStreamingOutput(response, url, converter);
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={ConversionException.class, IOException.class, ClassNotFoundException.class})
    private void clientNotificationUpdate(RESTRequest request, RESTResponse response) {
        RESTHelper.ensureConsumesJson(request);
        String objectName = RESTHelper.getRequiredParam(request, "objectName");
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationRegistrationsHandler", (String)"131", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        JSONConverter converter = JSONConverter.getConverter();
        objectName = RESTHelper.URLDecoder(objectName, null);
        NotificationFilter[] filters = null;
        InputStream is = RESTHelper.getInputStream(request);
        try {
            filters = converter.readNotificationFilters(is);
        }
        catch (ConversionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (IOException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (ClassNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        NotificationManager.getNotificationManager().updateClientNotification(request, clientID, objectName, filters, converter);
        JSONConverter.returnConverter((JSONConverter)converter);
        response.setStatus(204);
    }

    /*
     * WARNING - void declaration
     */
    private void clientNotificationDelete(RESTRequest request, RESTResponse response) {
        String objectName = RESTHelper.getRequiredParam(request, "objectName");
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationRegistrationsHandler", (String)"170", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        ObjectName objectNameObj = RESTHelper.objectNameConverter(objectName, true, null);
        NotificationManager.getNotificationManager().removeClientNotification(request, objectNameObj, clientID);
        response.setStatus(204);
    }

    /*
     * WARNING - void declaration
     */
    private void fetchRegistrations(RESTRequest request, RESTResponse response) {
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationRegistrationsHandler", (String)"188", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        JSONConverter converter = JSONConverter.getConverter();
        String[] notificationRegistrations = NotificationManager.getNotificationManager().getRegisteredClientNotifications(request, clientID, converter);
        OutputHelper.writeStringArrayStreamingOutput(response, notificationRegistrations, converter);
    }

    /*
     * WARNING - void declaration
     */
    private void fetchFilters(RESTRequest request, RESTResponse response) {
        String objectName = RESTHelper.getRequiredParam(request, "objectName");
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationRegistrationsHandler", (String)"208", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        JSONConverter converter = JSONConverter.getConverter();
        NotificationFilter[] filters = NotificationManager.getNotificationManager().getRegisteredFilters(request, clientID, RESTHelper.URLDecoder(objectName, converter), converter);
        OutputHelper.writeNotificationFilterArrayStreamingOutput(response, filters, converter);
    }

    /*
     * WARNING - void declaration
     */
    private void removeClientNotifications(RESTRequest request, RESTResponse response) {
        String clientIDString = RESTHelper.getRequiredParam(request, "clientID");
        int clientID = -1;
        try {
            clientID = Integer.parseInt(clientIDString);
        }
        catch (NumberFormatException numberFormatException) {
            void e;
            FFDCFilter.processException((Throwable)numberFormatException, (String)"com.ibm.ws.jmx.connector.server.rest.handlers.NotificationRegistrationsHandler", (String)"227", (Object)this, (Object[])new Object[]{request, response});
            ErrorHelper.createRESTHandlerJsonException((Throwable)e, null, 400);
        }
        NotificationManager.getNotificationManager().removeAllClientRegistrations(request, clientID);
        response.setStatus(204);
    }
}

