/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jmx.connector.server.rest.helpers;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jmx.connector.converter.JSONConverter;
import com.ibm.ws.jmx.connector.datatypes.CreateMBean;
import com.ibm.ws.jmx.connector.datatypes.ObjectInstanceWrapper;
import com.ibm.ws.jmx.connector.server.rest.helpers.ErrorHelper;
import com.ibm.ws.jmx.connector.server.rest.notification.ClientNotificationListener;
import com.ibm.ws.jmx.request.RequestContext;
import com.ibm.ws.jmx.request.RequestMetadata;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.URLEncoder;
import java.util.LinkedList;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class MBeanServerHelper {
    private static final MBeanServer mbeanServer;
    static final long serialVersionUID = 2304073103374806191L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static ObjectInstanceWrapper[] queryObjectName(ObjectName objectName, QueryExp queryExp, String className, JSONConverter converter) {
        Set<ObjectInstance> instances = mbeanServer.queryMBeans(objectName, queryExp);
        if (className != null) {
            LinkedList<ObjectInstance> filtered = null;
            for (ObjectInstance instance : instances) {
                boolean isInstanceOf = false;
                try {
                    isInstanceOf = MBeanServerHelper.instanceOf(instance.getObjectName(), className, converter);
                    if (isInstanceOf) continue;
                    if (filtered == null) {
                        filtered = new LinkedList();
                    }
                    filtered.add(instance);
                }
                catch (Exception exception) {
                    try {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"74", null, (Object[])new Object[]{objectName, queryExp, className, converter});
                        if (isInstanceOf) continue;
                        if (filtered == null) {
                            filtered = new LinkedList();
                        }
                        filtered.add(instance);
                    }
                    catch (Throwable throwable) {
                        if (!isInstanceOf) {
                            if (filtered == null) {
                                filtered = new LinkedList<ObjectInstance>();
                            }
                            filtered.add(instance);
                        }
                        throw throwable;
                    }
                }
            }
            if (filtered != null) {
                for (ObjectInstance filter : filtered) {
                    instances.remove(filter);
                }
            }
        }
        ObjectInstanceWrapper[] returnInstances = new ObjectInstanceWrapper[instances.size()];
        int i = 0;
        for (ObjectInstance instance : instances) {
            ObjectInstanceWrapper arrayItem = new ObjectInstanceWrapper();
            arrayItem.objectInstance = instance;
            try {
                arrayItem.mbeanInfoURL = "/IBMJMXConnectorREST/mbeans/" + URLEncoder.encode(instance.getObjectName().getCanonicalName(), "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                void e;
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"102", null, (Object[])new Object[]{objectName, queryExp, className, converter});
                throw ErrorHelper.createRESTHandlerJsonException((Throwable)e, converter, 500);
            }
            returnInstances[i++] = arrayItem;
        }
        return returnInstances;
    }

    @FFDCIgnore(value={InstanceNotFoundException.class})
    public static boolean instanceOf(ObjectName objectName, String className, JSONConverter converter) {
        try {
            return mbeanServer.isInstanceOf(objectName, className);
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
    }

    public static boolean isRegistered(ObjectName objectName) {
        return mbeanServer.isRegistered(objectName);
    }

    public static Integer getMBeanCount() {
        return mbeanServer.getMBeanCount();
    }

    public static String getDefaultDomain() {
        return mbeanServer.getDefaultDomain();
    }

    public static String[] getDomains() {
        return mbeanServer.getDomains();
    }

    @FFDCIgnore(value={InstanceNotFoundException.class, IntrospectionException.class, ReflectionException.class})
    public static MBeanInfo getMBeanInfo(ObjectName objectNameObj) {
        try {
            return mbeanServer.getMBeanInfo(objectNameObj);
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 400);
        }
        catch (IntrospectionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 500);
        }
        catch (ReflectionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 500);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"147", null, (Object[])new Object[]{objectNameObj});
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 500);
        }
    }

    @FFDCIgnore(value={InstanceNotFoundException.class, ReflectionException.class, MBeanException.class, RuntimeMBeanException.class})
    public static Object invoke(ObjectName objectName, String operation, Object[] params, String[] signature, JSONConverter converter) {
        try {
            RequestMetadata metadata = new RequestMetadata();
            RequestContext.setRequestMetadata((RequestMetadata)metadata);
            Object object = mbeanServer.invoke(objectName, operation, params, signature);
            return object;
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (MBeanException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
        catch (ReflectionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (RuntimeMBeanException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"170", null, (Object[])new Object[]{objectName, operation, params, signature, converter});
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
        finally {
            RequestContext.removeRequestMetadata();
        }
    }

    @FFDCIgnore(value={ReflectionException.class, InstanceAlreadyExistsException.class, NotCompliantMBeanException.class, InstanceNotFoundException.class, MBeanException.class, RuntimeMBeanException.class})
    public static ObjectInstance createMBean(CreateMBean createMBean, JSONConverter converter) {
        try {
            if (createMBean.useLoader && createMBean.useSignature) {
                return mbeanServer.createMBean(createMBean.className, createMBean.objectName, createMBean.loaderName, createMBean.params, createMBean.signature);
            }
            if (createMBean.useSignature) {
                return mbeanServer.createMBean(createMBean.className, createMBean.objectName, createMBean.params, createMBean.signature);
            }
            if (createMBean.useLoader) {
                return mbeanServer.createMBean(createMBean.className, createMBean.objectName, createMBean.loaderName);
            }
            return mbeanServer.createMBean(createMBean.className, createMBean.objectName);
        }
        catch (ReflectionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (InstanceAlreadyExistsException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (MBeanException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
        catch (NotCompliantMBeanException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (RuntimeMBeanException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"217", null, (Object[])new Object[]{createMBean, converter});
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
    }

    @FFDCIgnore(value={InstanceNotFoundException.class, MBeanRegistrationException.class})
    public static void unregisterMBean(ObjectName objectNameObj) {
        try {
            mbeanServer.unregisterMBean(objectNameObj);
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 400);
        }
        catch (MBeanRegistrationException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 500);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"231", null, (Object[])new Object[]{objectNameObj});
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 500);
        }
    }

    @FFDCIgnore(value={InstanceNotFoundException.class, ReflectionException.class})
    public static AttributeList getAttributes(ObjectName objectNameObj, String[] attributes) {
        try {
            return mbeanServer.getAttributes(objectNameObj, attributes);
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 400);
        }
        catch (ReflectionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 500);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"244", null, (Object[])new Object[]{objectNameObj, attributes});
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 500);
        }
    }

    @FFDCIgnore(value={InstanceNotFoundException.class, ReflectionException.class})
    public static AttributeList setAttributes(ObjectName objectNameObj, AttributeList attributeList, JSONConverter converter) {
        try {
            return mbeanServer.setAttributes(objectNameObj, attributeList);
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (ReflectionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"259", null, (Object[])new Object[]{objectNameObj, attributeList, converter});
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
    }

    @FFDCIgnore(value={InstanceNotFoundException.class, AttributeNotFoundException.class, ReflectionException.class, MBeanException.class, RuntimeMBeanException.class})
    public static Object getAttribute(ObjectName objectNameObj, String attributeName) {
        try {
            return mbeanServer.getAttribute(objectNameObj, attributeName);
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 400);
        }
        catch (ReflectionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 500);
        }
        catch (AttributeNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 400);
        }
        catch (MBeanException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 500);
        }
        catch (RuntimeMBeanException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 500);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"278", null, (Object[])new Object[]{objectNameObj, attributeName});
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 500);
        }
    }

    @FFDCIgnore(value={InvalidAttributeValueException.class, InstanceNotFoundException.class, AttributeNotFoundException.class, ReflectionException.class, MBeanException.class, RuntimeMBeanException.class})
    public static void setAttribute(ObjectName objectNameObj, Attribute attribute, JSONConverter converter) {
        try {
            mbeanServer.setAttribute(objectNameObj, attribute);
        }
        catch (InvalidAttributeValueException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (ReflectionException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
        catch (AttributeNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (MBeanException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
        catch (RuntimeMBeanException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"300", null, (Object[])new Object[]{objectNameObj, attribute, converter});
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
    }

    @FFDCIgnore(value={InstanceNotFoundException.class, RuntimeOperationsException.class})
    public static void addClientNotification(ObjectName objectName, ClientNotificationListener listener, NotificationFilter filter, Object handback, JSONConverter converter) {
        try {
            mbeanServer.addNotificationListener(objectName, listener, filter, handback);
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (RuntimeOperationsException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"317", null, (Object[])new Object[]{objectName, listener, filter, handback, converter});
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
    }

    @FFDCIgnore(value={InstanceNotFoundException.class, RuntimeOperationsException.class})
    public static void addServerNotification(ObjectName objectName, ObjectName listener, NotificationFilter filter, Object handback, JSONConverter converter) {
        try {
            mbeanServer.addNotificationListener(objectName, listener, filter, handback);
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (RuntimeOperationsException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"334", null, (Object[])new Object[]{objectName, listener, filter, handback, converter});
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
    }

    @FFDCIgnore(value={InstanceNotFoundException.class, ListenerNotFoundException.class})
    public static void removeClientNotification(ObjectName objectName, NotificationListener listener) {
        try {
            mbeanServer.removeNotificationListener(objectName, listener);
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 400);
        }
        catch (ListenerNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 400);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"349", null, (Object[])new Object[]{objectName, listener});
            throw ErrorHelper.createRESTHandlerJsonException(e, null, 500);
        }
    }

    @FFDCIgnore(value={InstanceNotFoundException.class, ListenerNotFoundException.class})
    public static void removeServerNotification(ObjectName objectName, ObjectName listener, NotificationFilter filter, Object handback, JSONConverter converter) {
        try {
            mbeanServer.removeNotificationListener(objectName, listener, filter, handback);
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (ListenerNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"367", null, (Object[])new Object[]{objectName, listener, filter, handback, converter});
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
    }

    @FFDCIgnore(value={InstanceNotFoundException.class, ListenerNotFoundException.class})
    public static void removeServerNotification(ObjectName objectName, ObjectName listener, JSONConverter converter) {
        try {
            mbeanServer.removeNotificationListener(objectName, listener);
        }
        catch (InstanceNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (ListenerNotFoundException e) {
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 400);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.jmx.connector.server.rest.helpers.MBeanServerHelper", (String)"383", null, (Object[])new Object[]{objectName, listener, converter});
            throw ErrorHelper.createRESTHandlerJsonException(e, converter, 500);
        }
    }

    public static String getMBeanServerName() {
        return mbeanServer.getClass().getName();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(MBeanServerHelper.class);
        mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }
}

