/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs20.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.container.service.app.deploy.EJBModuleInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.anno.info.ClassInfo;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class JaxRsUtils {
    private static final TraceComponent tc = Tr.register(JaxRsUtils.class);
    static final long serialVersionUID = 8432133845169311509L;

    public static boolean isWebService(ClassInfo classInfo) {
        return false;
    }

    public static ExtendedModuleInfo getModuleInfo(Container container) {
        NonPersistentCache overlayCache;
        ExtendedModuleInfo moduleInfo = null;
        try {
            overlayCache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jaxrs20.utils.JaxRsUtils", (String)"499", null, (Object[])new Object[]{container});
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to get ModuleInfo due to no NonPersistentCache found", (Object[])new Object[0]);
            }
            return null;
        }
        if (overlayCache != null && (moduleInfo = (ExtendedModuleInfo)overlayCache.getFromCache(WebModuleInfo.class)) == null) {
            moduleInfo = (ExtendedModuleInfo)overlayCache.getFromCache(EJBModuleInfo.class);
        }
        return moduleInfo;
    }

    public static WebModuleInfo getWebModuleInfo(Container container) {
        NonPersistentCache overlayCache;
        WebModuleInfo moduleInfo = null;
        try {
            overlayCache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.jaxrs20.utils.JaxRsUtils", (String)"519", null, (Object[])new Object[]{container});
            return null;
        }
        if (overlayCache != null) {
            moduleInfo = (WebModuleInfo)overlayCache.getFromCache(WebModuleInfo.class);
        }
        return moduleInfo;
    }

    public static boolean isWebModule(Container container) throws UnableToAdaptException {
        NonPersistentCache overlayCache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
        if (overlayCache != null) {
            return overlayCache.getFromCache(WebModuleInfo.class) != null;
        }
        return false;
    }

    public static boolean isEJBModule(Container container) throws UnableToAdaptException {
        NonPersistentCache overlayCache = (NonPersistentCache)container.adapt(NonPersistentCache.class);
        if (overlayCache != null) {
            return overlayCache.getFromCache(EJBModuleInfo.class) != null;
        }
        return false;
    }
}

