/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import net.jodah.failsafe.CircuitBreaker;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class CircuitBreakerImpl
extends CircuitBreaker {
    private static final TraceComponent tc = Tr.register(CircuitBreakerImpl.class);
    static final long serialVersionUID = -5543854155184164293L;

    public CircuitBreakerImpl(CircuitBreakerPolicy policy) {
        Duration delay = policy.getDelay();
        Class[] failOn = policy.getFailOn();
        double failureRatio = policy.getFailureRatio();
        int requestVolumeThreshold = policy.getRequestVolumeThreshold();
        int successThreshold = policy.getSuccessThreshold();
        this.failOn(failOn);
        if (delay.toMillis() > 0L) {
            this.withDelay(delay.toMillis(), TimeUnit.MILLISECONDS);
        }
        int failures = (int)(failureRatio * (double)requestVolumeThreshold);
        int executions = requestVolumeThreshold;
        this.withFailureThreshold(failures, executions);
        this.withSuccessThreshold(successThreshold);
    }
}

