/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.event.internal.adapter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public final class BundleEventAdapter
implements BundleListener {
    private static final String BUNDLE_EVENT_TOPIC_PREFIX = "org/osgi/framework/BundleEvent/";
    private final EventAdmin eventAdmin;
    static final long serialVersionUID = -818773777250172927L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public BundleEventAdapter(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    public void bundleChanged(BundleEvent bundleEvent) {
        String topic = this.getTopic(bundleEvent);
        if (topic == null) {
            return;
        }
        HashMap<String, Object> eventProperties = new HashMap<String, Object>();
        eventProperties.put("event", bundleEvent);
        Bundle bundle = bundleEvent.getBundle();
        if (bundle != null) {
            eventProperties.put("bundle.id", bundle.getBundleId());
            String symbolicName = bundle.getSymbolicName();
            if (symbolicName != null) {
                eventProperties.put("bundle.symbolicName", symbolicName);
            }
            eventProperties.put("bundle", bundle);
        }
        Event event = new Event(topic, eventProperties);
        this.eventAdmin.postEvent(event);
    }

    private String getTopic(BundleEvent bundleEvent) {
        StringBuilder topic = new StringBuilder(BUNDLE_EVENT_TOPIC_PREFIX);
        switch (bundleEvent.getType()) {
            case 1: {
                topic.append("INSTALLED");
                break;
            }
            case 2: {
                topic.append("STARTED");
                break;
            }
            case 4: {
                topic.append("STOPPED");
                break;
            }
            case 8: {
                topic.append("UPDATED");
                break;
            }
            case 16: {
                topic.append("UNINSTALLED");
                break;
            }
            case 32: {
                topic.append("RESOLVED");
                break;
            }
            case 64: {
                topic.append("UNRESOLVED");
                break;
            }
            default: {
                return null;
            }
        }
        return topic.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register(BundleEventAdapter.class);
    }
}

